/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.file.GenericAttribute;
import EDU.purdue.cs.bloat.file.LineNumberTable;
import EDU.purdue.cs.bloat.file.LocalVariableTable;
import EDU.purdue.cs.bloat.reflect.Catch;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.Constant;
import EDU.purdue.cs.bloat.reflect.LineNumberDebugInfo;
import EDU.purdue.cs.bloat.reflect.LocalDebugInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Code
extends Attribute {
    private ClassInfo classInfo;
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private Catch[] handlers;
    private LineNumberTable lineNumbers;
    private LocalVariableTable locals;
    private Attribute[] attrs;

    Code(ClassInfo classInfo, int codeIndex) {
        super(codeIndex, -1);
        this.classInfo = classInfo;
        this.maxStack = -1;
        this.maxLocals = -1;
        this.code = new byte[0];
        this.handlers = new Catch[0];
        this.lineNumbers = null;
        this.locals = null;
        this.attrs = new Attribute[0];
    }

    public Code(ClassInfo classInfo, DataInputStream in, int index, int len) throws IOException {
        super(index, len);
        this.classInfo = classInfo;
        this.maxStack = in.readUnsignedShort();
        this.maxLocals = in.readUnsignedShort();
        int codeLength = in.readInt();
        this.code = new byte[codeLength];
        for (int read = 0; read < codeLength; read += in.read(this.code, read, codeLength - read)) {
        }
        int numHandlers = in.readUnsignedShort();
        this.handlers = new Catch[numHandlers];
        for (int i = 0; i < numHandlers; ++i) {
            this.handlers[i] = this.readCatch(in);
        }
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            Constant name = classInfo.constants()[nameIndex];
            if (name != null) {
                if ("LineNumberTable".equals(name.value())) {
                    this.lineNumbers = new LineNumberTable(in, nameIndex, length);
                    this.attrs[i] = this.lineNumbers;
                } else if ("LocalVariableTable".equals(name.value())) {
                    this.locals = new LocalVariableTable(in, nameIndex, length);
                    this.attrs[i] = this.locals;
                }
            }
            if (this.attrs[i] != null) continue;
            this.attrs[i] = new GenericAttribute(in, nameIndex, length);
        }
    }

    public void writeData(DataOutputStream out) throws IOException {
        int i;
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.code.length);
        out.write(this.code, 0, this.code.length);
        out.writeShort(this.handlers.length);
        for (i = 0; i < this.handlers.length; ++i) {
            this.writeCatch(out, this.handlers[i]);
        }
        out.writeShort(this.attrs.length);
        for (i = 0; i < this.attrs.length; ++i) {
            out.writeShort(this.attrs[i].nameIndex());
            out.writeInt(this.attrs[i].length());
            this.attrs[i].writeData(out);
        }
    }

    private Catch readCatch(DataInputStream in) throws IOException {
        int startPC = in.readUnsignedShort();
        int endPC = in.readUnsignedShort();
        int handlerPC = in.readUnsignedShort();
        int catchType = in.readUnsignedShort();
        return new Catch(startPC, endPC, handlerPC, catchType);
    }

    private void writeCatch(DataOutputStream out, Catch c) throws IOException {
        int startPC = c.startPC();
        int endPC = c.endPC();
        int handlerPC = c.handlerPC();
        int catchType = c.catchTypeIndex();
        out.writeShort(startPC);
        out.writeShort(endPC);
        out.writeShort(handlerPC);
        out.writeShort(catchType);
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public int maxStack() {
        return this.maxStack;
    }

    public int maxLocals() {
        return this.maxLocals;
    }

    public void setExceptionHandlers(Catch[] handlers) {
        this.handlers = handlers;
    }

    public int length() {
        int length = 8 + this.code.length + 2 + this.handlers.length * 8 + 2;
        for (int i = 0; i < this.attrs.length; ++i) {
            length += 6 + this.attrs[i].length();
        }
        return length;
    }

    public LineNumberDebugInfo[] lineNumbers() {
        if (this.lineNumbers != null) {
            return this.lineNumbers.lineNumbers();
        }
        return new LineNumberDebugInfo[0];
    }

    public LocalDebugInfo[] locals() {
        if (this.locals != null) {
            return this.locals.locals();
        }
        return new LocalDebugInfo[0];
    }

    public void setLineNumbers(LineNumberDebugInfo[] lineNumbers) {
        if (lineNumbers == null) {
            for (int i = 0; i < this.attrs.length; ++i) {
                if (this.lineNumbers != this.attrs[i]) continue;
                Attribute[] a = this.attrs;
                this.attrs = new Attribute[a.length - 1];
                System.arraycopy(a, 0, this.attrs, 0, i);
                System.arraycopy(a, i + 1, this.attrs, i, this.attrs.length - i);
                break;
            }
            this.lineNumbers = null;
        } else if (this.lineNumbers != null) {
            this.lineNumbers.setLineNumbers(lineNumbers);
        }
    }

    public void setLocals(LocalDebugInfo[] locals) {
        if (locals == null) {
            for (int i = 0; i < this.attrs.length; ++i) {
                if (this.locals != this.attrs[i]) continue;
                Attribute[] a = this.attrs;
                this.attrs = new Attribute[a.length - 1];
                System.arraycopy(a, 0, this.attrs, 0, i);
                System.arraycopy(a, i + 1, this.attrs, i, this.attrs.length - i);
                break;
            }
            this.locals = null;
        } else if (this.locals != null) {
            this.locals.setLocals(locals);
        }
    }

    public Catch[] exceptionHandlers() {
        return this.handlers;
    }

    public byte[] code() {
        return this.code;
    }

    public int codeLength() {
        return this.code.length;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    private Code(Code other) {
        super(other.nameIndex, other.length);
        int i;
        this.classInfo = other.classInfo;
        this.maxStack = other.maxStack;
        this.maxLocals = other.maxLocals;
        this.code = new byte[other.code.length];
        System.arraycopy(other.code, 0, this.code, 0, other.code.length);
        this.handlers = new Catch[other.handlers.length];
        for (i = 0; i < other.handlers.length; ++i) {
            this.handlers[i] = (Catch)other.handlers[i].clone();
        }
        if (other.lineNumbers != null) {
            this.lineNumbers = (LineNumberTable)other.lineNumbers.clone();
        }
        if (other.locals != null) {
            this.locals = (LocalVariableTable)other.locals.clone();
        }
        this.attrs = new Attribute[other.attrs.length];
        for (i = 0; i < other.attrs.length; ++i) {
            this.attrs[i] = other.attrs[i];
        }
    }

    public Object clone() {
        return new Code(this);
    }

    public String toString() {
        String x = "";
        if (this.handlers != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                x = x + "\n        " + this.handlers[i];
            }
        }
        return "(code " + this.maxStack + " " + this.maxLocals + " " + this.code.length + x + ")";
    }
}

