/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.ClassFile;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassFileLoader
implements ClassInfoLoader {
    public static boolean DEBUG = false;
    public static boolean USE_SYSTEM_CLASSES = true;
    private File outputDir = new File(".");
    private String classpath = this.classpath + File.pathSeparator + System.getProperty("sun.boot.class.path");
    private Map openZipFiles;
    private LinkedList cache;
    private boolean verbose;
    private static final int CACHE_LIMIT = 10;

    public ClassFileLoader() {
        if (USE_SYSTEM_CLASSES) {
            this.classpath = this.classpath + File.pathSeparator + System.getProperty("java.sys.class.path");
        }
        this.openZipFiles = new HashMap();
        this.cache = new LinkedList();
        this.verbose = false;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setClassPath(String classpath) {
        this.classpath = classpath;
    }

    public void appendClassPath(String morePath) {
        this.classpath = this.classpath + File.pathSeparator + morePath;
    }

    public void prependClassPath(String morePath) {
        this.classpath = morePath + File.pathSeparator + this.classpath;
    }

    public String getClassPath() {
        return this.classpath;
    }

    private ClassInfo loadClassFromStream(File inputFile, InputStream stream) throws ClassNotFoundException {
        DataInputStream in = new DataInputStream(stream);
        ClassFile file = new ClassFile(inputFile, this, in);
        return file;
    }

    private ClassInfo loadClassFromFile(File file) throws ClassNotFoundException {
        try {
            FileInputStream in = new FileInputStream(file);
            ClassInfo info = this.loadClassFromStream(file, in);
            if (this.verbose) {
                System.out.println("[Loaded " + info.name() + " from " + file.getPath() + "]");
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return info;
        }
        catch (FileNotFoundException e) {
            throw new ClassNotFoundException(file.getPath());
        }
    }

    public ClassInfo[] loadClassesFromZipFile(ZipFile zipFile) throws ClassNotFoundException {
        ClassInfo[] infos = new ClassInfo[zipFile.size()];
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        int i = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                try {
                    InputStream stream = zipFile.getInputStream(entry);
                    File file = new File(entry.getName());
                    infos[i] = this.loadClassFromStream(file, stream);
                }
                catch (IOException ex) {
                    System.err.println("IOException: " + ex);
                }
            }
            ++i;
        }
        return infos;
    }

    public ClassInfo newClass(int modifiers, int classIndex, int superClassIndex, int[] interfaceIndexes, List constants) {
        return new ClassFile(modifiers, classIndex, superClassIndex, interfaceIndexes, constants, this);
    }

    public ClassInfo loadClass(String name) throws ClassNotFoundException {
        ClassInfo file = null;
        if (name.endsWith(".class")) {
            File nameFile = new File(name);
            if (!nameFile.exists()) {
                throw new ClassNotFoundException(name);
            }
            return this.loadClassFromFile(nameFile);
        }
        name = name.replace('.', '/');
        if (DEBUG) {
            System.out.println("  Looking for " + name + " in cache = " + this.cache);
        }
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            file = (ClassFile)iter.next();
            if (!name.equals(file.name())) continue;
            if (DEBUG) {
                System.out.println("  Found " + file.name() + " in cache");
            }
            iter.remove();
            this.cache.addFirst(file);
            return file;
        }
        file = null;
        String classFile = name.replace('/', File.separatorChar) + ".class";
        String path = this.classpath + File.pathSeparator;
        if (DEBUG) {
            System.out.println("CLASSPATH = " + path);
        }
        int index = 0;
        int end = path.indexOf(File.pathSeparator, index);
        while (end >= 0) {
            String dir = path.substring(index, end);
            File f = new File(dir);
            if (f.isDirectory()) {
                f = new File(dir, classFile);
                if (f.exists()) {
                    try {
                        FileInputStream in = new FileInputStream(f);
                        if (this.verbose) {
                            System.out.println("  [Loaded " + name + " from " + f.getPath() + "]");
                        }
                        file = this.loadClassFromStream(f, in);
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException ex) {}
                        break;
                    }
                    catch (FileNotFoundException ex) {}
                }
            } else if (dir.endsWith(".zip") || dir.endsWith(".jar")) {
                try {
                    String zipEntry;
                    ZipEntry entry;
                    ZipFile zip = (ZipFile)this.openZipFiles.get(dir);
                    if (zip == null) {
                        zip = new ZipFile(f);
                        this.openZipFiles.put(dir, zip);
                    }
                    if ((entry = zip.getEntry(zipEntry = classFile.replace(File.separatorChar, '/'))) != null) {
                        if (this.verbose) {
                            System.out.println("  [Loaded " + name + " from " + f.getPath() + "]");
                        }
                        InputStream in = zip.getInputStream(entry);
                        file = this.loadClassFromStream(f, in);
                        try {
                            in.close();
                        }
                        catch (IOException ex) {}
                        break;
                    }
                }
                catch (ZipException ex) {
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            index = end + 1;
            end = path.indexOf(File.pathSeparator, index);
        }
        if (file == null) {
            File f = new File(classFile);
            if (!f.exists()) {
                throw new ClassNotFoundException(name);
            }
            if (this.verbose) {
                System.out.println("  [Loaded " + name + " from " + f.getPath() + "]");
            }
            try {
                FileInputStream in = new FileInputStream(f);
                file = this.loadClassFromStream(f, in);
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ex) {}
            }
            catch (FileNotFoundException ex) {
                throw new ClassNotFoundException(name);
            }
        }
        if (file == null) {
            throw new ClassNotFoundException(name);
        }
        if (this.cache.size() == 10) {
            this.cache.removeLast();
        }
        this.cache.addFirst(file);
        return file;
    }

    public void setOutputDir(File dir) {
        this.outputDir = dir;
    }

    public File outputDir() {
        return this.outputDir;
    }

    public void writeEntry(byte[] bytes, String name) throws IOException {
        OutputStream os = this.outputStreamFor(name);
        os.write(bytes);
        os.flush();
        os.close();
    }

    public OutputStream outputStreamFor(ClassInfo info) throws IOException {
        String name = info.name().replace('/', File.separatorChar) + ".class";
        return this.outputStreamFor(name);
    }

    protected OutputStream outputStreamFor(String name) throws IOException {
        File f = new File(this.outputDir, name = name.replace('/', File.separatorChar));
        if (f.exists()) {
            f.delete();
        }
        File dir = new File(f.getParent());
        dir.mkdirs();
        if (!dir.exists()) {
            throw new RuntimeException("Couldn't create directory: " + dir);
        }
        return new FileOutputStream(f);
    }

    public void done() throws IOException {
    }
}

