/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class SerialVersionUID {
    public static boolean implementsSerializable(ClassEditor ce) {
        if (ce.type().equals(Type.OBJECT)) {
            return false;
        }
        Type serializable = Type.getType("Ljava/io/Serializable;");
        Type[] interfaces = ce.interfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(serializable)) continue;
            return true;
        }
        Type superclass = ce.superclass();
        ClassInfoLoader loader = ce.classInfo().loader();
        try {
            ClassInfo ci = loader.loadClass(superclass.className());
            ClassEditor sce = new ClassEditor(ce.context(), ci);
            return SerialVersionUID.implementsSerializable(sce);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Could not load class: " + superclass + ", superclass of " + ce.name());
            System.exit(1);
            return false;
        }
    }

    public static long serialVersionUID(ClassEditor ce) {
        if (!SerialVersionUID.implementsSerializable(ce)) {
            String s = "Class " + ce.name() + " does not implement java.io.Serializable";
            throw new IllegalArgumentException(s);
        }
        FieldInfo[] fields = ce.fields();
        for (int i = 0; i < fields.length; ++i) {
            Object value;
            FieldEditor fe = new FieldEditor(ce, fields[i]);
            if (!fe.name().equals("serialVersionUID") || (value = fe.constantValue()) == null || !(value instanceof Long)) continue;
            return (Long)value;
        }
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException ex) {
            String s = "Can't use SHA-1 message digest algorith!";
            throw new IllegalArgumentException(s);
        }
        DataOutputStream dos = new DataOutputStream(new DigestOutputStream(new ByteArrayOutputStream(), algorithm));
        try {
            SerialVersionUID.writeClassName(ce, dos);
            SerialVersionUID.writeClassModifiers(ce, dos);
            SerialVersionUID.writeInterfaceNames(ce, dos);
            SerialVersionUID.writeFields(ce, dos);
            SerialVersionUID.writeStaticInitializer(ce, dos);
            SerialVersionUID.writeConstructors(ce, dos);
            SerialVersionUID.writeMethods(ce, dos);
            dos.flush();
            dos.close();
        }
        catch (IOException ex) {
            String s = "While computing serial version UID: " + ex;
            throw new IllegalArgumentException(s);
        }
        byte[] digest = algorithm.digest();
        long uid = 0L;
        for (int i = 0; i < Math.min(8, digest.length); ++i) {
            uid += (long)(digest[i] & 0xFF) << i * 8;
        }
        return uid;
    }

    private static void writeClassName(ClassEditor ce, DataOutputStream dos) throws IOException {
        dos.writeUTF(ce.name().replace('/', '.'));
    }

    static int getModifiers(ClassEditor ce) {
        int modifiers = 0;
        if (ce.isPublic()) {
            modifiers |= 1;
        }
        if (ce.isPrivate()) {
            modifiers |= 2;
        }
        if (ce.isProtected()) {
            modifiers |= 4;
        }
        if (ce.isStatic()) {
            modifiers |= 8;
        }
        if (ce.isFinal()) {
            modifiers |= 0x10;
        }
        if (ce.isAbstract()) {
            modifiers |= 0x400;
        }
        if (ce.isInterface()) {
            modifiers |= 0x200;
        }
        return modifiers;
    }

    private static void writeClassModifiers(ClassEditor ce, DataOutputStream dos) throws IOException {
        dos.writeInt(SerialVersionUID.getModifiers(ce));
    }

    private static void writeInterfaceNames(ClassEditor ce, DataOutputStream dos) throws IOException {
        TreeSet<String> sorted = new TreeSet<String>();
        Type[] interfaces = ce.interfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            sorted.add(interfaces[i].className().replace('/', '.'));
        }
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            dos.writeUTF(name);
        }
    }

    static int getModifiers(FieldEditor fe) {
        int modifiers = 0;
        if (fe.isPublic()) {
            modifiers |= 1;
        }
        if (fe.isPrivate()) {
            modifiers |= 2;
        }
        if (fe.isProtected()) {
            modifiers |= 4;
        }
        if (fe.isPackage()) {
            // empty if block
        }
        if (fe.isStatic()) {
            modifiers |= 8;
        }
        if (fe.isFinal()) {
            modifiers |= 0x10;
        }
        if (fe.isVolatile()) {
            modifiers |= 0x40;
        }
        if (fe.isTransient()) {
            modifiers |= 0x80;
        }
        return modifiers;
    }

    private static void writeFields(ClassEditor ce, DataOutputStream dos) throws IOException {
        FieldEditor fe;
        TreeSet<FieldEditor> sorted = new TreeSet<FieldEditor>(new Comparator(){

            public int compare(Object o1, Object o2) {
                FieldEditor fe1 = (FieldEditor)o1;
                FieldEditor fe2 = (FieldEditor)o2;
                return fe1.name().compareTo(fe2.name());
            }
        });
        FieldInfo[] infos = ce.fields();
        for (int i = 0; !(i >= infos.length || (fe = new FieldEditor(ce, infos[i])).isPrivate() && fe.isStatic() || fe.isPrivate() && fe.isTransient()); ++i) {
            sorted.add(fe);
        }
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            fe = (FieldEditor)iter.next();
            dos.writeUTF(fe.name());
            dos.writeInt(SerialVersionUID.getModifiers(fe));
            dos.writeUTF(fe.type().descriptor());
        }
    }

    static int getModifiers(MethodEditor me) {
        int modifiers = 0;
        if (me.isPublic()) {
            modifiers |= 1;
        }
        if (me.isPrivate()) {
            modifiers |= 2;
        }
        if (me.isProtected()) {
            modifiers |= 4;
        }
        if (me.isPackage()) {
            // empty if block
        }
        if (me.isStatic()) {
            modifiers |= 8;
        }
        if (me.isFinal()) {
            modifiers |= 0x10;
        }
        if (me.isSynchronized()) {
            modifiers |= 0x20;
        }
        if (me.isNative()) {
            modifiers |= 0x100;
        }
        if (me.isAbstract()) {
            modifiers |= 0x400;
        }
        if (me.isInterface()) {
            modifiers |= 0x200;
        }
        return modifiers;
    }

    private static void writeStaticInitializer(ClassEditor ce, DataOutputStream dos) throws IOException {
        MethodEditor clinit = null;
        MethodInfo[] methods = ce.methods();
        for (int i = 0; i < methods.length; ++i) {
            MethodEditor me = new MethodEditor(ce, methods[i]);
            if (!me.name().equals("<clinit>")) continue;
            clinit = me;
            break;
        }
        if (clinit != null) {
            dos.writeUTF("<clinit>");
            dos.writeInt(8);
            dos.writeUTF("()V");
        }
    }

    private static void writeConstructors(ClassEditor ce, DataOutputStream dos) throws IOException {
        TreeSet<MethodEditor> sorted = new TreeSet<MethodEditor>(new Comparator(){

            public int compare(Object o1, Object o2) {
                MethodEditor me1 = (MethodEditor)o1;
                MethodEditor me2 = (MethodEditor)o2;
                return me1.type().descriptor().compareTo(me2.type().descriptor());
            }
        });
        MethodInfo[] methods = ce.methods();
        for (int i = 0; i < methods.length; ++i) {
            MethodEditor me = new MethodEditor(ce, methods[i]);
            if (!me.name().equals("<init>") || me.isPrivate()) continue;
            sorted.add(me);
        }
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            MethodEditor init = (MethodEditor)iter.next();
            dos.writeUTF("<init>");
            dos.writeInt(SerialVersionUID.getModifiers(init));
            dos.writeUTF(init.type().descriptor());
        }
    }

    private static void writeMethods(ClassEditor ce, DataOutputStream dos) throws IOException {
        MethodEditor me;
        TreeSet<MethodEditor> sorted = new TreeSet<MethodEditor>(new Comparator(){

            public int compare(Object o1, Object o2) {
                MethodEditor me1 = (MethodEditor)o1;
                MethodEditor me2 = (MethodEditor)o2;
                String d1 = me1.name() + me1.type().descriptor();
                String d2 = me2.name() + me2.type().descriptor();
                return d1.compareTo(d2);
            }
        });
        MethodInfo[] methods = ce.methods();
        for (int i = 0; i < methods.length; ++i) {
            me = new MethodEditor(ce, methods[i]);
            if (me.isPrivate() || me.isConstructor() || me.name().equals("<clinit>")) continue;
            sorted.add(me);
        }
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            me = (MethodEditor)iter.next();
            dos.writeUTF(me.name());
            dos.writeInt(SerialVersionUID.getModifiers(me));
            dos.writeUTF(me.type().descriptor());
        }
    }
}

