/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.editor.ConstantPool;
import EDU.purdue.cs.bloat.editor.IncOperand;
import EDU.purdue.cs.bloat.editor.InstructionVisitor;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MultiArrayOperand;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.util.Assert;

public class Instruction
implements Opcode {
    private Object operand;
    private int opcode;
    private int origOpcode;
    private boolean useSlow = false;

    public Instruction(int opcode) {
        this(opcode, null);
    }

    public Instruction(int opcode, Object operand) {
        this.opcode = opcode;
        this.origOpcode = opcode;
        this.operand = operand;
        Assert.isTrue(opcode == Opcode.opcXMap[opcode], "Illegal instruction: " + this);
    }

    public Instruction(byte[] code, int index, int[] targets, int[] lookups, LocalVariable[] locals, ConstantPool constants) {
        int opc = Instruction.toUByte(code[index]);
        switch (opc) {
            case 1: {
                this.operand = null;
                break;
            }
            case 2: {
                this.operand = new Integer(-1);
                break;
            }
            case 3: {
                this.operand = new Integer(0);
                break;
            }
            case 4: {
                this.operand = new Integer(1);
                break;
            }
            case 5: {
                this.operand = new Integer(2);
                break;
            }
            case 6: {
                this.operand = new Integer(3);
                break;
            }
            case 7: {
                this.operand = new Integer(4);
                break;
            }
            case 8: {
                this.operand = new Integer(5);
                break;
            }
            case 9: {
                this.operand = new Long(0L);
                break;
            }
            case 10: {
                this.operand = new Long(1L);
                break;
            }
            case 11: {
                this.operand = new Float(0.0f);
                break;
            }
            case 12: {
                this.operand = new Float(1.0f);
                break;
            }
            case 13: {
                this.operand = new Float(2.0f);
                break;
            }
            case 14: {
                this.operand = new Double(0.0);
                break;
            }
            case 15: {
                this.operand = new Double(1.0);
                break;
            }
            case 16: {
                this.operand = new Integer(code[index + 1]);
                break;
            }
            case 17: {
                this.operand = new Integer(Instruction.toShort(code[index + 1], code[index + 2]));
                break;
            }
            case 18: {
                int i = Instruction.toUByte(code[index + 1]);
                this.operand = constants.constantAt(i);
                break;
            }
            case 19: 
            case 20: {
                int i = Instruction.toUShort(code[index + 1], code[index + 2]);
                this.operand = constants.constantAt(i);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int i = Instruction.toUByte(code[index + 1]);
                this.operand = i < locals.length && locals[i] != null ? locals[i] : new LocalVariable(i);
                break;
            }
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 42: {
                this.operand = 0 < locals.length && locals[0] != null ? locals[0] : new LocalVariable(0);
                break;
            }
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: {
                this.operand = 1 < locals.length && locals[1] != null ? locals[1] : new LocalVariable(1);
                break;
            }
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: {
                this.operand = 2 < locals.length && locals[2] != null ? locals[2] : new LocalVariable(2);
                break;
            }
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                this.operand = 3 < locals.length && locals[3] != null ? locals[3] : new LocalVariable(3);
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                int i = Instruction.toUByte(code[index + 1]);
                this.operand = i < locals.length && locals[i] != null ? locals[i] : new LocalVariable(i);
                break;
            }
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: {
                this.operand = 0 < locals.length && locals[0] != null ? locals[0] : new LocalVariable(0);
                break;
            }
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                this.operand = 1 < locals.length && locals[1] != null ? locals[1] : new LocalVariable(1);
                break;
            }
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                this.operand = 2 < locals.length && locals[2] != null ? locals[2] : new LocalVariable(2);
                break;
            }
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                this.operand = 3 < locals.length && locals[3] != null ? locals[3] : new LocalVariable(3);
                break;
            }
            case 132: {
                int i = Instruction.toUByte(code[index + 1]);
                byte incr = code[index + 2];
                this.operand = new IncOperand(i < locals.length && locals[i] != null ? locals[i] : new LocalVariable(i), incr);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                Assert.isTrue(targets.length == 1, "Illegal instruction: " + Opcode.opcNames[opc]);
                this.operand = new Label(targets[0]);
                break;
            }
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                Assert.isTrue(targets.length == 1, "Illegal instruction: " + Opcode.opcNames[opc]);
                this.operand = new Label(targets[0]);
                break;
            }
            case 169: {
                int i = Instruction.toUByte(code[index + 1]);
                this.operand = i < locals.length && locals[i] != null ? locals[i] : new LocalVariable(i);
                break;
            }
            case 170: {
                Label[] t = new Label[targets.length - 1];
                int[] v = new int[targets.length - 1];
                int j = lookups[0];
                for (int i = 1; i < targets.length; ++i) {
                    t[i - 1] = new Label(targets[i]);
                    v[i - 1] = j++;
                }
                this.operand = new Switch(new Label(targets[0]), t, v);
                break;
            }
            case 171: {
                Label[] t = new Label[targets.length - 1];
                int[] v = new int[targets.length - 1];
                for (int i = 1; i < targets.length; ++i) {
                    t[i - 1] = new Label(targets[i]);
                    v[i - 1] = lookups[i - 1];
                }
                this.operand = new Switch(new Label(targets[0]), t, v);
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 204: 
            case 205: {
                int i = Instruction.toUShort(code[index + 1], code[index + 2]);
                this.operand = constants.constantAt(i);
                break;
            }
            case 188: {
                byte atype = code[index + 1];
                this.operand = Type.getType(atype);
                break;
            }
            case 196: {
                opc = Instruction.toUByte(code[index + 1]);
                switch (opc) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        int i = Instruction.toUShort(code[index + 2], code[index + 3]);
                        this.operand = i < locals.length && locals[i] != null ? locals[i] : new LocalVariable(i);
                        break;
                    }
                    case 132: {
                        int i = Instruction.toUShort(code[index + 2], code[index + 3]);
                        short incr = Instruction.toShort(code[index + 4], code[index + 5]);
                        this.operand = new IncOperand(i < locals.length && locals[i] != null ? locals[i] : new LocalVariable(i), incr);
                    }
                }
                break;
            }
            case 197: {
                int i = Instruction.toUShort(code[index + 1], code[index + 2]);
                int dim = Instruction.toUByte(code[index + 3]);
                this.operand = new MultiArrayOperand((Type)constants.constantAt(i), dim);
                break;
            }
            case 237: {
                int i = Instruction.toUByte(code[index + 1]);
                this.operand = new Integer(i);
                break;
            }
            case 238: {
                int i = Instruction.toUByte(code[index + 1]);
                this.operand = new Integer(i);
                break;
            }
            case 239: {
                int i = Instruction.toUByte(code[index + 1]);
                this.operand = new Integer(i);
                break;
            }
        }
        this.origOpcode = opc;
        this.opcode = Opcode.opcXMap[opc];
    }

    public int origOpcode() {
        return this.origOpcode;
    }

    public void setUseSlow(boolean useSlow) {
        this.useSlow = useSlow;
    }

    public boolean useSlow() {
        return this.useSlow;
    }

    public boolean isLoad() {
        switch (this.opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    public boolean isStore() {
        switch (this.opcode) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return true;
            }
        }
        return false;
    }

    public boolean isInc() {
        return this.opcode == 132;
    }

    public boolean isThrow() {
        return this.opcode == 191;
    }

    public boolean isInvoke() {
        switch (this.opcode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return true;
            }
        }
        return false;
    }

    public boolean isRet() {
        return this.opcode == 169;
    }

    public boolean isReturn() {
        switch (this.opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    public boolean isSwitch() {
        return this.opcodeClass() == 170;
    }

    public boolean isJump() {
        return this.isConditionalJump() || this.isGoto();
    }

    public boolean isJsr() {
        return this.opcodeClass() == 168;
    }

    public boolean isGoto() {
        return this.opcodeClass() == 167;
    }

    public boolean isConditionalJump() {
        switch (this.opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return true;
            }
        }
        return false;
    }

    public int opcodeClass() {
        return this.opcode;
    }

    public void setOpcodeClass(int opcode) {
        this.opcode = opcode;
    }

    public void setOperand(Object operand) {
        this.operand = operand;
    }

    public Object operand() {
        return this.operand;
    }

    public String toString() {
        if (this.operand == null && this.opcodeClass() != 18) {
            return Opcode.opcNames[this.opcode];
        }
        if (this.operand instanceof Float) {
            return Opcode.opcNames[this.opcode] + " " + this.operand + "F";
        }
        if (this.operand instanceof Long) {
            return Opcode.opcNames[this.opcode] + " " + this.operand + "L";
        }
        if (this.operand instanceof String) {
            StringBuffer sb = new StringBuffer();
            String s = (String)this.operand;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isWhitespace(c) || ' ' <= c && c <= '~') {
                    sb.append(c);
                } else {
                    sb.append("\\u");
                    sb.append(Integer.toHexString(c));
                }
                if (sb.length() <= 50) continue;
                sb.append("...");
                break;
            }
            return Opcode.opcNames[this.opcode] + " \"" + sb.toString() + "\"";
        }
        return Opcode.opcNames[this.opcode] + " " + this.operand;
    }

    protected static int toUShort(byte b1, byte b2) {
        int x = (short)(Instruction.toUByte(b1) << 8) | Instruction.toUByte(b2);
        if (x < 0) {
            x += 65536;
        }
        return x;
    }

    protected static short toShort(byte b1, byte b2) {
        return (short)(Instruction.toUByte(b1) << 8 | Instruction.toUByte(b2));
    }

    protected static int toInt(byte b1, byte b2, byte b3, byte b4) {
        return Instruction.toUByte(b1) << 24 | Instruction.toUByte(b2) << 16 | Instruction.toUByte(b3) << 8 | Instruction.toUByte(b4);
    }

    protected static int toUByte(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public int category() {
        switch (this.opcode) {
            case 22: 
            case 24: 
            case 47: 
            case 49: 
            case 55: 
            case 57: 
            case 80: 
            case 82: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                return 2;
            }
            case 18: {
                if (this.operand instanceof Long || this.operand instanceof Double) {
                    return 2;
                }
                return 1;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MemberRef callee = (MemberRef)this.operand;
                if (callee.nameAndType().type().returnType().isWide()) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    public void visit(InstructionVisitor visitor) {
        switch (this.opcodeClass()) {
            case 0: {
                visitor.visit_nop(this);
                break;
            }
            case 18: {
                visitor.visit_ldc(this);
                break;
            }
            case 21: {
                visitor.visit_iload(this);
                break;
            }
            case 22: {
                visitor.visit_lload(this);
                break;
            }
            case 23: {
                visitor.visit_fload(this);
                break;
            }
            case 24: {
                visitor.visit_dload(this);
                break;
            }
            case 25: {
                visitor.visit_aload(this);
                break;
            }
            case 46: {
                visitor.visit_iaload(this);
                break;
            }
            case 47: {
                visitor.visit_laload(this);
                break;
            }
            case 48: {
                visitor.visit_faload(this);
                break;
            }
            case 49: {
                visitor.visit_daload(this);
                break;
            }
            case 50: {
                visitor.visit_aaload(this);
                break;
            }
            case 51: {
                visitor.visit_baload(this);
                break;
            }
            case 52: {
                visitor.visit_caload(this);
                break;
            }
            case 53: {
                visitor.visit_saload(this);
                break;
            }
            case 54: {
                visitor.visit_istore(this);
                break;
            }
            case 55: {
                visitor.visit_lstore(this);
                break;
            }
            case 56: {
                visitor.visit_fstore(this);
                break;
            }
            case 57: {
                visitor.visit_dstore(this);
                break;
            }
            case 58: {
                visitor.visit_astore(this);
                break;
            }
            case 79: {
                visitor.visit_iastore(this);
                break;
            }
            case 80: {
                visitor.visit_lastore(this);
                break;
            }
            case 81: {
                visitor.visit_fastore(this);
                break;
            }
            case 82: {
                visitor.visit_dastore(this);
                break;
            }
            case 83: {
                visitor.visit_aastore(this);
                break;
            }
            case 84: {
                visitor.visit_bastore(this);
                break;
            }
            case 85: {
                visitor.visit_castore(this);
                break;
            }
            case 86: {
                visitor.visit_sastore(this);
                break;
            }
            case 87: {
                visitor.visit_pop(this);
                break;
            }
            case 88: {
                visitor.visit_pop2(this);
                break;
            }
            case 89: {
                visitor.visit_dup(this);
                break;
            }
            case 90: {
                visitor.visit_dup_x1(this);
                break;
            }
            case 91: {
                visitor.visit_dup_x2(this);
                break;
            }
            case 92: {
                visitor.visit_dup2(this);
                break;
            }
            case 93: {
                visitor.visit_dup2_x1(this);
                break;
            }
            case 94: {
                visitor.visit_dup2_x2(this);
                break;
            }
            case 95: {
                visitor.visit_swap(this);
                break;
            }
            case 96: {
                visitor.visit_iadd(this);
                break;
            }
            case 97: {
                visitor.visit_ladd(this);
                break;
            }
            case 98: {
                visitor.visit_fadd(this);
                break;
            }
            case 99: {
                visitor.visit_dadd(this);
                break;
            }
            case 100: {
                visitor.visit_isub(this);
                break;
            }
            case 101: {
                visitor.visit_lsub(this);
                break;
            }
            case 102: {
                visitor.visit_fsub(this);
                break;
            }
            case 103: {
                visitor.visit_dsub(this);
                break;
            }
            case 104: {
                visitor.visit_imul(this);
                break;
            }
            case 105: {
                visitor.visit_lmul(this);
                break;
            }
            case 106: {
                visitor.visit_fmul(this);
                break;
            }
            case 107: {
                visitor.visit_dmul(this);
                break;
            }
            case 108: {
                visitor.visit_idiv(this);
                break;
            }
            case 109: {
                visitor.visit_ldiv(this);
                break;
            }
            case 110: {
                visitor.visit_fdiv(this);
                break;
            }
            case 111: {
                visitor.visit_ddiv(this);
                break;
            }
            case 112: {
                visitor.visit_irem(this);
                break;
            }
            case 113: {
                visitor.visit_lrem(this);
                break;
            }
            case 114: {
                visitor.visit_frem(this);
                break;
            }
            case 115: {
                visitor.visit_drem(this);
                break;
            }
            case 116: {
                visitor.visit_ineg(this);
                break;
            }
            case 117: {
                visitor.visit_lneg(this);
                break;
            }
            case 118: {
                visitor.visit_fneg(this);
                break;
            }
            case 119: {
                visitor.visit_dneg(this);
                break;
            }
            case 120: {
                visitor.visit_ishl(this);
                break;
            }
            case 121: {
                visitor.visit_lshl(this);
                break;
            }
            case 122: {
                visitor.visit_ishr(this);
                break;
            }
            case 123: {
                visitor.visit_lshr(this);
                break;
            }
            case 124: {
                visitor.visit_iushr(this);
                break;
            }
            case 125: {
                visitor.visit_lushr(this);
                break;
            }
            case 126: {
                visitor.visit_iand(this);
                break;
            }
            case 127: {
                visitor.visit_land(this);
                break;
            }
            case 128: {
                visitor.visit_ior(this);
                break;
            }
            case 129: {
                visitor.visit_lor(this);
                break;
            }
            case 130: {
                visitor.visit_ixor(this);
                break;
            }
            case 131: {
                visitor.visit_lxor(this);
                break;
            }
            case 132: {
                visitor.visit_iinc(this);
                break;
            }
            case 133: {
                visitor.visit_i2l(this);
                break;
            }
            case 134: {
                visitor.visit_i2f(this);
                break;
            }
            case 135: {
                visitor.visit_i2d(this);
                break;
            }
            case 136: {
                visitor.visit_l2i(this);
                break;
            }
            case 137: {
                visitor.visit_l2f(this);
                break;
            }
            case 138: {
                visitor.visit_l2d(this);
                break;
            }
            case 139: {
                visitor.visit_f2i(this);
                break;
            }
            case 140: {
                visitor.visit_f2l(this);
                break;
            }
            case 141: {
                visitor.visit_f2d(this);
                break;
            }
            case 142: {
                visitor.visit_d2i(this);
                break;
            }
            case 143: {
                visitor.visit_d2l(this);
                break;
            }
            case 144: {
                visitor.visit_d2f(this);
                break;
            }
            case 145: {
                visitor.visit_i2b(this);
                break;
            }
            case 146: {
                visitor.visit_i2c(this);
                break;
            }
            case 147: {
                visitor.visit_i2s(this);
                break;
            }
            case 148: {
                visitor.visit_lcmp(this);
                break;
            }
            case 149: {
                visitor.visit_fcmpl(this);
                break;
            }
            case 150: {
                visitor.visit_fcmpg(this);
                break;
            }
            case 151: {
                visitor.visit_dcmpl(this);
                break;
            }
            case 152: {
                visitor.visit_dcmpg(this);
                break;
            }
            case 153: {
                visitor.visit_ifeq(this);
                break;
            }
            case 154: {
                visitor.visit_ifne(this);
                break;
            }
            case 155: {
                visitor.visit_iflt(this);
                break;
            }
            case 156: {
                visitor.visit_ifge(this);
                break;
            }
            case 157: {
                visitor.visit_ifgt(this);
                break;
            }
            case 158: {
                visitor.visit_ifle(this);
                break;
            }
            case 159: {
                visitor.visit_if_icmpeq(this);
                break;
            }
            case 160: {
                visitor.visit_if_icmpne(this);
                break;
            }
            case 161: {
                visitor.visit_if_icmplt(this);
                break;
            }
            case 162: {
                visitor.visit_if_icmpge(this);
                break;
            }
            case 163: {
                visitor.visit_if_icmpgt(this);
                break;
            }
            case 164: {
                visitor.visit_if_icmple(this);
                break;
            }
            case 165: {
                visitor.visit_if_acmpeq(this);
                break;
            }
            case 166: {
                visitor.visit_if_acmpne(this);
                break;
            }
            case 167: {
                visitor.visit_goto(this);
                break;
            }
            case 168: {
                visitor.visit_jsr(this);
                break;
            }
            case 169: {
                visitor.visit_ret(this);
                break;
            }
            case 170: {
                visitor.visit_switch(this);
                break;
            }
            case 172: {
                visitor.visit_ireturn(this);
                break;
            }
            case 173: {
                visitor.visit_lreturn(this);
                break;
            }
            case 174: {
                visitor.visit_freturn(this);
                break;
            }
            case 175: {
                visitor.visit_dreturn(this);
                break;
            }
            case 176: {
                visitor.visit_areturn(this);
                break;
            }
            case 177: {
                visitor.visit_return(this);
                break;
            }
            case 178: {
                visitor.visit_getstatic(this);
                break;
            }
            case 179: {
                visitor.visit_putstatic(this);
                break;
            }
            case 205: {
                visitor.visit_putstatic_nowb(this);
                break;
            }
            case 180: {
                visitor.visit_getfield(this);
                break;
            }
            case 181: {
                visitor.visit_putfield(this);
                break;
            }
            case 204: {
                visitor.visit_putfield_nowb(this);
                break;
            }
            case 182: {
                visitor.visit_invokevirtual(this);
                break;
            }
            case 183: {
                visitor.visit_invokespecial(this);
                break;
            }
            case 184: {
                visitor.visit_invokestatic(this);
                break;
            }
            case 185: {
                visitor.visit_invokeinterface(this);
                break;
            }
            case 187: {
                visitor.visit_new(this);
                break;
            }
            case 188: {
                visitor.visit_newarray(this);
                break;
            }
            case 190: {
                visitor.visit_arraylength(this);
                break;
            }
            case 191: {
                visitor.visit_athrow(this);
                break;
            }
            case 192: {
                visitor.visit_checkcast(this);
                break;
            }
            case 193: {
                visitor.visit_instanceof(this);
                break;
            }
            case 194: {
                visitor.visit_monitorenter(this);
                break;
            }
            case 195: {
                visitor.visit_monitorexit(this);
                break;
            }
            case 197: {
                visitor.visit_multianewarray(this);
                break;
            }
            case 198: {
                visitor.visit_ifnull(this);
                break;
            }
            case 199: {
                visitor.visit_ifnonnull(this);
                break;
            }
            case 237: {
                visitor.visit_rc(this);
                break;
            }
            case 238: {
                visitor.visit_aupdate(this);
                break;
            }
            case 239: {
                visitor.visit_supdate(this);
                break;
            }
            case 240: {
                visitor.visit_aswizzle(this);
                break;
            }
            case 241: {
                visitor.visit_aswrange(this);
            }
        }
    }
}

