/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ConstantPool;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import java.io.PrintStream;

public class FieldEditor {
    private ClassEditor editor;
    private FieldInfo fieldInfo;
    private String name;
    private Type type;
    private Object constantValue;
    private boolean isDirty;
    private boolean isDeleted = false;

    public FieldEditor(ClassEditor editor, int modifiers, Type type, String name) {
        this(editor, modifiers, type, name, null);
    }

    public FieldEditor(ClassEditor editor, int modifiers, Class type, String name, Object constantValue) {
        this(editor, modifiers, Type.getType(type), name, constantValue);
    }

    public FieldEditor(ClassEditor editor, int modifiers, Class type, String name) {
        this(editor, modifiers, Type.getType(type), name, null);
    }

    /*
     * WARNING - void declaration
     */
    public FieldEditor(ClassEditor editor, int modifiers, Type type, String name, Object constantValue) {
        FieldInfo[] fields = editor.fields();
        for (int i = 0; i < fields.length; ++i) {
            FieldEditor fe = new FieldEditor(editor, fields[i]);
            if (!fe.name().equals(name)) continue;
            String s = "A field named " + name + " already exists in " + editor.name();
            throw new IllegalArgumentException(s);
        }
        this.editor = editor;
        ConstantPool cp = editor.constants();
        this.name = name;
        this.type = type;
        int typeIndex = cp.getUTF8Index(this.type.descriptor());
        int nameIndex = cp.getUTF8Index(name);
        ClassInfo classInfo = editor.classInfo();
        if (constantValue != null) {
            void var11_15;
            int valueIndex;
            if ((modifiers & 8) == 0 || (modifiers & 0x10) == 0) {
                String s = "Field " + name + " with a constant value must be static and final";
                throw new IllegalArgumentException(s);
            }
            if (constantValue instanceof String) {
                if (!type.equals(Type.STRING)) {
                    String s = "Can't have field type of " + type.className() + " with a constant value of \"" + constantValue + "\"";
                    throw new IllegalArgumentException(s);
                }
                valueIndex = cp.getStringIndex((String)constantValue);
            } else if (constantValue instanceof Integer) {
                if (!type.equals(Type.INTEGER)) {
                    String s = "Can't have field type of " + type.className() + " with a constant value of \"" + constantValue + "\"";
                    throw new IllegalArgumentException(s);
                }
                valueIndex = cp.getIntegerIndex((Integer)constantValue);
            } else if (constantValue instanceof Long) {
                if (!type.equals(Type.LONG)) {
                    String s = "Can't have field type of " + type.className() + " with a constant value of \"" + constantValue + "\"";
                    throw new IllegalArgumentException(s);
                }
                valueIndex = cp.getLongIndex((Long)constantValue);
            } else if (constantValue instanceof Float) {
                if (!type.equals(Type.FLOAT)) {
                    String s = "Can't have field type of " + type.className() + " with a constant value of \"" + constantValue + "\"";
                    throw new IllegalArgumentException(s);
                }
                valueIndex = cp.getFloatIndex((Float)constantValue);
            } else if (constantValue instanceof Double) {
                if (!type.equals(Type.DOUBLE)) {
                    String s = "Can't have field type of " + type.className() + " with a constant value of \"" + constantValue + "\"";
                    throw new IllegalArgumentException(s);
                }
                valueIndex = cp.getDoubleIndex((Double)constantValue);
            } else {
                String s = "Cannot have a constant value of type " + constantValue.getClass().getName();
                throw new IllegalArgumentException(s);
            }
            this.constantValue = constantValue;
            int cvNameIndex = cp.getUTF8Index("ConstantValue");
            this.fieldInfo = classInfo.addNewField(modifiers, typeIndex, nameIndex, cvNameIndex, (int)var11_15);
        } else {
            this.fieldInfo = classInfo.addNewField(modifiers, typeIndex, nameIndex);
        }
        this.isDirty = true;
    }

    public FieldEditor(ClassEditor editor, FieldInfo fieldInfo) {
        ConstantPool cp = editor.constants();
        this.fieldInfo = fieldInfo;
        this.editor = editor;
        int index = fieldInfo.nameIndex();
        this.name = (String)cp.constantAt(index);
        index = fieldInfo.typeIndex();
        String typeName = (String)cp.constantAt(index);
        this.type = Type.getType(typeName);
        index = fieldInfo.constantValue();
        this.constantValue = cp.constantAt(index);
        this.isDirty = false;
    }

    public ClassEditor declaringClass() {
        return this.editor;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        this.isDirty = isDirty;
        if (isDirty) {
            this.editor.setDirty(true);
        }
    }

    public void delete() {
        this.setDirty(true);
        this.isDeleted = true;
    }

    public FieldInfo fieldInfo() {
        return this.fieldInfo;
    }

    public Object constantValue() {
        return this.constantValue;
    }

    public boolean isPublic() {
        return (this.fieldInfo.modifiers() & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.fieldInfo.modifiers() & 2) != 0;
    }

    public boolean isProtected() {
        return (this.fieldInfo.modifiers() & 4) != 0;
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return (this.fieldInfo.modifiers() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.fieldInfo.modifiers() & 0x10) != 0;
    }

    public boolean isVolatile() {
        return (this.fieldInfo.modifiers() & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.fieldInfo.modifiers() & 0x80) != 0;
    }

    public void setPublic(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        int modifiers = this.fieldInfo.modifiers();
        modifiers = flag ? (modifiers |= 1) : (modifiers &= 0xFFFFFFFE);
        this.fieldInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setPrivate(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        int modifiers = this.fieldInfo.modifiers();
        modifiers = flag ? (modifiers |= 2) : (modifiers &= 0xFFFFFFFD);
        this.fieldInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setProtected(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        int modifiers = this.fieldInfo.modifiers();
        modifiers = flag ? (modifiers |= 4) : (modifiers &= 0xFFFFFFFB);
        this.fieldInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setStatic(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        int modifiers = this.fieldInfo.modifiers();
        modifiers = flag ? (modifiers |= 8) : (modifiers &= 0xFFFFFFF7);
        this.fieldInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setFinal(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        int modifiers = this.fieldInfo.modifiers();
        modifiers = flag ? (modifiers |= 0x10) : (modifiers &= 0xFFFFFFEF);
        this.fieldInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setTransient(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        int modifiers = this.fieldInfo.modifiers();
        modifiers = flag ? (modifiers |= 0x80) : (modifiers &= 0xFFFFFF7F);
        this.fieldInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public void setVolatile(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException(s);
        }
        int modifiers = this.fieldInfo.modifiers();
        modifiers = flag ? (modifiers |= 0x40) : (modifiers &= 0xFFFFFFBF);
        this.fieldInfo.setModifiers(modifiers);
        this.setDirty(true);
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public NameAndType nameAndType() {
        return new NameAndType(this.name(), this.type());
    }

    public MemberRef memberRef() {
        return new MemberRef(this.declaringClass().type(), this.nameAndType());
    }

    public void commit() {
        if (this.isDeleted) {
            ConstantPool cp = this.editor.constants();
            int nameIndex = cp.getUTF8Index(this.name);
            this.editor.classInfo().deleteField(nameIndex);
        } else {
            ConstantPool cp = this.editor.constants();
            this.fieldInfo.setNameIndex(cp.addConstant(1, this.name));
            this.fieldInfo.setTypeIndex(cp.addConstant(1, this.type.descriptor()));
            if (this.constantValue != null) {
                if (this.constantValue instanceof Long) {
                    this.fieldInfo.setConstantValue(cp.addConstant(5, this.constantValue));
                } else if (this.constantValue instanceof Float) {
                    this.fieldInfo.setConstantValue(cp.addConstant(4, this.constantValue));
                } else if (this.constantValue instanceof Double) {
                    this.fieldInfo.setConstantValue(cp.addConstant(6, this.constantValue));
                } else if (this.constantValue instanceof Integer) {
                    this.fieldInfo.setConstantValue(cp.addConstant(3, this.constantValue));
                } else if (this.constantValue instanceof String) {
                    this.fieldInfo.setConstantValue(cp.addConstant(8, this.constantValue));
                }
            }
        }
        this.isDirty = false;
    }

    public void print(PrintStream out) {
        out.println("field " + this.name + " " + this.type);
    }

    public String fullName() {
        return this.declaringClass().name() + "." + this.name();
    }

    public String toString() {
        return "[FieldEditor for " + this.name + this.type + "]";
    }
}

