/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.Graph;
import EDU.purdue.cs.bloat.util.GraphNode;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ClassHierarchy {
    public static final Type POS_SHORT = Type.getType("L+short!;");
    public static final Type POS_BYTE = Type.getType("L+byte!;");
    static final int MAX_INT = 8;
    static final int MAX_SHORT = 7;
    static final int MAX_CHAR = 6;
    static final int MAX_BYTE = 5;
    static final int MAX_BOOL = 4;
    static final int MIN_CHAR = 3;
    static final int MIN_BOOL = 3;
    static final int ZERO = 3;
    static final int MIN_BYTE = 2;
    static final int MIN_SHORT = 1;
    static final int MIN_INT = 0;
    public static boolean DEBUG = false;
    public static boolean RELAX = false;
    Set classes;
    Graph extendsGraph;
    Graph implementsGraph;
    boolean closure;
    private Map resolvesToCache;
    EditorContext context;
    LinkedList worklist;
    Set inWorklist;

    private void db(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    public ClassHierarchy(EditorContext context, Collection initial, boolean closure) {
        this.context = context;
        this.closure = closure;
        this.classes = new HashSet();
        this.extendsGraph = new Graph();
        this.implementsGraph = new Graph();
        this.worklist = new LinkedList();
        this.inWorklist = new HashSet();
        this.resolvesToCache = new HashMap();
        Iterator iter = new ArrayList(initial).iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.addClass(name);
        }
    }

    public void addClassNamed(String name) {
        this.addClass(name);
    }

    public Collection subclasses(Type type) {
        TypeNode node = this.getExtendsNode(type);
        if (node != null) {
            ArrayList list = new ArrayList(this.extendsGraph.preds(node));
            ListIterator<Type> iter = list.listIterator();
            while (iter.hasNext()) {
                TypeNode v = (TypeNode)iter.next();
                iter.set(v.type);
            }
            return list;
        }
        return new ArrayList();
    }

    public Type superclass(Type type) {
        Collection succs;
        Iterator iter;
        TypeNode node = this.getExtendsNode(type);
        if (node != null && (iter = (succs = this.extendsGraph.succs(node)).iterator()).hasNext()) {
            TypeNode v = (TypeNode)iter.next();
            return v.type;
        }
        return null;
    }

    public Collection interfaces(Type type) {
        TypeNode node = this.getImplementsNode(type);
        if (node != null) {
            ArrayList list = new ArrayList(this.implementsGraph.succs(node));
            ListIterator<Type> iter = list.listIterator();
            while (iter.hasNext()) {
                TypeNode v = (TypeNode)iter.next();
                iter.set(v.type);
            }
            return list;
        }
        return new ArrayList();
    }

    public Collection implementors(Type type) {
        TypeNode node = this.getImplementsNode(type);
        if (node != null) {
            ArrayList list = new ArrayList(this.implementsGraph.preds(node));
            ListIterator<Type> iter = list.listIterator();
            while (iter.hasNext()) {
                TypeNode v = (TypeNode)iter.next();
                iter.set(v.type);
            }
            return list;
        }
        return new ArrayList();
    }

    public boolean subclassOf(Type a, Type b) {
        Assert.isTrue(a.isReference() && b.isReference(), "Cannot compare " + a + " and " + b);
        if (a.equals(b)) {
            return true;
        }
        if (b.equals(Type.OBJECT)) {
            return true;
        }
        if (b.isNull()) {
            return a.isNull();
        }
        if (a.isArray()) {
            if (b.isArray()) {
                if (a.elementType().isReference() && b.elementType().isReference()) {
                    return this.subclassOf(a.elementType(), b.elementType());
                }
                return a.elementType().equals(b.elementType());
            }
            return false;
        }
        if (b.isArray()) {
            return false;
        }
        Type t = a;
        while (t != null) {
            if (t.equals(b)) {
                return true;
            }
            t = this.superclass(t);
        }
        return false;
    }

    public Collection classes() {
        Assert.isTrue(this.classes != null);
        return this.classes;
    }

    public boolean closure() {
        return this.closure;
    }

    private TypeNode getExtendsNode(Type type) {
        GraphNode node = this.extendsGraph.getNode(type);
        if (node == null && type.isObject()) {
            this.addClassNamed(type.className());
        }
        return (TypeNode)this.extendsGraph.getNode(type);
    }

    private TypeNode getImplementsNode(Type type) {
        GraphNode node = this.implementsGraph.getNode(type);
        if (node == null && type.isObject()) {
            this.addClassNamed(type.className());
        }
        return (TypeNode)this.implementsGraph.getNode(type);
    }

    private void addClass(String name) {
        Type type = Type.getType(Type.classDescriptor(name));
        if (this.classes.contains(type)) {
            return;
        }
        if (this.inWorklist.contains(type)) {
            return;
        }
        this.db("ClassHierarchy: Adding " + name + " to hierarchy");
        this.worklist.add(type);
        this.inWorklist.add(type);
        while (!this.worklist.isEmpty()) {
            Type t;
            String desc;
            int i;
            ClassEditor c;
            type = (Type)this.worklist.removeFirst();
            this.inWorklist.remove(type);
            if (this.classes.contains(type)) continue;
            this.classes.add(type);
            TypeNode extendsNode = this.getExtendsNode(type);
            if (extendsNode == null) {
                extendsNode = new TypeNode(type);
                this.extendsGraph.addNode(type, extendsNode);
            }
            try {
                c = this.context.editClass(type.className());
            }
            catch (ClassNotFoundException ex) {
                if (RELAX) continue;
                throw new RuntimeException("Class not found: " + ex.getMessage());
            }
            Type[] interfaces = c.interfaces();
            if (c.superclass() != null) {
                if (!c.isInterface() || interfaces.length == 0) {
                    TypeNode superNode = this.getExtendsNode(c.superclass());
                    if (superNode == null) {
                        superNode = new TypeNode(c.superclass());
                        this.extendsGraph.addNode(c.superclass(), superNode);
                    }
                    if (!extendsNode.type.equals(Type.OBJECT)) {
                        this.extendsGraph.addEdge(extendsNode, superNode);
                    }
                }
            } else if (!type.equals(Type.OBJECT) && !RELAX) {
                throw new RuntimeException("Null superclass for " + type);
            }
            if (c.isInterface()) {
                for (int i2 = 0; i2 < interfaces.length; ++i2) {
                    Type iType = interfaces[i2];
                    TypeNode iNode = this.getExtendsNode(iType);
                    if (iNode == null) {
                        iNode = new TypeNode(iType);
                        this.extendsGraph.addNode(iType, iNode);
                    }
                    this.extendsGraph.addEdge(extendsNode, iNode);
                }
            } else {
                TypeNode implementsNode = null;
                if (interfaces.length > 0 && (implementsNode = this.getImplementsNode(type)) == null) {
                    implementsNode = new TypeNode(type);
                    this.implementsGraph.addNode(type, implementsNode);
                }
                for (int i3 = 0; i3 < interfaces.length; ++i3) {
                    Type iType = interfaces[i3];
                    TypeNode iNode = this.getImplementsNode(iType);
                    if (iNode == null) {
                        iNode = new TypeNode(iType);
                        this.implementsGraph.addNode(iType, iNode);
                    }
                    this.implementsGraph.addEdge(implementsNode, iNode);
                }
            }
            if (c.superclass() != null) {
                this.addType(c.superclass());
            }
            for (i = 0; i < c.interfaces().length; ++i) {
                this.addType(c.interfaces()[i]);
            }
            if (!this.closure) {
                this.context.release(c.classInfo());
                continue;
            }
            for (i = 0; i < c.methods().length; ++i) {
                MethodInfo m = c.methods()[i];
                int typeIndex = m.typeIndex();
                desc = (String)c.constants().constantAt(typeIndex);
                t = Type.getType(desc);
                this.addType(t);
            }
            for (i = 0; i < c.fields().length; ++i) {
                FieldInfo f = c.fields()[i];
                int typeIndex = f.typeIndex();
                desc = (String)c.constants().constantAt(typeIndex);
                t = Type.getType(desc);
                this.addType(t);
            }
            for (i = 0; i < c.constants().numConstants(); ++i) {
                Object t2;
                int tag = c.constants().constantTag(i);
                if (tag == 5 || tag == 6) {
                    ++i;
                    continue;
                }
                if (tag == 7) {
                    t2 = (Type)c.constants().constantAt(i);
                    this.addType((Type)t2);
                    continue;
                }
                if (tag != 12) continue;
                t2 = (NameAndType)c.constants().constantAt(i);
                this.addType(((NameAndType)t2).type());
            }
            this.context.release(c.classInfo());
        }
    }

    private void addType(Type type) {
        if (type.isMethod()) {
            Type[] paramTypes = type.paramTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                this.addType(paramTypes[i]);
            }
            Type returnType = type.returnType();
            this.addType(returnType);
            return;
        }
        if (type.isArray()) {
            this.addType(type.elementType());
            return;
        }
        if (!type.isObject()) {
            return;
        }
        if (this.classes.contains(type)) {
            return;
        }
        if (this.inWorklist.contains(type)) {
            return;
        }
        this.worklist.add(type);
        this.inWorklist.add(type);
    }

    public Type intersectType(Type a, Type b) {
        Assert.isTrue(a.isReference() && b.isReference(), "Cannot intersect " + a + " and " + b);
        if (a.equals(b)) {
            return a;
        }
        if (a.isNull() || b.isNull()) {
            return Type.NULL;
        }
        if (a.equals(Type.OBJECT)) {
            return b;
        }
        if (b.equals(Type.OBJECT)) {
            return a;
        }
        if (a.isArray()) {
            if (b.isArray()) {
                if (a.elementType().isReference() && b.elementType().isReference()) {
                    Type t = this.intersectType(a.elementType(), b.elementType());
                    if (t.isNull()) {
                        return Type.NULL;
                    }
                    return t.arrayType();
                }
                if (a.elementType().isReference() || b.elementType().isReference()) {
                    return Type.NULL;
                }
                return Type.NULL;
            }
            return Type.NULL;
        }
        if (b.isArray()) {
            return Type.NULL;
        }
        Type t = a;
        while (t != null) {
            if (t.equals(b)) {
                return a;
            }
            t = this.superclass(t);
        }
        t = b;
        while (t != null) {
            if (t.equals(a)) {
                return b;
            }
            t = this.superclass(t);
        }
        return Type.NULL;
    }

    public Type unionTypes(Collection types) {
        if (types.size() <= 0) {
            return Type.OBJECT;
        }
        Iterator ts = types.iterator();
        Type type = (Type)ts.next();
        while (ts.hasNext()) {
            type = this.unionType(type, (Type)ts.next());
        }
        return type;
    }

    public Type unionType(Type a, Type b) {
        if (a.equals(b)) {
            return a;
        }
        if (a.equals(Type.OBJECT) || b.equals(Type.OBJECT)) {
            return Type.OBJECT;
        }
        if (a.isNull()) {
            return b;
        }
        if (b.isNull()) {
            return a;
        }
        if ((a.isIntegral() || a.equals(POS_BYTE) || a.equals(POS_SHORT)) && (b.isIntegral() || b.equals(POS_BYTE) || b.equals(POS_SHORT))) {
            BitSet v1 = ClassHierarchy.typeToSet(a);
            BitSet v2 = ClassHierarchy.typeToSet(b);
            v1.or(v2);
            return ClassHierarchy.setToType(v1);
        }
        Assert.isTrue(a.isReference() && b.isReference(), "Cannot union " + a + " and " + b);
        if (a.isArray()) {
            if (b.isArray()) {
                if (a.elementType().isReference() && b.elementType().isReference()) {
                    Type t = this.unionType(a.elementType(), b.elementType());
                    return t.arrayType();
                }
                if (a.elementType().isReference() || b.elementType().isReference()) {
                    return Type.OBJECT;
                }
                return Type.OBJECT;
            }
            return Type.OBJECT;
        }
        if (b.isArray()) {
            return Type.OBJECT;
        }
        HashSet<Type> superOfA = new HashSet<Type>();
        HashSet<Type> superOfB = new HashSet<Type>();
        Type t = a;
        while (t != null) {
            superOfA.add(t);
            t = this.superclass(t);
        }
        t = b;
        while (t != null) {
            if (superOfA.contains(t)) {
                return t;
            }
            superOfB.add(t);
            t = this.superclass(t);
        }
        t = a;
        while (t != null) {
            if (superOfB.contains(t)) {
                return t;
            }
            t = this.superclass(t);
        }
        throw new RuntimeException("No common super type for " + a + " (" + superOfA + ")" + " and " + b + " (" + superOfB + ")");
    }

    public void printClasses(PrintWriter out, int indent) {
        TypeNode objectNode = this.getExtendsNode(Type.OBJECT);
        this.indent(out, indent);
        out.println(objectNode.type);
        this.printSubclasses(objectNode.type, out, true, indent + 2);
    }

    public void printImplements(PrintWriter out, int indent) {
        indent += 2;
        Iterator roots = this.implementsGraph.roots().iterator();
        while (roots.hasNext()) {
            TypeNode iNode = (TypeNode)roots.next();
            this.indent(out, indent);
            out.println(iNode.type);
            this.printImplementors(iNode.type, out, true, indent + 2);
        }
    }

    private void printImplementors(Type iType, PrintWriter out, boolean recurse, int indent) {
        Iterator implementors = this.implementors(iType).iterator();
        while (implementors.hasNext()) {
            Type implementor = (Type)implementors.next();
            this.indent(out, indent);
            out.println(implementor);
            if (!recurse) continue;
            this.printImplementors(implementor, out, recurse, indent + 2);
        }
    }

    private void indent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
    }

    private void printSubclasses(Type classType, PrintWriter out, boolean recurse, int indent) {
        Iterator iter = this.subclasses(classType).iterator();
        while (iter.hasNext()) {
            Type subclass = (Type)iter.next();
            this.indent(out, indent);
            out.println(subclass);
            if (!recurse) continue;
            this.printSubclasses(subclass, out, recurse, indent + 2);
        }
    }

    public boolean methodIsOverridden(Type classType, NameAndType nat) {
        String methodName = nat.name();
        Type methodType = nat.type();
        this.db("ClassHierarchy: Is " + classType + "." + methodName + methodType + " overridden?");
        Collection subclasses = this.subclasses(classType);
        Iterator iter = subclasses.iterator();
        while (iter.hasNext()) {
            Type subclass = (Type)iter.next();
            this.db("Examining subclass " + subclass);
            ClassEditor ce = null;
            try {
                ce = this.context.editClass(subclass.className());
            }
            catch (ClassNotFoundException ex) {
                this.db(ex.getMessage());
                return true;
            }
            MethodInfo[] methods = ce.methods();
            for (int i = 0; i < methods.length; ++i) {
                MethodEditor me = this.context.editMethod(methods[i]);
                if (!me.name().equals(methodName) || !me.type().equals(methodType)) continue;
                this.db("  " + methodName + methodType + " is overridden by " + me.name() + me.type());
                this.context.release(ce.classInfo());
                return true;
            }
            if (this.methodIsOverridden(subclass, nat)) {
                this.context.release(ce.classInfo());
                return true;
            }
            this.context.release(ce.classInfo());
        }
        this.db("  NO!");
        return false;
    }

    public MemberRef methodInvoked(Type receiver, NameAndType method) {
        Type type = receiver;
        while (type != null) {
            MemberRef m = new MemberRef(type, method);
            try {
                this.context.editMethod(m);
                return m;
            }
            catch (NoSuchMethodException ex) {
                type = this.superclass(type);
            }
        }
        throw new IllegalArgumentException("No implementation of " + receiver + "." + method);
    }

    public static Type setToType(BitSet v) {
        if (v.get(8)) {
            return Type.INTEGER;
        }
        if (v.get(6)) {
            if (v.get(0) || v.get(1) || v.get(2)) {
                return Type.INTEGER;
            }
            return Type.CHARACTER;
        }
        if (v.get(7)) {
            if (v.get(0)) {
                return Type.INTEGER;
            }
            if (v.get(1) || v.get(2)) {
                return Type.SHORT;
            }
            return POS_SHORT;
        }
        if (v.get(5)) {
            if (v.get(0)) {
                return Type.INTEGER;
            }
            if (v.get(1)) {
                return Type.SHORT;
            }
            if (v.get(2)) {
                return Type.BYTE;
            }
            return POS_BYTE;
        }
        if (v.get(4)) {
            if (v.get(0)) {
                return Type.INTEGER;
            }
            if (v.get(1)) {
                return Type.SHORT;
            }
            if (v.get(2)) {
                return Type.BYTE;
            }
            return Type.BOOLEAN;
        }
        if (v.get(0)) {
            return Type.INTEGER;
        }
        if (v.get(1)) {
            return Type.SHORT;
        }
        if (v.get(2)) {
            return Type.BYTE;
        }
        return Type.BOOLEAN;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet typeToSet(Type type) {
        void var3_3;
        int hi;
        int lo;
        BitSet v = new BitSet(8);
        if (type.equals(Type.INTEGER)) {
            lo = 0;
            hi = 8;
        } else if (type.equals(Type.CHARACTER)) {
            lo = 3;
            hi = 6;
        } else if (type.equals(Type.SHORT)) {
            lo = 1;
            hi = 7;
        } else if (type.equals(POS_SHORT)) {
            lo = 3;
            hi = 7;
        } else if (type.equals(Type.BYTE)) {
            lo = 2;
            hi = 5;
        } else if (type.equals(POS_BYTE)) {
            lo = 3;
            hi = 5;
        } else if (type.equals(Type.BOOLEAN)) {
            lo = 3;
            hi = 4;
        } else {
            throw new RuntimeException();
        }
        for (void i = var2_2; i <= var3_3; ++i) {
            v.set((int)i);
        }
        return v;
    }

    public Set resolvesToWith(MemberRef method) {
        HashSet<ResolvesToWith> resolvesTo = (HashSet<ResolvesToWith>)this.resolvesToCache.get(method);
        if (resolvesTo == null) {
            this.db("Resolving " + method);
            resolvesTo = new HashSet<ResolvesToWith>();
            ResolvesToWith rtw = new ResolvesToWith();
            rtw.method = method;
            rtw.rTypes = new HashSet();
            MethodEditor me = null;
            try {
                me = this.context.editMethod(method);
            }
            catch (NoSuchMethodException ex1) {
                this.db("  Hmm. Method is not implemented in declaring class");
            }
            if (me != null && (me.isStatic() || me.isConstructor())) {
                rtw.rTypes.add(method.declaringClass());
                resolvesTo.add(rtw);
                this.db("  Static method or constructor, resolves to itself");
            } else {
                LinkedList<Type> types = new LinkedList<Type>();
                types.add(method.declaringClass());
                while (!types.isEmpty()) {
                    Type type = (Type)types.remove(0);
                    this.db("  Examining type " + type);
                    ClassEditor ce = null;
                    try {
                        ce = this.context.editClass(type);
                    }
                    catch (ClassNotFoundException ex1) {
                        System.err.println("** Class not found: " + ex1.getMessage());
                        ex1.printStackTrace(System.err);
                        System.exit(1);
                    }
                    if (ce.isInterface()) {
                        Iterator subinterfaces = this.subclasses(type).iterator();
                        while (subinterfaces.hasNext()) {
                            Type subinterface = (Type)subinterfaces.next();
                            types.add(subinterface);
                            this.db("  Noting subinterface " + subinterface);
                        }
                        Iterator implementors = this.implementors(type).iterator();
                        while (implementors.hasNext()) {
                            Type implementor = (Type)implementors.next();
                            types.add(implementor);
                            this.db("  Noting implementor " + implementor);
                        }
                        continue;
                    }
                    NameAndType nat = method.nameAndType();
                    MethodInfo[] methods = ce.methods();
                    boolean overridden = false;
                    for (int i = 0; i < methods.length; ++i) {
                        MethodEditor over = this.context.editMethod(methods[i]);
                        MemberRef ref = over.memberRef();
                        if (!ref.nameAndType().equals(nat) || method.declaringClass().equals(type)) continue;
                        this.db("  Class " + type + " overrides " + method);
                        resolvesTo.addAll(this.resolvesToWith(ref));
                        overridden = true;
                    }
                    if (overridden) continue;
                    this.db("  " + rtw.method + " called with " + type);
                    rtw.rTypes.add(type);
                    resolvesTo.add(rtw);
                    Iterator subclasses = this.subclasses(type).iterator();
                    while (subclasses.hasNext()) {
                        Type subclass = (Type)subclasses.next();
                        types.add(subclass);
                        this.db("  Noting subclass " + subclass);
                    }
                }
            }
            this.resolvesToCache.put(method, resolvesTo);
        }
        return resolvesTo;
    }

    public class ResolvesToWith {
        public MemberRef method;
        public HashSet rTypes;
    }

    class TypeNode
    extends GraphNode {
        Type type;

        public TypeNode(Type type) {
            this.type = type;
        }

        public String toString() {
            return "[" + this.type + "]";
        }
    }
}

