/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.diva;

import EDU.purdue.cs.bloat.cfg.DominatorTree;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.VerifyCFG;
import EDU.purdue.cs.bloat.codegen.CodeGenerator;
import EDU.purdue.cs.bloat.codegen.Liveness;
import EDU.purdue.cs.bloat.context.BloatContext;
import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.diva.InductionVarAnalyzer;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFile;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.ssa.SSA;
import EDU.purdue.cs.bloat.ssa.SSAGraph;
import EDU.purdue.cs.bloat.tbaa.TypeInference;
import EDU.purdue.cs.bloat.trans.CompactArrayInitializer;
import EDU.purdue.cs.bloat.trans.DeadCodeElimination;
import EDU.purdue.cs.bloat.trans.ExprPropagation;
import EDU.purdue.cs.bloat.trans.Peephole;
import EDU.purdue.cs.bloat.trans.PersistentCheckElimination;
import EDU.purdue.cs.bloat.trans.SSAPRE;
import EDU.purdue.cs.bloat.trans.StackPRE;
import EDU.purdue.cs.bloat.trans.ValueFolding;
import EDU.purdue.cs.bloat.trans.ValueNumbering;
import EDU.purdue.cs.bloat.tree.Tree;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Main {
    static boolean DEBUG = false;
    static boolean VERBOSE = false;
    static boolean FORCE = false;
    static boolean CLOSURE = false;
    static boolean PRE = true;
    static boolean DCE = true;
    static boolean PROP = true;
    static boolean FOLD = true;
    static boolean STACK_ALLOC = false;
    static boolean COMPACT_ARRAY_INIT = true;
    static boolean ANNO = true;
    static String[] ARGS = null;
    static List SKIP = new ArrayList();
    static List ONLY = new ArrayList();
    static String METHOD = null;
    static BloatContext context = null;
    static ClassFileLoader loader = null;

    public static void main(String[] args) {
        try {
            Iterator e;
            loader = new ClassFileLoader();
            ArrayList<String> classes = new ArrayList<String>(args.length);
            boolean gotdir = false;
            ARGS = args;
            for (int i = 0; i < args.length; ++i) {
                String pkg;
                if (args[i].equals("-v") || args[i].equals("-verbose")) {
                    VERBOSE = true;
                    loader.setVerbose(true);
                    continue;
                }
                if (args[i].equals("-debug")) {
                    DEBUG = true;
                    loader.setVerbose(true);
                    ClassFileLoader.DEBUG = true;
                    CompactArrayInitializer.DEBUG = true;
                    ClassEditor.DEBUG = true;
                    FlowGraph.DEBUG = true;
                    DominatorTree.DEBUG = true;
                    Tree.DEBUG = true;
                    CodeGenerator.DEBUG = true;
                    Liveness.DEBUG = true;
                    SSA.DEBUG = true;
                    SSAGraph.DEBUG = true;
                    PersistentCheckElimination.DEBUG = true;
                    ValueNumbering.DEBUG = true;
                    ValueFolding.DEBUG = true;
                    ClassHierarchy.DEBUG = true;
                    TypeInference.DEBUG = true;
                    SSAPRE.DEBUG = true;
                    StackPRE.DEBUG = true;
                    ExprPropagation.DEBUG = true;
                    DeadCodeElimination.DEBUG = true;
                    continue;
                }
                if (args[i].equals("-help")) {
                    Main.usage();
                    continue;
                }
                if (args[i].equals("-noanno")) {
                    ANNO = false;
                    continue;
                }
                if (args[i].equals("-anno")) {
                    ANNO = true;
                    continue;
                }
                if (args[i].equals("-preserve-debug")) {
                    MethodEditor.PRESERVE_DEBUG = true;
                    continue;
                }
                if (args[i].equals("-nouse-stack-vars")) {
                    Tree.USE_STACK = false;
                    continue;
                }
                if (args[i].equals("-use-stack-vars")) {
                    Tree.USE_STACK = true;
                    continue;
                }
                if (args[i].equals("-nocompact-array-init")) {
                    COMPACT_ARRAY_INIT = false;
                    continue;
                }
                if (args[i].equals("-compact-array-init")) {
                    COMPACT_ARRAY_INIT = true;
                    continue;
                }
                if (args[i].equals("-nostack-alloc")) {
                    STACK_ALLOC = false;
                    continue;
                }
                if (args[i].equals("-stack-alloc")) {
                    STACK_ALLOC = true;
                    continue;
                }
                if (args[i].equals("-peel-loops")) {
                    String n;
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    if ((n = args[i]).equals("all")) {
                        FlowGraph.PEEL_LOOPS_LEVEL = -1;
                        continue;
                    }
                    try {
                        FlowGraph.PEEL_LOOPS_LEVEL = Integer.parseInt(n);
                        if (FlowGraph.PEEL_LOOPS_LEVEL >= 0) continue;
                        Main.usage();
                    }
                    catch (NumberFormatException ex) {
                        Main.usage();
                    }
                    continue;
                }
                if (args[i].equals("-color")) {
                    Liveness.UNIQUE = false;
                    continue;
                }
                if (args[i].equals("-nocolor")) {
                    Liveness.UNIQUE = true;
                    continue;
                }
                if (args[i].equals("-only-method")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    METHOD = args[i];
                    continue;
                }
                if (args[i].equals("-print-flow-graph")) {
                    FlowGraph.PRINT_GRAPH = true;
                    continue;
                }
                if (args[i].equals("-classpath")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    String classpath = args[i];
                    loader.setClassPath(classpath);
                    continue;
                }
                if (args[i].equals("-skip")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    pkg = args[i].replace('.', '/');
                    SKIP.add(pkg);
                    continue;
                }
                if (args[i].equals("-only")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    pkg = args[i].replace('.', '/');
                    ONLY.add(pkg);
                    continue;
                }
                if (args[i].equals("-nodce")) {
                    DCE = false;
                    continue;
                }
                if (args[i].equals("-noprop")) {
                    PROP = false;
                    continue;
                }
                if (args[i].equals("-nopre")) {
                    PRE = false;
                    continue;
                }
                if (args[i].equals("-dce")) {
                    DCE = true;
                    continue;
                }
                if (args[i].equals("-prop")) {
                    PROP = true;
                    continue;
                }
                if (args[i].equals("-pre")) {
                    PRE = true;
                    continue;
                }
                if (args[i].equals("-closure")) {
                    CLOSURE = true;
                    continue;
                }
                if (args[i].equals("-relax-loading")) {
                    ClassHierarchy.RELAX = true;
                    continue;
                }
                if (args[i].equals("-f")) {
                    FORCE = true;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    Main.usage();
                    continue;
                }
                if (i == args.length - 1) {
                    File f = new File(args[i]);
                    if (f.exists() && !f.isDirectory()) {
                        System.err.println("No such directory: " + f.getPath());
                        System.exit(2);
                    }
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    if (!f.exists()) {
                        System.err.println("Couldn't create directory: " + f.getPath());
                        System.exit(2);
                    }
                    loader.setOutputDir(f);
                    gotdir = true;
                    continue;
                }
                classes.add(args[i]);
            }
            if (!gotdir) {
                Main.usage();
            }
            if (classes.size() == 0) {
                Main.usage();
            }
            boolean errors = false;
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                try {
                    loader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    errors = true;
                }
            }
            if (errors) {
                System.exit(1);
            }
            context = new CachingBloatContext(loader, classes, CLOSURE);
            if (!CLOSURE) {
                e = classes.iterator();
                while (e.hasNext()) {
                    String name = (String)e.next();
                    Main.editClass(name);
                }
            } else {
                classes = null;
                e = context.getHierarchy().classes().iterator();
                while (e.hasNext()) {
                    Type t = (Type)e.next();
                    if (!t.isObject()) continue;
                    Main.editClass(t.className());
                }
            }
        }
        catch (ExceptionInInitializerError ex) {
            ex.printStackTrace();
            System.out.println(ex.getException());
        }
    }

    private static void usage() {
        System.err.println("Usage: java EDU.purdue.cs.bloat.optimize.Main\n            [-options] classes dir\n\nwhere options include:\n    -help             print out this message\n    -v -verbose       turn on verbose mode\n    -debug            display a hideous amount of debug info\n    -classpath <directories separated by colons>\n                      list directories in which to look for classes\n    -f                optimize files even if up-to-date\n    -closure          recursively optimize referenced classes\n    -relax-loading    don't report errors if a class is not found\n    -skip <class|package.*>\n                      skip the given class or package\n    -only <class|package.*>\n                      skip all but the given class or package\n    -preserve-debug   try to preserve debug information\n    -[no]anno         insert an annotation in the contant pool\n    -[no]stack-alloc  try to push locals onto the operand stack\n    -peel-loops <n|all>\n                      peel innermost loops to enable code hoisting\n                      (n >= 0 is the maximum loop level to peel)\n    -[no]pre          perform partial redundency elimination\n    -[no]dce          perform dead code elimination\n    -[no]prop         perform copy and constant propagation");
        System.exit(0);
    }

    private static void editClass(String className) {
        String pkg;
        int i;
        ClassFile classFile;
        try {
            classFile = (ClassFile)loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Couldn't find class: " + ex.getMessage());
            return;
        }
        if (!FORCE) {
            File source = classFile.file();
            File target = classFile.outputFile();
            if (source != null && target != null && source.exists() && target.exists() && source.lastModified() < target.lastModified()) {
                if (VERBOSE) {
                    System.out.println(classFile.name() + " is up to date");
                }
                return;
            }
        }
        if (DEBUG) {
            classFile.print(System.out);
        }
        ClassEditor c = context.editClass(classFile);
        boolean skip = false;
        String name = c.type().className();
        String qual = c.type().qualifier() + "/*";
        if (ONLY.size() > 0) {
            skip = true;
            for (i = 0; i < ONLY.size(); ++i) {
                pkg = (String)ONLY.get(i);
                if (!name.equals(pkg) && !qual.equals(pkg)) continue;
                skip = false;
                break;
            }
        }
        if (!skip) {
            for (i = 0; i < SKIP.size(); ++i) {
                pkg = (String)SKIP.get(i);
                if (!name.equals(pkg) && !qual.equals(pkg)) continue;
                skip = true;
                break;
            }
        }
        if (skip) {
            if (VERBOSE) {
                System.out.println("Skipping " + c.type().className());
            }
            context.release(classFile);
            return;
        }
        if (VERBOSE) {
            System.out.println("Optimizing " + c.type().className());
        }
        MethodInfo[] methods = c.methods();
        for (int j = 0; j < methods.length; ++j) {
            DeadCodeElimination dce;
            ExprPropagation copy;
            FlowGraph cfg;
            MethodEditor m;
            try {
                m = context.editMethod(methods[j]);
            }
            catch (ClassFormatException ex) {
                System.err.println(ex.getMessage());
                continue;
            }
            if (METHOD != null && !m.name().equals(METHOD)) {
                context.release(methods[j]);
                continue;
            }
            if (DEBUG) {
                m.print(System.out);
            }
            if (m.isNative() || m.isAbstract()) {
                context.release(methods[j]);
                continue;
            }
            if (COMPACT_ARRAY_INIT) {
                CompactArrayInitializer.transform(m);
                if (DEBUG) {
                    System.out.println("---------- After compaction:");
                    m.print(System.out);
                    System.out.println("---------- end print");
                }
            }
            try {
                cfg = new FlowGraph(m);
            }
            catch (ClassFormatException ex) {
                System.err.println(ex.getMessage());
                context.release(methods[j]);
                continue;
            }
            SSA.transform(cfg);
            if (FlowGraph.DEBUG) {
                System.out.println("---------- After SSA:");
                cfg.print(System.out);
                System.out.println("---------- end print");
            }
            if (DEBUG) {
                cfg.visit(new VerifyCFG(false));
            }
            if (PROP) {
                if (DEBUG) {
                    System.out.println("-------Before Copy Propagation-------");
                }
                copy = new ExprPropagation(cfg);
                copy.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG(false));
                }
                if (DEBUG) {
                    System.out.println("--------After Copy Propagation-------");
                    cfg.print(System.out);
                }
            }
            if (DCE) {
                if (DEBUG) {
                    System.out.println("-----Before Dead Code Elimination----");
                }
                dce = new DeadCodeElimination(cfg);
                dce.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG(false));
                }
                if (DEBUG) {
                    System.out.println("-----After Dead Code Elimination-----");
                    cfg.print(System.out);
                }
            }
            if (DEBUG) {
                System.out.println("---------Doing type inference--------");
            }
            TypeInference.transform(cfg, context.getHierarchy());
            if (DEBUG) {
                System.out.println("--------Doing value numbering--------");
            }
            new ValueNumbering().transform(cfg);
            if (FOLD) {
                if (DEBUG) {
                    System.out.println("--------Before Value Folding---------");
                }
                new ValueFolding().transform(cfg);
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("---------After Value Folding---------");
                    cfg.print(System.out);
                }
            }
            if (PRE) {
                if (DEBUG) {
                    System.out.println("-------------Before SSAPRE-----------");
                }
                SSAPRE pre = new SSAPRE(cfg, context);
                pre.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("-------------After SSAPRE------------");
                    cfg.print(System.out);
                }
            }
            if (FOLD) {
                if (DEBUG) {
                    System.out.println("--------Before Value Folding---------");
                }
                new ValueFolding().transform(cfg);
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("---------After Value Folding---------");
                    cfg.print(System.out);
                }
            }
            if (PROP) {
                if (DEBUG) {
                    System.out.println("-------Before Copy Propagation-------");
                }
                copy = new ExprPropagation(cfg);
                copy.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("--------After Copy Propagation-------");
                    cfg.print(System.out);
                }
            }
            if (DCE) {
                if (DEBUG) {
                    System.out.println("-----Before Dead Code Elimination----");
                }
                dce = new DeadCodeElimination(cfg);
                dce.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("-----After Dead Code Elimination-----");
                    cfg.print(System.out);
                }
            }
            new PersistentCheckElimination().transform(cfg);
            new InductionVarAnalyzer().transform(cfg);
            cfg.commit();
            Peephole.transform(m);
            context.commit(methods[j]);
        }
        if (ANNO) {
            String s = "Optimized with: EDU.purdue.cs.bloat.diva.Main";
            for (int i2 = 0; i2 < ARGS.length; ++i2) {
                s = ARGS[i2].indexOf(32) >= 0 || ARGS[i2].indexOf(9) >= 0 || ARGS[i2].indexOf(13) >= 0 || ARGS[i2].indexOf(10) >= 0 ? s + " '" + ARGS[i2] + "'" : s + " " + ARGS[i2];
            }
            System.out.println(s);
        }
        context.commit(classFile);
    }
}

