/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.context;

import EDU.purdue.cs.bloat.context.BloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PersistentBloatContext
extends BloatContext {
    protected final ClassHierarchy hierarchy;
    protected Map classInfos;
    protected Map methodInfos;
    protected Map fieldInfos;
    protected Map classEditors;
    protected Map methodEditors;
    protected Map fieldEditors;
    public static boolean DB_COMMIT = false;

    protected static void comm(String s) {
        if (DB_COMMIT || DEBUG) {
            System.out.println(s);
        }
    }

    public PersistentBloatContext(ClassInfoLoader loader) {
        this(loader, true);
    }

    protected PersistentBloatContext(ClassInfoLoader loader, boolean closure) {
        super(loader);
        PersistentBloatContext.db("Creating a new BloatContext");
        this.classInfos = new HashMap();
        this.methodInfos = new HashMap();
        this.fieldInfos = new HashMap();
        this.classEditors = new HashMap();
        this.methodEditors = new HashMap();
        this.fieldEditors = new HashMap();
        this.hierarchy = new ClassHierarchy(this, new ArrayList(), closure);
    }

    protected void addClasses(Collection classes) {
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            this.hierarchy.addClassNamed(className);
        }
    }

    public ClassInfo loadClass(String className) throws ClassNotFoundException {
        ClassInfo info = (ClassInfo)this.classInfos.get(className = className.replace('.', '/').intern());
        if (info == null) {
            PersistentBloatContext.db("BloatContext: Loading class " + className);
            info = this.loader.loadClass(className);
            this.hierarchy.addClassNamed(className);
            PersistentBloatContext.db("loadClass: " + className + " -> " + info);
            this.classInfos.put(className, info);
        }
        return info;
    }

    public ClassInfo newClassInfo(int modifiers, int classIndex, int superClassIndex, int[] interfaceIndexes, List constants) {
        return this.loader.newClass(modifiers, classIndex, superClassIndex, interfaceIndexes, constants);
    }

    public ClassHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public ClassEditor newClass(int modifiers, String className, Type superType, Type[] interfaces) {
        ClassEditor ce = new ClassEditor(this, modifiers, className, superType, interfaces);
        ClassInfo info = ce.classInfo();
        className = ce.name().intern();
        PersistentBloatContext.db("editClass(ClassInfo): " + className + " -> " + info);
        this.classInfos.put(className, info);
        this.classEditors.put(info, ce);
        return ce;
    }

    public ClassEditor editClass(String className) throws ClassNotFoundException, ClassFormatException {
        ClassInfo info = (ClassInfo)this.classInfos.get(className = className.intern());
        if (info == null) {
            info = this.loadClass(className);
        }
        return this.editClass(info);
    }

    public ClassEditor editClass(Type classType) throws ClassNotFoundException, ClassFormatException {
        return this.editClass(classType.className());
    }

    public ClassEditor editClass(ClassInfo info) {
        ClassEditor ce = (ClassEditor)this.classEditors.get(info);
        if (ce == null) {
            ce = new ClassEditor(this, info);
            this.classEditors.put(info, ce);
            if (!this.classInfos.containsValue(info)) {
                String className = ce.name().intern();
                PersistentBloatContext.db("editClass(ClassInfo): " + className + " -> " + info);
                this.classInfos.put(className, info);
            }
        }
        return ce;
    }

    public MethodEditor editMethod(MemberRef method) throws NoSuchMethodException {
        MethodInfo info = (MethodInfo)this.methodInfos.get(method);
        if (info == null) {
            PersistentBloatContext.db("Creating a new MethodEditor for " + method);
            NameAndType nat = method.nameAndType();
            String name = nat.name();
            Type type = nat.type();
            try {
                ClassEditor ce = this.editClass(method.declaringClass());
                MethodInfo[] methods = ce.methods();
                for (int i = 0; i < methods.length; ++i) {
                    MethodEditor me = this.editMethod(methods[i]);
                    if (me.name().equals(name) && me.type().equals(type)) {
                        this.methodInfos.put(method, methods[i]);
                        this.release(ce.classInfo());
                        return me;
                    }
                    this.release(methods[i]);
                }
            }
            catch (ClassNotFoundException ex1) {
            }
            catch (ClassFormatException ex2) {
                // empty catch block
            }
            throw new NoSuchMethodException(method.toString());
        }
        return this.editMethod(info);
    }

    public MethodEditor editMethod(MethodInfo info) {
        MethodEditor me = (MethodEditor)this.methodEditors.get(info);
        if (me == null) {
            me = new MethodEditor(this.editClass(info.declaringClass()), info);
            this.methodEditors.put(info, me);
            PersistentBloatContext.db("Creating a new MethodEditor for " + me.memberRef());
        }
        return me;
    }

    public FieldEditor editField(MemberRef field) throws NoSuchFieldException {
        FieldInfo info = (FieldInfo)this.fieldInfos.get(field);
        if (info == null) {
            NameAndType nat = field.nameAndType();
            String name = nat.name();
            Type type = nat.type();
            try {
                ClassEditor ce = this.editClass(field.declaringClass());
                FieldInfo[] fields = ce.fields();
                for (int i = 0; i < fields.length; ++i) {
                    FieldEditor fe = this.editField(fields[i]);
                    if (fe.name().equals(name) && fe.type().equals(type)) {
                        this.fieldInfos.put(field, fields[i]);
                        this.release(ce.classInfo());
                        return fe;
                    }
                    this.release(fields[i]);
                }
            }
            catch (ClassNotFoundException ex1) {
            }
            catch (ClassFormatException ex2) {
                // empty catch block
            }
            throw new NoSuchFieldException(field.toString());
        }
        return this.editField(info);
    }

    public FieldEditor editField(FieldInfo info) {
        FieldEditor fe = (FieldEditor)this.fieldEditors.get(info);
        if (fe == null) {
            fe = new FieldEditor(this.editClass(info.declaringClass()), info);
            this.fieldEditors.put(info, fe);
            PersistentBloatContext.db("Creating a new FieldEditor for " + fe.nameAndType());
        }
        return fe;
    }

    public void release(ClassInfo info) {
    }

    public void release(ClassEditor ce) {
    }

    public void release(MethodInfo info) {
    }

    public void release(FieldInfo info) {
    }

    public void commit(ClassInfo info) {
        Type type = Type.getType("L" + info.name() + ";");
        if (this.ignoreClass(type)) {
            return;
        }
        ClassEditor ce = this.editClass(info);
        MethodInfo[] methods = ce.methods();
        for (int i = 0; i < methods.length; ++i) {
            this.commit(methods[i]);
        }
        FieldInfo[] fields = ce.fields();
        for (int i = 0; i < fields.length; ++i) {
            this.commit(fields[i]);
        }
        ce.commit();
        ce.setDirty(false);
        this.release(info);
    }

    public void commit(MethodInfo info) {
        MethodEditor me = this.editMethod(info);
        me.commit();
        me.declaringClass().setDirty(true);
        me.setDirty(false);
        this.release(info);
    }

    public void commit(FieldInfo info) {
        FieldEditor fe = this.editField(info);
        fe.commit();
        fe.declaringClass().setDirty(true);
        fe.setDirty(false);
        this.release(info);
    }

    public void commit() {
        int i;
        Object[] array = this.fieldEditors.values().toArray();
        for (i = 0; i < array.length; ++i) {
            FieldEditor fe = (FieldEditor)array[i];
            if (this.ignoreField(fe.memberRef())) continue;
            this.commit(fe.fieldInfo());
        }
        array = this.methodEditors.values().toArray();
        for (i = 0; i < array.length; ++i) {
            MethodEditor me = (MethodEditor)array[i];
            if (this.ignoreMethod(me.memberRef())) continue;
            this.commit(me.methodInfo());
        }
        array = this.classEditors.values().toArray();
        for (i = 0; i < array.length; ++i) {
            ClassEditor ce = (ClassEditor)array[i];
            if (this.ignoreClass(ce.type())) continue;
            this.commit(ce.classInfo());
        }
    }

    public void commitDirty() {
        int i;
        PersistentBloatContext.comm("Committing dirty data");
        Object[] array = this.fieldEditors.values().toArray();
        for (i = 0; i < array.length; ++i) {
            FieldEditor fe = (FieldEditor)array[i];
            if (!fe.isDirty() || this.ignoreField(fe.memberRef())) continue;
            PersistentBloatContext.comm("  Committing field: " + fe.declaringClass().name() + "." + fe.name());
            this.commit(fe.fieldInfo());
        }
        array = this.methodEditors.values().toArray();
        for (i = 0; i < array.length; ++i) {
            MethodEditor me = (MethodEditor)array[i];
            if (!me.isDirty() || this.ignoreMethod(me.memberRef())) continue;
            PersistentBloatContext.comm("  Committing method: " + me.declaringClass().name() + "." + me.name() + me.type());
            this.commit(me.methodInfo());
        }
        array = this.classEditors.values().toArray();
        for (i = 0; i < array.length; ++i) {
            ClassEditor ce = (ClassEditor)array[i];
            if (!ce.isDirty() || this.ignoreClass(ce.type())) continue;
            PersistentBloatContext.comm("  Committing class: " + ce.name());
            this.commit(ce.classInfo());
        }
    }
}

