/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.context;

import EDU.purdue.cs.bloat.context.PersistentBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CachingBloatContext
extends PersistentBloatContext {
    protected Map classRC = new HashMap();
    protected Map methodRC = new HashMap();
    protected Map fieldRC = new HashMap();

    public CachingBloatContext(ClassInfoLoader loader, Collection classes, boolean closure) {
        super(loader, closure);
        this.addClasses(classes);
    }

    public ClassEditor newClass(int modifiers, String className, Type superType, Type[] interfaces) {
        ClassEditor ce = super.newClass(modifiers, className, superType, interfaces);
        ClassInfo info = ce.classInfo();
        this.classRC.put(info, new Integer(1));
        return ce;
    }

    public ClassEditor editClass(ClassInfo info) {
        ClassEditor ce = (ClassEditor)this.classEditors.get(info);
        if (ce == null) {
            ce = new ClassEditor(this, info);
            this.classEditors.put(info, ce);
            this.classRC.put(info, new Integer(1));
            if (!this.classInfos.containsValue(info)) {
                String className = ce.name().intern();
                CachingBloatContext.db("editClass(ClassInfo): " + className + " -> " + info);
                this.classInfos.put(className, info);
            }
        } else {
            Integer rc = (Integer)this.classRC.get(info);
            this.classRC.put(info, new Integer(rc + 1));
        }
        return ce;
    }

    public MethodEditor editMethod(MemberRef method) throws NoSuchMethodException {
        MethodInfo info = (MethodInfo)this.methodInfos.get(method);
        if (info == null) {
            CachingBloatContext.db("Creating a new MethodEditor for " + method);
            NameAndType nat = method.nameAndType();
            String name = nat.name();
            Type type = nat.type();
            try {
                ClassEditor ce = this.editClass(method.declaringClass());
                MethodInfo[] methods = ce.methods();
                for (int i = 0; i < methods.length; ++i) {
                    MethodEditor me = this.editMethod(methods[i]);
                    if (!me.name().equals(name) || !me.type().equals(type)) continue;
                    this.methodInfos.put(method, methods[i]);
                    this.release(ce.classInfo());
                    return me;
                }
                this.release(ce.classInfo());
            }
            catch (ClassNotFoundException ex1) {
                throw new NoSuchMethodException(method.toString() + "(" + ex1.getMessage() + ")");
            }
            catch (ClassFormatException ex2) {
                throw new NoSuchMethodException(method.toString() + "(" + ex2.getMessage() + ")");
            }
            throw new NoSuchMethodException(method.toString());
        }
        return this.editMethod(info);
    }

    public MethodEditor editMethod(MethodInfo info) {
        MethodEditor me = (MethodEditor)this.methodEditors.get(info);
        if (me == null) {
            ClassInfo classInfo = info.declaringClass();
            me = new MethodEditor(this.editClass(classInfo), info);
            this.release(classInfo);
            this.methodEditors.put(info, me);
            this.methodRC.put(info, new Integer(1));
            CachingBloatContext.db("Creating a new MethodEditor for " + me.memberRef());
        } else {
            Integer rc = (Integer)this.methodRC.get(info);
            this.methodRC.put(info, new Integer(rc + 1));
        }
        return me;
    }

    public FieldEditor editField(MemberRef field) throws NoSuchFieldException {
        FieldInfo info = (FieldInfo)this.fieldInfos.get(field);
        if (info == null) {
            NameAndType nat = field.nameAndType();
            String name = nat.name();
            Type type = nat.type();
            try {
                ClassEditor ce = this.editClass(field.declaringClass());
                FieldInfo[] fields = ce.fields();
                for (int i = 0; i < fields.length; ++i) {
                    FieldEditor fe = this.editField(fields[i]);
                    if (fe.name().equals(name) && fe.type().equals(type)) {
                        this.fieldInfos.put(field, fields[i]);
                        this.release(ce.classInfo());
                        return fe;
                    }
                    this.release(fields[i]);
                }
                this.release(ce.classInfo());
            }
            catch (ClassNotFoundException ex1) {
            }
            catch (ClassFormatException ex2) {
                // empty catch block
            }
            throw new NoSuchFieldException(field.toString());
        }
        return this.editField(info);
    }

    public FieldEditor editField(FieldInfo info) {
        FieldEditor fe = (FieldEditor)this.fieldEditors.get(info);
        CachingBloatContext.db("Editing " + info);
        if (fe == null) {
            ClassInfo classInfo = info.declaringClass();
            fe = new FieldEditor(this.editClass(classInfo), info);
            this.release(classInfo);
            this.fieldEditors.put(info, fe);
            this.fieldRC.put(info, new Integer(0));
            CachingBloatContext.db("Creating a new FieldEditor for " + fe.nameAndType());
        } else {
            Integer rc = (Integer)this.fieldRC.get(info);
            this.fieldRC.put(info, new Integer(rc + 1));
        }
        return fe;
    }

    public void release(ClassInfo info) {
        Integer rc = (Integer)this.classRC.get(info);
        if (rc != null && rc > 1) {
            this.classRC.put(info, new Integer(rc - 1));
            return;
        }
        ClassEditor ce = (ClassEditor)this.classEditors.get(info);
        if (ce != null && ce.isDirty()) {
            return;
        }
        ce = (ClassEditor)this.classEditors.remove(info);
        this.classRC.remove(info);
        this.classEditors.remove(info);
        Iterator iter = this.classInfos.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ClassInfo info2 = (ClassInfo)this.classInfos.get(name);
            if (info2 != info) continue;
            CachingBloatContext.db("Removing ClassInfo: " + name + " -> " + info2);
            this.classInfos.remove(name);
            break;
        }
        if (ce != null) {
            MethodInfo[] methods = ce.methods();
            for (int i = 0; i < methods.length; ++i) {
                this.release(methods[i]);
            }
            FieldInfo[] fields = ce.fields();
            for (int i = 0; i < fields.length; ++i) {
                this.release(fields[i]);
            }
        }
    }

    public void release(MethodInfo info) {
        Integer rc = (Integer)this.classRC.get(info);
        if (rc != null && rc > 1) {
            this.methodRC.put(info, new Integer(rc - 1));
            return;
        }
        MethodEditor me = (MethodEditor)this.methodEditors.get(info);
        if (me != null && me.isDirty()) {
            return;
        }
        this.methodRC.remove(info);
        this.methodEditors.remove(info);
        Iterator iter = this.methodInfos.keySet().iterator();
        while (iter.hasNext()) {
            MemberRef ref = (MemberRef)iter.next();
            MethodInfo info2 = (MethodInfo)this.methodInfos.get(ref);
            if (info2 != info) continue;
            this.methodInfos.remove(ref);
            break;
        }
    }

    public void release(FieldInfo info) {
        Integer rc = (Integer)this.fieldRC.get(info);
        CachingBloatContext.db("Releasing " + info);
        if (rc != null && rc > 1) {
            this.fieldRC.put(info, new Integer(rc - 1));
            return;
        }
        FieldEditor fe = (FieldEditor)this.fieldEditors.get(info);
        if (fe != null && fe.isDirty()) {
            return;
        }
        this.fieldRC.remove(info);
        this.fieldEditors.remove(info);
        Iterator iter = this.fieldInfos.keySet().iterator();
        while (iter.hasNext()) {
            MemberRef ref = (MemberRef)iter.next();
            FieldInfo info2 = (FieldInfo)this.fieldInfos.get(ref);
            if (info2 != info) continue;
            this.fieldInfos.remove(ref);
            break;
        }
    }

    public void commit(ClassInfo info) {
        super.commit(info);
        this.classEditors.remove(info);
        this.classRC.remove(info);
    }

    public void commit(MethodInfo info) {
        super.commit(info);
        this.methodEditors.remove(info);
        this.methodRC.remove(info);
    }

    public void commit(FieldInfo info) {
        super.commit(info);
        this.fieldEditors.remove(info);
        this.fieldRC.remove(info);
    }

    public void commit() {
        Iterator iter = this.fieldEditors.values().iterator();
        while (iter.hasNext()) {
            FieldEditor fe = (FieldEditor)iter.next();
            this.commit(fe.fieldInfo());
        }
        iter = this.methodEditors.values().iterator();
        while (iter.hasNext()) {
            MethodEditor me = (MethodEditor)iter.next();
            this.commit(me.methodInfo());
        }
        iter = this.classEditors.values().iterator();
        while (iter.hasNext()) {
            ClassEditor ce = (ClassEditor)iter.next();
            this.commit(ce.classInfo());
        }
    }

    public String toString() {
        Object key;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("Context of caches in CachingBloatContext...");
        pw.println("  Class Infos");
        Iterator iter = this.classInfos.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.classInfos.get(key));
        }
        pw.println("  Class Editors");
        iter = this.classEditors.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.classEditors.get(key));
        }
        pw.println("  Class RC");
        iter = this.classRC.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.classRC.get(key));
        }
        pw.println("  Method Infos");
        iter = this.methodInfos.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.methodInfos.get(key));
        }
        pw.println("  Method Editors");
        iter = this.methodEditors.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.methodEditors.get(key));
        }
        pw.println("  Method RC");
        iter = this.methodRC.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.methodRC.get(key));
        }
        pw.println("  Field Infos");
        iter = this.fieldInfos.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.fieldInfos.get(key));
        }
        pw.println("  Field Editors");
        iter = this.fieldEditors.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.fieldEditors.get(key));
        }
        pw.println("  Field RC");
        iter = this.fieldRC.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            pw.println("    " + key + " -> " + this.fieldRC.get(key));
        }
        return sw.toString();
    }
}

