/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.context;

import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.inline.CallGraph;
import EDU.purdue.cs.bloat.inline.InlineContext;
import EDU.purdue.cs.bloat.inline.InlineStats;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class BloatContext
implements InlineContext {
    public static boolean DEBUG = Boolean.getBoolean("BloatContext.DEBUG");
    protected InlineStats inlineStats;
    protected Set ignorePackages = new HashSet();
    protected Set ignoreClasses = new HashSet();
    protected Set ignoreMethods = new HashSet();
    protected Set ignoreFields = new HashSet();
    protected boolean ignoreSystem = false;
    protected CallGraph callGraph;
    protected Set roots;
    protected ClassInfoLoader loader;
    private static ClassLoader systemCL;

    protected static void db(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    public BloatContext(ClassInfoLoader loader) {
        this.loader = loader;
    }

    public static boolean isSystem(Type type) {
        Class<?> c = null;
        try {
            c = Class.forName(type.className().replace('/', '.'));
        }
        catch (ClassNotFoundException ex) {
            System.err.println("** Could not find class " + type.className());
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        return c.getClassLoader() == systemCL;
    }

    public void setRootMethods(Set roots) {
        if (this.callGraph != null) {
            throw new IllegalStateException("Cannot set roots after call graph has been created");
        }
        this.roots = roots;
    }

    public CallGraph getCallGraph() {
        if (this.callGraph == null) {
            this.callGraph = new CallGraph(this, this.roots);
        }
        return this.callGraph;
    }

    public InlineStats getInlineStats() {
        if (this.inlineStats == null) {
            this.inlineStats = new InlineStats();
        }
        return this.inlineStats;
    }

    public void addIgnorePackage(String name) {
        name = name.replace('.', '/');
        this.ignorePackages.add(name);
    }

    public void addIgnoreClass(Type type) {
        this.ignoreClasses.add(type);
    }

    public void addIgnoreMethod(MemberRef method) {
        this.ignoreMethods.add(method);
    }

    public void addIgnoreField(MemberRef field) {
        this.ignoreFields.add(field);
    }

    public void setIgnoreSystem(boolean ignore) {
        this.ignoreSystem = ignore;
    }

    public boolean ignoreClass(Type type) {
        if (this.ignoreClasses.contains(type)) {
            return true;
        }
        if (type.isPrimitive()) {
            this.addIgnoreClass(type);
            return true;
        }
        if (this.ignoreSystem && BloatContext.isSystem(type)) {
            this.addIgnoreClass(type);
            return true;
        }
        String packageName = type.className();
        int lastSlash = packageName.lastIndexOf(47);
        if (lastSlash == -1) {
            return false;
        }
        packageName = packageName.substring(0, lastSlash);
        Iterator packages = this.ignorePackages.iterator();
        while (packages.hasNext()) {
            String s = (String)packages.next();
            if (!type.className().startsWith(s)) continue;
            this.addIgnoreClass(type);
            return true;
        }
        return false;
    }

    public boolean ignoreMethod(MemberRef method) {
        if (this.ignoreMethods.contains(method)) {
            return true;
        }
        if (this.ignoreClass(method.declaringClass())) {
            this.addIgnoreMethod(method);
            return true;
        }
        return false;
    }

    public boolean ignoreField(MemberRef field) {
        if (this.ignoreMethods.contains(field)) {
            return true;
        }
        if (this.ignoreClass(field.declaringClass())) {
            this.addIgnoreField(field);
            return true;
        }
        return false;
    }

    public abstract void commitDirty();

    public static void main(String[] args) {
        Object type;
        PrintWriter out = new PrintWriter(System.out, true);
        PrintWriter err = new PrintWriter(System.err, true);
        CachingBloatContext context = new CachingBloatContext(new ClassFileLoader(), new ArrayList(), false);
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-ip")) {
                if (++i >= args.length) {
                    err.println("** Missing package name");
                    System.exit(1);
                }
                out.println("Ignoring package " + args[i]);
                context.addIgnorePackage(args[i]);
                continue;
            }
            if (args[i].equals("-ic")) {
                if (++i >= args.length) {
                    err.println("** Missing class name");
                    System.exit(1);
                }
                out.println("Ignoring class " + args[i]);
                type = args[i].replace('.', '/');
                context.addIgnoreClass(Type.getType("L" + (String)type + ";"));
                continue;
            }
            type = args[i].replace('.', '/');
            types.add(Type.getType("L" + (String)type + ";"));
        }
        out.println("");
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            type = (Type)iter.next();
            out.println("Ignore " + type + "? " + context.ignoreClass((Type)type));
        }
    }

    static {
        String s = "";
        systemCL = s.getClass().getClassLoader();
    }
}

