/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.codegen;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.codegen.CodeGenerator;
import EDU.purdue.cs.bloat.codegen.Liveness;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.Graph;
import EDU.purdue.cs.bloat.util.GraphNode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RegisterAllocator {
    FlowGraph cfg;
    Liveness liveness;
    Map colors;
    int colorsUsed;
    static final float MAX_WEIGHT = Float.MAX_VALUE;
    static final float LOOP_FACTOR = 10.0f;
    static final int MAX_DEPTH = (int)(Math.log(3.4028234663852886E38) / Math.log(10.0));

    public RegisterAllocator(FlowGraph cfg, Liveness liveness) {
        IGNode node;
        this.cfg = cfg;
        this.liveness = liveness;
        this.colorsUsed = 0;
        this.colors = new HashMap();
        final Graph ig = new Graph();
        Iterator iter = liveness.defs().iterator();
        while (iter.hasNext()) {
            VarExpr def = (VarExpr)iter.next();
            if (!(def instanceof LocalExpr)) continue;
            IGNode defNode = (IGNode)ig.getNode(def);
            if (defNode == null) {
                defNode = new IGNode((LocalExpr)def);
                ig.addNode(def, defNode);
            }
            Iterator intersections = liveness.intersections(def);
            while (intersections.hasNext()) {
                VarExpr expr = (VarExpr)intersections.next();
                if (expr == def || !(expr instanceof LocalExpr)) continue;
                node = (IGNode)ig.getNode(expr);
                if (node == null) {
                    node = new IGNode((LocalExpr)expr);
                    ig.addNode(expr, node);
                }
                ig.addEdge(defNode, node);
                ig.addEdge(node, defNode);
            }
        }
        final ArrayList copies = new ArrayList();
        final ArrayList precolor = new ArrayList();
        cfg.visit(new TreeVisitor(){

            public void visitBlock(Block block) {
                if (block != RegisterAllocator.this.cfg.sink()) {
                    block.visitChildren(this);
                }
            }

            public void visitPhiStmt(PhiStmt stmt) {
                stmt.visitChildren(this);
                if (!(stmt.target() instanceof LocalExpr)) {
                    return;
                }
                IGNode lnode = (IGNode)ig.getNode(stmt.target());
                HashSet<DefExpr> set = new HashSet<DefExpr>();
                Iterator e = stmt.operands().iterator();
                while (e.hasNext()) {
                    Expr op = (Expr)e.next();
                    if (!(op instanceof LocalExpr) || op.def() == null || set.contains(op.def())) continue;
                    set.add(op.def());
                    if (op.def() == stmt.target()) continue;
                    IGNode rnode = (IGNode)ig.getNode(op.def());
                    copies.add(new IGNode[]{lnode, rnode});
                }
            }

            public void visitStoreExpr(StoreExpr expr) {
                expr.visitChildren(this);
                if (!(expr.target() instanceof LocalExpr)) {
                    return;
                }
                IGNode lnode = (IGNode)ig.getNode(expr.target());
                if (expr.expr() instanceof LocalExpr && expr.expr().def() != null) {
                    IGNode rnode = (IGNode)ig.getNode(expr.expr().def());
                    copies.add(new IGNode[]{lnode, rnode});
                    return;
                }
                if (expr.target().type().equals(Type.INTEGER)) {
                    int incr;
                    ConstantExpr c;
                    if (!(expr.expr() instanceof ArithExpr)) {
                        return;
                    }
                    LocalExpr lhs = (LocalExpr)expr.target();
                    ArithExpr rhs = (ArithExpr)expr.expr();
                    LocalExpr var = null;
                    Integer value = null;
                    if (rhs.left() instanceof LocalExpr && rhs.right() instanceof ConstantExpr) {
                        var = (LocalExpr)rhs.left();
                        c = (ConstantExpr)rhs.right();
                        if (c.value() instanceof Integer) {
                            value = (Integer)c.value();
                        }
                    } else if (rhs.right() instanceof LocalExpr && rhs.left() instanceof ConstantExpr) {
                        var = (LocalExpr)rhs.right();
                        c = (ConstantExpr)rhs.left();
                        if (c.value() instanceof Integer) {
                            value = (Integer)c.value();
                        }
                    }
                    if (rhs.operation() == 45) {
                        if (value != null) {
                            value = new Integer(-value.intValue());
                        }
                    } else if (rhs.operation() != 43) {
                        value = null;
                    }
                    if (value != null && var.def() != null && (short)(incr = value.intValue()) == incr) {
                        IGNode rnode = (IGNode)ig.getNode(var.def());
                        copies.add(new IGNode[]{lnode, rnode});
                    }
                }
            }

            public void visitInitStmt(InitStmt stmt) {
                stmt.visitChildren(this);
                LocalExpr[] t = stmt.targets();
                for (int i = 0; i < t.length; ++i) {
                    precolor.add(t[i]);
                }
            }
        });
        while (copies.size() > 0) {
            int max = 0;
            IGNode[] copy = (IGNode[])copies.get(max);
            float maxWeight = copy[0].weight + copy[1].weight;
            HashSet union = new HashSet();
            union.addAll(ig.succs(copy[0]));
            union.addAll(ig.succs(copy[1]));
            maxWeight /= (float)union.size();
            for (int i = 1; i < copies.size(); ++i) {
                copy = (IGNode[])copies.get(i);
                float weight = copy[0].weight + copy[1].weight;
                union.clear();
                union.addAll(ig.succs(copy[0]));
                union.addAll(ig.succs(copy[1]));
                weight /= (float)union.size();
                if (!(weight > maxWeight)) continue;
                maxWeight = weight;
                max = i;
            }
            copy = (IGNode[])copies.get(max);
            copies.set(max, copies.get(copies.size() - 1));
            copies.remove(copies.size() - 1);
            if (ig.hasEdge(copy[0], copy[1])) continue;
            if (CodeGenerator.DEBUG) {
                System.out.println("coalescing " + copy[0] + " " + copy[1]);
                System.out.println("    0 conflicts " + ig.succs(copy[0]));
                System.out.println("    1 conflicts " + ig.succs(copy[1]));
            }
            ig.succs(copy[0]).addAll(ig.succs(copy[1]));
            ig.preds(copy[0]).addAll(ig.preds(copy[1]));
            copy[0].coalesce(copy[1]);
            if (CodeGenerator.DEBUG) {
                System.out.println("    coalesced " + copy[0]);
                System.out.println("    conflicts " + ig.succs(copy[0]));
            }
            ig.removeNode(copy[1].key);
            iter = copies.iterator();
            while (iter.hasNext()) {
                IGNode[] c = (IGNode[])iter.next();
                if (c[0] != copy[1] && c[1] != copy[1]) continue;
                iter.remove();
            }
        }
        ArrayList<IGNode> uncoloredNodes = new ArrayList<IGNode>();
        Iterator nodes = ig.nodes().iterator();
        while (nodes.hasNext()) {
            node = (IGNode)nodes.next();
            ArrayList p = new ArrayList(precolor);
            p.retainAll(node.defs);
            if (p.size() == 1) {
                node.color = ((LocalExpr)p.get(0)).index();
                if (!CodeGenerator.DEBUG) continue;
                System.out.println("precolored " + node + " " + node.color);
                continue;
            }
            if (p.size() == 0) {
                node.color = -1;
                uncoloredNodes.add(node);
                continue;
            }
            throw new RuntimeException("coalesced pre-colored defs " + p);
        }
        Collections.sort(uncoloredNodes, new Comparator(){

            public int compare(Object a, Object b) {
                IGNode na = (IGNode)a;
                IGNode nb = (IGNode)b;
                float wa = na.weight / (float)ig.succs(na).size();
                float wb = nb.weight / (float)ig.succs(nb).size();
                if (na.wide) {
                    wa /= 2.0f;
                }
                if (nb.wide) {
                    wb /= 2.0f;
                }
                if (wb > wa) {
                    return 1;
                }
                if (wb < wa) {
                    return -1;
                }
                return 0;
            }
        });
        nodes = uncoloredNodes.iterator();
        while (nodes.hasNext()) {
            node = (IGNode)nodes.next();
            if (CodeGenerator.DEBUG) {
                System.out.println("coloring " + node);
                System.out.println("    conflicts " + ig.succs(node));
            }
            Assert.isTrue(node.color == -1);
            BitSet used = new BitSet();
            Iterator succs = ig.succs(node).iterator();
            while (succs.hasNext()) {
                IGNode succ = (IGNode)succs.next();
                if (succ.color == -1) continue;
                used.set(succ.color);
                if (!succ.wide) continue;
                used.set(succ.color + 1);
            }
            int i = 0;
            while (node.color == -1) {
                if (!used.get(i)) {
                    if (node.wide) {
                        if (!used.get(i + 1)) {
                            node.color = i;
                            if (CodeGenerator.DEBUG) {
                                System.out.println("    assigning color " + i + " to " + node);
                            }
                            if (i + 1 >= this.colorsUsed) {
                                this.colorsUsed = i + 2;
                            }
                        }
                    } else {
                        node.color = i;
                        if (CodeGenerator.DEBUG) {
                            System.out.println("    assigning color " + i + " to " + node);
                        }
                        if (i >= this.colorsUsed) {
                            this.colorsUsed = i + 1;
                        }
                    }
                }
                ++i;
            }
        }
        nodes = ig.nodes().iterator();
        while (nodes.hasNext()) {
            node = (IGNode)nodes.next();
            Assert.isTrue(node.color != -1, "No color for " + node);
            iter = node.defs.iterator();
            while (iter.hasNext()) {
                LocalExpr def = (LocalExpr)iter.next();
                def.setIndex(node.color);
                Iterator uses = def.uses().iterator();
                while (uses.hasNext()) {
                    LocalExpr use = (LocalExpr)uses.next();
                    use.setIndex(node.color);
                }
            }
        }
        if (CodeGenerator.DEBUG) {
            System.out.println("After allocating locals--------------------");
            cfg.print(System.out);
            System.out.println("End print----------------------------------");
        }
    }

    public int maxLocals() {
        return this.colorsUsed;
    }

    public LocalVariable newLocal(Type type) {
        LocalVariable var = new LocalVariable(this.colorsUsed);
        this.colorsUsed += type.stackHeight();
        return var;
    }

    class IGNode
    extends GraphNode {
        Set defs;
        LocalExpr key;
        int color = -1;
        boolean wide;
        float weight;

        public IGNode(LocalExpr def) {
            this.key = def;
            this.defs = new HashSet();
            this.defs.add(def);
            this.wide = def.type().isWide();
            this.computeWeight();
        }

        void coalesce(IGNode node) {
            Assert.isTrue(this.wide == node.wide);
            this.weight += node.weight;
            Iterator iter = node.defs.iterator();
            while (iter.hasNext()) {
                LocalExpr def = (LocalExpr)iter.next();
                this.defs.add(def);
            }
        }

        public String toString() {
            return "(color=" + this.color + " weight=" + this.weight + " " + this.defs.toString() + ")";
        }

        private float blockWeight(Block block) {
            int depth = RegisterAllocator.this.cfg.loopDepth(block);
            if (depth > MAX_DEPTH) {
                return Float.MAX_VALUE;
            }
            float w = 1.0f;
            while (depth-- > 0) {
                w *= 10.0f;
            }
            return w;
        }

        private void computeWeight() {
            this.weight = 0.0f;
            Iterator iter = this.defs.iterator();
            while (iter.hasNext()) {
                LocalExpr def = (LocalExpr)iter.next();
                this.weight += this.blockWeight(def.block());
                Iterator uses = def.uses().iterator();
                block1: while (uses.hasNext()) {
                    LocalExpr use = (LocalExpr)uses.next();
                    if (use.parent() instanceof PhiJoinStmt) {
                        PhiJoinStmt phi = (PhiJoinStmt)use.parent();
                        Iterator preds = RegisterAllocator.this.cfg.preds(phi.block()).iterator();
                        while (preds.hasNext()) {
                            Block pred = (Block)preds.next();
                            Expr op = phi.operandAt(pred);
                            if (use != op) continue;
                            this.weight += this.blockWeight(pred);
                            continue block1;
                        }
                        continue;
                    }
                    if (use.parent() instanceof PhiCatchStmt) {
                        this.weight += this.blockWeight(use.def().block());
                        continue;
                    }
                    this.weight += this.blockWeight(use.block());
                }
            }
        }
    }
}

