/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.codegen;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.Handler;
import EDU.purdue.cs.bloat.cfg.ReplaceTarget;
import EDU.purdue.cs.bloat.cfg.Subroutine;
import EDU.purdue.cs.bloat.codegen.RegisterAllocator;
import EDU.purdue.cs.bloat.editor.IncOperand;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.MultiArrayOperand;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.TryCatch;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.JumpStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.ReplaceVisitor;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StackOptimizer;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.ImmutableIterator;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CodeGenerator
extends TreeVisitor
implements Opcode {
    public static boolean DEBUG = false;
    public static boolean USE_PERSISTENT = false;
    public static boolean OPT_STACK = false;
    public static boolean DB_OPT_STACK = false;
    protected MethodEditor method;
    protected Set visited;
    protected Map postponedInstructions;
    protected Block next;
    protected int stackHeight;
    StackOptimizer currentSO;
    public boolean nowb = false;

    public CodeGenerator(MethodEditor method) {
        this.method = method;
        this.postponedInstructions = new HashMap();
    }

    public void visitFlowGraph(FlowGraph cfg) {
        this.visited = new HashSet();
        this.visited.add(cfg.source());
        this.visited.add(cfg.sink());
        Iterator e = cfg.trace().iterator();
        Assert.isTrue(e.hasNext(), "trace is empty");
        this.stackHeight = 0;
        Block block = (Block)e.next();
        while (block != null) {
            this.next = e.hasNext() ? (Block)e.next() : null;
            if (DEBUG) {
                System.out.println("code for " + block);
            }
            block.visit(new TreeVisitor(){
                boolean startsBlock = true;

                public void visitLabelStmt(LabelStmt stmt) {
                    stmt.label().setStartsBlock(this.startsBlock);
                    this.startsBlock = false;
                }

                public void visitStmt(Stmt stmt) {
                }
            });
            this.visited.add(block);
            if (OPT_STACK) {
                this.currentSO = block.stackOptimizer();
            }
            block.visitChildren(this);
            block = this.next;
        }
        Assert.isTrue(this.visited.size() == cfg.size(), "did not visit all blocks while generating code");
        this.next = null;
        this.visited = null;
        Iterator iter = cfg.catchBlocks().iterator();
        while (iter.hasNext()) {
            Block catchBlock = (Block)iter.next();
            Handler handler = (Handler)cfg.handlersMap().get(catchBlock);
            Type type = handler.catchType();
            if (type.isNull()) {
                type = null;
            }
            Block begin = null;
            Iterator blocks = cfg.trace().iterator();
            while (blocks.hasNext()) {
                block = (Block)blocks.next();
                if (handler.protectedBlocks().contains(block)) {
                    if (begin != null) continue;
                    begin = block;
                    continue;
                }
                if (begin == null) continue;
                TryCatch tc = new TryCatch(begin.label(), block.label(), catchBlock.label(), type);
                this.method.addTryCatch(tc);
                begin = null;
            }
        }
    }

    public void simplifyControlFlow(final FlowGraph cfg) {
        this.removeEmptyBlocks(cfg);
        cfg.visit(new TreeVisitor(){

            public void visitJsrStmt(JsrStmt stmt) {
                Subroutine sub = stmt.sub();
                Block entry = sub.entry();
                if (sub.numPaths() == 1) {
                    Block exit = sub.exit();
                    if (exit != null) {
                        JumpStmt oldJump = (JumpStmt)exit.tree().lastStmt();
                        GotoStmt jump = new GotoStmt(stmt.follow());
                        jump.catchTargets().addAll(oldJump.catchTargets());
                        oldJump.replaceWith(jump);
                    }
                    GotoStmt jump = new GotoStmt(sub.entry());
                    jump.catchTargets().addAll(stmt.catchTargets());
                    stmt.replaceWith(jump);
                    cfg.removeSub(sub);
                    cfg.visit(new TreeVisitor(this, sub){
                        Iterator iter;
                        private final /* synthetic */ Subroutine val$sub;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$sub = val$sub;
                        }

                        public void visitTree(Tree tree) {
                            this.iter = tree.stmts().iterator();
                            while (this.iter.hasNext()) {
                                AddressStoreStmt store;
                                Stmt s = (Stmt)this.iter.next();
                                if (!(s instanceof AddressStoreStmt) || (store = (AddressStoreStmt)s).sub() != this.val$sub) continue;
                                this.iter.remove();
                            }
                        }
                    });
                }
            }

            public void visitStmt(Stmt stmt) {
            }
        });
    }

    public void replacePhis(FlowGraph cfg) {
        this.replaceCatchPhis(cfg);
        this.replaceJoinPhis(cfg);
        cfg.visit(new TreeVisitor(){

            public void visitTree(Tree tree) {
                Iterator e = tree.stmts().iterator();
                while (e.hasNext()) {
                    Stmt s = (Stmt)e.next();
                    if (!(s instanceof PhiStmt)) continue;
                    e.remove();
                }
            }
        });
    }

    private void replaceCatchPhis(FlowGraph cfg) {
        cfg.visit(new TreeVisitor(){
            HashMap seen = new HashMap();

            public void visitFlowGraph(FlowGraph graph) {
                Iterator iter = graph.catchBlocks().iterator();
                while (iter.hasNext()) {
                    Block block = (Block)iter.next();
                    block.visit(this);
                }
            }

            public void visitPhiCatchStmt(PhiCatchStmt phi) {
                LocalExpr target = (LocalExpr)phi.target();
                int index = target.index();
                Iterator iter = phi.operands().iterator();
                while (iter.hasNext()) {
                    BitSet s;
                    LocalExpr expr = (LocalExpr)iter.next();
                    LocalExpr def = (LocalExpr)expr.def();
                    if (def == null) continue;
                    if (DEBUG) {
                        System.out.println("inserting for " + phi + " at " + def);
                    }
                    if ((s = (BitSet)this.seen.get(def)) == null) {
                        s = new BitSet();
                        this.seen.put(def, s);
                        BitSet t = s;
                        def.parent().visit(new TreeVisitor(this, t){
                            private final /* synthetic */ BitSet val$t;
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$t = val$t;
                            }

                            public void visitStoreExpr(StoreExpr expr) {
                                if (DEBUG) {
                                    System.out.println("    merging with " + expr);
                                }
                                MemExpr lhs = expr.target();
                                Expr rhs = expr.expr();
                                if (lhs instanceof LocalExpr) {
                                    this.val$t.set(((LocalExpr)lhs).index());
                                }
                                if (rhs instanceof LocalExpr) {
                                    this.val$t.set(((LocalExpr)rhs).index());
                                } else if (rhs instanceof StoreExpr) {
                                    super.visitStoreExpr(expr);
                                }
                            }

                            public void visitNode(Node node) {
                            }
                        });
                    }
                    if (s.get(index)) continue;
                    s.set(index);
                    Assert.isTrue(def != null);
                    if (def.parent() instanceof Stmt) {
                        Stmt stmt = (Stmt)def.parent();
                        Stmt store = CodeGenerator.this.createStore(target, def);
                        def.block().tree().addStmtAfter(store, stmt);
                        continue;
                    }
                    Assert.isTrue(def.parent() instanceof StoreExpr);
                    StoreExpr p = (StoreExpr)def.parent();
                    Expr rhs = p.expr();
                    if (rhs instanceof LocalExpr && ((LocalExpr)rhs).index() == def.index()) {
                        def.setIndex(index);
                        continue;
                    }
                    rhs.setParent(null);
                    StoreExpr store = new StoreExpr((LocalExpr)target.clone(), rhs, rhs.type());
                    p.visit(new ReplaceVisitor(rhs, store));
                }
            }

            public void visitStmt(Stmt stmt) {
            }
        });
    }

    private void replaceJoinPhis(final FlowGraph cfg) {
        Iterator iter = cfg.trace().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            if (block == cfg.sink()) continue;
            block.visit(new TreeVisitor(){

                public void visitPhiJoinStmt(PhiJoinStmt stmt) {
                    Iterator preds = cfg.preds(stmt.block()).iterator();
                    while (preds.hasNext()) {
                        Block pred = (Block)preds.next();
                        Expr operand = stmt.operandAt(pred);
                        if (stmt.target() instanceof LocalExpr && operand instanceof LocalExpr) {
                            LocalExpr t = (LocalExpr)stmt.target();
                            LocalExpr s = (LocalExpr)operand;
                            if (t.index() == s.index()) continue;
                        }
                        Tree tree = pred.tree();
                        Stmt last = tree.lastStmt();
                        last.visitChildren(new TreeVisitor(this, tree){
                            private final /* synthetic */ Tree val$tree;
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$tree = val$tree;
                            }

                            public void visitExpr(Expr expr) {
                                StackExpr var = this.val$tree.newStack(expr.type());
                                var.setValueNumber(expr.valueNumber());
                                Node p = expr.parent();
                                expr.setParent(null);
                                p.visit(new ReplaceVisitor(expr, var));
                                var = (StackExpr)var.clone();
                                StoreExpr store = new StoreExpr(var, expr, expr.type());
                                store.setValueNumber(expr.valueNumber());
                                ExprStmt storeStmt = new ExprStmt(store);
                                storeStmt.setValueNumber(expr.valueNumber());
                                this.val$tree.addStmtBeforeJump(storeStmt);
                            }

                            public void visitStackExpr(StackExpr expr) {
                            }
                        });
                        Stmt store = CodeGenerator.this.createStore(stmt.target(), operand);
                        if (DEBUG) {
                            System.out.println("insert for " + stmt + " " + store + " in " + pred);
                        }
                        tree.addStmtBeforeJump(store);
                    }
                }

                public void visitStmt(Stmt stmt) {
                }
            });
        }
    }

    private void removeEmptyBlocks(FlowGraph cfg) {
        HashSet<Block> emptyBlocks = new HashSet<Block>();
        Iterator e = cfg.nodes().iterator();
        block0: while (e.hasNext()) {
            Block block = (Block)e.next();
            Iterator stmts = block.tree().stmts().iterator();
            while (stmts.hasNext()) {
                Stmt stmt = (Stmt)stmts.next();
                if (!(stmt instanceof GotoStmt) && !(stmt instanceof JsrStmt) && !(stmt instanceof RetStmt) && !(stmt instanceof LabelStmt)) continue block0;
            }
            emptyBlocks.add(block);
        }
        emptyBlocks.remove(cfg.source());
        emptyBlocks.remove(cfg.init());
        emptyBlocks.remove(cfg.sink());
        boolean changed = true;
        while (changed) {
            changed = false;
            HashSet empty = new HashSet(emptyBlocks);
            empty.removeAll(cfg.iteratedPdomFrontier(cfg.nodes()));
            e = empty.iterator();
            while (e.hasNext()) {
                JumpStmt jump;
                JsrStmt stmt;
                Stmt predLast;
                Block pred;
                ImmutableIterator preds;
                Stmt last;
                Block block = (Block)e.next();
                if (DEBUG) {
                    System.out.println("removing empty " + block);
                }
                Assert.isTrue((last = block.tree().lastStmt()) instanceof GotoStmt || last instanceof JsrStmt || last instanceof RetStmt);
                if (last instanceof GotoStmt) {
                    Block target = ((GotoStmt)last).target();
                    ImmutableIterator preds2 = new ImmutableIterator(cfg.preds(block));
                    while (preds2.hasNext()) {
                        Block pred2 = (Block)preds2.next();
                        Assert.isTrue(pred2 != cfg.source());
                        Stmt predLast2 = pred2.tree().lastStmt();
                        predLast2.visit(new ReplaceTarget(block, target));
                        cfg.removeEdge(pred2, block);
                        cfg.addEdge(pred2, target);
                        changed = true;
                    }
                    continue;
                }
                if (last instanceof RetStmt) {
                    preds = new ImmutableIterator(cfg.preds(block));
                    while (preds.hasNext()) {
                        pred = (Block)preds.next();
                        Assert.isTrue(pred != cfg.source());
                        predLast = pred.tree().lastStmt();
                        if (predLast instanceof JsrStmt) {
                            stmt = (JsrStmt)predLast;
                            jump = new GotoStmt(stmt.follow());
                            jump.catchTargets().addAll(stmt.catchTargets());
                            stmt.replaceWith(jump);
                            stmt.sub().removePathsContaining(pred);
                        } else if (predLast instanceof GotoStmt) {
                            RetStmt jump2 = (RetStmt)last.clone();
                            jump2.catchTargets().addAll(((JumpStmt)predLast).catchTargets());
                            predLast.replaceWith(jump2);
                            ((RetStmt)last).sub().setExit(pred);
                        }
                        cfg.succs(pred).remove(block);
                        cfg.succs(pred).addAll(cfg.succs(block));
                        changed = true;
                    }
                    continue;
                }
                if (last instanceof JsrStmt) {
                    preds = new ImmutableIterator(cfg.preds(block));
                    while (preds.hasNext()) {
                        pred = (Block)preds.next();
                        Assert.isTrue(pred != cfg.source());
                        predLast = pred.tree().lastStmt();
                        if (!(predLast instanceof GotoStmt)) continue;
                        stmt = (JsrStmt)last;
                        jump = new JsrStmt(stmt.sub(), stmt.follow());
                        jump.catchTargets().addAll(((JumpStmt)predLast).catchTargets());
                        predLast.replaceWith(jump);
                        stmt.sub().removePathsContaining(block);
                        stmt.sub().addPath(pred, stmt.follow());
                        cfg.addEdge(pred, stmt.sub().entry());
                        cfg.removeEdge(pred, block);
                        changed = true;
                    }
                    continue;
                }
                throw new RuntimeException();
            }
            if (!changed) continue;
            cfg.removeUnreachable();
            emptyBlocks.retainAll(cfg.nodes());
        }
    }

    public void allocReturnAddresses(FlowGraph cfg, RegisterAllocator alloc) {
        Iterator e = cfg.subroutines().iterator();
        while (e.hasNext()) {
            Subroutine sub = (Subroutine)e.next();
            LocalVariable var = alloc.newLocal(Type.ADDRESS);
            sub.setReturnAddress(var);
        }
    }

    protected Stmt createUndefinedStore(VarExpr target) {
        if (target.type().isReference()) {
            return new ExprStmt(new StoreExpr(target, new ConstantExpr(null, Type.OBJECT), target.type()));
        }
        if (target.type().isIntegral()) {
            return new ExprStmt(new StoreExpr(target, new ConstantExpr(new Integer(0), Type.INTEGER), target.type()));
        }
        if (target.type().equals(Type.LONG)) {
            return new ExprStmt(new StoreExpr(target, new ConstantExpr(new Long(0L), Type.LONG), target.type()));
        }
        if (target.type().equals(Type.FLOAT)) {
            return new ExprStmt(new StoreExpr(target, new ConstantExpr(new Float(0.0f), Type.FLOAT), target.type()));
        }
        if (target.type().equals(Type.DOUBLE)) {
            return new ExprStmt(new StoreExpr(target, new ConstantExpr(new Double(0.0), Type.DOUBLE), target.type()));
        }
        throw new RuntimeException("Illegal type: " + target.type());
    }

    protected Stmt createStore(VarExpr target, Expr source) {
        target = (VarExpr)target.clone();
        if (source instanceof VarExpr && source.def() == null) {
            return this.createUndefinedStore(target);
        }
        return new ExprStmt(new StoreExpr(target, (Expr)source.clone(), target.type()));
    }

    public void visitExpr(Expr expr) {
        throw new RuntimeException("Unhandled expression type: " + expr.getClass().getName());
    }

    public void visitExprStmt(ExprStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        if (!(stmt.expr() instanceof StoreExpr) && !stmt.expr().type().isVoid()) {
            if (stmt.expr().type().isWide()) {
                this.method.addInstruction(88);
                this.stackHeight -= 2;
            } else {
                this.method.addInstruction(87);
                --this.stackHeight;
            }
        }
    }

    public void visitInitStmt(InitStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
    }

    public void visitGotoStmt(GotoStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        this.genPostponed(stmt);
        Block target = stmt.target();
        if (target != this.next) {
            this.method.addInstruction(167, stmt.target().label());
        }
    }

    public void visitIfCmpStmt(IfCmpStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        Block t = stmt.trueTarget();
        Block f = stmt.falseTarget();
        if (f == this.next) {
            this.genIfCmpStmt(stmt);
        } else if (t == this.next) {
            stmt.negate();
            this.genIfCmpStmt(stmt);
        } else {
            this.genIfCmpStmt(stmt);
            this.method.addLabel(this.method.newLabelTrue());
            this.method.addInstruction(167, f.label());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void genIfCmpStmt(IfCmpStmt stmt) {
        void var2_3;
        block13: {
            int opcode;
            int cmp;
            block12: {
                stmt.visitChildren(this);
                this.genPostponed(stmt);
                cmp = stmt.comparison();
                if (!stmt.left().type().isReference()) break block12;
                Assert.isTrue(stmt.right().type().isReference(), "Illegal statement: " + stmt);
                switch (cmp) {
                    case 0: {
                        opcode = 165;
                        break block13;
                    }
                    case 1: {
                        opcode = 166;
                        break block13;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            Assert.isTrue(stmt.left().type().isIntegral(), "Illegal statement: " + stmt);
            Assert.isTrue(stmt.right().type().isIntegral(), "Illegal statement: " + stmt);
            switch (cmp) {
                case 0: {
                    opcode = 159;
                    break;
                }
                case 1: {
                    opcode = 160;
                    break;
                }
                case 2: {
                    opcode = 163;
                    break;
                }
                case 3: {
                    opcode = 162;
                    break;
                }
                case 4: {
                    opcode = 161;
                    break;
                }
                case 5: {
                    opcode = 164;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.method.addInstruction((int)var2_3, stmt.trueTarget().label());
        this.stackHeight -= 2;
    }

    public void visitIfZeroStmt(IfZeroStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        Block t = stmt.trueTarget();
        Block f = stmt.falseTarget();
        if (f == this.next) {
            this.genIfZeroStmt(stmt);
        } else if (t == this.next) {
            stmt.negate();
            this.genIfZeroStmt(stmt);
        } else {
            this.genIfZeroStmt(stmt);
            this.method.addLabel(this.method.newLabelTrue());
            this.method.addInstruction(167, f.label());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void genIfZeroStmt(IfZeroStmt stmt) {
        void var2_3;
        block13: {
            int opcode;
            int cmp;
            block12: {
                stmt.expr().visit(this);
                this.genPostponed(stmt);
                cmp = stmt.comparison();
                if (!stmt.expr().type().isReference()) break block12;
                switch (cmp) {
                    case 0: {
                        opcode = 198;
                        break block13;
                    }
                    case 1: {
                        opcode = 199;
                        break block13;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            Assert.isTrue(stmt.expr().type().isIntegral(), "Illegal statement: " + stmt);
            switch (cmp) {
                case 0: {
                    opcode = 153;
                    break;
                }
                case 1: {
                    opcode = 154;
                    break;
                }
                case 2: {
                    opcode = 157;
                    break;
                }
                case 3: {
                    opcode = 156;
                    break;
                }
                case 4: {
                    opcode = 155;
                    break;
                }
                case 5: {
                    opcode = 158;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.method.addInstruction((int)var2_3, stmt.trueTarget().label());
        --this.stackHeight;
    }

    public void visitLabelStmt(LabelStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        this.method.addLabel(stmt.label());
    }

    public void visitMonitorStmt(MonitorStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        if (stmt.kind() == 0) {
            this.method.addInstruction(194);
            --this.stackHeight;
        } else if (stmt.kind() == 1) {
            this.method.addInstruction(195);
            --this.stackHeight;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void visitPhiStmt(PhiStmt stmt) {
        throw new RuntimeException("Cannot generate code for " + stmt);
    }

    public void visitRCExpr(RCExpr expr) {
        Expr p;
        expr.visitChildren(this);
        this.genPostponed(expr);
        Instruction postpone = null;
        Node parent = expr.parent();
        if (parent instanceof ZeroCheckExpr) {
            parent = parent.parent();
        }
        if (parent instanceof ArrayRefExpr) {
            p = (ArrayRefExpr)parent;
            if (expr == ((ArrayRefExpr)p).array()) {
                postpone = ((DefExpr)p).isDef() ? new Instruction(237, new Integer(p.type().stackHeight() + 1)) : new Instruction(237, new Integer(1));
            }
        } else if (parent instanceof CallMethodExpr) {
            p = (CallMethodExpr)parent;
            if (expr == ((CallMethodExpr)p).receiver()) {
                MemberRef method = ((CallExpr)p).method();
                int depth = method.nameAndType().type().stackHeight();
                postpone = new Instruction(237, new Integer(depth));
            }
        } else if (parent instanceof FieldExpr && expr == ((FieldExpr)(p = (FieldExpr)parent)).object() && ((DefExpr)p).isDef()) {
            postpone = new Instruction(237, new Integer(p.type().stackHeight()));
        }
        if (postpone == null) {
            int depth = 0;
            if (expr.expr() instanceof StackExpr) {
                StackExpr stackVar = (StackExpr)expr.expr();
                depth = this.stackHeight - stackVar.index() - 1;
            }
            this.method.addInstruction(237, new Integer(depth));
        } else {
            this.postponedInstructions.put(parent, postpone);
        }
    }

    public void visitUCExpr(UCExpr expr) {
        expr.visitChildren(this);
    }

    public void visitRetStmt(RetStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        this.genPostponed(stmt);
        Subroutine sub = stmt.sub();
        Assert.isTrue(sub.returnAddress() != null);
        this.method.addInstruction(169, sub.returnAddress());
    }

    public void visitReturnExprStmt(ReturnExprStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        Type type = stmt.expr().type();
        if (type.isReference()) {
            this.method.addInstruction(176);
            this.stackHeight = 0;
        } else if (type.isIntegral()) {
            this.method.addInstruction(172);
            this.stackHeight = 0;
        } else if (type.equals(Type.LONG)) {
            this.method.addInstruction(173);
            this.stackHeight = 0;
        } else if (type.equals(Type.FLOAT)) {
            this.method.addInstruction(174);
            this.stackHeight = 0;
        } else if (type.equals(Type.DOUBLE)) {
            this.method.addInstruction(175);
            this.stackHeight = 0;
        }
    }

    public void visitReturnStmt(ReturnStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        this.genPostponed(stmt);
        stmt.visitChildren(this);
        this.method.addInstruction(177);
        this.stackHeight = 0;
    }

    public void visitStoreExpr(StoreExpr expr) {
        boolean returnsValue;
        if (DEBUG) {
            System.out.println("code for " + expr);
        }
        MemExpr lhs = expr.target();
        Expr rhs = expr.expr();
        boolean bl = returnsValue = !(expr.parent() instanceof ExprStmt);
        if (!returnsValue) {
            if (lhs instanceof LocalExpr && rhs instanceof LocalExpr && ((LocalExpr)lhs).index() == ((LocalExpr)rhs).index() && (!OPT_STACK || this.currentSO.shouldStore((LocalExpr)((LocalExpr)rhs).def()))) {
                return;
            }
            if (lhs instanceof LocalExpr && lhs.type().isIntegral()) {
                Integer value = null;
                int index = ((LocalExpr)lhs).index();
                if (rhs instanceof ArithExpr) {
                    ConstantExpr c;
                    ArithExpr arith = (ArithExpr)rhs;
                    Expr left = arith.left();
                    Expr right = arith.right();
                    if (left instanceof LocalExpr && index == ((LocalExpr)left).index() && right instanceof ConstantExpr) {
                        c = (ConstantExpr)right;
                        if (c.value() instanceof Integer) {
                            value = (Integer)c.value();
                        }
                    } else if (right instanceof LocalExpr && index == ((LocalExpr)right).index() && left instanceof ConstantExpr && arith.operation() == 43 && (c = (ConstantExpr)left).value() instanceof Integer) {
                        value = (Integer)c.value();
                    }
                    if (value != null && arith.operation() == 45) {
                        value = new Integer(-value.intValue());
                    } else if (arith.operation() != 43) {
                        value = null;
                    }
                }
                if (value != null) {
                    int incr = value;
                    if (incr == 0) {
                        if (OPT_STACK) {
                            int i;
                            int dups = this.currentSO.dups((LocalExpr)lhs);
                            int dup_x1s = this.currentSO.dup_x1s((LocalExpr)lhs);
                            int dup_x2s = this.currentSO.dup_x2s((LocalExpr)lhs);
                            for (i = 0; i < dup_x2s; ++i) {
                                this.method.addInstruction(18, new Integer(0));
                                this.method.addInstruction(91);
                                this.method.addInstruction(87);
                                ++this.stackHeight;
                            }
                            for (i = 0; i < dup_x1s; ++i) {
                                this.method.addInstruction(18, new Integer(0));
                                this.method.addInstruction(95);
                                ++this.stackHeight;
                            }
                            for (i = 0; i < dups; ++i) {
                                this.method.addInstruction(18, new Integer(0));
                                ++this.stackHeight;
                            }
                        }
                        return;
                    }
                    if ((short)incr == incr) {
                        this.method.addInstruction(132, new IncOperand(new LocalVariable(index), incr));
                        if (OPT_STACK) {
                            int i;
                            int dups = this.currentSO.dups((LocalExpr)lhs);
                            int dup_x1s = this.currentSO.dup_x1s((LocalExpr)lhs);
                            int dup_x2s = this.currentSO.dup_x2s((LocalExpr)lhs);
                            for (i = 0; i < dup_x2s; ++i) {
                                this.method.addInstruction(54, new LocalVariable(((LocalExpr)lhs).index()));
                                this.method.addInstruction(91);
                                this.method.addInstruction(87);
                                ++this.stackHeight;
                            }
                            for (i = 0; i < dup_x1s; ++i) {
                                this.method.addInstruction(21, new LocalVariable(((LocalExpr)lhs).index()));
                                this.method.addInstruction(95);
                                ++this.stackHeight;
                            }
                            for (i = 0; i < dups; ++i) {
                                this.method.addInstruction(21, new LocalVariable(((LocalExpr)lhs).index()));
                                ++this.stackHeight;
                            }
                        }
                        return;
                    }
                }
            }
        }
        lhs.visitChildren(this);
        rhs.visit(this);
        if (returnsValue) {
            if (lhs instanceof ArrayRefExpr) {
                if (rhs.type().isWide()) {
                    this.method.addInstruction(94);
                    this.stackHeight += 2;
                } else {
                    this.method.addInstruction(91);
                    ++this.stackHeight;
                }
            } else if (lhs instanceof FieldExpr) {
                if (rhs.type().isWide()) {
                    this.method.addInstruction(93);
                    this.stackHeight += 2;
                } else {
                    this.method.addInstruction(90);
                    ++this.stackHeight;
                }
            } else if (rhs.type().isWide()) {
                this.method.addInstruction(92);
                this.stackHeight += 2;
            } else {
                this.method.addInstruction(89);
                ++this.stackHeight;
            }
        }
        this.genPostponed(expr);
        lhs.visitOnly(this);
    }

    public void visitAddressStoreStmt(AddressStoreStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        this.genPostponed(stmt);
        Subroutine sub = stmt.sub();
        Assert.isTrue(sub.returnAddress() != null);
        this.method.addInstruction(58, sub.returnAddress());
        --this.stackHeight;
    }

    public void visitJsrStmt(JsrStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        this.genPostponed(stmt);
        Block entry = stmt.sub().entry();
        this.method.addInstruction(168, entry.label());
        ++this.stackHeight;
        if (stmt.follow() != this.next) {
            this.method.addLabel(this.method.newLabelTrue());
            this.method.addInstruction(167, stmt.follow().label());
        }
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        Label[] targets = new Label[stmt.targets().length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = stmt.targets()[i].label();
        }
        this.method.addInstruction(170, new Switch(stmt.defaultTarget().label(), targets, stmt.values()));
        --this.stackHeight;
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        this.genPostponed(stmt);
        switch (stmt.kind()) {
            case 0: {
                this.method.addInstruction(95);
                break;
            }
            case 1: {
                this.method.addInstruction(89);
                ++this.stackHeight;
                break;
            }
            case 2: {
                this.method.addInstruction(90);
                ++this.stackHeight;
                break;
            }
            case 3: {
                this.method.addInstruction(91);
                ++this.stackHeight;
                break;
            }
            case 4: {
                this.method.addInstruction(92);
                this.stackHeight += 2;
                break;
            }
            case 5: {
                this.method.addInstruction(93);
                this.stackHeight += 2;
                break;
            }
            case 6: {
                this.method.addInstruction(94);
                this.stackHeight += 2;
            }
        }
    }

    public void visitThrowStmt(ThrowStmt stmt) {
        if (DEBUG) {
            System.out.println("code for " + stmt);
        }
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        this.method.addInstruction(191);
    }

    public void visitSCStmt(SCStmt stmt) {
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        this.method.addInstruction(240);
        this.stackHeight -= 2;
    }

    public void visitSRStmt(SRStmt stmt) {
        stmt.visitChildren(this);
        this.genPostponed(stmt);
        this.method.addInstruction(241);
        this.stackHeight -= 3;
    }

    /*
     * WARNING - void declaration
     */
    public void visitArithExpr(ArithExpr expr) {
        int type;
        expr.visitChildren(this);
        this.genPostponed(expr);
        int[][] opcode = new int[][]{{96, 97, 98, 99}, {126, 127, 0, 0}, {108, 109, 110, 111}, {104, 105, 106, 107}, {128, 129, 0, 0}, {112, 113, 114, 115}, {100, 101, 102, 103}, {130, 131, 0, 0}, {0, 148, 0, 0}, {0, 0, 149, 151}, {0, 0, 150, 152}};
        int[][] stackChange = new int[][]{{-1, -2, -1, -2}, {-1, -2, 0, 0}, {-1, -2, -1, -2}, {-1, -2, -1, -2}, {-1, -2, 0, 0}, {-1, -2, -1, -2}, {-1, -2, -1, -2}, {-1, -2, 0, 0}, {0, -3, 0, 0}, {0, 0, -1, -3}, {0, 0, -1, -3}};
        if (expr.left().type().isIntegral()) {
            type = 0;
        } else if (expr.left().type().equals(Type.LONG)) {
            type = 1;
        } else if (expr.left().type().equals(Type.FLOAT)) {
            type = 2;
        } else if (expr.left().type().equals(Type.DOUBLE)) {
            type = 3;
        } else {
            throw new IllegalArgumentException("Can't generate code for type: " + expr.left().type() + " (expr " + expr + ")");
        }
        switch (expr.operation()) {
            case 43: {
                void var4_4;
                this.method.addInstruction(opcode[0][var4_4]);
                this.stackHeight += stackChange[0][var4_4];
                break;
            }
            case 38: {
                void var4_4;
                this.method.addInstruction(opcode[1][var4_4]);
                this.stackHeight += stackChange[1][var4_4];
                break;
            }
            case 47: {
                void var4_4;
                this.method.addInstruction(opcode[2][var4_4]);
                this.stackHeight += stackChange[2][var4_4];
                break;
            }
            case 42: {
                void var4_4;
                this.method.addInstruction(opcode[3][var4_4]);
                this.stackHeight += stackChange[3][var4_4];
                break;
            }
            case 124: {
                void var4_4;
                this.method.addInstruction(opcode[4][var4_4]);
                this.stackHeight += stackChange[4][var4_4];
                break;
            }
            case 37: {
                void var4_4;
                this.method.addInstruction(opcode[5][var4_4]);
                this.stackHeight += stackChange[5][var4_4];
                break;
            }
            case 45: {
                void var4_4;
                this.method.addInstruction(opcode[6][var4_4]);
                this.stackHeight += stackChange[6][var4_4];
                break;
            }
            case 94: {
                void var4_4;
                this.method.addInstruction(opcode[7][var4_4]);
                this.stackHeight += stackChange[7][var4_4];
                break;
            }
            case 63: {
                void var4_4;
                this.method.addInstruction(opcode[8][var4_4]);
                this.stackHeight += stackChange[8][var4_4];
                break;
            }
            case 60: {
                void var4_4;
                this.method.addInstruction(opcode[9][var4_4]);
                this.stackHeight += stackChange[9][var4_4];
                break;
            }
            case 62: {
                void var4_4;
                this.method.addInstruction(opcode[10][var4_4]);
                this.stackHeight += stackChange[10][var4_4];
            }
        }
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
        expr.visitChildren(this);
        this.method.addInstruction(190);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitArrayRefExpr(ArrayRefExpr expr) {
        void var2_2;
        int opcode;
        expr.visitChildren(this);
        this.genPostponed(expr);
        if (expr.isDef()) {
            if (expr.elementType().isReference()) {
                opcode = 83;
                this.stackHeight -= 3;
            } else if (expr.elementType().equals(Type.BYTE)) {
                opcode = 84;
                this.stackHeight -= 3;
            } else if (expr.elementType().equals(Type.CHARACTER)) {
                opcode = 85;
                this.stackHeight -= 3;
            } else if (expr.elementType().equals(Type.SHORT)) {
                opcode = 86;
                this.stackHeight -= 3;
            } else if (expr.elementType().equals(Type.INTEGER)) {
                opcode = 79;
                this.stackHeight -= 3;
            } else if (expr.elementType().equals(Type.LONG)) {
                opcode = 80;
                this.stackHeight -= 4;
            } else if (expr.elementType().equals(Type.FLOAT)) {
                opcode = 81;
                this.stackHeight -= 3;
            } else {
                if (!expr.elementType().equals(Type.DOUBLE)) throw new IllegalArgumentException("Can't generate code for type: " + expr.type() + " (expr " + expr + ")");
                opcode = 82;
                this.stackHeight -= 4;
            }
        } else if (expr.elementType().isReference()) {
            opcode = 50;
            --this.stackHeight;
        } else if (expr.elementType().equals(Type.BYTE)) {
            opcode = 51;
            --this.stackHeight;
        } else if (expr.elementType().equals(Type.CHARACTER)) {
            opcode = 52;
            --this.stackHeight;
        } else if (expr.elementType().equals(Type.SHORT)) {
            opcode = 53;
            --this.stackHeight;
        } else if (expr.elementType().equals(Type.INTEGER)) {
            opcode = 46;
            --this.stackHeight;
        } else if (expr.elementType().equals(Type.LONG)) {
            opcode = 47;
            this.stackHeight -= 0;
        } else if (expr.elementType().equals(Type.FLOAT)) {
            opcode = 48;
            --this.stackHeight;
        } else {
            if (!expr.elementType().equals(Type.DOUBLE)) throw new IllegalArgumentException("Can't generate code for type: " + expr.type() + " (expr " + expr + ")");
            opcode = 49;
            this.stackHeight -= 0;
        }
        this.method.addInstruction((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitCallMethodExpr(CallMethodExpr expr) {
        void var2_2;
        int opcode;
        expr.visitChildren(this);
        this.genPostponed(expr);
        if (expr.kind() == 0) {
            opcode = 182;
        } else if (expr.kind() == 1) {
            opcode = 183;
        } else if (expr.kind() == 2) {
            opcode = 185;
        } else {
            throw new IllegalArgumentException();
        }
        this.method.addInstruction((int)var2_2, expr.method());
        --this.stackHeight;
        Expr[] params = expr.params();
        for (int i = 0; i < params.length; ++i) {
            this.stackHeight -= params[i].type().stackHeight();
        }
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        this.method.addInstruction(184, expr.method());
        Expr[] params = expr.params();
        for (int i = 0; i < params.length; ++i) {
            this.stackHeight -= params[i].type().stackHeight();
        }
    }

    public void visitCastExpr(CastExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        if (expr.castType().isReference()) {
            this.method.addInstruction(192, expr.castType());
            return;
        }
        int opType = expr.expr().type().typeCode();
        int castType = expr.castType().typeCode();
        switch (opType) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                switch (castType) {
                    case 8: {
                        this.method.addInstruction(145);
                        return;
                    }
                    case 9: {
                        this.method.addInstruction(147);
                        return;
                    }
                    case 5: {
                        this.method.addInstruction(146);
                        return;
                    }
                    case 10: {
                        return;
                    }
                    case 11: {
                        this.method.addInstruction(133);
                        ++this.stackHeight;
                        return;
                    }
                    case 6: {
                        this.method.addInstruction(134);
                        return;
                    }
                    case 7: {
                        this.method.addInstruction(135);
                        ++this.stackHeight;
                        return;
                    }
                }
                throw new IllegalArgumentException("Can't generate cast for type " + Type.getType(castType));
            }
            case 11: {
                switch (castType) {
                    case 8: {
                        this.method.addInstruction(136);
                        --this.stackHeight;
                        this.method.addInstruction(145);
                        return;
                    }
                    case 9: {
                        this.method.addInstruction(136);
                        --this.stackHeight;
                        this.method.addInstruction(147);
                        return;
                    }
                    case 5: {
                        this.method.addInstruction(136);
                        --this.stackHeight;
                        this.method.addInstruction(146);
                        return;
                    }
                    case 10: {
                        this.method.addInstruction(136);
                        --this.stackHeight;
                        return;
                    }
                    case 11: {
                        return;
                    }
                    case 6: {
                        this.method.addInstruction(137);
                        --this.stackHeight;
                        return;
                    }
                    case 7: {
                        this.method.addInstruction(138);
                        return;
                    }
                }
                throw new IllegalArgumentException("Can't generate cast for type " + Type.getType(castType));
            }
            case 6: {
                switch (castType) {
                    case 8: {
                        this.method.addInstruction(139);
                        this.method.addInstruction(145);
                        return;
                    }
                    case 9: {
                        this.method.addInstruction(139);
                        this.method.addInstruction(147);
                        return;
                    }
                    case 5: {
                        this.method.addInstruction(139);
                        this.method.addInstruction(146);
                        return;
                    }
                    case 10: {
                        this.method.addInstruction(139);
                        return;
                    }
                    case 11: {
                        this.method.addInstruction(140);
                        ++this.stackHeight;
                        return;
                    }
                    case 6: {
                        return;
                    }
                    case 7: {
                        this.method.addInstruction(141);
                        ++this.stackHeight;
                        return;
                    }
                }
                throw new IllegalArgumentException("Can't generate cast for type " + Type.getType(castType));
            }
            case 7: {
                switch (castType) {
                    case 8: {
                        this.method.addInstruction(142);
                        --this.stackHeight;
                        this.method.addInstruction(145);
                        return;
                    }
                    case 9: {
                        this.method.addInstruction(142);
                        --this.stackHeight;
                        this.method.addInstruction(147);
                        return;
                    }
                    case 5: {
                        this.method.addInstruction(142);
                        --this.stackHeight;
                        this.method.addInstruction(146);
                        return;
                    }
                    case 10: {
                        this.method.addInstruction(142);
                        --this.stackHeight;
                        return;
                    }
                    case 11: {
                        this.method.addInstruction(143);
                        return;
                    }
                    case 6: {
                        this.method.addInstruction(144);
                        return;
                    }
                    case 7: {
                        return;
                    }
                }
                throw new IllegalArgumentException("Can't generate cast for type " + Type.getType(castType));
            }
        }
        throw new IllegalArgumentException("Can't generate cast from type " + Type.getType(opType));
    }

    public void visitConstantExpr(ConstantExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        this.method.addInstruction(18, expr.value());
        this.stackHeight += expr.type().stackHeight();
    }

    public void visitFieldExpr(FieldExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        if (expr.isDef()) {
            boolean UC = false;
            Expr check = expr.object();
            while (check instanceof CheckExpr) {
                if (check instanceof UCExpr) {
                    UC = true;
                    break;
                }
                CheckExpr c = (CheckExpr)check;
                check = c.expr();
            }
            if (!UC && USE_PERSISTENT) {
                this.nowb = true;
            } else {
                this.method.addInstruction(181, expr.field());
            }
            --this.stackHeight;
            this.stackHeight -= expr.type().stackHeight();
        } else {
            this.method.addInstruction(180, expr.field());
            --this.stackHeight;
            this.stackHeight += expr.type().stackHeight();
        }
    }

    public void visitInstanceOfExpr(InstanceOfExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        this.method.addInstruction(193, expr.checkType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitLocalExpr(LocalExpr expr) {
        this.genPostponed(expr);
        boolean cat2 = expr.type().isWide();
        int opcode = -1;
        if (DB_OPT_STACK) {
            this.currentSO.infoDisplay(expr);
        }
        if (expr.isDef()) {
            if (!OPT_STACK || this.currentSO.shouldStore(expr)) {
                if (expr.type().isAddress()) {
                    opcode = 58;
                    --this.stackHeight;
                } else if (expr.type().isReference()) {
                    opcode = 58;
                    --this.stackHeight;
                } else if (expr.type().isIntegral()) {
                    opcode = 54;
                    --this.stackHeight;
                } else if (expr.type().equals(Type.LONG)) {
                    opcode = 55;
                    this.stackHeight -= 2;
                } else if (expr.type().equals(Type.FLOAT)) {
                    opcode = 56;
                    --this.stackHeight;
                } else {
                    if (!expr.type().equals(Type.DOUBLE)) throw new IllegalArgumentException("Can't generate code for type: " + expr.type() + " (expr " + expr + ")");
                    opcode = 57;
                    this.stackHeight -= 2;
                }
            }
        } else if (OPT_STACK && this.currentSO.onStack(expr)) {
            if (this.currentSO.shouldSwap(expr)) {
                if (cat2) {
                    throw new IllegalArgumentException("Can't swap for wide expression " + expr.toString() + " of type " + expr.type().toString());
                }
                opcode = 95;
                --this.stackHeight;
            }
        } else if (expr.type().isReference()) {
            opcode = 25;
            ++this.stackHeight;
        } else if (expr.type().isIntegral()) {
            opcode = 21;
            ++this.stackHeight;
        } else if (expr.type().equals(Type.LONG)) {
            opcode = 22;
            this.stackHeight += 2;
        } else if (expr.type().equals(Type.FLOAT)) {
            opcode = 23;
            ++this.stackHeight;
        } else {
            if (!expr.type().equals(Type.DOUBLE)) throw new IllegalArgumentException("Can't generate code for type: " + expr.type() + " (expr " + expr + ")");
            opcode = 24;
            this.stackHeight += 2;
        }
        if (opcode == 95) {
            this.method.addInstruction(opcode);
        } else if (opcode != -1 && !expr.isDef()) {
            this.method.addInstruction(opcode, new LocalVariable(expr.index()));
            if (MethodEditor.OPT_STACK_2) {
                this.method.rememberDef(expr);
            }
        }
        if (OPT_STACK) {
            int i;
            int dups = this.currentSO.dups(expr);
            int dup_x1s = this.currentSO.dup_x1s(expr);
            int dup_x2s = this.currentSO.dup_x2s(expr);
            for (i = 0; i < dup_x2s; ++i) {
                if (cat2) {
                    this.method.addInstruction(94);
                    this.stackHeight += 2;
                    continue;
                }
                this.method.addInstruction(91);
                ++this.stackHeight;
            }
            for (i = 0; i < dup_x1s; ++i) {
                if (cat2) {
                    this.method.addInstruction(93);
                    this.stackHeight += 2;
                    continue;
                }
                this.method.addInstruction(90);
                ++this.stackHeight;
            }
            for (i = 0; i < dups; ++i) {
                if (cat2) {
                    this.method.addInstruction(92);
                    this.stackHeight += 2;
                    continue;
                }
                this.method.addInstruction(89);
                ++this.stackHeight;
            }
        }
        if (opcode != -1 && expr.isDef()) {
            this.method.addInstruction(opcode, new LocalVariable(expr.index()));
            if (MethodEditor.OPT_STACK_2) {
                this.method.rememberDef(expr);
            }
        }
        if (!OPT_STACK || this.currentSO.shouldStore(expr)) return;
        if (cat2) {
            this.method.addInstruction(88);
            this.stackHeight -= 2;
            return;
        } else {
            this.method.addInstruction(87);
            --this.stackHeight;
        }
    }

    public void visitNegExpr(NegExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        if (expr.type().isIntegral()) {
            this.method.addInstruction(116);
        } else if (expr.type().equals(Type.FLOAT)) {
            this.method.addInstruction(118);
        } else if (expr.type().equals(Type.LONG)) {
            this.method.addInstruction(117);
        } else if (expr.type().equals(Type.DOUBLE)) {
            this.method.addInstruction(119);
        } else {
            throw new IllegalArgumentException("Can't generate code for type: " + expr.type() + " (expr " + expr + ")");
        }
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        this.method.addInstruction(188, expr.elementType());
    }

    public void visitNewExpr(NewExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        this.method.addInstruction(187, expr.objectType());
        ++this.stackHeight;
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        this.method.addInstruction(197, new MultiArrayOperand(expr.elementType().arrayType(expr.dimensions().length), expr.dimensions().length));
        this.stackHeight -= expr.dimensions().length;
        ++this.stackHeight;
    }

    public void visitReturnAddressExpr(ReturnAddressExpr expr) {
        this.genPostponed(expr);
    }

    public void visitShiftExpr(ShiftExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        if (expr.type().isIntegral()) {
            if (expr.dir() == 0) {
                this.method.addInstruction(120);
                --this.stackHeight;
            } else if (expr.dir() == 1) {
                this.method.addInstruction(122);
                --this.stackHeight;
            } else {
                this.method.addInstruction(124);
                --this.stackHeight;
            }
        } else if (expr.type().equals(Type.LONG)) {
            if (expr.dir() == 0) {
                this.method.addInstruction(121);
                --this.stackHeight;
            } else if (expr.dir() == 1) {
                this.method.addInstruction(123);
                --this.stackHeight;
            } else {
                this.method.addInstruction(125);
                --this.stackHeight;
            }
        } else {
            throw new IllegalArgumentException("Can't generate code for type: " + expr.type() + " (expr " + expr + ")");
        }
    }

    public void visitDefExpr(DefExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
    }

    public void visitCatchExpr(CatchExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
    }

    public void visitStackExpr(StackExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
        if (expr.isDef()) {
            this.method.addInstruction(179, expr.field());
            this.stackHeight -= expr.type().stackHeight();
        } else {
            this.method.addInstruction(178, expr.field());
            this.stackHeight += expr.type().stackHeight();
        }
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
        expr.visitChildren(this);
        this.genPostponed(expr);
    }

    private void genPostponed(Node node) {
        Instruction inst = (Instruction)this.postponedInstructions.get(node);
        if (inst != null) {
            this.method.addInstruction(inst);
            this.postponedInstructions.remove(node);
        }
    }
}

