/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.cfg;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.Handler;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VerifyCFG
extends TreeVisitor {
    Block block;
    Node parent;
    FlowGraph cfg;
    Set uses;
    Set nodes;
    boolean checkValueNumbers;

    public VerifyCFG() {
        this(false);
    }

    public VerifyCFG(boolean checkValueNumbers) {
        this.checkValueNumbers = checkValueNumbers;
    }

    public void visitFlowGraph(FlowGraph cfg) {
        if (FlowGraph.DEBUG) {
            System.out.println("Verifying CFG for " + cfg.method());
        }
        this.cfg = cfg;
        this.uses = new HashSet();
        this.nodes = new HashSet();
        cfg.visitChildren(this);
        Iterator e = this.uses.iterator();
        while (e.hasNext()) {
            Expr use = (Expr)e.next();
            Assert.isTrue(this.nodes.contains(use), "use = " + use + " (" + System.identityHashCode(use) + ") is not in the CFG");
        }
        if (FlowGraph.DEBUG) {
            System.out.println("Verification successful");
        }
        this.cfg = null;
        this.uses = null;
        this.nodes = null;
        this.block = null;
        this.parent = null;
    }

    public void visitBlock(Block block) {
        Iterator e;
        Assert.isTrue(block.graph() == this.cfg, block + " is not in the CFG");
        Handler handler = (Handler)this.cfg.handlersMap().get(block);
        if (handler != null) {
            HashSet<Block> handlerPreds = new HashSet<Block>();
            e = handler.protectedBlocks().iterator();
            while (e.hasNext()) {
                Block prot = (Block)e.next();
                handlerPreds.add(prot);
                handlerPreds.addAll(this.cfg.preds(prot));
            }
            HashSet extra = new HashSet(this.cfg.preds(block));
            extra.removeAll(handlerPreds);
            HashSet missing = new HashSet(handlerPreds);
            missing.removeAll(this.cfg.preds(block));
            Assert.isTrue(extra.size() == 0 && missing.size() == 0 || missing.size() == 1 && missing.contains(this.cfg.init()), "Handler prots = " + handlerPreds + " != handler block preds = " + this.cfg.preds(block) + " extra = " + extra + " missing = " + missing);
        }
        e = this.cfg.preds(block).iterator();
        while (e.hasNext()) {
            Block pred = (Block)e.next();
            Assert.isTrue(this.cfg.succs(pred).contains(block), pred + " has no succ " + block);
            Assert.isTrue(this.cfg.preds(block).contains(pred), block + " has no pred " + pred);
        }
        e = this.cfg.succs(block).iterator();
        while (e.hasNext()) {
            Block succ = (Block)e.next();
            Assert.isTrue(this.cfg.succs(block).contains(succ), block + " has no succ " + succ);
            Assert.isTrue(this.cfg.preds(succ).contains(block), succ + " has no pred " + block);
        }
        this.block = block;
        this.parent = null;
        block.visitChildren(this);
    }

    public void visitRetStmt(RetStmt stmt) {
        HashSet<Block> targets = new HashSet<Block>();
        Iterator iter = stmt.sub().paths().iterator();
        while (iter.hasNext()) {
            Block[] path = (Block[])iter.next();
            targets.add(path[1]);
        }
        targets.addAll(stmt.catchTargets());
        this.verifyTargets(stmt.block(), targets);
        this.visitNode(stmt);
    }

    public void visitJsrStmt(JsrStmt stmt) {
        HashSet<Block> targets = new HashSet<Block>();
        targets.add(stmt.sub().entry());
        targets.addAll(stmt.catchTargets());
        this.verifyTargets(stmt.block(), targets);
        this.visitNode(stmt);
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        HashSet<Block> targets = new HashSet<Block>();
        targets.add(stmt.defaultTarget());
        for (int i = 0; i < stmt.targets().length; ++i) {
            targets.add(stmt.targets()[i]);
        }
        targets.addAll(stmt.catchTargets());
        this.verifyTargets(stmt.block(), targets);
        this.visitNode(stmt);
    }

    public void visitIfStmt(IfStmt stmt) {
        HashSet<Block> targets = new HashSet<Block>();
        targets.add(stmt.trueTarget());
        targets.add(stmt.falseTarget());
        targets.addAll(stmt.catchTargets());
        this.verifyTargets(stmt.block(), targets);
        this.visitNode(stmt);
    }

    public void visitGotoStmt(GotoStmt stmt) {
        HashSet<Block> targets = new HashSet<Block>();
        targets.add(stmt.target());
        targets.addAll(stmt.catchTargets());
        this.verifyTargets(stmt.block(), targets);
        this.visitNode(stmt);
    }

    private void verifyTargets(Block block, Set targets) {
        Assert.isTrue(targets.size() == this.cfg.succs(block).size(), block + " has succs " + this.cfg.succs(block) + " != " + targets + " in " + block.tree().lastStmt());
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            Block target = (Block)iter.next();
            Assert.isTrue(block.graph().hasNode(target), target + " is not in the CFG");
            Assert.isTrue(this.cfg.succs(block).contains(target), target + " is not a succ of " + block + " " + block.tree().lastStmt());
        }
    }

    public void visitStoreExpr(StoreExpr node) {
        this.nodes.add(node);
        if (this.checkValueNumbers) {
            Assert.isTrue(node.valueNumber() != -1, node + ".valueNumber() = -1");
        }
        Assert.isTrue(node.block() == this.block, node + ".block() = " + node.block() + " != block = " + this.block);
        Assert.isTrue(node.parent() == this.parent, node + ".parent() = " + node.parent() + " != parent = " + this.parent);
        this.parent = node;
        node.target().visit(this);
        this.parent = node;
        node.expr().visit(this);
        this.parent = node.parent();
        if (node.type().isVoid()) {
            Assert.isTrue(this.parent instanceof ExprStmt, "parent of " + node + " = " + this.parent + " is not an ExprStmt");
        }
    }

    public void visitNode(Node node) {
        this.nodes.add(node);
        Assert.isTrue(node.block() == this.block, node + ".block() = " + node.block() + " != block = " + this.block);
        Assert.isTrue(node.parent() == this.parent, node + ".parent() = " + node.parent() + " != parent = " + this.parent);
        final ArrayList children = new ArrayList();
        node.visitChildren(new TreeVisitor(){

            public void visitNode(Node n) {
                children.add(n);
            }
        });
        Iterator e = children.iterator();
        while (e.hasNext()) {
            Node child = (Node)e.next();
            this.parent = node;
            child.visit(this);
        }
        this.parent = node.parent();
    }

    public void visitExpr(Expr expr) {
        if (this.checkValueNumbers) {
            Assert.isTrue(expr.valueNumber() != -1, expr + ".valueNumber() = -1");
        }
        this.visitNode(expr);
    }

    public void visitDefExpr(DefExpr expr) {
        this.uses.addAll(expr.uses());
        this.visitExpr(expr);
    }

    public void visitVarExpr(VarExpr expr) {
        Assert.isTrue(expr.isDef() || expr.def() != null || expr.parent() instanceof PhiStmt, "Null def for variable " + expr);
        this.visitDefExpr(expr);
    }
}

