/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.cfg;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Subroutine {
    FlowGraph graph;
    Block entry;
    Block exit;
    ArrayList paths;
    LocalVariable returnAddress;

    public Subroutine(FlowGraph graph) {
        this.graph = graph;
        this.entry = null;
        this.exit = null;
        this.paths = new ArrayList();
        this.returnAddress = null;
    }

    public LocalVariable returnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(LocalVariable returnAddress) {
        this.returnAddress = returnAddress;
    }

    public int numPaths() {
        return this.paths.size();
    }

    public Collection paths() {
        return this.paths;
    }

    public FlowGraph graph() {
        return this.graph;
    }

    public void removePathsContaining(Block block) {
        for (int i = this.paths.size() - 1; i >= 0; --i) {
            Block[] path = (Block[])this.paths.get(i);
            if (path[0] != block && path[1] != block) continue;
            if (FlowGraph.DEBUG) {
                System.out.println("removing path " + path[0] + " -> " + path[1]);
            }
            this.paths.remove(i);
        }
    }

    public void removePath(Block callerBlock, Block returnBlock) {
        for (int i = 0; i < this.paths.size(); ++i) {
            Block[] path = (Block[])this.paths.get(i);
            if (path[0] != callerBlock || path[1] != returnBlock) continue;
            if (FlowGraph.DEBUG) {
                System.out.println("removing path " + path[0] + " -> " + path[1]);
            }
            this.paths.remove(i);
            return;
        }
    }

    public void removeAllPaths() {
        this.paths = new ArrayList();
    }

    public void addPath(Block callerBlock, Block returnBlock) {
        for (int i = 0; i < this.paths.size(); ++i) {
            Block[] path = (Block[])this.paths.get(i);
            if (path[0] != callerBlock) continue;
            path[1] = returnBlock;
            return;
        }
        this.paths.add(new Block[]{callerBlock, returnBlock});
    }

    public Block pathTarget(Block block) {
        for (int i = 0; i < this.paths.size(); ++i) {
            Block[] path = (Block[])this.paths.get(i);
            if (path[0] != block) continue;
            return path[1];
        }
        return null;
    }

    public Block pathSource(Block block) {
        for (int i = 0; i < this.paths.size(); ++i) {
            Block[] path = (Block[])this.paths.get(i);
            if (path[1] != block) continue;
            return path[0];
        }
        return null;
    }

    public void setEntry(Block entry) {
        this.entry = entry;
    }

    public void setExit(Block exit) {
        this.exit = exit;
    }

    public Block entry() {
        return this.entry;
    }

    public Block exit() {
        return this.exit;
    }

    public void print(PrintStream out) {
        out.println("    " + this.entry);
        Iterator e = this.paths().iterator();
        while (e.hasNext()) {
            Block[] path = (Block[])e.next();
            out.println("    path: " + path[0] + " -> " + path[1]);
        }
    }

    public String toString() {
        return "sub " + this.entry;
    }
}

