/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.cfg;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DominatorTree {
    public static boolean DEBUG = false;

    public static void buildTree(FlowGraph graph, boolean reverse) {
        int i;
        Block block;
        Iterator blocks;
        int i2;
        int size = graph.size();
        HashMap snkPreds = new HashMap();
        DominatorTree.insertEdgesToSink(graph, snkPreds, reverse);
        int root = reverse ? graph.preOrderIndex(graph.sink()) : graph.preOrderIndex(graph.source());
        Assert.isTrue(0 <= root && root < size);
        BitSet[] dom = new BitSet[size];
        BitSet ALL = new BitSet(size);
        for (i2 = 0; i2 < size; ++i2) {
            ALL.set(i2);
        }
        for (i2 = 0; i2 < size; ++i2) {
            BitSet blockDoms;
            dom[i2] = blockDoms = new BitSet(size);
            if (i2 != root) {
                blockDoms.or(ALL);
                continue;
            }
            blockDoms.set(root);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator iterator = blocks = reverse ? graph.postOrder().iterator() : graph.preOrder().iterator();
            while (blocks.hasNext()) {
                int j;
                Block pred;
                block = (Block)blocks.next();
                i = graph.preOrderIndex(block);
                Assert.isTrue(0 <= i && i < size, "Unreachable block " + block);
                if (i == root) continue;
                BitSet oldSet = dom[i];
                BitSet blockDoms = new BitSet(size);
                blockDoms.or(oldSet);
                Collection preds = reverse ? graph.succs(block) : graph.preds(block);
                Iterator e = preds.iterator();
                while (e.hasNext()) {
                    pred = (Block)e.next();
                    j = graph.preOrderIndex(pred);
                    Assert.isTrue(j >= 0, "Unreachable block " + pred);
                    blockDoms.and(dom[j]);
                }
                preds = (Collection)snkPreds.get(block);
                if (preds != null) {
                    e = preds.iterator();
                    while (e.hasNext()) {
                        pred = (Block)e.next();
                        j = graph.preOrderIndex(pred);
                        Assert.isTrue(j >= 0, "Unreachable block " + pred);
                        blockDoms.and(dom[j]);
                    }
                }
                blockDoms.set(i);
                if (blockDoms.equals(oldSet)) continue;
                changed = true;
                dom[i] = blockDoms;
            }
        }
        blocks = graph.nodes().iterator();
        while (blocks.hasNext()) {
            block = (Block)blocks.next();
            if (!reverse) {
                block.setDomParent(null);
                block.domChildren().clear();
                continue;
            }
            block.setPdomParent(null);
            block.pdomChildren().clear();
        }
        blocks = graph.nodes().iterator();
        while (blocks.hasNext()) {
            block = (Block)blocks.next();
            i = graph.preOrderIndex(block);
            Assert.isTrue(0 <= i && i < size, "Unreachable block " + block);
            if (i == root) {
                if (!reverse) {
                    block.setDomParent(null);
                    continue;
                }
                block.setPdomParent(null);
                continue;
            }
            BitSet blockDoms = dom[i];
            BitSet idom = new BitSet(size);
            idom.or(blockDoms);
            idom.clear(i);
            for (int j = 0; j < size; ++j) {
                if (i == j || !blockDoms.get(j)) continue;
                BitSet domDomBlocks = dom[j];
                BitSet b = new BitSet(size);
                b.or(domDomBlocks);
                b.xor(ALL);
                b.set(j);
                idom.and(b);
            }
            Block parent = null;
            for (int j = 0; j < size; ++j) {
                if (!idom.get(j)) continue;
                Block p = (Block)graph.preOrder().get(j);
                Assert.isTrue(parent == null, block + " has more than one immediate dominator: " + parent + " and " + p);
                parent = p;
            }
            Assert.isTrue(parent != null, block + " has 0 immediate " + (reverse ? "postdominators" : "dominators"));
            if (!reverse) {
                if (DEBUG) {
                    System.out.println(parent + " dominates " + block);
                }
                block.setDomParent(parent);
                continue;
            }
            if (DEBUG) {
                System.out.println(parent + " postdominates " + block);
            }
            block.setPdomParent(parent);
        }
    }

    private static void insertEdgesToSink(FlowGraph graph, Map preds, boolean reverse) {
        BitSet visited = new BitSet();
        BitSet returned = new BitSet();
        visited.set(graph.preOrderIndex(graph.source()));
        DominatorTree.insertEdgesToSinkDFS(graph, graph.source(), visited, returned, preds, reverse);
    }

    private static void insertEdgesToSinkDFS(FlowGraph graph, Block block, BitSet visited, BitSet returned, Map preds, boolean reverse) {
        boolean leaf = true;
        Iterator e = graph.succs(block).iterator();
        while (e.hasNext()) {
            Block succ = (Block)e.next();
            int index = graph.preOrderIndex(succ);
            Assert.isTrue(index >= 0, "Unreachable block " + succ);
            if (!visited.get(index)) {
                visited.set(index);
                DominatorTree.insertEdgesToSinkDFS(graph, succ, visited, returned, preds, reverse);
                returned.set(index);
                leaf = false;
                continue;
            }
            if (!returned.get(index)) continue;
            leaf = false;
        }
        if (leaf && block != graph.sink()) {
            Set<Block> p;
            if (!reverse) {
                p = (Set)preds.get(graph.sink());
                if (p == null) {
                    p = new HashSet();
                    preds.put(graph.sink(), p);
                }
                p.add(block);
            } else {
                p = (HashSet<Block>)preds.get(block);
                if (p == null) {
                    p = new HashSet<Block>();
                    preds.put(block, p);
                }
                p.add(graph.sink());
            }
        }
    }

    private static void print(FlowGraph graph, boolean rev, String msg, int j, BitSet set) {
        if (rev) {
            System.out.print("reverse ");
        } else {
            System.out.print("forward ");
        }
        System.out.print(msg + " for " + graph.preOrder().get(j) + " =");
        for (int i = 0; i < graph.size(); ++i) {
            if (!set.get(i)) continue;
            System.out.print(" " + graph.preOrder().get(i));
        }
        System.out.println();
    }
}

