/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.cfg;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.tree.StackOptimizer;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.GraphNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Block
extends GraphNode {
    public static final int NON_HEADER = 0;
    public static final int IRREDUCIBLE = 1;
    public static final int REDUCIBLE = 2;
    FlowGraph graph;
    Label label;
    Tree tree;
    Block domParent;
    Block pdomParent;
    Set domChildren;
    Set pdomChildren;
    Set domFrontier;
    Set pdomFrontier;
    int blockType;
    Block header;
    StackOptimizer stackOptimizer;

    Block(Label label, FlowGraph graph) {
        this.label = label;
        this.graph = graph;
        this.tree = null;
        this.header = null;
        this.blockType = 0;
        label.setStartsBlock(true);
        this.domParent = null;
        this.pdomParent = null;
        this.domChildren = new HashSet();
        this.pdomChildren = new HashSet();
        this.domFrontier = new HashSet();
        this.pdomFrontier = new HashSet();
        this.stackOptimizer = new StackOptimizer(this);
    }

    public StackOptimizer stackOptimizer() {
        return this.stackOptimizer;
    }

    public Tree tree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public FlowGraph graph() {
        return this.graph;
    }

    public Label label() {
        return this.label;
    }

    public void visitChildren(TreeVisitor visitor) {
        if (this.tree != null) {
            this.tree.visit(visitor);
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitBlock(this);
    }

    void setBlockType(int blockType) {
        this.blockType = blockType;
        if (FlowGraph.DEBUG) {
            System.out.println("    Set block type " + this);
        }
    }

    int blockType() {
        return this.blockType;
    }

    public void setHeader(Block header) {
        this.header = header;
        if (FlowGraph.DEBUG) {
            System.out.println("    Set header " + this);
        }
    }

    public Block header() {
        return this.header;
    }

    public String toString() {
        String s = "<block " + this.label + " hdr=";
        s = this.header != null ? s + this.header.label() : s + "null";
        switch (this.blockType) {
            case 0: {
                break;
            }
            case 1: {
                s = s + " irred";
                break;
            }
            case 2: {
                s = s + " red";
            }
        }
        if (this == this.graph.source()) {
            return s + " source>";
        }
        if (this == this.graph.init()) {
            return s + " init>";
        }
        if (this == this.graph.sink()) {
            return s + " sink>";
        }
        return s + ">";
    }

    Collection domChildren() {
        return this.domChildren;
    }

    Block domParent() {
        return this.domParent;
    }

    void setDomParent(Block block) {
        if (this.domParent != null) {
            this.domParent.domChildren.remove(this);
        }
        this.domParent = block;
        if (this.domParent != null) {
            this.domParent.domChildren.add(this);
        }
    }

    public boolean dominates(Block block) {
        for (Block p = block; p != null; p = p.domParent()) {
            if (p != this) continue;
            return true;
        }
        return false;
    }

    Collection pdomChildren() {
        return this.pdomChildren;
    }

    Block pdomParent() {
        return this.pdomParent;
    }

    void setPdomParent(Block block) {
        if (this.pdomParent != null) {
            this.pdomParent.pdomChildren.remove(this);
        }
        this.pdomParent = block;
        if (this.pdomParent != null) {
            this.pdomParent.pdomChildren.add(this);
        }
    }

    public boolean postdominates(Block block) {
        for (Block p = block; p != null; p = p.pdomParent()) {
            if (p != this) continue;
            return true;
        }
        return false;
    }

    Collection domFrontier() {
        Assert.isTrue(this.domFrontier != null);
        return this.domFrontier;
    }

    Collection pdomFrontier() {
        Assert.isTrue(this.pdomFrontier != null);
        return this.pdomFrontier;
    }
}

