/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.benchmark;

import EDU.purdue.cs.bloat.benchmark.BenchmarkSecurityManager;

public class Benchmark {
    public static native void init(Class var0);

    public static native void run(Class var0, String[] var1);

    public static native void setMode(int var0);

    public static void main(String[] args) throws Exception {
        int mode = 0;
        int runs = 1;
        int eat = 0;
        if (args.length <= 1) {
            Benchmark.usage();
        }
        for (eat = 0; eat < args.length; ++eat) {
            if (args[eat].equals("-inst-cycle")) {
                mode = 3;
                continue;
            }
            if (args[eat].equals("-inst-load-stall")) {
                mode = 0;
                continue;
            }
            if (args[eat].equals("-dcache")) {
                mode = 1;
                continue;
            }
            if (args[eat].equals("-cycle-ic-miss-stall")) {
                mode = 2;
                continue;
            }
            if (args[eat].equals("-run")) {
                if (++eat >= args.length) {
                    Benchmark.usage();
                }
                if ((runs = Integer.parseInt(args[eat])) > 0) continue;
                Benchmark.usage();
                continue;
            }
            ++eat;
            break;
        }
        if (eat > args.length) {
            Benchmark.usage();
        }
        BenchmarkSecurityManager sec = new BenchmarkSecurityManager();
        System.setSecurityManager(sec);
        String mainClassName = args[eat - 1];
        String[] a = new String[args.length - eat];
        System.err.println("Running " + mainClassName + " in mode " + mode);
        Benchmark.setMode(mode);
        Class<?> mainClass = Class.forName(mainClassName);
        Benchmark.init(mainClass);
        for (int i = 0; i < runs; ++i) {
            try {
                System.arraycopy(args, eat, a, 0, a.length);
                Benchmark.run(mainClass, a);
                continue;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                sec.allowExit = true;
                System.exit(1);
            }
        }
        sec.allowExit = true;
    }

    private static void usage() {
        System.err.print("usage: java EDU.purdue.cs.bloat.Benchmark ");
        System.err.println("options class args...");
        System.err.println("where options are one of:");
        System.err.println("    -inst-load-stall");
        System.err.println("    -inst-cycle");
        System.err.println("    -cycle-ic-miss-stall");
        System.err.println("    -dcache");
        System.err.println("    -run n");
        System.exit(1);
    }

    static {
        System.loadLibrary("benchmark");
    }
}

