/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;

public abstract class BufferedIndexInput
extends IndexInput {
    static final int BUFFER_SIZE = 1024;
    private byte[] buffer;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len < 1024) {
            for (int i = 0; i < len; ++i) {
                b[i + offset] = this.readByte();
            }
        } else {
            long start = this.getFilePointer();
            this.seekInternal(start);
            this.readInternal(b, offset, len);
            this.bufferStart = start + (long)len;
            this.bufferPosition = 0;
            this.bufferLength = 0;
        }
    }

    private void refill() throws IOException {
        long start = this.bufferStart + (long)this.bufferPosition;
        long end = start + 1024L;
        if (end > this.length()) {
            end = this.length();
        }
        this.bufferLength = (int)(end - start);
        if (this.bufferLength <= 0) {
            throw new IOException("read past EOF");
        }
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        this.readInternal(this.buffer, 0, this.bufferLength);
        this.bufferStart = start;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public Object clone() {
        BufferedIndexInput clone = (BufferedIndexInput)super.clone();
        if (this.buffer != null) {
            clone.buffer = new byte[1024];
            System.arraycopy(this.buffer, 0, clone.buffer, 0, this.bufferLength);
        }
        return clone;
    }
}

