/*
 * Decompiled with CFR 0.152.
 */
package dacapo.lusearch;

import dacapo.Benchmark;
import dacapo.parser.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;

public class LusearchHarness
extends Benchmark {
    public int completed = 0;

    public LusearchHarness(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(String size) throws Exception {
        String[] args = this.config.getArgs(size);
        String usage = "Usage: java org.apache.lucene.demo.SearchFiles [-index dir] [-field f] [-repeat n] [-queries file] [-raw] [-norms field]";
        if (args.length > 0 && ("-h".equals(args[0]) || "-help".equals(args[0]))) {
            System.out.println(usage);
            System.exit(0);
        }
        String index = "index";
        String field = "contents";
        String queryBase = null;
        String outBase = null;
        int repeat = 0;
        boolean raw = false;
        String normsField = null;
        int threads = 1;
        for (int i = 0; i < args.length; ++i) {
            if ("-index".equals(args[i])) {
                index = this.fileInScratch(args[i + 1]);
                ++i;
                continue;
            }
            if ("-field".equals(args[i])) {
                field = args[i + 1];
                ++i;
                continue;
            }
            if ("-queries".equals(args[i])) {
                queryBase = this.fileInScratch(args[i + 1]);
                ++i;
                continue;
            }
            if ("-repeat".equals(args[i])) {
                repeat = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if ("-raw".equals(args[i])) {
                raw = true;
                continue;
            }
            if ("-norms".equals(args[i])) {
                normsField = args[i + 1];
                ++i;
                continue;
            }
            if ("-threads".equals(args[i])) {
                threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (!"-output".equals(args[i])) continue;
            outBase = args[++i];
        }
        this.completed = 0;
        for (int j = 0; j < threads; ++j) {
            new QueryThread("Query" + j, j, index, outBase, queryBase, field, normsField, repeat, raw, this).start();
        }
        LusearchHarness lusearchHarness = this;
        synchronized (lusearchHarness) {
            while (this.completed != threads) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    public class QueryThread
    extends Thread {
        Searcher searcher;
        BufferedReader in;
        PrintWriter out;
        IndexReader reader;
        String field;
        int repeat;
        boolean raw;
        LusearchHarness parent;

        public QueryThread(String str, int id, String index, String outBase, String queryBase, String field, String normsField, int repeat, boolean raw, LusearchHarness parent) {
            super(str);
            try {
                this.reader = IndexReader.open(index);
                this.field = field;
                if (normsField != null) {
                    this.reader = new OneNormsReader(this.reader, normsField);
                }
                this.searcher = new IndexSearcher(this.reader);
                String inName = queryBase + (id < 10 ? "0" : "") + id + ".txt";
                this.in = new BufferedReader(new FileReader(inName));
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(LusearchHarness.this.fileInScratch(outBase + id))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.repeat = repeat;
            this.raw = raw;
            this.parent = parent;
        }

        public void run() {
            try {
                this.runQuery();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runQuery() throws IOException {
            String line;
            StandardAnalyzer analyzer = new StandardAnalyzer();
            while ((line = this.in.readLine()) != null && line.length() != -1) {
                Query query = null;
                try {
                    query = QueryParser.parse(line, this.field, analyzer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.out.println("Searching for: " + query.toString(this.field));
                Hits hits = this.searcher.search(query);
                if (this.repeat > 0) {
                    for (int i = 0; i < this.repeat; ++i) {
                        hits = this.searcher.search(query);
                    }
                }
                this.out.println(hits.length() + " total matching documents");
                int HITS_PER_PAGE = 10;
                int start = 0;
                if (start >= hits.length()) continue;
                int end = Math.min(hits.length(), start + 10);
                for (int i = start; i < end; ++i) {
                    if (this.raw) {
                        this.out.println("doc=" + hits.id(i) + " score=" + hits.score(i));
                        continue;
                    }
                    Document doc = hits.doc(i);
                    String path = doc.get("path");
                    if (path != null) {
                        this.out.println(i + 1 + ". " + path);
                        String title = doc.get("title");
                        if (title == null) continue;
                        this.out.println("   Title: " + doc.get("title"));
                        continue;
                    }
                    this.out.println(i + 1 + ". " + "No path for this document");
                }
            }
            this.out.flush();
            this.out.close();
            this.reader.close();
            LusearchHarness lusearchHarness = this.parent;
            synchronized (lusearchHarness) {
                ++this.parent.completed;
                if (this.parent.completed % 4 == 0) {
                    System.out.println(this.parent.completed + " query batches completed");
                }
                this.parent.notify();
            }
        }
    }

    private static class OneNormsReader
    extends FilterIndexReader {
        private String field;

        public OneNormsReader(IndexReader in, String field) {
            super(in);
            this.field = field;
        }

        public byte[] norms(String field) throws IOException {
            return this.in.norms(this.field);
        }
    }
}

