/*
 * Decompiled with CFR 0.152.
 */
package dacapo.luindex;

import dacapo.Benchmark;
import dacapo.DacapoException;
import dacapo.parser.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.demo.FileDocument;
import org.apache.lucene.index.IndexWriter;

public class LuindexHarness
extends Benchmark {
    public LuindexHarness(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    public void cleanup() {
        if (!LuindexHarness.isPreserve()) {
            LuindexHarness.deleteTree(new File(this.scratch, "luindex"));
        }
    }

    public void preIteration(String size) {
        if (LuindexHarness.isPreserve() && this.getIteration() > 1) {
            LuindexHarness.deleteTree(new File(this.scratch, "index"));
        }
    }

    public void iterate(String size) throws DacapoException, IOException {
        if (LuindexHarness.isVerbose()) {
            System.out.println("luindex benchmark starting");
        }
        String[] args = this.config.getArgs(size);
        File INDEX_DIR = new File(this.scratch, "index");
        if (INDEX_DIR.exists()) {
            System.out.println("Cannot save index to '" + INDEX_DIR + "' directory, please delete it first");
            throw new DacapoException("Cannot write to index directory");
        }
        IndexWriter writer = new IndexWriter(INDEX_DIR, (Analyzer)new StandardAnalyzer(), true);
        for (int arg = 0; arg < args.length; ++arg) {
            File docDir = new File(this.scratch, args[arg]);
            if (!docDir.exists() || !docDir.canRead()) {
                System.out.println("Document directory '" + docDir.getAbsolutePath() + "' does not exist or is not readable, please check the path");
                throw new DacapoException("Cannot read from document directory");
            }
            this.indexDocs(writer, docDir);
            System.out.println("Optimizing...");
            writer.optimize();
        }
        writer.close();
    }

    public void postIteration(String size) {
        if (!LuindexHarness.isPreserve()) {
            LuindexHarness.deleteTree(new File(this.scratch, "index"));
        }
    }

    void indexDocs(IndexWriter writer, File file) throws IOException {
        block3: {
            int scratchP;
            block4: {
                scratchP = this.scratch.getPath().length() + 1;
                if (!file.canRead()) break block3;
                if (!file.isDirectory()) break block4;
                String[] files = file.list();
                if (files == null) break block3;
                this.sortArray((Comparable[])files);
                for (int i = 0; i < files.length; ++i) {
                    this.indexDocs(writer, new File(file, files[i]));
                }
                break block3;
            }
            System.out.println("adding " + file.getPath().substring(scratchP));
            try {
                writer.addDocument(FileDocument.Document(file));
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
        }
    }
}

