/*
 * Decompiled with CFR 0.152.
 */
package dacapo;

public class Callback {
    protected long timer;

    public void start(String benchmark) {
        this.start(benchmark, false);
    }

    public void startWarmup(String benchmark) {
        this.start(benchmark, true);
    }

    private void start(String benchmark, boolean warmup) {
        this.timer = System.currentTimeMillis();
        System.err.print("===== DaCapo " + benchmark + " starting ");
        System.err.println((warmup ? "warmup " : "") + "=====");
        System.err.flush();
    }

    public void stop() {
        this.timer = System.currentTimeMillis() - this.timer;
    }

    public void stopWarmup() {
        this.timer = System.currentTimeMillis() - this.timer;
    }

    public void complete(String benchmark, boolean valid) {
        this.complete(benchmark, valid, false);
    }

    public void completeWarmup(String benchmark, boolean valid) {
        this.complete(benchmark, valid, true);
    }

    private void complete(String benchmark, boolean valid, boolean warmup) {
        System.err.print("===== DaCapo " + benchmark);
        if (valid) {
            System.err.print(warmup ? " completed warmup " : " PASSED ");
            System.err.print("in " + this.timer + " msec ");
        } else {
            System.err.print(" FAILED " + (warmup ? "warmup " : ""));
        }
        System.err.println("=====");
        System.err.flush();
    }
}

