/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.Properties;
import java.util.Vector;
import org.python.core.Options;

class CommandLineOptions {
    public String filename = null;
    public boolean jar = false;
    public boolean interactive = true;
    public boolean notice = true;
    private boolean fixInteractive = false;
    public boolean help = false;
    public boolean version = false;
    public String[] argv;
    public Properties properties;
    public String command;
    public Vector warnoptions = new Vector();
    public String encoding;
    public String division;

    public CommandLineOptions() {
        this.properties = new Properties();
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public boolean parse(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string;
            String string2 = stringArray[n];
            if (string2.equals("--help")) {
                this.help = true;
                return false;
            }
            if (string2.equals("--version")) {
                this.version = true;
                return false;
            }
            if (string2.equals("-")) {
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                this.filename = "-";
                continue;
            }
            if (string2.equals("-i")) {
                this.fixInteractive = true;
                this.interactive = true;
                continue;
            }
            if (string2.equals("-jar")) {
                this.jar = true;
                if (this.fixInteractive) continue;
                this.interactive = false;
                continue;
            }
            if (string2.equals("-v")) {
                ++Options.verbose;
                continue;
            }
            if (string2.equals("-vv")) {
                Options.verbose += 2;
                continue;
            }
            if (string2.equals("-vvv")) {
                Options.verbose += 3;
                continue;
            }
            if (string2.equals("-S")) {
                Options.importSite = false;
                continue;
            }
            if (string2.equals("-c")) {
                this.command = stringArray[++n];
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                ++n;
                break;
            }
            if (string2.equals("-W")) {
                this.warnoptions.addElement(stringArray[++n]);
                continue;
            }
            if (string2.equals("-E")) {
                this.encoding = stringArray[++n];
                continue;
            }
            if (string2.startsWith("-D")) {
                string = null;
                String string3 = null;
                int n2 = string2.indexOf("=");
                if (n2 == -1) {
                    String string4 = stringArray[++n];
                    string = string2.substring(2, string2.length());
                    string3 = string4;
                } else {
                    string = string2.substring(2, n2);
                    string3 = string2.substring(n2 + 1, string2.length());
                }
                this.setProperty(string, string3);
                continue;
            }
            if (string2.startsWith("-Q")) {
                if (string2.length() > 2) {
                    this.division = string2.substring(2);
                    continue;
                }
                this.division = stringArray[++n];
                continue;
            }
            string = stringArray[n];
            if (string.startsWith("--")) {
                string = string.substring(2);
            } else if (string.startsWith("-")) {
                string = string.substring(1);
            }
            System.err.println("jython: illegal option -- " + string);
            return false;
        }
        this.notice = this.interactive;
        if (this.filename == null && n < stringArray.length && this.command == null) {
            this.filename = stringArray[n++];
            if (!this.fixInteractive) {
                this.interactive = false;
            }
            this.notice = false;
        }
        if (this.command != null) {
            this.notice = false;
        }
        int n3 = stringArray.length - n + 1;
        this.argv = new String[n3];
        this.argv[0] = this.filename != null ? this.filename : (this.command != null ? "-c" : "");
        int n4 = 1;
        while (n4 < n3) {
            this.argv[n4] = stringArray[n];
            ++n4;
            ++n;
        }
        return true;
    }
}

