/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.TimeFunctions;

public class time
implements ClassDictInit {
    public static PyString __doc__ = new PyString("This module provides various functions to manipulate time values.\n\nThere are two standard representations of time.  One is the number\nof seconds since the Epoch, in UTC (a.k.a. GMT).  It may be an integer\nor a floating point number (to represent fractions of seconds).\nThe Epoch is system-defined; on Unix, it is generally January 1st, 1970.\nThe actual value can be retrieved by calling gmtime(0).\n\nThe other representation is a tuple of 9 integers giving local time.\nThe tuple items are:\n  year (four digits, e.g. 1998)\n  month (1-12)\n  day (1-31)\n  hours (0-23)\n  minutes (0-59)\n  seconds (0-59)\n  weekday (0-6, Monday is 0)\n  Julian day (day in the year, 1-366)\n  DST (Daylight Savings Time) flag (-1, 0 or 1)\nIf the DST flag is 0, the time is given in the regular time zone;\nif it is 1, the time is given in the DST time zone;\nif it is -1, mktime() should guess based on the date and time.\n\nVariables:\n\ntimezone -- difference in seconds between UTC and local standard time\naltzone -- difference in  seconds between UTC and local DST time\ndaylight -- whether local time should reflect DST\ntzname -- tuple of (standard time zone name, DST time zone name)\n\nFunctions:\n\ntime() -- return current time in seconds since the Epoch as a float\nclock() -- return CPU time since process start as a float\nsleep() -- delay for a number of seconds given as a float\ngmtime() -- convert seconds since Epoch to UTC tuple\nlocaltime() -- convert seconds since Epoch to local time tuple\nasctime() -- convert time tuple to string\nctime() -- convert time in seconds to string\nmktime() -- convert local time tuple to seconds since Epoch\nstrftime() -- convert time tuple to string according to format specification\nstrptime() -- parse string to time tuple according to format specification\n");
    private static double __initialclock__ = 0.0;
    protected static Locale currentLocale = null;
    protected static DateFormatSymbols datesyms = new DateFormatSymbols();
    protected static String[] shortdays = null;
    protected static String[] shortmonths = null;
    public static int timezone;
    public static int altzone;
    public static int daylight;
    public static PyTuple tzname;
    public static final int accept2dyear = 0;

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("time", (PyObject)new TimeFunctions("time", 0, 0));
        pyObject.__setitem__("clock", (PyObject)new TimeFunctions("clock", 1, 0));
        TimeZone timeZone = TimeZone.getDefault();
        tzname = new PyTuple(new PyObject[]{new PyString(time.getDisplayName(timeZone, false, 0)), new PyString(time.getDisplayName(timeZone, true, 0))});
        daylight = timeZone.useDaylightTime() ? 1 : 0;
        timezone = -timeZone.getRawOffset() / 1000;
        altzone = timezone - time.getDSTSavings(timeZone) / 1000;
    }

    public static double time$() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double clock$() {
        if (__initialclock__ == 0.0) {
            __initialclock__ = time.time$();
        }
        return time.time$() - __initialclock__;
    }

    private static void throwValueError(String string) {
        throw new PyException(Py.ValueError, new PyString(string));
    }

    private static int item(PyTuple pyTuple, int n) {
        int n2 = ((PyInteger)pyTuple.__getitem__(n).__int__()).getValue();
        boolean bl = true;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                bl = 1 <= n2 && n2 <= 12;
                break;
            }
            case 2: {
                bl = 1 <= n2 && n2 <= 31;
                break;
            }
            case 3: {
                bl = 0 <= n2 && n2 <= 23;
                break;
            }
            case 4: {
                bl = 0 <= n2 && n2 <= 59;
                break;
            }
            case 5: {
                bl = 0 <= n2 && n2 <= 59;
                break;
            }
            case 6: {
                bl = 0 <= n2 && n2 <= 6;
                break;
            }
            case 7: {
                bl = 1 <= n2 && n2 < 367;
                break;
            }
            case 8: {
                boolean bl2 = bl = -1 <= n2 && n2 <= 1;
            }
        }
        if (!bl) {
            String string;
            switch (n) {
                case 1: {
                    string = "month out of range (1-12)";
                    break;
                }
                case 2: {
                    string = "day out of range (1-31)";
                    break;
                }
                case 3: {
                    string = "hour out of range (0-23)";
                    break;
                }
                case 4: {
                    string = "minute out of range (0-59)";
                    break;
                }
                case 5: {
                    string = "second out of range (0-59)";
                    break;
                }
                case 6: {
                    string = "day of week out of range (0-6)";
                    break;
                }
                case 7: {
                    string = "day of year out of range (1-366)";
                    break;
                }
                case 8: {
                    string = "daylight savings flag out of range (-1,0,1)";
                    break;
                }
                default: {
                    string = "ignore";
                }
            }
            time.throwValueError(string);
        }
        if (n == 1) {
            --n2;
        }
        return n2;
    }

    private static GregorianCalendar _tupletocal(PyTuple pyTuple) {
        return new GregorianCalendar(time.item(pyTuple, 0), time.item(pyTuple, 1), time.item(pyTuple, 2), time.item(pyTuple, 3), time.item(pyTuple, 4), time.item(pyTuple, 5));
    }

    public static double mktime(PyTuple pyTuple) {
        GregorianCalendar gregorianCalendar;
        try {
            gregorianCalendar = time._tupletocal(pyTuple);
        }
        catch (PyException pyException) {
            pyException.type = Py.OverflowError;
            throw pyException;
        }
        int n = time.item(pyTuple, 8);
        if (n == 0 || n == 1) {
            gregorianCalendar.set(16, n * time.getDSTSavings(gregorianCalendar.getTimeZone()));
        }
        return (double)gregorianCalendar.getTime().getTime() / 1000.0;
    }

    protected static PyTuple _timefields(double d, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.setTime(new Date((long)(d * 1000.0)));
        int n = gregorianCalendar.get(7) - 2;
        if (n < 0) {
            n += 7;
        }
        boolean bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
        return new PyTuple(new PyObject[]{new PyInteger(gregorianCalendar.get(1)), new PyInteger(gregorianCalendar.get(2) + 1), new PyInteger(gregorianCalendar.get(5)), new PyInteger(gregorianCalendar.get(10) + 12 * gregorianCalendar.get(9)), new PyInteger(gregorianCalendar.get(12)), new PyInteger(gregorianCalendar.get(13)), new PyInteger(n), new PyInteger(gregorianCalendar.get(6)), new PyInteger(bl ? 1 : 0)});
    }

    public static PyTuple localtime() {
        return time.localtime(time.time$());
    }

    public static PyTuple localtime(double d) {
        return time._timefields(d, TimeZone.getDefault());
    }

    public static PyTuple gmtime() {
        return time.gmtime(time.time$());
    }

    public static PyTuple gmtime(double d) {
        return time._timefields(d, TimeZone.getTimeZone("GMT"));
    }

    public static String ctime() {
        return time.ctime(time.time$());
    }

    public static String ctime(double d) {
        return time.asctime(time.localtime(d));
    }

    private static String _shortday(int n) {
        try {
            if (shortdays == null) {
                shortdays = new String[7];
                String[] stringArray = datesyms.getShortWeekdays();
                for (int i = 0; i < 6; ++i) {
                    time.shortdays[i] = stringArray[i + 2];
                }
                time.shortdays[6] = stringArray[1];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            time.throwValueError("day of week out of range (0-6)");
        }
        return shortdays[n];
    }

    private static String _shortmonth(int n) {
        try {
            if (shortmonths == null) {
                shortmonths = new String[12];
                String[] stringArray = datesyms.getShortMonths();
                for (int i = 0; i < 12; ++i) {
                    time.shortmonths[i] = stringArray[i];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            time.throwValueError("month out of range (1-12)");
        }
        return shortmonths[n];
    }

    private static String _padint(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = string.length();
        if (n2 <= n3) {
            return string;
        }
        if (n2 == n3 + 1) {
            return "0" + string;
        }
        if (n2 == n3 + 2) {
            return "00" + string;
        }
        char[] cArray = new char[n2 - n3];
        while (n2 > n3) {
            cArray[n2 - n3] = 48;
            --n2;
        }
        return new String(cArray) + string;
    }

    private static String _twodigit(int n) {
        return time._padint(n, 2);
    }

    private static String _truncyear(int n) {
        String string = time._padint(n, 4);
        return string.substring(string.length() - 2, string.length());
    }

    public static String asctime() {
        return time.asctime(time.localtime());
    }

    public static String asctime(PyTuple pyTuple) {
        time.checkLocale();
        int n = time.item(pyTuple, 6);
        int n2 = time.item(pyTuple, 1);
        return time._shortday(n) + " " + time._shortmonth(n2) + " " + time._twodigit(time.item(pyTuple, 2)) + " " + time._twodigit(time.item(pyTuple, 3)) + ":" + time._twodigit(time.item(pyTuple, 4)) + ":" + time._twodigit(time.item(pyTuple, 5)) + " " + time.item(pyTuple, 0);
    }

    public static void sleep(double d) {
        try {
            Thread.sleep((long)(d * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            throw new PyException(Py.KeyboardInterrupt, "interrupted sleep");
        }
    }

    public static String strftime(String string) {
        return time.strftime(string, time.localtime());
    }

    public static String strftime(String string, PyTuple pyTuple) {
        time.checkLocale();
        String string2 = "";
        int n = 0;
        GregorianCalendar gregorianCalendar = null;
        while (n < string.length()) {
            int n2 = string.indexOf("%", n);
            if (n2 < 0) {
                string2 = string2 + string.substring(n);
                break;
            }
            if (n2 == string.length() - 1) {
                string2 = string2 + "%";
                break;
            }
            string2 = string2 + string.substring(n, n2);
            switch (string.charAt(++n2)) {
                case 'a': {
                    int n3 = time.item(pyTuple, 6);
                    string2 = string2 + time._shortday(n3);
                    break;
                }
                case 'A': {
                    String[] stringArray = datesyms.getWeekdays();
                    int n3 = time.item(pyTuple, 6);
                    if (0 <= n3 && n3 < 6) {
                        string2 = string2 + stringArray[n3 + 2];
                        break;
                    }
                    if (n3 == 6) {
                        string2 = string2 + stringArray[1];
                        break;
                    }
                    time.throwValueError("day of week out of range (0 - 6)");
                    break;
                }
                case 'b': {
                    int n3 = time.item(pyTuple, 1);
                    string2 = string2 + time._shortmonth(n3);
                    break;
                }
                case 'B': {
                    String[] stringArray = datesyms.getMonths();
                    int n3 = time.item(pyTuple, 1);
                    string2 = string2 + stringArray[n3];
                    break;
                }
                case 'c': {
                    string2 = string2 + time.asctime(pyTuple);
                    break;
                }
                case 'd': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 2));
                    break;
                }
                case 'H': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 3));
                    break;
                }
                case 'I': {
                    int n3 = time.item(pyTuple, 3) % 12;
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'j': {
                    string2 = time._padint(time.item(pyTuple, 7), 3);
                    break;
                }
                case 'm': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 1) + 1);
                    break;
                }
                case 'M': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 4));
                    break;
                }
                case 'p': {
                    int n3 = time.item(pyTuple, 3);
                    String[] stringArray = datesyms.getAmPmStrings();
                    if (0 <= n3 && n3 < 12) {
                        string2 = string2 + stringArray[0];
                        break;
                    }
                    if (12 <= n3 && n3 < 24) {
                        string2 = string2 + stringArray[1];
                        break;
                    }
                    time.throwValueError("hour out of range (0-23)");
                    break;
                }
                case 'S': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 5));
                    break;
                }
                case 'U': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(1);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    if (gregorianCalendar.get(2) == 0 && n3 >= 52) {
                        n3 = 0;
                    }
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'w': {
                    int n3 = (time.item(pyTuple, 6) + 1) % 7;
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'W': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(2);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    if (gregorianCalendar.get(2) == 0 && n3 >= 52) {
                        n3 = 0;
                    }
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'x': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 1) + 1) + "/" + time._twodigit(time.item(pyTuple, 2)) + "/" + time._truncyear(time.item(pyTuple, 0));
                    break;
                }
                case 'X': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 3)) + ":" + time._twodigit(time.item(pyTuple, 4)) + ":" + time._twodigit(time.item(pyTuple, 5));
                    break;
                }
                case 'Y': {
                    string2 = string2 + time._padint(time.item(pyTuple, 0), 4);
                    break;
                }
                case 'y': {
                    string2 = string2 + time._truncyear(time.item(pyTuple, 0));
                    break;
                }
                case 'Z': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = time._tupletocal(pyTuple);
                    }
                    string2 = string2 + time.getDisplayName(gregorianCalendar.getTimeZone(), time.item(pyTuple, 8) > 0, 0);
                    break;
                }
                case '%': {
                    string2 = string2 + "%";
                    break;
                }
                default: {
                    string2 = string2 + "%" + string.charAt(n2);
                    ++n2;
                }
            }
            n = n2 + 1;
            ++n2;
        }
        return string2;
    }

    private static void checkLocale() {
        if (!Locale.getDefault().equals(currentLocale)) {
            currentLocale = Locale.getDefault();
            datesyms = new DateFormatSymbols(currentLocale);
            shortdays = null;
            shortmonths = null;
        }
    }

    private static String getDisplayName(TimeZone timeZone, boolean bl, int n) {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.2") >= 0) {
            try {
                Method method = timeZone.getClass().getMethod("getDisplayName", Boolean.TYPE, Integer.TYPE);
                return (String)method.invoke((Object)timeZone, new Boolean(bl), new Integer(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timeZone.getID();
    }

    private static int getDSTSavings(TimeZone timeZone) {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.2") >= 0) {
            try {
                Method method = timeZone.getClass().getMethod("getDSTSavings", null);
                return (Integer)method.invoke((Object)timeZone, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    static {
        altzone = -1;
        tzname = null;
    }
}

