/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.__builtin__;

public class struct {
    public static PyString error = new PyString("struct.error");
    public static String __doc__ = "Functions to convert between Python values and C structs.\nPython strings are used to hold the data representing the C\nstruct and also as format strings to describe the layout of\ndata in the C struct.\n\nThe optional first format char indicates byte ordering and\nalignment:\n @: native w/native alignment(default)\n =: native w/standard alignment\n <: little-endian, std. alignment\n >: big-endian, std. alignment\n !: network, std (same as >)\n\nThe remaining chars indicate types of args and must match\nexactly; these can be preceded by a decimal repeat count:\n x: pad byte (no data); c:char; b:signed byte; B:unsigned byte;\n h:short; H:unsigned short; i:int; I:unsigned int;\n l:long; L:unsigned long; f:float; d:double.\nSpecial cases (preceding decimal count indicates length):\n s:string (array of char); p: pascal string (w. count byte).\nWhitespace between formats is ignored.\n\nThe variable struct.error is an exception raised on errors.";
    private static FormatDef[] lilendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new LEShortFormatDef().init('h', 2, 0), new LEUnsignedShortFormatDef().init('H', 2, 0), new LEIntFormatDef().init('i', 4, 0), new LEUnsignedIntFormatDef().init('I', 4, 0), new LEIntFormatDef().init('l', 4, 0), new LEUnsignedIntFormatDef().init('L', 4, 0), new LELongFormatDef().init('q', 8, 8), new LEUnsignedLongFormatDef().init('Q', 8, 8), new LEFloatFormatDef().init('f', 4, 0), new LEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] bigendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 0), new BEUnsignedShortFormatDef().init('H', 2, 0), new BEIntFormatDef().init('i', 4, 0), new BEUnsignedIntFormatDef().init('I', 4, 0), new BEIntFormatDef().init('l', 4, 0), new BEUnsignedIntFormatDef().init('L', 4, 0), new BELongFormatDef().init('q', 8, 8), new BEUnsignedLongFormatDef().init('Q', 8, 8), new BEFloatFormatDef().init('f', 4, 0), new BEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] native_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 2), new BEUnsignedShortFormatDef().init('H', 2, 2), new BEIntFormatDef().init('i', 4, 4), new BEUnsignedIntFormatDef().init('I', 4, 4), new BEIntFormatDef().init('l', 4, 4), new BEUnsignedIntFormatDef().init('L', 4, 4), new BELongFormatDef().init('q', 8, 8), new BEUnsignedLongFormatDef().init('Q', 8, 8), new BEFloatFormatDef().init('f', 4, 4), new BEDoubleFormatDef().init('d', 8, 8)};
    static /* synthetic */ Class class$java$math$BigInteger;

    private static FormatDef[] whichtable(String string) {
        char c = string.charAt(0);
        switch (c) {
            case '<': {
                return lilendian_table;
            }
            case '!': 
            case '>': {
                return bigendian_table;
            }
            case '=': {
                return bigendian_table;
            }
        }
        return native_table;
    }

    private static FormatDef getentry(char c, FormatDef[] formatDefArray) {
        for (int i = 0; i < formatDefArray.length; ++i) {
            if (formatDefArray[i].name != c) continue;
            return formatDefArray[i];
        }
        throw struct.StructError("bad char in struct format");
    }

    private static int align(int n, FormatDef formatDef) {
        if (formatDef.alignment != 0) {
            n = (n + formatDef.alignment - 1) / formatDef.alignment * formatDef.alignment;
        }
        return n;
    }

    private static int calcsize(String string, FormatDef[] formatDefArray) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (i == 0 && (c == '@' || c == '<' || c == '>' || c == '=' || c == '!') || Character.isWhitespace(c)) continue;
            int n3 = 1;
            if (Character.isDigit(c)) {
                n3 = Character.digit(c, 10);
                while (++i < n2 && Character.isDigit(c = string.charAt(i))) {
                    int n4 = n3 * 10 + Character.digit(c, 10);
                    if (n4 / 10 != n3) {
                        throw struct.StructError("overflow in item count");
                    }
                    n3 = n4;
                }
                if (i >= n2) break;
            }
            FormatDef formatDef = struct.getentry(c, formatDefArray);
            int n5 = formatDef.size;
            n = struct.align(n, formatDef);
            int n6 = n3 * n5;
            if (n6 / n5 == n3 && (n += n6) >= 0) continue;
            throw struct.StructError("total struct size too long");
        }
        return n;
    }

    public static int calcsize(String string) {
        FormatDef[] formatDefArray = struct.whichtable(string);
        return struct.calcsize(string, formatDefArray);
    }

    public static String pack(PyObject[] pyObjectArray) {
        if (pyObjectArray.length < 1) {
            Py.TypeError("illegal argument type for built-in operation");
        }
        String string = pyObjectArray[0].toString();
        FormatDef[] formatDefArray = struct.whichtable(string);
        int n = struct.calcsize(string, formatDefArray);
        ByteStream byteStream = new ByteStream();
        int n2 = 1;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (i == 0 && (c == '@' || c == '<' || c == '>' || c == '=' || c == '!') || Character.isWhitespace(c)) continue;
            int n4 = 1;
            if (Character.isDigit(c)) {
                n4 = Character.digit(c, 10);
                while (++i < n3 && Character.isDigit(c = string.charAt(i))) {
                    n4 = n4 * 10 + Character.digit(c, 10);
                }
                if (i >= n3) break;
            }
            FormatDef formatDef = struct.getentry(c, formatDefArray);
            int n5 = struct.align(byteStream.size(), formatDef) - byteStream.size();
            while (n5-- > 0) {
                byteStream.writeByte(0);
            }
            n2 += formatDef.doPack(byteStream, n4, n2, pyObjectArray);
        }
        if (n2 < pyObjectArray.length) {
            throw struct.StructError("too many arguments for pack format");
        }
        return byteStream.toString();
    }

    public static PyTuple unpack(String string, String string2) {
        int n = string2.length();
        FormatDef[] formatDefArray = struct.whichtable(string);
        int n2 = struct.calcsize(string, formatDefArray);
        if (n2 != n) {
            throw struct.StructError("unpack str size does not match format");
        }
        PyList pyList = new PyList();
        ByteStream byteStream = new ByteStream(string2);
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (i == 0 && (c == '@' || c == '<' || c == '>' || c == '=' || c == '!') || Character.isWhitespace(c)) continue;
            int n4 = 1;
            if (Character.isDigit(c)) {
                n4 = Character.digit(c, 10);
                while (++i < n3 && Character.isDigit(c = string.charAt(i))) {
                    n4 = n4 * 10 + Character.digit(c, 10);
                }
                if (i > n3) break;
            }
            FormatDef formatDef = struct.getentry(c, formatDefArray);
            byteStream.skip(struct.align(byteStream.size(), formatDef) - byteStream.size());
            formatDef.doUnpack(byteStream, n4, pyList);
        }
        return __builtin__.tuple(pyList);
    }

    private static PyException StructError(String string) {
        return new PyException((PyObject)error, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class BEDoubleFormatDef
    extends FormatDef {
        BEDoubleFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            long l = Double.doubleToLongBits(this.get_float(pyObject));
            this.BEwriteInt(byteStream, (int)(l >>> 32));
            this.BEwriteInt(byteStream, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream byteStream) {
            long l = ((long)this.BEreadInt(byteStream) << 32) + ((long)this.BEreadInt(byteStream) & 0xFFFFFFFFL);
            return Py.newFloat(Double.longBitsToDouble(l));
        }
    }

    static class BEFloatFormatDef
    extends FormatDef {
        BEFloatFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            int n = Float.floatToIntBits((float)this.get_float(pyObject));
            this.BEwriteInt(byteStream, n);
        }

        Object unpack(ByteStream byteStream) {
            int n = this.BEreadInt(byteStream);
            return Py.newFloat(Float.intBitsToFloat(n));
        }
    }

    static class LEDoubleFormatDef
    extends FormatDef {
        LEDoubleFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            long l = Double.doubleToLongBits(this.get_float(pyObject));
            this.LEwriteInt(byteStream, (int)(l & 0xFFFFFFFFFFFFFFFFL));
            this.LEwriteInt(byteStream, (int)(l >>> 32));
        }

        Object unpack(ByteStream byteStream) {
            long l = ((long)this.LEreadInt(byteStream) & 0xFFFFFFFFL) + ((long)this.LEreadInt(byteStream) << 32);
            return Py.newFloat(Double.longBitsToDouble(l));
        }
    }

    static class LEFloatFormatDef
    extends FormatDef {
        LEFloatFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            int n = Float.floatToIntBits((float)this.get_float(pyObject));
            this.LEwriteInt(byteStream, n);
        }

        Object unpack(ByteStream byteStream) {
            int n = this.LEreadInt(byteStream);
            return Py.newFloat(Float.intBitsToFloat(n));
        }
    }

    static class BELongFormatDef
    extends FormatDef {
        BELongFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            long l = this.get_long(pyObject);
            int n = (int)((l & 0xFFFFFFFF00000000L) >> 32);
            int n2 = (int)(l & 0xFFFFFFFFL);
            this.BEwriteInt(byteStream, n);
            this.BEwriteInt(byteStream, n2);
        }

        Object unpack(ByteStream byteStream) {
            long l = (long)this.BEreadInt(byteStream) << 32 & 0xFFFFFFFF00000000L;
            long l2 = (long)this.BEreadInt(byteStream) & 0xFFFFFFFFL;
            long l3 = l | l2;
            return new PyLong(l3);
        }
    }

    static class LELongFormatDef
    extends FormatDef {
        LELongFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            long l = this.get_long(pyObject);
            int n = (int)((l & 0xFFFFFFFF00000000L) >> 32);
            int n2 = (int)(l & 0xFFFFFFFFL);
            this.LEwriteInt(byteStream, n2);
            this.LEwriteInt(byteStream, n);
        }

        Object unpack(ByteStream byteStream) {
            long l = (long)this.LEreadInt(byteStream) & 0xFFFFFFFFL;
            long l2 = (long)this.LEreadInt(byteStream) << 32 & 0xFFFFFFFF00000000L;
            long l3 = l2 | l;
            return new PyLong(l3);
        }
    }

    static class BEUnsignedLongFormatDef
    extends FormatDef {
        BEUnsignedLongFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            BigInteger bigInteger = this.get_ulong(pyObject);
            if (bigInteger.compareTo(BigInteger.valueOf(0L)) < 0) {
                throw struct.StructError("can't convert negative long to unsigned");
            }
            long l = bigInteger.longValue();
            int n = (int)((l & 0xFFFFFFFF00000000L) >> 32);
            int n2 = (int)(l & 0xFFFFFFFFL);
            this.BEwriteInt(byteStream, n);
            this.BEwriteInt(byteStream, n2);
        }

        Object unpack(ByteStream byteStream) {
            long l = (long)this.BEreadInt(byteStream) & 0xFFFFFFFFL;
            long l2 = (long)this.BEreadInt(byteStream) & 0xFFFFFFFFL;
            BigInteger bigInteger = BigInteger.valueOf(l);
            bigInteger = bigInteger.multiply(BigInteger.valueOf(0x100000000L));
            bigInteger = bigInteger.add(BigInteger.valueOf(l2));
            return new PyLong(bigInteger);
        }
    }

    static class LEUnsignedLongFormatDef
    extends FormatDef {
        LEUnsignedLongFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            BigInteger bigInteger = this.get_ulong(pyObject);
            if (bigInteger.compareTo(BigInteger.valueOf(0L)) < 0) {
                throw struct.StructError("can't convert negative long to unsigned");
            }
            long l = bigInteger.longValue();
            int n = (int)((l & 0xFFFFFFFF00000000L) >> 32);
            int n2 = (int)(l & 0xFFFFFFFFL);
            this.LEwriteInt(byteStream, n2);
            this.LEwriteInt(byteStream, n);
        }

        Object unpack(ByteStream byteStream) {
            long l = (long)this.LEreadInt(byteStream) & 0xFFFFFFFFL;
            long l2 = (long)this.LEreadInt(byteStream) & 0xFFFFFFFFL;
            BigInteger bigInteger = BigInteger.valueOf(l2);
            bigInteger = bigInteger.multiply(BigInteger.valueOf(0x100000000L));
            bigInteger = bigInteger.add(BigInteger.valueOf(l));
            return new PyLong(bigInteger);
        }
    }

    static class BEUnsignedIntFormatDef
    extends FormatDef {
        BEUnsignedIntFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            this.BEwriteInt(byteStream, (int)(this.get_long(pyObject) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream byteStream) {
            long l = this.BEreadInt(byteStream);
            if (l < 0L) {
                l += 0x100000000L;
            }
            return new PyLong(l);
        }
    }

    static class BEIntFormatDef
    extends FormatDef {
        BEIntFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            this.BEwriteInt(byteStream, this.get_int(pyObject));
        }

        Object unpack(ByteStream byteStream) {
            return Py.newInteger(this.BEreadInt(byteStream));
        }
    }

    static class LEUnsignedIntFormatDef
    extends FormatDef {
        LEUnsignedIntFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            this.LEwriteInt(byteStream, (int)(this.get_long(pyObject) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream byteStream) {
            long l = this.LEreadInt(byteStream);
            if (l < 0L) {
                l += 0x100000000L;
            }
            return new PyLong(l);
        }
    }

    static class LEIntFormatDef
    extends FormatDef {
        LEIntFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            this.LEwriteInt(byteStream, this.get_int(pyObject));
        }

        Object unpack(ByteStream byteStream) {
            int n = this.LEreadInt(byteStream);
            return Py.newInteger(n);
        }
    }

    static class BEUnsignedShortFormatDef
    extends BEShortFormatDef {
        BEUnsignedShortFormatDef() {
        }

        Object unpack(ByteStream byteStream) {
            int n = byteStream.readByte() << 8 | byteStream.readByte();
            return Py.newInteger(n);
        }
    }

    static class BEShortFormatDef
    extends FormatDef {
        BEShortFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            int n = this.get_int(pyObject);
            byteStream.writeByte(n >> 8 & 0xFF);
            byteStream.writeByte(n & 0xFF);
        }

        Object unpack(ByteStream byteStream) {
            int n = byteStream.readByte() << 8 | byteStream.readByte();
            if (n > Short.MAX_VALUE) {
                n -= 65536;
            }
            return Py.newInteger(n);
        }
    }

    static class LEUnsignedShortFormatDef
    extends LEShortFormatDef {
        LEUnsignedShortFormatDef() {
        }

        Object unpack(ByteStream byteStream) {
            int n = byteStream.readByte() | byteStream.readByte() << 8;
            return Py.newInteger(n);
        }
    }

    static class LEShortFormatDef
    extends FormatDef {
        LEShortFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            int n = this.get_int(pyObject);
            byteStream.writeByte(n & 0xFF);
            byteStream.writeByte(n >> 8 & 0xFF);
        }

        Object unpack(ByteStream byteStream) {
            int n = byteStream.readByte() | byteStream.readByte() << 8;
            if (n > Short.MAX_VALUE) {
                n -= 65536;
            }
            return Py.newInteger(n);
        }
    }

    static class UnsignedByteFormatDef
    extends ByteFormatDef {
        UnsignedByteFormatDef() {
        }

        Object unpack(ByteStream byteStream) {
            return Py.newInteger(byteStream.readByte());
        }
    }

    static class ByteFormatDef
    extends FormatDef {
        ByteFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            byteStream.writeByte(this.get_int(pyObject));
        }

        Object unpack(ByteStream byteStream) {
            int n = byteStream.readByte();
            if (n > 127) {
                n -= 256;
            }
            return Py.newInteger(n);
        }
    }

    static class CharFormatDef
    extends FormatDef {
        CharFormatDef() {
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
            if (!(pyObject instanceof PyString) || pyObject.__len__() != 1) {
                throw struct.StructError("char format require string of length 1");
            }
            byteStream.writeByte(pyObject.toString().charAt(0));
        }

        Object unpack(ByteStream byteStream) {
            return Py.newString((char)byteStream.readByte());
        }
    }

    static class PascalStringFormatDef
    extends StringFormatDef {
        PascalStringFormatDef() {
        }

        int doPack(ByteStream byteStream, int n, int n2, PyObject[] pyObjectArray) {
            PyObject pyObject = pyObjectArray[n2];
            if (!(pyObject instanceof PyString)) {
                throw struct.StructError("argument for 'p' must be a string");
            }
            byteStream.writeByte(Math.min(255, Math.min(pyObject.toString().length(), n - 1)));
            return super.doPack(byteStream, n - 1, n2, pyObjectArray);
        }

        void doUnpack(ByteStream byteStream, int n, PyList pyList) {
            int n2 = byteStream.readByte();
            if (n2 >= n) {
                n2 = n - 1;
            }
            super.doUnpack(byteStream, n2, pyList);
            byteStream.skip(Math.max(n - n2 - 1, 0));
        }
    }

    static class StringFormatDef
    extends FormatDef {
        StringFormatDef() {
        }

        int doPack(ByteStream byteStream, int n, int n2, PyObject[] pyObjectArray) {
            PyObject pyObject = pyObjectArray[n2];
            if (!(pyObject instanceof PyString)) {
                throw struct.StructError("argument for 's' must be a string");
            }
            String string = pyObject.toString();
            int n3 = string.length();
            byteStream.writeString(string, 0, Math.min(n, n3));
            if (n3 < n) {
                n -= n3;
                for (int i = 0; i < n; ++i) {
                    byteStream.writeByte(0);
                }
            }
            return 1;
        }

        void doUnpack(ByteStream byteStream, int n, PyList pyList) {
            pyList.append(Py.newString(byteStream.readString(n)));
        }
    }

    static class PadFormatDef
    extends FormatDef {
        PadFormatDef() {
        }

        int doPack(ByteStream byteStream, int n, int n2, PyObject[] pyObjectArray) {
            while (n-- > 0) {
                byteStream.writeByte(0);
            }
            return 0;
        }

        void doUnpack(ByteStream byteStream, int n, PyList pyList) {
            while (n-- > 0) {
                byteStream.readByte();
            }
        }
    }

    static class ByteStream {
        char[] data;
        int len;
        int pos;

        ByteStream() {
            this.data = new char[10];
            this.len = 0;
            this.pos = 0;
        }

        ByteStream(String string) {
            int n = string.length();
            this.data = new char[n];
            string.getChars(0, n, this.data, 0);
            this.len = n;
            this.pos = 0;
        }

        int readByte() {
            return this.data[this.pos++] & 0xFF;
        }

        void read(char[] cArray, int n, int n2) {
            System.arraycopy(this.data, this.pos, cArray, n, n2);
            this.pos += n2;
        }

        String readString(int n) {
            char[] cArray = new char[n];
            this.read(cArray, 0, n);
            return new String(cArray);
        }

        private void ensureCapacity(int n) {
            if (this.pos + n >= this.data.length) {
                char[] cArray = new char[(this.pos + n) * 2];
                System.arraycopy(this.data, 0, cArray, 0, this.pos);
                this.data = cArray;
            }
        }

        void writeByte(int n) {
            this.ensureCapacity(1);
            this.data[this.pos++] = (char)(n & 0xFF);
        }

        void write(char[] cArray, int n, int n2) {
            this.ensureCapacity(n2);
            System.arraycopy(cArray, n, this.data, this.pos, n2);
            this.pos += n2;
        }

        void writeString(String string, int n, int n2) {
            char[] cArray = new char[n2];
            string.getChars(n, n2, cArray, 0);
            this.write(cArray, 0, n2);
        }

        int skip(int n) {
            this.pos += n;
            return this.pos;
        }

        int size() {
            return this.pos;
        }

        public String toString() {
            return new String(this.data, 0, this.pos);
        }
    }

    static class FormatDef {
        char name;
        int size;
        int alignment;

        FormatDef() {
        }

        FormatDef init(char c, int n, int n2) {
            this.name = c;
            this.size = n;
            this.alignment = n2;
            return this;
        }

        void pack(ByteStream byteStream, PyObject pyObject) {
        }

        Object unpack(ByteStream byteStream) {
            return null;
        }

        int doPack(ByteStream byteStream, int n, int n2, PyObject[] pyObjectArray) {
            if (n2 + n > pyObjectArray.length) {
                throw struct.StructError("insufficient arguments to pack");
            }
            int n3 = n;
            while (n-- > 0) {
                this.pack(byteStream, pyObjectArray[n2++]);
            }
            return n3;
        }

        void doUnpack(ByteStream byteStream, int n, PyList pyList) {
            while (n-- > 0) {
                pyList.append(Py.java2py(this.unpack(byteStream)));
            }
        }

        int get_int(PyObject pyObject) {
            try {
                return ((PyInteger)pyObject.__int__()).getValue();
            }
            catch (PyException pyException) {
                throw struct.StructError("required argument is not an integer");
            }
        }

        long get_long(PyObject pyObject) {
            if (pyObject instanceof PyLong) {
                Object object = pyObject.__tojava__(Long.TYPE);
                if (object == Py.NoConversion) {
                    throw Py.OverflowError("long int too long to convert");
                }
                return (Long)object;
            }
            return this.get_int(pyObject);
        }

        BigInteger get_ulong(PyObject pyObject) {
            if (pyObject instanceof PyLong) {
                BigInteger bigInteger = (BigInteger)pyObject.__tojava__(class$java$math$BigInteger == null ? (class$java$math$BigInteger = struct.class$("java.math.BigInteger")) : class$java$math$BigInteger);
                if (bigInteger.compareTo(PyLong.maxULong) > 0) {
                    throw Py.OverflowError("unsigned long int too long to convert");
                }
                return bigInteger;
            }
            return BigInteger.valueOf(this.get_int(pyObject));
        }

        double get_float(PyObject pyObject) {
            if (!(pyObject instanceof PyFloat)) {
                throw struct.StructError("required argument is not an float");
            }
            return pyObject.__float__().getValue();
        }

        void BEwriteInt(ByteStream byteStream, int n) {
            byteStream.writeByte(n >>> 24 & 0xFF);
            byteStream.writeByte(n >>> 16 & 0xFF);
            byteStream.writeByte(n >>> 8 & 0xFF);
            byteStream.writeByte(n >>> 0 & 0xFF);
        }

        void LEwriteInt(ByteStream byteStream, int n) {
            byteStream.writeByte(n >>> 0 & 0xFF);
            byteStream.writeByte(n >>> 8 & 0xFF);
            byteStream.writeByte(n >>> 16 & 0xFF);
            byteStream.writeByte(n >>> 24 & 0xFF);
        }

        int BEreadInt(ByteStream byteStream) {
            int n = byteStream.readByte();
            int n2 = byteStream.readByte();
            int n3 = byteStream.readByte();
            int n4 = byteStream.readByte();
            return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
        }

        int LEreadInt(ByteStream byteStream) {
            int n = byteStream.readByte();
            int n2 = byteStream.readByte();
            int n3 = byteStream.readByte();
            int n4 = byteStream.readByte();
            return (n << 0) + (n2 << 8) + (n3 << 16) + (n4 << 24);
        }
    }
}

