/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.codecs;

public class _codecs {
    public static void register(PyObject pyObject) {
        codecs.register(pyObject);
    }

    public static PyTuple lookup(String string) {
        return codecs.lookup(string);
    }

    private static PyTuple codec_tuple(String string, int n) {
        return new PyTuple(new PyObject[]{Py.java2py(string), Py.newInteger(n)});
    }

    public static PyTuple utf_8_decode(String string) {
        return _codecs.utf_8_decode(string, null);
    }

    public static PyTuple utf_8_decode(String string, String string2) {
        int n = string.length();
        return _codecs.codec_tuple(codecs.PyUnicode_DecodeUTF8(string, string2), n);
    }

    public static PyTuple utf_8_encode(String string) {
        return _codecs.utf_8_encode(string, null);
    }

    public static PyTuple utf_8_encode(String string, String string2) {
        int n = string.length();
        return _codecs.codec_tuple(codecs.PyUnicode_EncodeUTF8(string, string2), n);
    }

    public static PyTuple charmap_decode(String string, String string2, PyObject pyObject) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                codecs.decoding_error("charmap", stringBuffer, string2, "ordinal not in range(255)");
                ++i;
                continue;
            }
            PyInteger pyInteger = Py.newInteger(c);
            PyObject pyObject2 = pyObject.__finditem__(pyInteger);
            if (pyObject2 == null) {
                stringBuffer.append(c);
                continue;
            }
            if (pyObject2 instanceof PyInteger) {
                int n2 = ((PyInteger)pyObject2).getValue();
                if (n2 < 0 || n2 > 65535) {
                    throw Py.TypeError("character mapping must be in range(65535)");
                }
                stringBuffer.append((char)n2);
                continue;
            }
            if (pyObject2 == Py.None) {
                codecs.decoding_error("charmap", stringBuffer, string2, "character maps to <undefined>");
                continue;
            }
            if (pyObject2 instanceof PyString) {
                stringBuffer.append(pyObject2.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return _codecs.codec_tuple(stringBuffer.toString(), n);
    }

    public static PyTuple charmap_encode(String string, String string2, PyObject pyObject) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            PyInteger pyInteger = Py.newInteger(c);
            PyObject pyObject2 = pyObject.__finditem__(pyInteger);
            if (pyObject2 == null) {
                if (c < '\u0100') {
                    stringBuffer.append(c);
                    continue;
                }
                codecs.encoding_error("charmap", stringBuffer, string2, "missing character mapping");
                continue;
            }
            if (pyObject2 instanceof PyInteger) {
                int n2 = ((PyInteger)pyObject2).getValue();
                if (n2 < 0 || n2 > 255) {
                    throw Py.TypeError("character mapping must be in range(256)");
                }
                stringBuffer.append((char)n2);
                continue;
            }
            if (pyObject2 == Py.None) {
                codecs.encoding_error("charmap", stringBuffer, string2, "character maps to <undefined>");
                continue;
            }
            if (pyObject2 instanceof PyString) {
                stringBuffer.append(pyObject2.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return _codecs.codec_tuple(stringBuffer.toString(), n);
    }

    public static PyTuple ascii_decode(String string) {
        return _codecs.ascii_decode(string, null);
    }

    public static PyTuple ascii_decode(String string, String string2) {
        int n = string.length();
        return _codecs.codec_tuple(codecs.PyUnicode_DecodeASCII(string, n, string2), n);
    }

    public static PyTuple ascii_encode(String string) {
        return _codecs.ascii_encode(string, null);
    }

    public static PyTuple ascii_encode(String string, String string2) {
        int n = string.length();
        return _codecs.codec_tuple(codecs.PyUnicode_EncodeASCII(string, n, string2), n);
    }

    public static PyTuple latin_1_decode(String string) {
        return _codecs.latin_1_decode(string, null);
    }

    public static PyTuple latin_1_decode(String string, String string2) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0100') {
                stringBuffer.append(c);
                continue;
            }
            codecs.decoding_error("latin-1", stringBuffer, string2, "ordinal not in range(256)");
            ++i;
        }
        return _codecs.codec_tuple(stringBuffer.toString(), n);
    }

    public static PyTuple latin_1_encode(String string) {
        return _codecs.latin_1_encode(string, null);
    }

    public static PyTuple latin_1_encode(String string, String string2) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0100') {
                codecs.encoding_error("latin-1", stringBuffer, string2, "ordinal not in range(256)");
                continue;
            }
            stringBuffer.append(c);
        }
        return _codecs.codec_tuple(stringBuffer.toString(), n);
    }

    public static PyTuple utf_16_encode(String string) {
        return _codecs.utf_16_encode(string, null);
    }

    public static PyTuple utf_16_encode(String string, String string2) {
        return _codecs.codec_tuple(_codecs.encode_UTF16(string, string2, 0), string.length());
    }

    public static PyTuple utf_16_encode(String string, String string2, int n) {
        return _codecs.codec_tuple(_codecs.encode_UTF16(string, string2, n), string.length());
    }

    public static PyTuple utf_16_le_encode(String string) {
        return _codecs.utf_16_le_encode(string, null);
    }

    public static PyTuple utf_16_le_encode(String string, String string2) {
        return _codecs.codec_tuple(_codecs.encode_UTF16(string, string2, -1), string.length());
    }

    public static PyTuple utf_16_be_encode(String string) {
        return _codecs.utf_16_be_encode(string, null);
    }

    public static PyTuple utf_16_be_encode(String string, String string2) {
        return _codecs.codec_tuple(_codecs.encode_UTF16(string, string2, 1), string.length());
    }

    private static String encode_UTF16(String string, String string2, int n) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer((n2 + (n == 0 ? 1 : 0)) * 2);
        if (n == 0) {
            stringBuffer.append('\u00fe');
            stringBuffer.append('\u00ff');
        }
        if (n == 0 || n == 1) {
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                stringBuffer.append((char)(c >>> 8 & 0xFF));
                stringBuffer.append((char)(c & 0xFF));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                stringBuffer.append((char)(c & 0xFF));
                stringBuffer.append((char)(c >>> 8 & 0xFF));
            }
        }
        return stringBuffer.toString();
    }

    public static PyTuple utf_16_decode(String string) {
        return _codecs.utf_16_decode(string, null);
    }

    public static PyTuple utf_16_decode(String string, String string2) {
        int[] nArray = new int[]{0};
        return _codecs.codec_tuple(_codecs.decode_UTF16(string, string2, nArray), string.length());
    }

    public static PyTuple utf_16_decode(String string, String string2, int n) {
        int[] nArray = new int[]{n};
        return _codecs.codec_tuple(_codecs.decode_UTF16(string, string2, nArray), string.length());
    }

    public static PyTuple utf_16_le_decode(String string) {
        return _codecs.utf_16_le_decode(string, null);
    }

    public static PyTuple utf_16_le_decode(String string, String string2) {
        int[] nArray = new int[]{-1};
        return _codecs.codec_tuple(_codecs.decode_UTF16(string, string2, nArray), string.length());
    }

    public static PyTuple utf_16_be_decode(String string) {
        return _codecs.utf_16_be_decode(string, null);
    }

    public static PyTuple utf_16_be_decode(String string, String string2) {
        int[] nArray = new int[]{1};
        return _codecs.codec_tuple(_codecs.decode_UTF16(string, string2, nArray), string.length());
    }

    public static PyTuple utf_16_ex_decode(String string) {
        return _codecs.utf_16_ex_decode(string, null);
    }

    public static PyTuple utf_16_ex_decode(String string, String string2) {
        return _codecs.utf_16_ex_decode(string, string2, 0);
    }

    public static PyTuple utf_16_ex_decode(String string, String string2, int n) {
        int[] nArray = new int[]{0};
        String string3 = _codecs.decode_UTF16(string, string2, nArray);
        return new PyTuple(new PyObject[]{Py.newString(string3), Py.newInteger(string.length()), Py.newInteger(nArray[0])});
    }

    private static String decode_UTF16(String string, String string2, int[] nArray) {
        int n;
        int n2 = 0;
        if (nArray != null) {
            n2 = nArray[0];
        }
        if ((n = string.length()) % 2 != 0) {
            codecs.decoding_error("UTF16", null, string2, "truncated data");
        }
        StringBuffer stringBuffer = new StringBuffer(n / 2);
        for (int i = 0; i < n; i += 2) {
            char c = string.charAt(i);
            char c2 = string.charAt(i + 1);
            if (c == '\u00fe' && c2 == '\u00ff') {
                n2 = 1;
                continue;
            }
            if (c == '\u00ff' && c2 == '\u00fe') {
                n2 = -1;
                continue;
            }
            char c3 = n2 == -1 ? (char)(c2 << 8 | c) : (char)(c << 8 | c2);
            if (c3 < '\ud800' || c3 > '\udfff') {
                stringBuffer.append(c3);
                continue;
            }
            if (i == n - 1) {
                codecs.decoding_error("UTF-16", stringBuffer, string2, "unexpected end of data");
                continue;
            }
            if ('\udc00' <= (c3 = string.charAt(++i)) && c3 <= '\udfff') {
                if ('\ud800' > (c3 = string.charAt(++i)) || c3 > '\udbff') continue;
                codecs.decoding_error("UTF-16", stringBuffer, string2, "code pairs are not supported");
                continue;
            }
            codecs.decoding_error("UTF-16", stringBuffer, string2, "illegal encoding");
        }
        if (nArray != null) {
            nArray[0] = n2;
        }
        return stringBuffer.toString();
    }

    public static PyTuple raw_unicode_escape_encode(String string) {
        return _codecs.raw_unicode_escape_encode(string, null);
    }

    public static PyTuple raw_unicode_escape_encode(String string, String string2) {
        return _codecs.codec_tuple(codecs.PyUnicode_EncodeRawUnicodeEscape(string, string2, false), string.length());
    }

    public static PyTuple raw_unicode_escape_decode(String string) {
        return _codecs.raw_unicode_escape_decode(string, null);
    }

    public static PyTuple raw_unicode_escape_decode(String string, String string2) {
        return _codecs.codec_tuple(codecs.PyUnicode_DecodeRawUnicodeEscape(string, string2), string.length());
    }

    public static PyTuple unicode_escape_encode(String string) {
        return _codecs.unicode_escape_encode(string, null);
    }

    public static PyTuple unicode_escape_encode(String string, String string2) {
        return _codecs.codec_tuple(PyString.encode_UnicodeEscape(string, false), string.length());
    }

    public static PyTuple unicode_escape_decode(String string) {
        return _codecs.unicode_escape_decode(string, null);
    }

    public static PyTuple unicode_escape_decode(String string, String string2) {
        int n = string.length();
        return _codecs.codec_tuple(PyString.decode_UnicodeEscape(string, 0, n, string2, true), n);
    }

    public static PyTuple unicode_internal_encode(String string) {
        return _codecs.unicode_internal_encode(string, null);
    }

    public static PyTuple unicode_internal_encode(String string, String string2) {
        return _codecs.codec_tuple(string, string.length());
    }

    public static PyTuple unicode_internal_decode(String string) {
        return _codecs.unicode_internal_decode(string, null);
    }

    public static PyTuple unicode_internal_decode(String string, String string2) {
        return _codecs.codec_tuple(string, string.length());
    }
}

