/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.MatchObject;
import org.python.modules.re;

public class RegexObject
extends PyObject {
    private static Perl5Compiler compiler = new Perl5Compiler();
    public String pattern;
    public int flags;
    public PyDictionary groupindex;
    private Pattern code;

    private static synchronized Pattern compile(String string, int n) {
        try {
            return compiler.compile(string, n);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw re.ReError(malformedPatternException.getMessage());
        }
    }

    private static synchronized Perl5Matcher getMatcher() {
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        return perl5Matcher;
    }

    public RegexObject(String string, int n) {
        this.pattern = string;
        this.flags = n;
        this.groupindex = new PyDictionary();
        this.code = RegexObject.compile(this.fixPattern(string), n);
    }

    public MatchObject match(String string) {
        MatchResult matchResult = this.doMatch(string);
        if (matchResult == null) {
            return null;
        }
        return new MatchObject(this, string, 0, string.length(), matchResult);
    }

    public MatchObject match(String string, int n) {
        return this.match(string, n, string.length());
    }

    public MatchObject match(String string, int n, int n2) {
        MatchResult matchResult;
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n2 < n) {
            n2 = n;
        }
        if ((matchResult = this.doMatch(new PatternMatcherInput(string, n, n2 - n))) == null) {
            return null;
        }
        return new MatchObject(this, string, n, n2, matchResult);
    }

    private MatchResult doMatch(Object object) {
        Perl5Matcher perl5Matcher = RegexObject.getMatcher();
        if (object instanceof String ? !perl5Matcher.matchesPrefix((String)object, this.code) : !perl5Matcher.matchesPrefix((PatternMatcherInput)object, this.code)) {
            return null;
        }
        return perl5Matcher.getMatch();
    }

    public MatchObject search(String string) {
        MatchResult matchResult = this.doSearch(string);
        if (matchResult == null) {
            return null;
        }
        return new MatchObject(this, string, 0, string.length(), matchResult);
    }

    public MatchObject search(String string, int n) {
        return this.search(string, n, string.length());
    }

    public MatchObject search(String string, int n, int n2) {
        MatchResult matchResult;
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n2 < n) {
            n2 = n;
        }
        if ((matchResult = this.doSearch(new PatternMatcherInput(string, n, n2 - n))) == null) {
            return null;
        }
        return new MatchObject(this, string, n, n2, matchResult);
    }

    private MatchResult doSearch(Object object) {
        Perl5Matcher perl5Matcher = RegexObject.getMatcher();
        if (object instanceof String ? !perl5Matcher.contains((String)object, this.code) : !perl5Matcher.contains((PatternMatcherInput)object, this.code)) {
            return null;
        }
        return perl5Matcher.getMatch();
    }

    public PyString sub(PyObject pyObject, String string) {
        return this.sub(pyObject, string, 0);
    }

    public PyString sub(PyObject pyObject, String string, int n) {
        return (PyString)this.subn(pyObject, string, n).__getitem__(0);
    }

    public PyTuple subn(PyObject pyObject, String string) {
        return this.subn(pyObject, string, 0);
    }

    public PyTuple subn(PyObject pyObject, String string, int n) {
        String string2 = null;
        boolean bl = false;
        if (pyObject instanceof PyString) {
            string2 = pyObject.toString();
            boolean bl2 = bl = string2.indexOf(92) != -1;
        }
        if (n < 0) {
            throw re.ReError("negative substitution count");
        }
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Perl5Matcher perl5Matcher = RegexObject.getMatcher();
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        int n3 = 0;
        while (n2 < n && !patternMatcherInput.endOfInput() && perl5Matcher.contains(patternMatcherInput, this.code)) {
            ++n2;
            int n4 = patternMatcherInput.getMatchBeginOffset();
            if (n4 > n3) {
                stringBuffer.append(patternMatcherInput.substring(n3, n4));
            }
            if (string2 == null) {
                MatchObject matchObject = new MatchObject(this, string, n3, string.length(), perl5Matcher.getMatch());
                PyObject pyObject2 = pyObject.__call__(matchObject);
                stringBuffer.append(pyObject2.toString());
            } else if (bl) {
                stringBuffer.append(this.expandMatch(perl5Matcher.getMatch(), string2));
            } else {
                stringBuffer.append(string2);
            }
            n3 = patternMatcherInput.getMatchEndOffset();
        }
        if (n3 < patternMatcherInput.getEndOffset()) {
            stringBuffer.append(patternMatcherInput.substring(n3, patternMatcherInput.getEndOffset()));
        }
        return new PyTuple(new PyObject[]{new PyString(stringBuffer.toString()), new PyInteger(n2)});
    }

    public PyList split(String string) {
        return this.split(string, 0);
    }

    public PyList split(String string, int n) {
        if (n < 0) {
            throw re.ReError("maxsplit < 0");
        }
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        int n2 = 0;
        Perl5Matcher perl5Matcher = RegexObject.getMatcher();
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        int n3 = 0;
        PyList pyList = new PyList();
        while (n2 < n && !patternMatcherInput.endOfInput() && perl5Matcher.contains(patternMatcherInput, this.code)) {
            int n4;
            ++n2;
            int n5 = patternMatcherInput.getMatchBeginOffset();
            if (n5 == (n4 = patternMatcherInput.getMatchEndOffset())) continue;
            pyList.append(new PyString(patternMatcherInput.substring(n3, n5)));
            MatchResult matchResult = perl5Matcher.getMatch();
            int n6 = matchResult.groups();
            if (n6 > 1) {
                for (int i = 1; i < n6; ++i) {
                    String string2 = matchResult.group(i);
                    if (string2 == null) {
                        pyList.append(Py.None);
                        continue;
                    }
                    pyList.append(new PyString(string2));
                }
            }
            n3 = n4;
        }
        pyList.append(new PyString(patternMatcherInput.substring(n3, patternMatcherInput.getEndOffset())));
        return pyList;
    }

    private int getindex(PyString pyString) {
        PyInteger pyInteger = (PyInteger)this.groupindex.__finditem__(pyString);
        if (pyInteger == null) {
            try {
                pyInteger = (PyInteger)pyString.__int__();
            }
            catch (PyException pyException) {
                if (!this.isname(pyString.toString())) {
                    throw re.ReError("illegal character in group name");
                }
                throw Py.IndexError("group " + pyString.__repr__() + " is undefined");
            }
        }
        return pyInteger.getValue();
    }

    private boolean isdigit(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean isident(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_';
    }

    private boolean isname(String string) {
        int n = string.length();
        if (n <= 0 || !this.isident(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (this.isident(c) || this.isdigit(c)) continue;
            return false;
        }
        return true;
    }

    private String fixPattern(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n4) {
            if (cArray[n++] != '(' || n > 2 && cArray[n - 2] == '\\') continue;
            if (n < n4 && cArray[n] == '?') {
                if (++n < n4 && cArray[n] == 'P') {
                    String string2;
                    if (++n == n4) break;
                    char c = cArray[n++];
                    int n5 = n;
                    if (c == '<') {
                        while (n < n4 && cArray[n] != '>') {
                            ++n;
                        }
                        if (n == n4) {
                            throw re.ReError("unmatched <");
                        }
                        string2 = new String(cArray, n5, n - n5);
                        if (!this.isname(string2)) {
                            throw re.ReError("illegal character in group name");
                        }
                        this.groupindex.__setitem__(new PyString(string2), (PyObject)new PyInteger(n2));
                        stringBuffer.append(cArray, n3, n5 - 3 - n3);
                        n3 = ++n;
                        ++n2;
                        continue;
                    }
                    if (c == '=') {
                        while (n < n4 && cArray[n] != ')') {
                            c = cArray[n];
                            if (Character.isJavaIdentifierPart(c) && c != '$') {
                                ++n;
                                continue;
                            }
                            throw re.ReError("illegal character in symbol");
                        }
                        if (n == n4) {
                            throw re.ReError("?P= not closed");
                        }
                        if (!Character.isJavaIdentifierStart(cArray[n5])) {
                            throw re.ReError("illegal character starting symbol");
                        }
                        string2 = new String(cArray, n5, n - n5);
                        PyString pyString = new PyString(string2);
                        stringBuffer.append(cArray, n3, n5 - 4 - n3);
                        stringBuffer.append('\\');
                        stringBuffer.append(this.getindex(pyString));
                        n3 = ++n;
                        continue;
                    }
                    throw re.ReError("invalid ?P grouping");
                }
                if (cArray[n] == ':') continue;
                while (n < n4 && cArray[n] != ')') {
                    ++n;
                }
                continue;
            }
            ++n2;
        }
        if (n3 > 0) {
            stringBuffer.append(cArray, n3, n4 - n3);
            return stringBuffer.toString();
        }
        return string;
    }

    public String expandMatch(MatchResult matchResult, String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            block15: while (n < n3) {
                if (cArray[n++] != '\\') continue;
                char c = '\u0000';
                switch (cArray[n++]) {
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case 'E': 
                    case 'G': 
                    case 'L': 
                    case 'Q': 
                    case 'U': 
                    case 'l': 
                    case 'u': {
                        throw re.ReError("\\" + cArray[n - 1] + " is not allowed");
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'g': {
                        if (cArray[n++] != '<') {
                            throw re.ReError("missing < in symbolic reference");
                        }
                        int n4 = n;
                        while (n < n3 && cArray[n] != '>') {
                            ++n;
                        }
                        if (n == n3) {
                            throw re.ReError("unfinished symbolic reference");
                        }
                        stringBuffer.append(cArray, n2, n4 - 3 - n2);
                        PyString pyString = new PyString(new String(cArray, n4, ++n - 1 - n4));
                        String string2 = matchResult.group(this.getindex(pyString));
                        if (string2 == null) {
                            throw re.ReError("group not in match: " + pyString);
                        }
                        stringBuffer.append(string2);
                        n2 = n;
                        continue block15;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int n4 = n - 2;
                        int n5 = cArray[n - 1] - 48;
                        if (n < n3 && (c = cArray[n]) >= '0' && c <= '9') {
                            char c2;
                            if (++n < n3 && c <= '7' && (c2 = cArray[n]) >= '0' && c2 <= '7') {
                                n5 = n5 * 64 + (c - 48) * 8 + (c2 - 48);
                                stringBuffer.append(cArray, n2, n - 2 - n2);
                                stringBuffer.append((char)n5);
                                n2 = ++n;
                            }
                            n5 = n5 * 10 + (c - 48);
                        }
                        stringBuffer.append(cArray, n2, n4 - n2);
                        String string2 = matchResult.group(n5);
                        if (string2 == null) {
                            throw re.ReError("group not in match: " + n5);
                        }
                        stringBuffer.append(string2);
                        n2 = n;
                        continue block15;
                    }
                    default: {
                        continue block15;
                    }
                }
                stringBuffer.append(cArray, n2, n - 2 - n2);
                stringBuffer.append(c);
                n2 = n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw re.ReError("invalid expression");
        }
        if (n2 > 0) {
            stringBuffer.append(cArray, n2, n3 - n2);
            return stringBuffer.toString();
        }
        return string;
    }

    public PyList findall(String string) {
        Perl5Matcher perl5Matcher = RegexObject.getMatcher();
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        PyList pyList = new PyList();
        while (perl5Matcher.contains(patternMatcherInput, this.code)) {
            MatchResult matchResult = perl5Matcher.getMatch();
            int n = matchResult.groups();
            if (n == 1) {
                pyList.append(new PyString(matchResult.group(0)));
                continue;
            }
            if (n == 2) {
                pyList.append(new PyString(matchResult.group(1)));
                continue;
            }
            PyObject[] pyObjectArray = new PyString[n - 1];
            for (int i = 1; i < n; ++i) {
                pyObjectArray[i - 1] = new PyString(matchResult.group(i));
            }
            PyTuple pyTuple = new PyTuple(pyObjectArray);
            pyList.append(pyTuple);
        }
        return pyList;
    }
}

