/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyBuiltinFunctionWide;
import org.python.core.PyFileDerived;
import org.python.core.PyGetSetDescr;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;

public class PyFile
extends PyObject {
    public static final String exposed_name = "file";
    public static final Class exposed_base = class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = PyFile.class$("org.python.core.PyObject")) : class$org$python$core$PyObject;
    public String name;
    public String mode;
    public boolean softspace;
    public boolean closed;
    private FileWrapper file;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$org$python$core$PyObject;
    static /* synthetic */ Class class$org$python$core$PyFile;
    static /* synthetic */ Class class$java$lang$String;

    public static void typeSetup(PyObject pyObject, PyType.Newstyle newstyle) {
        pyObject.__setitem__("mode", (PyObject)new PyGetSetDescr("mode", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, "getMode", null));
        pyObject.__setitem__("name", (PyObject)new PyGetSetDescr("name", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, "getName", null));
        pyObject.__setitem__("closed", (PyObject)new PyGetSetDescr("closed", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, "getClosed", null));
        class Exposed___cmp__
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___cmp__(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___cmp__((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                int n = this.self.file___cmp__(pyObject);
                if (n == -2) {
                    throw Py.TypeError("file.__cmp__(x,y) requires y to be 'file', not a '" + pyObject.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                int n = pyFile.file___cmp__(pyObject2);
                if (n == -2) {
                    throw Py.TypeError("file.__cmp__(x,y) requires y to be 'file', not a '" + pyObject2.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }
        }
        pyObject.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___iter__
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___iter__(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___iter__((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.file___iter__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return pyFile.file___iter__();
            }
        }
        pyObject.__setitem__("__iter__", (PyObject)new PyMethodDescr("__iter__", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed___iter__(null, null)));
        class Exposed___iternext__
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___iternext__(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___iternext__((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.file___iternext__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return pyFile.file___iternext__();
            }
        }
        pyObject.__setitem__("__iternext__", (PyObject)new PyMethodDescr("__iternext__", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed___iternext__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___nonzero__(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___nonzero__((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(this.self.file___nonzero__());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return Py.newBoolean(pyFile.file___nonzero__());
            }
        }
        pyObject.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___repr__
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___repr__(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___repr__((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.file_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return new PyString(pyFile.file_toString());
            }
        }
        pyObject.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___str__(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___str__((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.file_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return new PyString(pyFile.file_toString());
            }
        }
        pyObject.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed___str__(null, null)));
        class Exposed_close
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_close(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_close((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                this.self.file_close();
                return Py.None;
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                pyFile.file_close();
                return Py.None;
            }
        }
        pyObject.__setitem__("close", (PyObject)new PyMethodDescr("close", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed_close(null, null)));
        class Exposed_flush
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_flush(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_flush((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                this.self.file_flush();
                return Py.None;
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                pyFile.file_flush();
                return Py.None;
            }
        }
        pyObject.__setitem__("flush", (PyObject)new PyMethodDescr("flush", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed_flush(null, null)));
        class Exposed_read
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_read(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_read((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                try {
                    return new PyString(this.self.file_read(pyObject.asInt(0)));
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                try {
                    return new PyString(pyFile.file_read(pyObject2.asInt(0)));
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject __call__() {
                return new PyString(this.self.file_read());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return new PyString(pyFile.file_read());
            }
        }
        pyObject.__setitem__("read", (PyObject)new PyMethodDescr("read", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 1, new Exposed_read(null, null)));
        class Exposed_readline
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_readline(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_readline((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                try {
                    return new PyString(this.self.file_readline(pyObject.asInt(0)));
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                try {
                    return new PyString(pyFile.file_readline(pyObject2.asInt(0)));
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject __call__() {
                return new PyString(this.self.file_readline());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return new PyString(pyFile.file_readline());
            }
        }
        pyObject.__setitem__("readline", (PyObject)new PyMethodDescr("readline", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 1, new Exposed_readline(null, null)));
        class Exposed_readlines
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_readlines(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_readlines((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                try {
                    return this.self.file_readlines(pyObject.asInt(0));
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                try {
                    return pyFile.file_readlines(pyObject2.asInt(0));
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject __call__() {
                return this.self.file_readlines();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return pyFile.file_readlines();
            }
        }
        pyObject.__setitem__("readlines", (PyObject)new PyMethodDescr("readlines", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 1, new Exposed_readlines(null, null)));
        class Exposed_seek
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_seek(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_seek((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                try {
                    this.self.file_seek(pyObject.asLong(0), pyObject2.asInt(1));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a long";
                            break;
                        }
                        case 1: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
                PyFile pyFile = (PyFile)pyObject;
                try {
                    pyFile.file_seek(pyObject2.asLong(0), pyObject3.asInt(1));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a long";
                            break;
                        }
                        case 1: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject __call__(PyObject pyObject) {
                try {
                    this.self.file_seek(pyObject.asLong(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a long";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                try {
                    pyFile.file_seek(pyObject2.asLong(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a long";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }
        }
        pyObject.__setitem__("seek", (PyObject)new PyMethodDescr("seek", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 1, 2, new Exposed_seek(null, null)));
        class Exposed_tell
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_tell(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_tell((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyLong(this.self.file_tell());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return new PyLong(pyFile.file_tell());
            }
        }
        pyObject.__setitem__("tell", (PyObject)new PyMethodDescr("tell", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed_tell(null, null)));
        class Exposed_next
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_next(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_next((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.file_next();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return pyFile.file_next();
            }
        }
        pyObject.__setitem__("next", (PyObject)new PyMethodDescr("next", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed_next(null, null)));
        class Exposed_truncate
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_truncate(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_truncate((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                try {
                    this.self.file_truncate(pyObject.asLong(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a long";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                try {
                    pyFile.file_truncate(pyObject2.asLong(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a long";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject __call__() {
                this.self.file_truncate();
                return Py.None;
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                pyFile.file_truncate();
                return Py.None;
            }
        }
        pyObject.__setitem__("truncate", (PyObject)new PyMethodDescr("truncate", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 1, new Exposed_truncate(null, null)));
        class Exposed_write
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_write(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_write((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                try {
                    this.self.file_write(pyObject.asString(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a string";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                try {
                    pyFile.file_write(pyObject2.asString(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected a string";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }
        }
        pyObject.__setitem__("write", (PyObject)new PyMethodDescr("write", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 1, 1, new Exposed_write(null, null)));
        class Exposed_writelines
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_writelines(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_writelines((PyFile)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                this.self.file_writelines(pyObject);
                return Py.None;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFile pyFile = (PyFile)pyObject;
                pyFile.file_writelines(pyObject2);
                return Py.None;
            }
        }
        pyObject.__setitem__("writelines", (PyObject)new PyMethodDescr("writelines", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 1, 1, new Exposed_writelines(null, null)));
        class Exposed_xreadlines
        extends PyBuiltinFunctionNarrow {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_xreadlines(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_xreadlines((PyFile)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.file_xreadlines();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFile pyFile = (PyFile)pyObject;
                return pyFile.file_xreadlines();
            }
        }
        pyObject.__setitem__("xreadlines", (PyObject)new PyMethodDescr("xreadlines", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, 0, 0, new Exposed_xreadlines(null, null)));
        class Exposed___init__
        extends PyBuiltinFunctionWide {
            private PyFile self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___init__(PyFile pyFile, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFile;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___init__((PyFile)pyObject, this.info);
            }

            public PyObject inst_call(PyObject pyObject, PyObject[] pyObjectArray) {
                return this.inst_call(pyObject, pyObjectArray, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] pyObjectArray) {
                return this.__call__(pyObjectArray, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
                this.self.file_init(pyObjectArray, stringArray);
                return Py.None;
            }

            public PyObject inst_call(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
                PyFile pyFile = (PyFile)pyObject;
                pyFile.file_init(pyObjectArray, stringArray);
                return Py.None;
            }
        }
        pyObject.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, -1, -1, new Exposed___init__(null, null)));
        pyObject.__setitem__("__new__", (PyObject)new PyNewWrapper(class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile, "__new__", -1, -1){

            public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
                PyFile pyFile;
                if (this.for_type == pyType) {
                    pyFile = null;
                    if (bl) {
                        if (pyObjectArray.length == 0) {
                            pyFile = new PyFile();
                            pyFile.file_init(pyObjectArray, stringArray);
                        } else if (pyObjectArray[0] instanceof PyString || pyObjectArray[0] instanceof PyJavaInstance && ((PyJavaInstance)pyObjectArray[0]).javaProxy == (class$java$lang$String == null ? (class$java$lang$String = PyFile.class$("java.lang.String")) : class$java$lang$String)) {
                            pyFile = new PyFile();
                            pyFile.file_init(pyObjectArray, stringArray);
                        } else {
                            PyJavaClass pyJavaClass = new PyJavaClass(class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = PyFile.class$("org.python.core.PyFile")) : class$org$python$core$PyFile);
                            pyFile = (PyFile)pyJavaClass.__call__(pyObjectArray, stringArray);
                        }
                    } else {
                        pyFile = new PyFile();
                    }
                } else {
                    pyFile = new PyFileDerived(pyType);
                }
                return pyFile;
            }
        });
    }

    private static InputStream _pb(InputStream inputStream, String string) {
        if (string.indexOf(98) < 0) {
            if (inputStream instanceof PushbackInputStream) {
                return inputStream;
            }
            return new PushbackInputStream(inputStream);
        }
        return inputStream;
    }

    final void file_init(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser(exposed_name, pyObjectArray, stringArray, new String[]{"name", "mode"}, 1);
        String string = argParser.getString(0, null);
        String string2 = argParser.getString(1, "r");
        int n = 0;
        FileWrapper fileWrapper = PyFile._setup(string, string2, n);
        fileWrapper.setMode(string2);
        this.name = string;
        this.mode = string2;
        this.softspace = false;
        this.closed = false;
        this.file = string2.indexOf(98) < 0 ? new TextWrapper(fileWrapper) : fileWrapper;
    }

    public PyFile() {
    }

    public PyFile(PyType pyType) {
        super(pyType);
    }

    public PyFile(FileWrapper fileWrapper, String string, String string2) {
        fileWrapper.setMode(string2);
        this.name = string;
        this.mode = string2;
        this.softspace = false;
        this.closed = false;
        this.file = string2.indexOf(98) < 0 ? new TextWrapper(fileWrapper) : fileWrapper;
    }

    public PyFile(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        this(new IOStreamWrapper(PyFile._pb(inputStream, string2), outputStream), string, string2);
    }

    public PyFile(InputStream inputStream, OutputStream outputStream, String string) {
        this(inputStream, outputStream, string, "r+");
    }

    public PyFile(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, "<???>", "r+");
    }

    public PyFile(InputStream inputStream, String string, String string2) {
        this(new InputStreamWrapper(PyFile._pb(inputStream, string2)), string, string2);
    }

    public PyFile(InputStream inputStream, String string) {
        this(inputStream, string, "r");
    }

    public PyFile(InputStream inputStream) {
        this(inputStream, "<???>", "r");
    }

    public PyFile(OutputStream outputStream, String string, String string2) {
        this(new OutputStreamWrapper(outputStream), string, string2);
    }

    public PyFile(OutputStream outputStream, String string) {
        this(outputStream, string, "w");
    }

    public PyFile(OutputStream outputStream) {
        this(outputStream, "<???>", "w");
    }

    public PyFile(Writer writer, String string, String string2) {
        this(new WriterWrapper(writer), string, string2);
    }

    public PyFile(Writer writer, String string) {
        this(writer, string, "w");
    }

    public PyFile(Writer writer) {
        this(writer, "<???>", "w");
    }

    public PyFile(RandomAccessFile randomAccessFile, String string, String string2) {
        this(new RFileWrapper(randomAccessFile), string, string2);
    }

    public PyFile(RandomAccessFile randomAccessFile, String string) {
        this(randomAccessFile, string, "r+");
    }

    public PyFile(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, "<???>", "r+");
    }

    public PyFile(String string, String string2, int n) {
        this(PyFile._setup(string, string2, n), string, string2);
    }

    public void __setattr__(String string, PyObject pyObject) {
        if (string != "softspace") {
            if (string == "mode" || string == "closed" || string == "name") {
                throw Py.TypeError("readonly attribute: " + string);
            }
            throw Py.AttributeError(string);
        }
        this.softspace = pyObject.__nonzero__();
    }

    public Object __tojava__(Class clazz) {
        Object object = null;
        try {
            object = this.file.__tojava__(clazz);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object == null) {
            object = super.__tojava__(clazz);
        }
        return object;
    }

    private static FileWrapper _setup(String string, String string2, int n) {
        int n2 = 32;
        int n3 = 32;
        int n4 = 32;
        int n5 = string2.length();
        for (int i = 0; i < n5; ++i) {
            if ("awrtb+".indexOf(string2.charAt(i)) >= 0) continue;
            throw Py.IOError("Unknown open mode:" + string2);
        }
        if (n5 > 0) {
            n2 = string2.charAt(0);
            if (n5 > 1) {
                n3 = string2.charAt(1);
                if (n5 > 2) {
                    n4 = string2.charAt(2);
                }
            }
        }
        String string3 = "r";
        if (n2 == 114) {
            string3 = n3 == 43 || n4 == 43 ? "rw" : "r";
        } else if (n2 == 119 || n2 == 97) {
            string3 = "rw";
        }
        try {
            Closeable closeable;
            File file = new File(string);
            if (n2 == 114 && !file.exists()) {
                throw new IOException("No such file or directory: " + string);
            }
            if (n2 == 119) {
                closeable = new FileOutputStream(file);
                closeable.close();
                closeable = null;
            }
            closeable = new RandomAccessFile(file, string3);
            RFileWrapper rFileWrapper = new RFileWrapper((RandomAccessFile)closeable);
            if (n2 == 97) {
                rFileWrapper.seek(0L, 2);
            }
            return rFileWrapper;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    final String file_read(int n) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            int n2;
            while (n != 0 && (n2 = (string = this.file.read(n)).length()) != 0) {
                stringBuffer.append(string);
                if (n <= 0 || (n -= n2) > 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return stringBuffer.toString();
    }

    public String read(int n) {
        return this.file_read(n);
    }

    final String file_read() {
        return this.file_read(-1);
    }

    public String read() {
        return this.file_read();
    }

    final String file_readline(int n) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < 0 || stringBuffer.length() < n) {
            int n2;
            try {
                n2 = this.file.read();
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
            if (n2 < 0) break;
            stringBuffer.append((char)n2);
            if ((char)n2 != '\n') continue;
            break;
        }
        return stringBuffer.toString();
    }

    public String readline(int n) {
        return this.file_readline(n);
    }

    public String readline() {
        return this.file_readline();
    }

    final String file_readline() {
        return this.file_readline(-1);
    }

    final PyObject file_readlines(int n) {
        String string;
        int n2;
        if (this.closed) {
            this.err_closed();
        }
        PyList pyList = new PyList();
        int n3 = 0;
        while ((n2 = (string = this.readline()).length()) != 0) {
            pyList.append(new PyString(string));
            if (n <= 0 || (n3 += n2) <= n) continue;
            break;
        }
        return pyList;
    }

    public PyObject readlines(int n) {
        return this.file_readlines(n);
    }

    final PyObject file_readlines() {
        return this.file_readlines(0);
    }

    public PyObject readlines() {
        return this.file_readlines();
    }

    public PyObject __iter__() {
        return this.file___iter__();
    }

    final PyObject file___iter__() {
        return this;
    }

    public PyObject __iternext__() {
        return this.file___iternext__();
    }

    final PyObject file___iternext__() {
        PyString pyString = new PyString(this.readline());
        if (pyString.__len__() == 0) {
            return null;
        }
        return pyString;
    }

    final PyObject file_next() {
        PyObject pyObject = this.__iternext__();
        if (pyObject == null) {
            throw Py.StopIteration("");
        }
        return pyObject;
    }

    public PyObject next() {
        return this.file_next();
    }

    final PyObject file_xreadlines() {
        return this;
    }

    public PyObject xreadlines() {
        return this.file_xreadlines();
    }

    final void file_write(String string) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.write(string);
            this.softspace = false;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void write(String string) {
        this.file_write(string);
    }

    final void file_writelines(PyObject pyObject) {
        PyObject pyObject2 = Py.iter(pyObject, "writelines() requires an iterable argument");
        PyObject pyObject3 = null;
        while ((pyObject3 = pyObject2.__iternext__()) != null) {
            if (!(pyObject3 instanceof PyString)) {
                throw Py.TypeError("writelines() argument must be a sequence of strings");
            }
            this.write(pyObject3.toString());
        }
    }

    public void writelines(PyObject pyObject) {
        this.file_writelines(pyObject);
    }

    final long file_tell() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            return this.file.tell();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public long tell() {
        return this.file_tell();
    }

    final void file_seek(long l, int n) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.seek(l, n);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void seek(long l, int n) {
        this.file_seek(l, n);
    }

    final void file_seek(long l) {
        this.seek(l, 0);
    }

    public void seek(long l) {
        this.file_seek(l);
    }

    final void file_flush() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.flush();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void flush() {
        this.file_flush();
    }

    final void file_close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        this.closed = true;
        this.file = new FileWrapper();
    }

    public void close() {
        this.file_close();
    }

    final void file_truncate() {
        try {
            this.file.truncate(this.file.tell());
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void truncate() {
        this.file_truncate();
    }

    final void file_truncate(long l) {
        try {
            this.file.truncate(l);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void truncate(long l) {
        this.file_truncate(l);
    }

    public PyObject fileno() {
        throw Py.IOError("fileno() is not supported in jpython");
    }

    final String file_toString() {
        StringBuffer stringBuffer = new StringBuffer("<");
        if (this.closed) {
            stringBuffer.append("closed ");
        } else {
            stringBuffer.append("open ");
        }
        stringBuffer.append("file '");
        stringBuffer.append(this.name);
        stringBuffer.append("', mode '");
        stringBuffer.append(this.mode);
        stringBuffer.append("' ");
        stringBuffer.append(Py.idstr(this));
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.file_toString();
    }

    final int file___cmp__(PyObject pyObject) {
        return super.__cmp__(pyObject);
    }

    final boolean file___nonzero__() {
        return super.__nonzero__();
    }

    private void err_closed() {
        throw Py.ValueError("I/O operation on closed file");
    }

    public String getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public boolean getClosed() {
        return this.closed;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TextWrapper
    extends FileWrapper {
        private FileWrapper file;
        private String sep;
        private boolean sep_is_nl;

        public TextWrapper(FileWrapper fileWrapper) {
            this.file = fileWrapper;
            this.sep = System.getProperty("line.separator");
            this.sep_is_nl = this.sep == "\n";
        }

        public String read(int n) throws IOException {
            int n2;
            String string = this.file.read(n);
            int n3 = string.indexOf(13);
            if (n3 < 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            int n5 = string.length();
            do {
                stringBuffer.append(string.substring(n4, n3));
                stringBuffer.append('\n');
                n4 = n3 + 1;
                if (n4 >= n5 || string.charAt(n4) != '\n') continue;
                ++n4;
            } while ((n3 = string.indexOf(13, n4)) >= 0);
            stringBuffer.append(string.substring(n4));
            if (string.endsWith("\r") && this.file.available() > 0 && (n2 = this.file.read()) != -1 && n2 != 10) {
                this.file.unread(n2);
            }
            return stringBuffer.toString();
        }

        public int read() throws IOException {
            int n = this.file.read();
            if (n != 13) {
                return n;
            }
            if (this.file.available() > 0 && (n = this.file.read()) != -1 && n != 10) {
                this.file.unread(n);
            }
            return 10;
        }

        public void write(String string) throws IOException {
            int n;
            if (!this.sep_is_nl && (n = string.indexOf(10)) >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                do {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(this.sep);
                } while ((n = string.indexOf(10, n2 = n + 1)) >= 0);
                stringBuffer.append(string.substring(n2));
                string = stringBuffer.toString();
            }
            this.file.write(string);
        }

        public long tell() throws IOException {
            return this.file.tell();
        }

        public void seek(long l, int n) throws IOException {
            this.file.seek(l, n);
        }

        public void flush() throws IOException {
            this.file.flush();
        }

        public void close() throws IOException {
            this.file.close();
        }

        public void truncate(long l) throws IOException {
            this.file.truncate(l);
        }

        public Object __tojava__(Class clazz) throws IOException {
            return this.file.__tojava__(clazz);
        }
    }

    private static class RFileWrapper
    extends FileWrapper {
        protected static final int defaultBufferSize = 4096;
        protected RandomAccessFile file;
        protected long filePosition;
        protected byte[] buffer;
        protected long bufferStart;
        protected long dataEnd;
        protected int dataSize;
        protected boolean endOfFile;
        boolean bufferModified = false;

        public RFileWrapper(RandomAccessFile randomAccessFile) {
            this(randomAccessFile, 8092);
        }

        public RFileWrapper(RandomAccessFile randomAccessFile, int n) {
            this.file = randomAccessFile;
            this.bufferStart = 0L;
            this.dataEnd = 0L;
            this.dataSize = 0;
            this.filePosition = 0L;
            this.buffer = new byte[n];
            this.endOfFile = false;
        }

        public String read(int n) throws IOException {
            byte[] byArray;
            if (n < 0 && (n = (int)(this.file.length() - this.filePosition)) < 0) {
                n = 0;
            }
            if ((n = this.readBytes(byArray = new byte[n], 0, n)) < 0) {
                n = 0;
            }
            return this.getString(byArray, 0, n);
        }

        private int readBytes(byte[] byArray, int n, int n2) throws IOException {
            if (this.endOfFile) {
                return -1;
            }
            int n3 = (int)(this.dataEnd - this.filePosition);
            if (n3 < 1) {
                this.seek(this.filePosition, 0);
                return this.readBytes(byArray, n, n2);
            }
            int n4 = n3 >= n2 ? n2 : n3;
            System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), byArray, n, n4);
            this.filePosition += (long)n4;
            if (n4 < n2) {
                int n5 = n2 - n4;
                if (n5 > this.buffer.length) {
                    this.file.seek(this.filePosition);
                    n5 = this.file.read(byArray, n + n4, n2 - n4);
                } else {
                    this.seek(this.filePosition, 0);
                    if (!this.endOfFile) {
                        n5 = n5 > this.dataSize ? this.dataSize : n5;
                        System.arraycopy(this.buffer, 0, byArray, n + n4, n5);
                    } else {
                        n5 = -1;
                    }
                }
                if (n5 > 0) {
                    this.filePosition += (long)n5;
                    return n4 + n5;
                }
            }
            return n4;
        }

        public int read() throws IOException {
            if (this.filePosition < this.dataEnd) {
                return this.buffer[(int)(this.filePosition++ - this.bufferStart)] & 0xFF;
            }
            if (this.endOfFile) {
                return -1;
            }
            this.seek(this.filePosition, 0);
            return this.read();
        }

        public int available() throws IOException {
            return 1;
        }

        public void unread(int n) throws IOException {
            --this.filePosition;
        }

        public void write(String string) throws IOException {
            byte[] byArray = this.getBytes(string);
            int n = byArray.length;
            if (n < this.buffer.length) {
                long l;
                int n2 = 0;
                int n3 = 0;
                if (this.filePosition >= this.bufferStart) {
                    n2 = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
                }
                if (n2 > 0) {
                    n3 = n2 > n ? n : n2;
                    System.arraycopy(byArray, 0, this.buffer, (int)(this.filePosition - this.bufferStart), n3);
                    this.bufferModified = true;
                    l = this.filePosition + (long)n3;
                    this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)n3;
                }
                if (n3 < n) {
                    this.seek(this.filePosition, 0);
                    System.arraycopy(byArray, n3, this.buffer, (int)(this.filePosition - this.bufferStart), n - n3);
                    this.bufferModified = true;
                    l = this.filePosition + (long)(n - n3);
                    this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)(n - n3);
                }
            } else {
                if (this.bufferModified) {
                    this.flush();
                    this.dataSize = 0;
                    this.bufferStart = this.dataEnd = (long)0;
                }
                this.file.write(byArray, 0, n);
                this.filePosition += (long)n;
            }
        }

        public long tell() throws IOException {
            return this.filePosition;
        }

        public void seek(long l, int n) throws IOException {
            if (n == 1) {
                l += this.filePosition;
            } else if (n == 2) {
                l += this.file.length();
            }
            if (l < 0L) {
                l = 0L;
            }
            if (l >= this.bufferStart && l < this.dataEnd) {
                this.filePosition = l;
                this.endOfFile = false;
                return;
            }
            if (this.bufferModified) {
                this.flush();
            }
            this.file.seek(l);
            this.bufferStart = this.filePosition = this.file.getFilePointer();
            this.dataSize = this.file.read(this.buffer);
            if (this.dataSize < 0) {
                this.dataSize = 0;
                this.endOfFile = true;
            } else {
                this.endOfFile = false;
            }
            this.dataEnd = this.bufferStart + (long)this.dataSize;
        }

        public void flush() throws IOException {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
            this.file.getFD().sync();
        }

        public void close() throws IOException {
            if (this.writing && this.bufferModified) {
                this.file.seek(this.bufferStart);
                this.file.write(this.buffer, 0, this.dataSize);
            }
            this.file.close();
        }

        public void truncate(long l) throws IOException {
            this.flush();
            try {
                Method method = this.file.getClass().getMethod("setLength", Long.TYPE);
                method.invoke((Object)this.file, new Long(l));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                super.truncate(l);
            }
            catch (SecurityException securityException) {
                super.truncate(l);
            }
            catch (IllegalAccessException illegalAccessException) {
                super.truncate(l);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof IOException) {
                    throw (IOException)invocationTargetException.getTargetException();
                }
                super.truncate(l);
            }
        }

        public Object __tojava__(Class clazz) throws IOException {
            if ((class$java$io$OutputStream == null ? (class$java$io$OutputStream = PyFile.class$("java.io.OutputStream")) : class$java$io$OutputStream).isAssignableFrom(clazz) && this.writing) {
                return new FileOutputStream(this.file.getFD());
            }
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = PyFile.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(clazz) && this.reading) {
                return new FileInputStream(this.file.getFD());
            }
            return super.__tojava__(clazz);
        }
    }

    private static class WriterWrapper
    extends FileWrapper {
        private Writer writer;

        public WriterWrapper(Writer writer) {
            this.writer = writer;
        }

        public void write(String string) throws IOException {
            this.writer.write(string);
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class IOStreamWrapper
    extends InputStreamWrapper {
        private OutputStream ostream;

        public IOStreamWrapper(InputStream inputStream, OutputStream outputStream) {
            super(inputStream);
            this.ostream = outputStream;
        }

        public void write(String string) throws IOException {
            this.ostream.write(this.getBytes(string));
        }

        public void flush() throws IOException {
            this.ostream.flush();
        }

        public void close() throws IOException {
            this.ostream.close();
            this.istream.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            if ((class$java$io$OutputStream == null ? (class$java$io$OutputStream = PyFile.class$("java.io.OutputStream")) : class$java$io$OutputStream).isAssignableFrom(clazz)) {
                return this.ostream;
            }
            return super.__tojava__(clazz);
        }
    }

    private static class OutputStreamWrapper
    extends FileWrapper {
        private OutputStream ostream;
        private static final int MAX_WRITE = 30000;

        public OutputStreamWrapper(OutputStream outputStream) {
            this.ostream = outputStream;
        }

        public void write(String string) throws IOException {
            int n;
            byte[] byArray = this.getBytes(string);
            int n2 = byArray.length;
            for (int i = 0; i < n2; i += n) {
                n = n2 - i;
                n = n > 30000 ? 30000 : n;
                this.ostream.write(byArray, i, n);
            }
        }

        public void flush() throws IOException {
            this.ostream.flush();
        }

        public void close() throws IOException {
            this.ostream.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            if ((class$java$io$OutputStream == null ? (class$java$io$OutputStream = PyFile.class$("java.io.OutputStream")) : class$java$io$OutputStream).isAssignableFrom(clazz)) {
                return this.ostream;
            }
            return null;
        }
    }

    private static class InputStreamWrapper
    extends FileWrapper {
        InputStream istream;

        public InputStreamWrapper(InputStream inputStream) {
            this.istream = inputStream;
        }

        public String read(int n) throws IOException {
            if (n == 0) {
                return "";
            }
            if (n < 0) {
                byte[] byArray = new byte[1024];
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 >= 0) {
                    stringBuffer.append(this.getString(byArray, 0, n2));
                    n2 = this.istream.read(byArray);
                }
                return stringBuffer.toString();
            }
            byte[] byArray = new byte[n];
            int n3 = this.istream.read(byArray);
            if (n3 < 0) {
                return "";
            }
            return new String(byArray, 0, 0, n3);
        }

        public int read() throws IOException {
            return this.istream.read();
        }

        public int available() throws IOException {
            return this.istream.available();
        }

        public void unread(int n) throws IOException {
            ((PushbackInputStream)this.istream).unread(n);
        }

        public void close() throws IOException {
            this.istream.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = PyFile.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(clazz)) {
                return this.istream;
            }
            return null;
        }
    }

    private static class FileWrapper {
        protected boolean reading;
        protected boolean writing;
        protected boolean binary;

        private FileWrapper() {
        }

        void setMode(String string) {
            this.reading = string.indexOf(114) >= 0;
            this.writing = string.indexOf(119) >= 0 || string.indexOf("+") >= 0 || string.indexOf(97) >= 0;
            this.binary = string.indexOf(98) >= 0;
        }

        public String read(int n) throws IOException {
            throw new IOException("file not open for reading");
        }

        public int read() throws IOException {
            throw new IOException("file not open for reading");
        }

        public int available() throws IOException {
            throw new IOException("file not open for reading");
        }

        public void unread(int n) throws IOException {
            throw new IOException("file doesn't support unread");
        }

        public void write(String string) throws IOException {
            throw new IOException("file not open for writing");
        }

        public long tell() throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void seek(long l, int n) throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void truncate(long l) throws IOException {
            throw new IOException("file doesn't support truncate");
        }

        public Object __tojava__(Class clazz) throws IOException {
            return null;
        }

        protected byte[] getBytes(String string) {
            if (this.binary) {
                byte[] byArray = new byte[string.length()];
                string.getBytes(0, string.length(), byArray, 0);
                return byArray;
            }
            return string.getBytes();
        }

        protected String getString(byte[] byArray, int n, int n2) {
            if (this.binary) {
                return new String(byArray, 0, n, n2);
            }
            return new String(byArray, n, n2);
        }
    }
}

