/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.python.core.AbstractArray;
import org.python.core.ByteSwapper;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;

public class PyArray
extends PySequence
implements Cloneable,
ClassDictInit {
    protected Object data;
    protected Class type;
    protected String typecode;
    protected ArrayDelegate delegate;
    static /* synthetic */ Class class$java$lang$Object;

    private PyArray() {
    }

    public PyArray(PyArray pyArray) {
        this.data = pyArray.delegate.copyArray();
        this.delegate = new ArrayDelegate(this);
        this.type = pyArray.type;
    }

    public PyArray(Class clazz, Object object) {
        this.type = clazz;
        this.data = object;
        this.delegate = new ArrayDelegate(this);
    }

    public PyArray(Class clazz, int n) {
        this(clazz, Array.newInstance(clazz, n));
    }

    public static PyArray zeros(int n, char c) {
        PyArray pyArray = PyArray.zeros(n, PyArray.char2class(c));
        pyArray.typecode = Character.toString(c);
        return pyArray;
    }

    public static PyArray zeros(int n, Class clazz) {
        PyArray pyArray = new PyArray(clazz, n);
        pyArray.typecode = clazz.getName();
        return pyArray;
    }

    public static PyArray array(PyObject pyObject, char c) {
        PyArray pyArray = PyArray.array(pyObject, PyArray.char2class(c));
        pyArray.typecode = Character.toString(c);
        return pyArray;
    }

    public static PyArray array(PyObject pyObject, Class clazz) {
        PyArray pyArray = new PyArray(clazz, 0);
        pyArray.typecode = clazz.getName();
        pyArray.extendInternal(pyObject);
        return pyArray;
    }

    public PyObject __add__(PyObject pyObject) {
        PyArray pyArray = null;
        if (!(pyObject instanceof PyArray)) {
            throw Py.TypeError("can only append another array to an array");
        }
        pyArray = (PyArray)pyObject;
        if (!pyArray.type.equals(this.type)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + pyArray.type);
        }
        PyArray pyArray2 = new PyArray(this);
        pyArray2.delegate.appendArray(pyArray.delegate.copyArray());
        return pyArray2;
    }

    public PyObject __findattr__(String string) {
        if ("typecode".equals(string)) {
            return new PyString(this.getTypecode());
        }
        return super.__findattr__(string);
    }

    public int __len__() {
        return this.delegate.getSize();
    }

    public PyString __repr__() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("array(").append(PyArray.class2char(this.type)).append(",[");
        for (int i = 0; i < this.__len__() - 1; ++i) {
            stringBuffer.append(this.pyget(i).__repr__().toString());
            stringBuffer.append(", ");
        }
        if (this.__len__() > 0) {
            stringBuffer.append(this.pyget(this.__len__() - 1).__repr__().toString());
        }
        stringBuffer.append("]) ");
        return new PyString(stringBuffer.toString());
    }

    public Object __tojava__(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = PyArray.class$("java.lang.Object")) : class$java$lang$Object) || clazz.isArray() && clazz.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (clazz.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public void append(PyObject pyObject) {
        int n = this.delegate.getSize();
        this.delegate.makeInsertSpace(n);
        try {
            this.set(n, pyObject);
        }
        catch (PyException pyException) {
            this.delegate.setSize(n);
            throw new PyException(pyException.type, pyException.value);
        }
    }

    public void byteswap() {
        if (this.getItemsize() == 0) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public static void classDictInit(PyObject pyObject) throws PyIgnoreMethodTag {
        PySequence.classDictInit(pyObject);
        pyObject.__setitem__("clone", null);
        pyObject.__setitem__("classDictInit", null);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class char2class(char c) throws PyIgnoreMethodTag {
        switch (c) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("typecode must be in [zcbhilfd]");
    }

    private static String class2char(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return "'z'";
        }
        if (clazz.equals(Character.TYPE)) {
            return "'c'";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "'b'";
        }
        if (clazz.equals(Short.TYPE)) {
            return "'h'";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "'i'";
        }
        if (clazz.equals(Long.TYPE)) {
            return "'l'";
        }
        if (clazz.equals(Float.TYPE)) {
            return "'f'";
        }
        if (clazz.equals(Double.TYPE)) {
            return "'d'";
        }
        return clazz.getName();
    }

    public PyObject count(PyObject pyObject) {
        int n = 0;
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!pyObject.equals(Py.java2py(Array.get(this.data, i)))) continue;
            ++n;
        }
        return new PyInteger(n);
    }

    protected void del(int n) {
        this.delegate.remove(n);
    }

    protected void delRange(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        if (n3 == 1) {
            this.delegate.remove(n, n2);
        } else {
            int n4 = PyArray.sliceLength(n, n2, n3);
            int n5 = n;
            for (int i = 0; i < n4; ++i) {
                this.delegate.remove(n5);
                n5 += n3;
            }
        }
    }

    public void extend(PyObject pyObject) {
        this.extendInternal(pyObject);
    }

    private void extendInternal(PyObject pyObject) {
        if (pyObject instanceof PyString) {
            this.fromstring(((PyString)pyObject).toString());
        } else if (pyObject instanceof PyArray) {
            PyArray pyArray = (PyArray)pyObject;
            if (!pyArray.type.equals(this.type)) {
                throw Py.TypeError("can only extend with an array of the same kind");
            }
            this.delegate.appendArray(pyArray.delegate.copyArray());
        } else {
            this.extendInternalIter(pyObject);
        }
    }

    private void extendInternalIter(PyObject pyObject) {
        PyObject pyObject2 = pyObject.__iter__();
        PyObject pyObject3 = null;
        if (pyObject.__findattr__("__len__") == null) {
            int n = 0;
            while ((pyObject3 = pyObject2.__iternext__()) != null) {
                this.append(pyObject3);
                ++n;
            }
        } else {
            int n = this.delegate.getSize();
            this.delegate.ensureCapacity(n + pyObject.__len__());
            int n2 = n;
            while ((pyObject3 = pyObject2.__iternext__()) != null) {
                this.set(n2, pyObject3);
                ++this.delegate.size;
                ++n2;
            }
        }
    }

    public void fromfile(PyObject pyObject, int n) {
        if (!(pyObject instanceof PyFile)) {
            throw Py.TypeError("arg1 must be open file");
        }
        PyFile pyFile = (PyFile)pyObject;
        if (pyFile.mode.indexOf("r") == -1) {
            throw Py.TypeError("file needs to be in read mode");
        }
        int n2 = n * this.getItemsize();
        String string = pyFile.read(n2).toString();
        this.fromstring(string);
        if (string.length() < n2) {
            int n3 = string.length() / this.getItemsize();
            throw Py.EOFError("not enough items in file. " + Integer.toString(n) + " requested, " + Integer.toString(n3) + " actually read");
        }
    }

    public void fromlist(PyObject pyObject) {
        if (!(pyObject instanceof PyList)) {
            throw Py.TypeError("expected list argument");
        }
        int n = this.delegate.getSize();
        try {
            this.extendInternalIter(pyObject);
        }
        catch (PyException pyException) {
            this.delegate.setSize(n);
            throw new PyException(pyException.type, pyException.value);
        }
    }

    private int fromStream(InputStream inputStream) throws IOException, EOFException {
        return this.fromStream(inputStream, inputStream.available() / this.getItemsize());
    }

    private int fromStream(InputStream inputStream, int n) throws IOException, EOFException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n3 = n2 = this.delegate.getSize();
        this.delegate.ensureCapacity(n3 + n);
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                int n4 = 0;
                while (n4 < n) {
                    Array.setBoolean(this.data, n3, dataInputStream.readBoolean());
                    ++this.delegate.size;
                    ++n4;
                    ++n3;
                }
            } else if (this.type == Byte.TYPE) {
                int n5 = 0;
                while (n5 < n) {
                    Array.setByte(this.data, n3, dataInputStream.readByte());
                    ++this.delegate.size;
                    ++n5;
                    ++n3;
                }
            } else if (this.type == Character.TYPE) {
                int n6 = 0;
                while (n6 < n) {
                    Array.setChar(this.data, n3, (char)dataInputStream.readByte());
                    ++this.delegate.size;
                    ++n6;
                    ++n3;
                }
            } else if (this.type == Integer.TYPE) {
                int n7 = 0;
                while (n7 < n) {
                    Array.setInt(this.data, n3, dataInputStream.readInt());
                    ++this.delegate.size;
                    ++n7;
                    ++n3;
                }
            } else if (this.type == Short.TYPE) {
                int n8 = 0;
                while (n8 < n) {
                    Array.setShort(this.data, n3, dataInputStream.readShort());
                    ++this.delegate.size;
                    ++n8;
                    ++n3;
                }
            } else if (this.type == Long.TYPE) {
                int n9 = 0;
                while (n9 < n) {
                    Array.setLong(this.data, n3, dataInputStream.readLong());
                    ++this.delegate.size;
                    ++n9;
                    ++n3;
                }
            } else if (this.type == Float.TYPE) {
                int n10 = 0;
                while (n10 < n) {
                    Array.setFloat(this.data, n3, dataInputStream.readFloat());
                    ++this.delegate.size;
                    ++n10;
                    ++n3;
                }
            } else if (this.type == Double.TYPE) {
                int n11 = 0;
                while (n11 < n) {
                    Array.setDouble(this.data, n3, dataInputStream.readDouble());
                    ++this.delegate.size;
                    ++n11;
                    ++n3;
                }
            }
        }
        dataInputStream.close();
        return n3 - n2;
    }

    public void fromstring(String string) {
        int n = this.getItemsize();
        int n2 = string.length();
        if (n2 % n != 0) {
            throw Py.ValueError("string length not a multiple of item size");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        int n3 = this.delegate.getSize();
        try {
            this.fromStream(byteArrayInputStream);
        }
        catch (EOFException eOFException) {
            throw Py.EOFError("not enough items in string");
        }
        catch (IOException iOException) {
            this.delegate.setSize(n3);
            throw Py.IOError(iOException);
        }
    }

    protected PyObject pyget(int n) {
        return Py.java2py(Array.get(this.data, n));
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                return 1;
            }
            if (this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE) {
                return 1;
            }
            if (this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE) {
                return 8;
            }
            if (this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Double.TYPE) {
                return 8;
            }
        }
        return 0;
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        int n4 = PyArray.sliceLength(n, n2, n3);
        PyArray pyArray = new PyArray(this.type, n4);
        if (n3 == 1) {
            System.arraycopy(this.data, n, pyArray.data, 0, n4);
            return pyArray;
        }
        int n5 = n;
        for (int i = 0; i < n4; ++i) {
            Array.set(pyArray.data, i, Array.get(this.data, n5));
            n5 += n3;
        }
        return pyArray;
    }

    public String getTypecode() throws PyIgnoreMethodTag {
        return this.typecode;
    }

    public PyObject index(PyObject pyObject) {
        int n = this.indexInternal(pyObject);
        if (n != -1) {
            return new PyInteger(n);
        }
        throw Py.ValueError("array.index(" + pyObject + "): " + pyObject + " not found in array");
    }

    private int indexInternal(PyObject pyObject) {
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!pyObject.equals(Py.java2py(Array.get(this.data, i)))) continue;
            return i;
        }
        return -1;
    }

    public void insert(int n, PyObject pyObject) {
        this.delegate.makeInsertSpace(n);
        Array.set(this.data, n, Py.tojava(pyObject, this.type));
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        n = n < 0 ? this.delegate.getSize() + n : n;
        PyObject pyObject = Py.java2py(Array.get(this.data, n));
        this.delegate.remove(n);
        return pyObject;
    }

    public void remove(PyObject pyObject) {
        int n = this.indexInternal(pyObject);
        if (n != -1) {
            this.delegate.remove(n);
            return;
        }
        throw Py.ValueError("array.remove(" + pyObject + "): " + pyObject + " not found in array");
    }

    protected PyObject repeat(int n) {
        Object object = this.delegate.copyArray();
        PyArray pyArray = new PyArray(this.type, 0);
        for (int i = 0; i < n; ++i) {
            pyArray.delegate.appendArray(object);
        }
        return pyArray;
    }

    public void reverse() {
        Object object = Array.newInstance(this.type, Array.getLength(this.data));
        int n = this.delegate.getSize() - 1;
        for (int i = 0; i <= n; ++i) {
            Array.set(object, n - i, Array.get(this.data, i));
        }
        this.data = object;
    }

    protected void set(int n, PyObject pyObject) {
        Object object;
        if (this.type == Byte.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < -128L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > 127L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Short.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < -32768L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > 32767L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Integer.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < Integer.MIN_VALUE) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > Integer.MAX_VALUE) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Long.TYPE) {
            Object object2;
            try {
                object2 = pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (object2 == Py.NoConversion) {
                throw Py.OverflowError("value out of range for long");
            }
        }
        if ((object = Py.tojava(pyObject, this.type)) == Py.NoConversion) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.set(this.data, n, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        if (this.type == Character.TYPE && pyObject instanceof PyString) {
            char[] cArray = null;
            if (n3 != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            cArray = pyObject.toString().toCharArray();
            int n4 = cArray.length - (n2 - n);
            if (n4 > 0) {
                this.delegate.makeInsertSpace(n, n4);
            } else if (n4 < 0) {
                this.delegate.remove(n, -n4 + n - 1);
            }
            this.delegate.replaceSubArray(cArray, n);
            return;
        }
        if (pyObject instanceof PyString && this.type == Byte.TYPE) {
            byte[] byArray = pyObject.toString().getBytes();
            if (byArray.length != n2 - n || n3 != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(byArray, 0, this.data, n, byArray.length);
            return;
        }
        if (!(pyObject instanceof PyArray)) return;
        PyArray pyArray = (PyArray)pyObject;
        int n5 = pyArray.delegate.getSize() - (n2 - n);
        Object object = pyArray.delegate.copyArray();
        if (n5 > 0) {
            this.delegate.makeInsertSpace(n, n5);
        } else if (n5 < 0) {
            this.delegate.remove(n, -n5 + n - 1);
        }
        try {
            this.delegate.replaceSubArray(object, n);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.TypeError("Slice typecode '" + pyArray.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
        }
    }

    public void tofile(PyObject pyObject) {
        if (!(pyObject instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile pyFile = (PyFile)pyObject;
        if (pyFile.mode.indexOf("w") == -1 && pyFile.mode.indexOf("a") == -1) {
            throw Py.TypeError("file needs to be in write or append mode");
        }
        String string = this.tostring();
        pyFile.write(string);
    }

    public PyObject tolist() {
        PyList pyList = new PyList();
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            pyList.append(Py.java2py(Array.get(this.data, i)));
        }
        return pyList;
    }

    private int toStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream;
        block8: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        dataOutputStream = new DataOutputStream(outputStream);
                                        if (!this.type.isPrimitive()) break block8;
                                        if (this.type != Boolean.TYPE) break block9;
                                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                                            dataOutputStream.writeBoolean(Array.getBoolean(this.data, i));
                                        }
                                        break block8;
                                    }
                                    if (this.type != Byte.TYPE) break block10;
                                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                                        dataOutputStream.writeByte(Array.getByte(this.data, i));
                                    }
                                    break block8;
                                }
                                if (this.type != Character.TYPE) break block11;
                                for (int i = 0; i < this.delegate.getSize(); ++i) {
                                    dataOutputStream.writeByte((byte)Array.getChar(this.data, i));
                                }
                                break block8;
                            }
                            if (this.type != Integer.TYPE) break block12;
                            for (int i = 0; i < this.delegate.getSize(); ++i) {
                                dataOutputStream.writeInt(Array.getInt(this.data, i));
                            }
                            break block8;
                        }
                        if (this.type != Short.TYPE) break block13;
                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                            dataOutputStream.writeShort(Array.getShort(this.data, i));
                        }
                        break block8;
                    }
                    if (this.type != Long.TYPE) break block14;
                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                        dataOutputStream.writeLong(Array.getLong(this.data, i));
                    }
                    break block8;
                }
                if (this.type != Float.TYPE) break block15;
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dataOutputStream.writeFloat(Array.getFloat(this.data, i));
                }
                break block8;
            }
            if (this.type != Double.TYPE) break block8;
            for (int i = 0; i < this.delegate.getSize(); ++i) {
                dataOutputStream.writeDouble(Array.getDouble(this.data, i));
            }
        }
        return dataOutputStream.size();
    }

    public String tostring() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ArrayDelegate
    extends AbstractArray {
        final PyArray pyArray;

        private ArrayDelegate(PyArray pyArray2) {
            super(pyArray2.data == null ? 0 : Array.getLength(pyArray2.data));
            this.pyArray = pyArray2;
        }

        protected Object getArray() {
            return this.pyArray.data;
        }

        protected void setArray(Object object) {
            this.pyArray.data = object;
        }

        protected void makeInsertSpace(int n) {
            super.makeInsertSpace(n, 1);
        }

        protected void makeInsertSpace(int n, int n2) {
            super.makeInsertSpace(n, n2);
        }

        public void remove(int n) {
            super.remove(n);
        }
    }
}

