/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.FixedFileWrapper;
import org.python.core.IdImpl;
import org.python.core.JavaCode;
import org.python.core.JavaFunc;
import org.python.core.Options;
import org.python.core.PyArray;
import org.python.core.PyClass;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFunctionTable;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMetaClass;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.StdoutWrapper;
import org.python.core.ThreadState;
import org.python.core.ThreadStateMapping;
import org.python.core.__builtin__;
import org.python.core.imp;
import org.python.core.parser;
import org.python.parser.ast.modType;

public final class Py {
    static boolean frozen;
    static String frozenPackage;
    private static final Object PRESENT;
    static Hashtable frozenModules;
    static boolean initialized;
    public static PyObject None;
    public static PyObject Ellipsis;
    public static PyObject NotImplemented;
    public static String[] NoKeywords;
    public static PyObject[] EmptyObjects;
    public static PyTuple EmptyTuple;
    public static PyInteger Zero;
    public static PyInteger One;
    public static PyString EmptyString;
    public static PyString Newline;
    public static PyString Space;
    public static Object NoConversion;
    public static PyObject OSError;
    public static PyObject NotImplementedError;
    public static PyObject EnvironmentError;
    public static PyObject OverflowError;
    public static PyObject RuntimeError;
    public static PyObject KeyboardInterrupt;
    public static PyObject FloatingPointError;
    public static PyObject SyntaxError;
    public static PyObject IndentationError;
    public static PyObject TabError;
    public static PyObject AttributeError;
    public static PyObject IOError;
    public static PyObject KeyError;
    public static PyObject AssertionError;
    public static PyObject TypeError;
    public static PyObject ReferenceError;
    public static PyObject SystemError;
    public static PyObject IndexError;
    public static PyObject ZeroDivisionError;
    public static PyObject NameError;
    public static PyObject UnboundLocalError;
    public static PyObject SystemExit;
    public static PyObject StopIteration;
    public static PyObject ImportError;
    public static PyObject ValueError;
    public static PyObject UnicodeError;
    public static PyObject EOFError;
    public static PyObject MemoryError;
    public static PyObject ArithmeticError;
    public static PyObject LookupError;
    public static PyObject StandardError;
    public static PyObject Exception;
    public static PyObject Warning;
    public static PyObject UserWarning;
    public static PyObject DeprecationWarning;
    public static PyObject SyntaxWarning;
    public static PyObject OverflowWarning;
    public static PyObject RuntimeWarning;
    private static PyObject warnings_mod;
    public static PyObject JavaError;
    private static PyInteger[] integerCache;
    public static PySystemState defaultSystemState;
    private static boolean secEnv;
    private static boolean propertiesInitialized;
    private static ThreadStateMapping threadStateMapping;
    public static StdoutWrapper stderr;
    static StdoutWrapper stdout;
    private static PyString[] letters;
    private static Class[] pyClassCtrSignature;
    private static final PyType CLASS_TYPE;
    private static int nameindex;
    private static IdImpl idimpl;
    public static final int ERROR = -1;
    public static final int WARNING = 0;
    public static final int MESSAGE = 1;
    public static final int COMMENT = 2;
    public static final int DEBUG = 3;
    static /* synthetic */ Class array$Lorg$python$core$PyObject;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$java$lang$OutOfMemoryError;
    static /* synthetic */ Class class$org$python$core$Py;
    static /* synthetic */ Class class$org$python$core$PyObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$python$core$PyTuple;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$python$core$PyClass;

    public static PyException OverflowError(String string) {
        return new PyException(OverflowError, string);
    }

    public static PyException RuntimeError(String string) {
        return new PyException(RuntimeError, string);
    }

    public static PyException FloatingPointError(String string) {
        return new PyException(FloatingPointError, string);
    }

    public static PyException SyntaxError(String string) {
        return new PyException(SyntaxError, string);
    }

    public static PyException AttributeError(String string) {
        return new PyException(AttributeError, string);
    }

    public static PyException IOError(IOException iOException) {
        String string = iOException.getMessage();
        if (iOException instanceof FileNotFoundException) {
            string = "File not found - " + string;
        }
        return new PyException(IOError, string);
    }

    public static PyException IOError(String string) {
        return new PyException(IOError, string);
    }

    public static PyException KeyError(String string) {
        return new PyException(KeyError, string);
    }

    public static PyException AssertionError(String string) {
        return new PyException(AssertionError, string);
    }

    public static PyException TypeError(String string) {
        return new PyException(TypeError, string);
    }

    public static PyException ReferenceError(String string) {
        return new PyException(ReferenceError, string);
    }

    public static PyException SystemError(String string) {
        return new PyException(SystemError, string);
    }

    public static PyException IndexError(String string) {
        return new PyException(IndexError, string);
    }

    public static PyException ZeroDivisionError(String string) {
        return new PyException(ZeroDivisionError, string);
    }

    public static PyException NameError(String string) {
        return new PyException(NameError, string);
    }

    public static PyException UnboundLocalError(String string) {
        return new PyException(UnboundLocalError, string);
    }

    static void maybeSystemExit(PyException pyException) {
        if (Py.matchException(pyException, SystemExit)) {
            PyObject pyObject;
            PyObject pyObject2 = pyException.value;
            if (pyObject2 instanceof PyInstance && (pyObject = pyObject2.__findattr__("code")) != null) {
                pyObject2 = pyObject;
            }
            Py.getSystemState().callExitFunc();
            if (pyObject2 instanceof PyInteger) {
                System.exit(((PyInteger)pyObject2).getValue());
            } else {
                if (pyObject2 != None) {
                    try {
                        Py.println(pyObject2);
                        System.exit(1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                System.exit(0);
            }
        }
    }

    public static PyException StopIteration(String string) {
        return new PyException(StopIteration, string);
    }

    public static PyException ImportError(String string) {
        return new PyException(ImportError, string);
    }

    public static PyException ValueError(String string) {
        return new PyException(ValueError, string);
    }

    public static PyException UnicodeError(String string) {
        return new PyException(UnicodeError, string);
    }

    public static PyException EOFError(String string) {
        return new PyException(EOFError, string);
    }

    public static void memory_error(OutOfMemoryError outOfMemoryError) {
        if (Options.showJavaExceptions) {
            outOfMemoryError.printStackTrace();
        }
    }

    public static PyException MemoryError(String string) {
        return new PyException(MemoryError, string);
    }

    public static void Warning(String string) {
        Py.warning(Warning, string);
    }

    public static void UserWarning(String string) {
        Py.warning(UserWarning, string);
    }

    public static void DeprecationWarning(String string) {
        Py.warning(DeprecationWarning, string);
    }

    public static void SyntaxWarning(String string) {
        Py.warning(SyntaxWarning, string);
    }

    public static void OverflowWarning(String string) {
        Py.warning(OverflowWarning, string);
    }

    public static void RuntimeWarning(String string) {
        Py.warning(RuntimeWarning, string);
    }

    private static PyObject importWarnings() {
        PyObject pyObject;
        if (warnings_mod != null) {
            return warnings_mod;
        }
        try {
            pyObject = __builtin__.__import__("warnings");
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, ImportError)) {
                return null;
            }
            throw pyException;
        }
        warnings_mod = pyObject;
        return pyObject;
    }

    private static String warn_hcategory(PyObject pyObject) {
        PyObject pyObject2 = pyObject.__findattr__("__name__");
        if (pyObject2 != null) {
            return "[" + pyObject2 + "]";
        }
        return "[warning]";
    }

    public static void warning(PyObject pyObject, String string) {
        PyObject pyObject2 = null;
        PyObject pyObject3 = Py.importWarnings();
        if (pyObject3 != null) {
            pyObject2 = pyObject3.__getattr__("warn");
        }
        if (pyObject2 == null) {
            System.err.println(Py.warn_hcategory(pyObject) + ": " + string);
            return;
        }
        pyObject2.__call__(Py.newString(string), pyObject);
    }

    public static void warning(PyObject pyObject, String string, String string2, int n, String string3, PyObject pyObject2) {
        PyObject pyObject3 = null;
        PyObject pyObject4 = Py.importWarnings();
        if (pyObject4 != null) {
            pyObject3 = pyObject4.__getattr__("warn_explicit");
        }
        if (pyObject3 == null) {
            System.err.println(string2 + ":" + n + ":" + Py.warn_hcategory(pyObject) + ": " + string);
            return;
        }
        pyObject3.__call__(new PyObject[]{Py.newString(string), pyObject, Py.newString(string2), Py.newInteger(n), string3 == null ? None : Py.newString(string3), pyObject2}, NoKeywords);
    }

    public static PyException JavaError(Throwable throwable) {
        if (throwable instanceof PyException) {
            return (PyException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            return Py.JavaError(((InvocationTargetException)throwable).getTargetException());
        }
        if (throwable instanceof OutOfMemoryError) {
            Py.memory_error((OutOfMemoryError)throwable);
        }
        PyJavaInstance pyJavaInstance = (PyJavaInstance)Py.java2py(throwable);
        return new PyException((PyObject)pyJavaInstance.instclass, pyJavaInstance);
    }

    private Py() {
    }

    public static Object tojava(PyObject pyObject, Class clazz) {
        Object object = pyObject.__tojava__(clazz);
        if (object == NoConversion) {
            throw Py.TypeError("can't convert " + pyObject.__repr__() + " to " + clazz.getName());
        }
        return object;
    }

    public static Object tojava(PyObject pyObject, String string) {
        Class clazz = Py.findClass(string);
        if (clazz == null) {
            throw Py.TypeError("can't convert to: " + string);
        }
        return Py.tojava(pyObject, clazz);
    }

    public static PyObject jfindattr(PyProxy pyProxy, String string) {
        PyObject pyObject;
        PyInstance pyInstance = pyProxy._getPyInstance();
        if (pyInstance == null) {
            pyProxy.__initProxy__(new Object[0]);
            pyInstance = pyProxy._getPyInstance();
        }
        if ((pyObject = pyInstance.__jfindattr__(string)) == null) {
            return null;
        }
        Py.setSystemState(pyProxy._getPySystemState());
        return pyObject;
    }

    public static PyObject jgetattr(PyProxy pyProxy, String string) {
        PyInstance pyInstance = pyProxy._getPyInstance();
        PyObject pyObject = null;
        if (pyInstance != null) {
            pyObject = pyInstance.__jfindattr__(string);
        }
        if (pyObject == null) {
            throw Py.AttributeError("abstract method \"" + string + "\" not implemented");
        }
        Py.setSystemState(pyProxy._getPySystemState());
        return pyObject;
    }

    public static final PyInteger newInteger(int n) {
        if (integerCache == null) {
            integerCache = new PyInteger[1000];
            for (int i = -100; i < 900; ++i) {
                Py.integerCache[i + 100] = new PyInteger(i);
            }
        }
        if (n >= -100 && n < 900) {
            return integerCache[n + 100];
        }
        return new PyInteger(n);
    }

    public static PyObject newInteger(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            return new PyLong(l);
        }
        return Py.newInteger((int)l);
    }

    public static PyLong newLong(String string) {
        return new PyLong(string);
    }

    public static PyLong newLong(BigInteger bigInteger) {
        return new PyLong(bigInteger);
    }

    public static PyComplex newImaginary(double d) {
        return new PyComplex(0.0, d);
    }

    public static PyFloat newFloat(float f) {
        return new PyFloat((double)f);
    }

    public static PyFloat newFloat(double d) {
        return new PyFloat(d);
    }

    public static PyString newString(char c) {
        return Py.makeCharacter(c);
    }

    public static PyString newString(String string) {
        return new PyString(string);
    }

    public static PyInteger newBoolean(boolean bl) {
        return bl ? One : Zero;
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n2, String[] stringArray2, String[] stringArray3, int n3, int n4) {
        return new PyTableCode(n, stringArray, string, string2, 0, bl, bl2, pyFunctionTable, n2, stringArray2, stringArray3, n3, n4);
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, int n2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n3, String[] stringArray2, String[] stringArray3, int n4, int n5) {
        return new PyTableCode(n, stringArray, string, string2, n2, bl, bl2, pyFunctionTable, n3, stringArray2, stringArray3, n4, n5);
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n2) {
        return new PyTableCode(n, stringArray, string, string2, 0, bl, bl2, pyFunctionTable, n2);
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, int n2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n3) {
        return new PyTableCode(n, stringArray, string, string2, n2, bl, bl2, pyFunctionTable, n3);
    }

    public static PyCode newJavaCode(Class clazz, String string) {
        return new JavaCode(Py.newJavaFunc(clazz, string));
    }

    public static PyObject newJavaFunc(Class clazz, String string) {
        try {
            Method method = clazz.getMethod(string, array$Lorg$python$core$PyObject == null ? (array$Lorg$python$core$PyObject = Py.class$("[Lorg.python.core.PyObject;")) : array$Lorg$python$core$PyObject, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Py.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            return new JavaFunc(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Py.JavaError(noSuchMethodException);
        }
    }

    private static PyObject initExc(String string, PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3 = pyObject.__getattr__(string);
        pyObject2.__setitem__(string, pyObject3);
        return pyObject3;
    }

    static void initClassExceptions(PyObject pyObject) {
        PyObject pyObject2 = imp.load("exceptions");
        Exception = Py.initExc("Exception", pyObject2, pyObject);
        SystemExit = Py.initExc("SystemExit", pyObject2, pyObject);
        StopIteration = Py.initExc("StopIteration", pyObject2, pyObject);
        StandardError = Py.initExc("StandardError", pyObject2, pyObject);
        KeyboardInterrupt = Py.initExc("KeyboardInterrupt", pyObject2, pyObject);
        ImportError = Py.initExc("ImportError", pyObject2, pyObject);
        EnvironmentError = Py.initExc("EnvironmentError", pyObject2, pyObject);
        IOError = Py.initExc("IOError", pyObject2, pyObject);
        OSError = Py.initExc("OSError", pyObject2, pyObject);
        EOFError = Py.initExc("EOFError", pyObject2, pyObject);
        RuntimeError = Py.initExc("RuntimeError", pyObject2, pyObject);
        NotImplementedError = Py.initExc("NotImplementedError", pyObject2, pyObject);
        NameError = Py.initExc("NameError", pyObject2, pyObject);
        UnboundLocalError = Py.initExc("UnboundLocalError", pyObject2, pyObject);
        AttributeError = Py.initExc("AttributeError", pyObject2, pyObject);
        SyntaxError = Py.initExc("SyntaxError", pyObject2, pyObject);
        IndentationError = Py.initExc("IndentationError", pyObject2, pyObject);
        TabError = Py.initExc("TabError", pyObject2, pyObject);
        TypeError = Py.initExc("TypeError", pyObject2, pyObject);
        AssertionError = Py.initExc("AssertionError", pyObject2, pyObject);
        LookupError = Py.initExc("LookupError", pyObject2, pyObject);
        IndexError = Py.initExc("IndexError", pyObject2, pyObject);
        KeyError = Py.initExc("KeyError", pyObject2, pyObject);
        ArithmeticError = Py.initExc("ArithmeticError", pyObject2, pyObject);
        OverflowError = Py.initExc("OverflowError", pyObject2, pyObject);
        ZeroDivisionError = Py.initExc("ZeroDivisionError", pyObject2, pyObject);
        FloatingPointError = Py.initExc("FloatingPointError", pyObject2, pyObject);
        ValueError = Py.initExc("ValueError", pyObject2, pyObject);
        UnicodeError = Py.initExc("UnicodeError", pyObject2, pyObject);
        ReferenceError = Py.initExc("ReferenceError", pyObject2, pyObject);
        SystemError = Py.initExc("SystemError", pyObject2, pyObject);
        MemoryError = Py.initExc("MemoryError", pyObject2, pyObject);
        Warning = Py.initExc("Warning", pyObject2, pyObject);
        UserWarning = Py.initExc("UserWarning", pyObject2, pyObject);
        DeprecationWarning = Py.initExc("DeprecationWarning", pyObject2, pyObject);
        SyntaxWarning = Py.initExc("SyntaxWarning", pyObject2, pyObject);
        OverflowWarning = Py.initExc("OverflowWarning", pyObject2, pyObject);
        RuntimeWarning = Py.initExc("RuntimeWarning", pyObject2, pyObject);
    }

    public static synchronized boolean initPython() {
        PySystemState.initialize();
        return true;
    }

    public static Class relFindClass(Class clazz, String string) {
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Throwable throwable) {
            throw Py.JavaError(throwable);
        }
    }

    public static Class findClass(String string) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException securityException) {
                    secEnv = true;
                }
                if (classLoader != null) {
                    return classLoader.loadClass(string);
                }
            }
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    public static Class findClassEx(String string, String string2) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                Py.writeDebug("import", "trying " + string + " as " + string2 + " in classLoader");
                return classLoader.loadClass(string);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException securityException) {
                    secEnv = true;
                }
                if (classLoader != null) {
                    Py.writeDebug("import", "trying " + string + " as " + string2 + " in syspath loader");
                    return classLoader.loadClass(string);
                }
            }
            Py.writeDebug("import", "trying " + string + " as " + string2 + " in Class.forName");
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.JavaError(illegalArgumentException);
        }
        catch (LinkageError linkageError) {
            throw Py.JavaError(linkageError);
        }
    }

    public static void setArgv(String string, String[] stringArray) {
        PyObject[] pyObjectArray = new PyObject[stringArray.length + 1];
        pyObjectArray[0] = new PyString(string);
        for (int i = 1; i < pyObjectArray.length; ++i) {
            pyObjectArray[i] = new PyString(stringArray[i - 1]);
        }
        Py.getSystemState().argv = new PyList(pyObjectArray);
    }

    private static synchronized void initProperties(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String[] stringArray4, ClassLoader classLoader) {
        if (!propertiesInitialized) {
            Properties properties;
            propertiesInitialized = true;
            if (string != null) {
                frozen = true;
                if (string.length() > 0) {
                    frozenPackage = string;
                }
            }
            try {
                properties = new Properties(System.getProperties());
            }
            catch (Throwable throwable) {
                properties = new Properties();
            }
            if (stringArray3 != null) {
                for (int i = 0; i < stringArray3.length; i += 2) {
                    properties.put(stringArray3[i], stringArray3[i + 1]);
                }
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            PySystemState.initialize(properties, null, stringArray, classLoader);
        }
        if (stringArray4 != null) {
            if (frozenModules == null) {
                frozenModules = new Hashtable();
            }
            for (int i = 0; i < stringArray4.length; ++i) {
                String string2 = stringArray4[i];
                frozenModules.put(string2, PRESENT);
                if (!string2.endsWith(".__init__")) continue;
                String string3 = string2.substring(0, string2.length() - 9);
                PySystemState.add_package(string3);
            }
        }
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; i += 2) {
                PySystemState.add_package(stringArray2[i], stringArray2[i + 1]);
            }
        }
    }

    public static void initProxy(PyProxy pyProxy, String string, String string2, Object[] objectArray, String[] stringArray, String[] stringArray2, boolean bl) {
        Py.initProxy(pyProxy, string, string2, objectArray, stringArray, stringArray2, null, null);
    }

    public static void initProxy(PyProxy pyProxy, String string, String string2, Object[] objectArray, String[] stringArray, String[] stringArray2, String string3, String[] stringArray3) {
        PyObject[] pyObjectArray;
        PyObject pyObject;
        PyObject pyObject2;
        Py.initProperties(null, stringArray, stringArray2, string3, stringArray3, pyProxy.getClass().getClassLoader());
        if (pyProxy._getPyInstance() != null) {
            return;
        }
        ThreadState threadState = Py.getThreadState();
        PyInstance pyInstance = threadState.getInitializingProxy();
        if (pyInstance != null) {
            if (pyInstance.javaProxy != null) {
                throw Py.TypeError("Proxy instance reused");
            }
            pyInstance.javaProxy = pyProxy;
            pyProxy._setPyInstance(pyInstance);
            pyProxy._setPySystemState(threadState.systemState);
            return;
        }
        Class clazz = Py.findClass(string + "$_PyInner");
        if (clazz != null) {
            pyObject2 = null;
            try {
                pyObject2 = ((PyRunnable)clazz.newInstance()).getMain();
            }
            catch (Throwable throwable) {
                throw Py.JavaError(throwable);
            }
            pyObject = imp.createFromCode(string, pyObject2);
        } else {
            pyObject = imp.importName(string.intern(), false);
        }
        pyObject2 = (PyClass)pyObject.__getattr__(string2.intern());
        pyInstance = new PyInstance((PyClass)pyObject2);
        pyInstance.javaProxy = pyProxy;
        pyProxy._setPyInstance(pyInstance);
        pyProxy._setPySystemState(threadState.systemState);
        if (objectArray == null || objectArray.length == 0) {
            pyObjectArray = EmptyObjects;
        } else {
            pyObjectArray = new PyObject[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                pyObjectArray[i] = Py.java2py(objectArray[i]);
            }
        }
        pyInstance.__init__(pyObjectArray, NoKeywords);
    }

    public static void initRunnable(String string, PyObject pyObject) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error running main.  Can't find: " + string);
            System.exit(-1);
        }
        PyCode pyCode = null;
        try {
            pyCode = ((PyRunnable)clazz.newInstance()).getMain();
        }
        catch (Throwable throwable) {
            System.err.println("Invalid class (runnable): " + string + "$py");
            System.exit(-1);
        }
        Py.runCode(pyCode, pyObject, pyObject);
    }

    public static void runMain(Class clazz, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String[] stringArray4) throws Exception {
        Py.initProperties(stringArray, stringArray2, stringArray3, string, stringArray4, clazz.getClassLoader());
        try {
            PyCode pyCode = null;
            try {
                pyCode = ((PyRunnable)clazz.newInstance()).getMain();
            }
            catch (Throwable throwable) {
                System.err.println("Invalid class: " + clazz.getName() + "$py");
                System.exit(-1);
            }
            PyObject pyObject = imp.createFromCode("__main__", pyCode);
        }
        catch (PyException pyException) {
            Py.getSystemState().callExitFunc();
            if (Py.matchException(pyException, SystemExit)) {
                return;
            }
            throw pyException;
        }
        Py.getSystemState().callExitFunc();
    }

    private static String getStackTrace(Throwable throwable) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        String string = byteArrayOutputStream.toString();
        int n2 = -1;
        if (n2 == -1) {
            n2 = string.indexOf("at org.python.core.PyReflectedConstructor.call");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org.python.core.PyReflectedMethod.call");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org/python/core/PyReflectedConstructor.call");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org/python/core/PyReflectedMethod.call");
        }
        if (n2 != -1) {
            n2 = string.lastIndexOf("\n", n2);
        }
        if (n2 >= (n = string.indexOf("\n"))) {
            string = string.substring(n + 1, n2 + 1);
        }
        return string;
    }

    public static void printException(Throwable throwable) {
        Py.printException(throwable, null, null);
    }

    public static void printException(Throwable throwable, PyFrame pyFrame) {
        Py.printException(throwable, pyFrame, null);
    }

    public static synchronized void printException(Throwable throwable, PyFrame pyFrame, PyObject pyObject) {
        Object object;
        StdoutWrapper stdoutWrapper = stderr;
        if (pyObject != null) {
            stdoutWrapper = new FixedFileWrapper(pyObject);
        }
        if (Options.showJavaExceptions) {
            stdoutWrapper.println("Java Traceback:");
            object = new CharArrayWriter();
            if (throwable instanceof PyException) {
                ((PyException)throwable).super__printStackTrace(new PrintWriter((Writer)object));
            } else {
                throwable.printStackTrace(new PrintWriter((Writer)object));
            }
            stdoutWrapper.print(((CharArrayWriter)object).toString());
        }
        object = Py.JavaError(throwable);
        Py.maybeSystemExit((PyException)object);
        Py.setException((Throwable)object, pyFrame);
        ThreadState threadState = Py.getThreadState();
        threadState.systemState.last_value = ((PyException)object).value;
        threadState.systemState.last_type = ((PyException)object).type;
        threadState.systemState.last_traceback = ((PyException)object).traceback;
        PyObject pyObject2 = threadState.systemState.__findattr__("excepthook");
        if (pyObject2 != null) {
            try {
                pyObject2.__call__(((PyException)object).type, ((PyException)object).value, ((PyException)object).traceback);
            }
            catch (PyException pyException) {
                stdoutWrapper.println("Error in sys.excepthook:");
                Py.displayException(pyException.type, pyException.value, pyException.traceback, pyObject);
                stdoutWrapper.println();
                stdoutWrapper.println("Original exception was:");
                Py.displayException(((PyException)object).type, ((PyException)object).value, ((PyException)object).traceback, pyObject);
            }
        } else {
            stdoutWrapper.println("sys.excepthook is missing");
            Py.displayException(((PyException)object).type, ((PyException)object).value, ((PyException)object).traceback, pyObject);
        }
        threadState.exception = null;
    }

    public static void displayException(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        Object object;
        StdoutWrapper stdoutWrapper = stderr;
        if (pyObject4 != null) {
            stdoutWrapper = new FixedFileWrapper(pyObject4);
        }
        if (pyObject3 instanceof PyTraceback) {
            stdoutWrapper.print(((PyTraceback)pyObject3).dumpStack());
        }
        if (__builtin__.isinstance(pyObject2, (PyClass)SyntaxError)) {
            stdoutWrapper.println("  File \"" + pyObject2.__findattr__("filename") + "\", line " + pyObject2.__findattr__("lineno"));
            object = pyObject2.__findattr__("text");
            if (object != None && ((PyObject)object).__len__() != 0) {
                stdoutWrapper.println("\t" + object);
                String string = "\t";
                int n = ((PyInteger)pyObject2.__findattr__("offset").__int__()).getValue();
                for (int i = 1; i < n; ++i) {
                    string = string + " ";
                }
                stdoutWrapper.println(string + "^");
            }
        }
        if (pyObject2 instanceof PyJavaInstance && (object = pyObject2.__tojava__(class$java$lang$Throwable == null ? (class$java$lang$Throwable = Py.class$("java.lang.Throwable")) : class$java$lang$Throwable)) != null && object != NoConversion) {
            stdoutWrapper.println(Py.getStackTrace((Throwable)object));
        }
        stdoutWrapper.println(Py.formatException(pyObject, pyObject2, pyObject3));
    }

    static String formatException(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (pyObject instanceof PyClass) {
            stringBuffer.append(((PyClass)pyObject).__name__);
        } else {
            stringBuffer.append(pyObject.__str__());
        }
        if (pyObject2 != None) {
            stringBuffer.append(": ");
            if (__builtin__.isinstance(pyObject2, (PyClass)SyntaxError)) {
                stringBuffer.append(pyObject2.__getitem__(0).__str__());
            } else {
                stringBuffer.append(pyObject2.__str__());
            }
        }
        return stringBuffer.toString();
    }

    public static void assert_(PyObject pyObject, PyObject pyObject2) {
        if (!pyObject.__nonzero__()) {
            throw new PyException(AssertionError, pyObject2);
        }
    }

    public static void assert_(PyObject pyObject) {
        Py.assert_(pyObject, None);
    }

    public static void addTraceback(Throwable throwable, PyFrame pyFrame) {
        PyException pyException = Py.JavaError(throwable);
        if (pyException.traceback.tb_frame != pyFrame) {
            pyException.traceback = new PyTraceback(pyException.traceback);
        }
    }

    public static PyException setException(Throwable throwable, PyFrame pyFrame) {
        PyException pyException = Py.JavaError(throwable);
        pyException.instantiate();
        if (pyFrame != null && pyException.traceback.tb_frame != pyFrame) {
            pyException.traceback = new PyTraceback(pyException.traceback);
        }
        ThreadState threadState = Py.getThreadState();
        threadState.exception = pyException;
        return pyException;
    }

    public static boolean matchException(PyException pyException, PyObject pyObject) {
        pyException.instantiate();
        if (pyObject == IOError && __builtin__.isinstance(pyException.value, PyJavaClass.lookup(class$java$io$IOException == null ? (class$java$io$IOException = Py.class$("java.io.IOException")) : class$java$io$IOException))) {
            return true;
        }
        if (pyObject == MemoryError && __builtin__.isinstance(pyException.value, PyJavaClass.lookup(class$java$lang$OutOfMemoryError == null ? (class$java$lang$OutOfMemoryError = Py.class$("java.lang.OutOfMemoryError")) : class$java$lang$OutOfMemoryError))) {
            return true;
        }
        if (pyObject == IOError && __builtin__.isinstance(pyException.value, PyJavaClass.lookup(class$java$io$IOException == null ? (class$java$io$IOException = Py.class$("java.io.IOException")) : class$java$io$IOException))) {
            return true;
        }
        if (pyObject instanceof PyClass) {
            return __builtin__.isinstance(pyException.value, (PyClass)pyObject);
        }
        if (pyObject == pyException.type) {
            return true;
        }
        if (pyObject instanceof PyTuple) {
            PyObject[] pyObjectArray = ((PyTuple)pyObject).getArray();
            for (int i = 0; i < pyObjectArray.length; ++i) {
                if (!Py.matchException(pyException, pyObjectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static PyException makeException() {
        ThreadState threadState = Py.getThreadState();
        if (threadState.exception == null) {
            throw Py.ValueError("no exception to reraise");
        }
        return threadState.exception;
    }

    public static PyException makeException(PyObject pyObject) {
        if (pyObject instanceof PyInstance) {
            return new PyException(pyObject.fastGetClass(), pyObject);
        }
        return Py.makeException(pyObject, None);
    }

    public static PyException makeException(PyObject pyObject, PyObject pyObject2) {
        if (pyObject instanceof PyInstance) {
            if (pyObject2 != None) {
                throw Py.TypeError("instance exceptions may not have a separate value");
            }
            return new PyException(pyObject.fastGetClass(), pyObject);
        }
        PyException pyException = new PyException(pyObject, pyObject2);
        pyException.instantiate();
        return pyException;
    }

    public static PyException makeException(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (pyObject instanceof PyInstance) {
            if (pyObject2 != None) {
                throw Py.TypeError("instance exceptions may not have a separate value");
            }
            pyObject = pyObject.fastGetClass();
        }
        if (pyObject3 == None) {
            return new PyException(pyObject, pyObject2);
        }
        if (!(pyObject3 instanceof PyTraceback)) {
            throw Py.TypeError("raise 3rd arg must be traceback or None");
        }
        return new PyException(pyObject, pyObject2, (PyTraceback)pyObject3);
    }

    public static PyObject runCode(PyCode pyCode, PyObject pyObject, PyObject pyObject2) {
        if (pyObject == null) {
            pyObject = pyObject2 != null ? pyObject2 : Py.getFrame().getf_locals();
        }
        if (pyObject2 == null) {
            pyObject2 = Py.getFrame().f_globals;
        }
        PyTableCode pyTableCode = null;
        if (pyCode instanceof PyTableCode) {
            pyTableCode = (PyTableCode)pyCode;
        }
        PyFrame pyFrame = new PyFrame(pyTableCode, pyObject, pyObject2, Py.getThreadState().systemState.builtins);
        return pyCode.call(pyFrame);
    }

    public static void exec(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyCode pyCode;
        if (pyObject instanceof PyCode) {
            pyCode = (PyCode)pyObject;
        } else {
            String string = null;
            if (pyObject instanceof PyString) {
                string = pyObject.toString();
            } else if (pyObject instanceof PyFile) {
                PyFile pyFile = (PyFile)pyObject;
                if (pyFile.closed) {
                    return;
                }
                string = pyFile.read().toString();
            } else {
                throw Py.TypeError("exec: argument 1 must be string, code or file object");
            }
            pyCode = Py.compile_flags(string, "<string>", "exec", Py.getCompilerFlags());
        }
        Py.runCode(pyCode, pyObject3, pyObject2);
    }

    public static final ThreadState getThreadState() {
        return Py.getThreadState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ThreadState getThreadState(PySystemState pySystemState) {
        if (threadStateMapping == null) {
            Class clazz = class$org$python$core$Py == null ? (class$org$python$core$Py = Py.class$("org.python.core.Py")) : class$org$python$core$Py;
            synchronized (clazz) {
                if (threadStateMapping == null) {
                    threadStateMapping = ThreadStateMapping.makeMapping();
                }
            }
        }
        return threadStateMapping.getThreadState(pySystemState);
    }

    public static final PySystemState setSystemState(PySystemState pySystemState) {
        ThreadState threadState = Py.getThreadState(pySystemState);
        PySystemState pySystemState2 = threadState.systemState;
        if (pySystemState2 != pySystemState) {
            threadState.systemState = pySystemState;
        }
        return pySystemState2;
    }

    public static final PySystemState getSystemState() {
        return Py.getThreadState().systemState;
    }

    public static PyFrame getFrame() {
        ThreadState threadState = Py.getThreadState();
        if (threadState == null) {
            return null;
        }
        return threadState.frame;
    }

    public static void setFrame(PyFrame pyFrame) {
        Py.getThreadState().frame = pyFrame;
    }

    public static void print(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.print(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).print(pyObject2);
        }
    }

    public static void printComma(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.printComma(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).printComma(pyObject2);
        }
    }

    public static void println(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.println(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).println(pyObject2);
        }
    }

    public static void printlnv(PyObject pyObject) {
        if (pyObject == None) {
            Py.println();
        } else {
            new FixedFileWrapper(pyObject).println();
        }
    }

    public static void print(PyObject pyObject) {
        stdout.print(pyObject);
    }

    public static void printComma(PyObject pyObject) {
        stdout.printComma(pyObject);
    }

    public static void println(PyObject pyObject) {
        stdout.println(pyObject);
    }

    public static void println() {
        stdout.println();
    }

    public static boolean py2boolean(PyObject pyObject) {
        return pyObject.__nonzero__();
    }

    public static byte py2byte(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return (byte)((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Byte.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Byte)object;
    }

    public static short py2short(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return (short)((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Short.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Short)object;
    }

    public static int py2int(PyObject pyObject) {
        return Py.py2int(pyObject, "integer required");
    }

    public static int py2int(PyObject pyObject, String string) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Integer.TYPE);
        if (object == NoConversion) {
            throw Py.TypeError(string);
        }
        return (Integer)object;
    }

    public static long py2long(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Long.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Long)object;
    }

    public static float py2float(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return (float)((PyFloat)pyObject).getValue();
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Float.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("float required");
        }
        return ((Float)object).floatValue();
    }

    public static double py2double(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return ((PyFloat)pyObject).getValue();
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Double.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("float required");
        }
        return (Double)object;
    }

    public static char py2char(PyObject pyObject) {
        return Py.py2char(pyObject, "char required");
    }

    public static char py2char(PyObject pyObject, String string) {
        if (pyObject instanceof PyString) {
            PyString pyString = (PyString)pyObject;
            if (pyString.__len__() != 1) {
                throw Py.TypeError(string);
            }
            return pyString.toString().charAt(0);
        }
        if (pyObject instanceof PyInteger) {
            return (char)((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Character.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError(string);
        }
        return ((Character)object).charValue();
    }

    public static void py2void(PyObject pyObject) {
        if (pyObject != None) {
            throw Py.TypeError("None required for void return");
        }
    }

    static final PyString makeCharacter(Character c) {
        return Py.makeCharacter(c.charValue());
    }

    static final PyString makeCharacter(char c) {
        if (c > '\u00ff') {
            return new PyString(new Character(c).toString());
        }
        if (letters == null) {
            letters = new PyString[256];
            for (char c2 = '\u0000'; c2 < '\u0100'; c2 = (char)(c2 + '\u0001')) {
                Py.letters[c2] = new PyString(new Character(c2).toString());
            }
        }
        return letters[c];
    }

    public static PyObject java2py(Object object) {
        if (object instanceof PyObject) {
            return (PyObject)object;
        }
        if (object instanceof PyProxy) {
            return ((PyProxy)object)._getPyInstance();
        }
        if (object instanceof Number) {
            if (object instanceof Double || object instanceof Float) {
                return new PyFloat(((Number)object).doubleValue());
            }
            if (object instanceof Long) {
                return new PyLong(((Number)object).longValue());
            }
            if (object instanceof Integer || object instanceof Byte || object instanceof Short) {
                return new PyInteger(((Number)object).intValue());
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? One : Zero;
        }
        if (object == null) {
            return None;
        }
        if (object instanceof String) {
            return new PyString((String)object);
        }
        if (object instanceof Character) {
            return Py.makeCharacter((Character)object);
        }
        if (object instanceof Class) {
            Class clazz;
            if ((class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = Py.class$("org.python.core.PyObject")) : class$org$python$core$PyObject).isAssignableFrom(clazz = (Class)object)) {
                return PyType.fromClass(clazz);
            }
            return PyJavaClass.lookup(clazz);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return new PyArray(clazz.getComponentType(), object);
        }
        return new PyJavaInstance(object);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode, PyObject pyObject) {
        return Py.makeClass(string, pyObjectArray, pyCode, pyObject, null, null);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode, PyObject pyObject, PyObject[] pyObjectArray2) {
        return Py.makeClass(string, pyObjectArray, pyCode, pyObject, null, pyObjectArray2);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode, PyObject pyObject, Class clazz) {
        return Py.makeClass(string, pyObjectArray, pyCode, pyObject, clazz, null);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode, PyObject pyObject, Class clazz, PyObject[] pyObjectArray2) {
        PyObject pyObject2;
        PyFrame pyFrame = Py.getFrame();
        PyObject pyObject3 = pyFrame.f_globals;
        PyObject pyObject4 = pyCode.call(EmptyObjects, NoKeywords, pyObject3, EmptyObjects, (PyObject)new PyTuple(pyObjectArray2));
        if (pyObject != null) {
            pyObject4.__setitem__("__doc__", pyObject);
        }
        if ((pyObject2 = pyObject4.__finditem__("__metaclass__")) == null) {
            if (pyObjectArray.length != 0) {
                PyObject pyObject5 = pyObjectArray[0];
                if (pyObject5 instanceof PyMetaClass) {
                    try {
                        Constructor<?> constructor = pyObject5.getClass().getConstructor(pyClassCtrSignature);
                        return (PyObject)constructor.newInstance(string, new PyTuple(pyObjectArray), pyObject4, clazz);
                    }
                    catch (Exception exception) {
                        throw Py.TypeError("meta-class fails to supply proper ctr: " + pyObject5.safeRepr());
                    }
                }
                pyObject2 = pyObject5.__findattr__("__class__");
                if (pyObject2 == null) {
                    pyObject2 = pyObject5.getType();
                }
            } else if (pyObject3 != null) {
                pyObject2 = pyObject3.__finditem__("__metaclass__");
            }
        }
        if (pyObject2 == null || pyObject2 == CLASS_TYPE || pyObject2 instanceof PyJavaClass && ((PyJavaClass)pyObject2).proxyClass == (class$java$lang$Class == null ? (class$java$lang$Class = Py.class$("java.lang.Class")) : class$java$lang$Class)) {
            return new PyClass(string, new PyTuple(pyObjectArray), pyObject4, clazz);
        }
        if (clazz != null) {
            throw Py.TypeError("the meta-class cannot handle java subclassing");
        }
        return pyObject2.__call__((PyObject)new PyString(string), new PyTuple(pyObjectArray), pyObject4);
    }

    public static synchronized String getName() {
        String string = "org.python.pycode._pyx" + nameindex;
        ++nameindex;
        return string;
    }

    public static CompilerFlags getCompilerFlags() {
        return Py.getCompilerFlags(0, false);
    }

    public static CompilerFlags getCompilerFlags(int n, boolean bl) {
        CompilerFlags compilerFlags = null;
        if (bl) {
            compilerFlags = new CompilerFlags(n);
        } else {
            PyFrame pyFrame = Py.getFrame();
            if (pyFrame != null && pyFrame.f_code != null) {
                compilerFlags = new CompilerFlags(pyFrame.f_code.co_flags | n);
            }
        }
        return compilerFlags;
    }

    public static PyCode compile(modType modType2, String string) {
        return Py.compile(modType2, Py.getName(), string);
    }

    public static PyCode compile(modType modType2, String string, String string2) {
        return Py.compile(modType2, string, string2, true, false);
    }

    public static PyCode compile(modType modType2, String string, String string2, boolean bl, boolean bl2) {
        return Py.compile_flags(modType2, string, string2, bl, bl2, null);
    }

    public static PyCode compile(InputStream inputStream, String string, String string2) {
        return Py.compile_flags(inputStream, string, string2, null);
    }

    public static PyCode compile_flags(modType modType2, String string, String string2, boolean bl, boolean bl2, CompilerFlags compilerFlags) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Module.compile(modType2, byteArrayOutputStream, string, string2, bl, bl2, false, compilerFlags);
            Py.saveClassFile(string, byteArrayOutputStream);
            return BytecodeLoader.makeCode(string, byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            throw parser.fixParseError(null, throwable, string2);
        }
    }

    public static PyCode compile_flags(InputStream inputStream, String string, String string2, CompilerFlags compilerFlags) {
        modType modType2 = parser.parse(inputStream, string2, string, compilerFlags);
        boolean bl = false;
        if (string2.equals("single")) {
            bl = true;
        }
        return Py.compile_flags(modType2, Py.getName(), string, true, bl, compilerFlags);
    }

    public static PyCode compile_flags(String string, String string2, String string3, CompilerFlags compilerFlags) {
        return Py.compile_flags(new StringBufferInputStream(string + "\n\n"), string2, string3, compilerFlags);
    }

    public static PyObject compile_command_flags(String string, String string2, String string3, CompilerFlags compilerFlags, boolean bl) {
        modType modType2 = parser.partialParse(string + "\n", string3, string2, compilerFlags, bl);
        if (modType2 == null) {
            return None;
        }
        return Py.compile_flags(modType2, Py.getName(), string2, true, true, compilerFlags);
    }

    public static PyObject[] unpackSequence(PyObject pyObject, int n) {
        if (pyObject instanceof PyTuple) {
            PyTuple pyTuple = (PyTuple)pyObject;
            if (pyTuple.__len__() == n) {
                return pyTuple.getArray();
            }
            throw Py.ValueError("unpack tuple of wrong size");
        }
        PyObject[] pyObjectArray = new PyObject[n];
        PyObject pyObject2 = pyObject.__iter__();
        try {
            for (int i = 0; i < n; ++i) {
                PyObject pyObject3 = pyObject2.__iternext__();
                if (pyObject3 == null) {
                    throw Py.ValueError("unpack sequence too short");
                }
                pyObjectArray[i] = pyObject3;
            }
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, AttributeError)) {
                throw Py.TypeError("unpack non-sequence");
            }
            throw pyException;
        }
        if (pyObject2.__iternext__() != null) {
            throw Py.ValueError("unpack sequence too long");
        }
        return pyObjectArray;
    }

    public static PyObject iter(PyObject pyObject, String string) {
        try {
            return pyObject.__iter__();
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, TypeError)) {
                throw Py.TypeError(string);
            }
            throw pyException;
        }
    }

    public static long id(PyObject pyObject) {
        return idimpl.id(pyObject);
    }

    public static String idstr(PyObject pyObject) {
        return idimpl.idstr(pyObject);
    }

    public static long java_obj_id(Object object) {
        return idimpl.java_obj_id(object);
    }

    public static String safeRepr(PyObject pyObject) {
        return pyObject.safeRepr();
    }

    public static void printResult(PyObject pyObject) {
        Py.getThreadState().systemState.invoke("displayhook", pyObject);
    }

    public static void maybeWrite(String string, String string2, int n) {
        if (n <= Options.verbose) {
            System.err.println(string + ": " + string2);
        }
    }

    public static void writeError(String string, String string2) {
        Py.maybeWrite(string, string2, -1);
    }

    public static void writeWarning(String string, String string2) {
        Py.maybeWrite(string, string2, 0);
    }

    public static void writeMessage(String string, String string2) {
        Py.maybeWrite(string, string2, 1);
    }

    public static void writeComment(String string, String string2) {
        Py.maybeWrite(string, string2, 2);
    }

    public static void writeDebug(String string, String string2) {
        Py.maybeWrite(string, string2, 3);
    }

    public static void saveClassFile(String string, ByteArrayOutputStream byteArrayOutputStream) {
        String string2 = Options.proxyDebugDirectory;
        if (string2 == null) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        File file = new File(string2);
        File file2 = Py.makeFilename(string, file);
        new File(file2.getParent()).mkdirs();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static File makeFilename(String string, File file) {
        int n = string.indexOf(".");
        if (n == -1) {
            return new File(file, string + ".class");
        }
        return Py.makeFilename(string.substring(n + 1, string.length()), new File(file, string.substring(0, n)));
    }

    private static boolean abstract_issubclass(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == pyObject2) {
            return true;
        }
        PyObject pyObject3 = pyObject.__findattr__("__bases__");
        if (pyObject3 == null) {
            return false;
        }
        for (int i = 0; i < pyObject3.__len__(); ++i) {
            if (!Py.abstract_issubclass(pyObject3.__getitem__(i), pyObject2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(PyObject pyObject, PyObject pyObject2) {
        if (pyObject2 instanceof PyType) {
            PyType pyType = pyObject.getType();
            if (pyType == pyObject2) {
                return true;
            }
            return pyType.isSubType((PyType)pyObject2);
        }
        if (pyObject2 instanceof PyClass) {
            if (!(pyObject instanceof PyInstance)) {
                return false;
            }
            return ((PyClass)pyObject.fastGetClass()).isSubClass((PyClass)pyObject2);
        }
        if (pyObject2.getClass() == (class$org$python$core$PyTuple == null ? (class$org$python$core$PyTuple = Py.class$("org.python.core.PyTuple")) : class$org$python$core$PyTuple)) {
            for (int i = 0; i < pyObject2.__len__(); ++i) {
                if (!Py.isInstance(pyObject, pyObject2.__getitem__(i))) continue;
                return true;
            }
            return false;
        }
        if (pyObject2.__findattr__("__bases__") == null) {
            throw Py.TypeError("isinstance() arg 2 must be a class, type, or tuple of classes and types");
        }
        PyObject pyObject3 = pyObject.__findattr__("__class__");
        if (pyObject3 == null) {
            return false;
        }
        return Py.abstract_issubclass(pyObject3, pyObject2);
    }

    public static boolean isSubClass(PyObject pyObject, PyObject pyObject2) {
        if (pyObject instanceof PyType && pyObject2 instanceof PyType) {
            if (pyObject == pyObject2) {
                return true;
            }
            return ((PyType)pyObject).isSubType((PyType)pyObject2);
        }
        if (pyObject2 instanceof PyClass && pyObject instanceof PyClass) {
            return ((PyClass)pyObject).isSubClass((PyClass)pyObject2);
        }
        if (pyObject2.getClass() == (class$org$python$core$PyTuple == null ? (class$org$python$core$PyTuple = Py.class$("org.python.core.PyTuple")) : class$org$python$core$PyTuple)) {
            for (int i = 0; i < pyObject2.__len__(); ++i) {
                if (!Py.isSubClass(pyObject, pyObject2.__getitem__(i))) continue;
                return true;
            }
            return false;
        }
        if (pyObject.__findattr__("__bases__") == null) {
            throw Py.TypeError("issubclass() arg 1 must be a class");
        }
        if (pyObject2.__findattr__("__bases__") == null) {
            throw Py.TypeError("issubclass() arg 2 must be a class, type, or tuple of classes and types");
        }
        return Py.abstract_issubclass(pyObject, pyObject2);
    }

    static PyObject[] make_array(PyObject pyObject) {
        PyObject[] pyObjectArray;
        if (pyObject instanceof PyTuple) {
            return ((PyTuple)pyObject).getArray();
        }
        PyObject pyObject2 = pyObject.__iter__();
        int n = 10;
        try {
            n = pyObject.__len__();
        }
        catch (PyException pyException) {
            // empty catch block
        }
        PyObject[] pyObjectArray2 = new PyObject[n];
        int n2 = 0;
        while ((pyObjectArray = pyObject2.__iternext__()) != null) {
            if (n2 >= n) {
                n = n < 500 ? (n += 10) : (n += 100);
                PyObject[] pyObjectArray3 = new PyObject[n];
                System.arraycopy(pyObjectArray2, 0, pyObjectArray3, 0, pyObjectArray2.length);
                pyObjectArray2 = pyObjectArray3;
            }
            pyObjectArray2[n2] = pyObjectArray;
            ++n2;
        }
        if (n2 < n) {
            pyObjectArray = new PyObject[n2];
            System.arraycopy(pyObjectArray2, 0, pyObjectArray, 0, n2);
            pyObjectArray2 = pyObjectArray;
        }
        return pyObjectArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        frozenPackage = null;
        PRESENT = new Object();
        integerCache = null;
        secEnv = false;
        propertiesInitialized = false;
        threadStateMapping = null;
        letters = null;
        pyClassCtrSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Py.class$("java.lang.String")) : class$java$lang$String, class$org$python$core$PyTuple == null ? (class$org$python$core$PyTuple = Py.class$("org.python.core.PyTuple")) : class$org$python$core$PyTuple, class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = Py.class$("org.python.core.PyObject")) : class$org$python$core$PyObject, class$java$lang$Class == null ? (class$java$lang$Class = Py.class$("java.lang.Class")) : class$java$lang$Class};
        CLASS_TYPE = PyType.fromClass(class$org$python$core$PyClass == null ? (class$org$python$core$PyClass = Py.class$("org.python.core.PyClass")) : class$org$python$core$PyClass);
        nameindex = 0;
        idimpl = IdImpl.getInstance();
    }
}

