/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class ArgParser {
    private String funcname;
    private PyObject[] args;
    private String[] kws;
    private String[] params = null;
    private static Object required = new Object();
    private static String[] emptyKws = new String[0];
    static /* synthetic */ Class class$java$lang$String;

    private ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray) {
        this.funcname = string;
        this.args = pyObjectArray;
        if (stringArray == null) {
            stringArray = emptyKws;
        }
        this.kws = stringArray;
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String string2) {
        this(string, pyObjectArray, stringArray);
        this.params = new String[]{string2};
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String string2, String string3) {
        this(string, pyObjectArray, stringArray);
        this.params = new String[]{string2, string3};
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String string2, String string3, String string4) {
        this(string, pyObjectArray, stringArray);
        this.params = new String[]{string2, string3, string4};
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String[] stringArray2) {
        this(string, pyObjectArray, stringArray);
        this.params = stringArray2;
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String[] stringArray2, int n) {
        this(string, pyObjectArray, stringArray);
        this.params = stringArray2;
        this.check();
        if (!PyBuiltinFunction.DefaultInfo.check(pyObjectArray.length, n, this.params.length)) {
            throw PyBuiltinFunction.DefaultInfo.unexpectedCall(pyObjectArray.length, false, string, n, this.params.length);
        }
    }

    public String getString(int n) {
        return (String)this.getArg(n, class$java$lang$String == null ? (class$java$lang$String = ArgParser.class$("java.lang.String")) : class$java$lang$String, "string");
    }

    public String getString(int n, String string) {
        return (String)this.getArg(n, class$java$lang$String == null ? (class$java$lang$String = ArgParser.class$("java.lang.String")) : class$java$lang$String, "string", string);
    }

    public int getInt(int n) {
        return ((PyInteger)this.getRequiredArg(n).__int__()).getValue();
    }

    public int getInt(int n, int n2) {
        PyObject pyObject = this.getOptionalArg(n);
        if (pyObject == null) {
            return n2;
        }
        return ((PyInteger)pyObject.__int__()).getValue();
    }

    public PyObject getPyObject(int n) {
        return this.getRequiredArg(n);
    }

    public PyObject getPyObject(int n, PyObject pyObject) {
        PyObject pyObject2 = this.getOptionalArg(n);
        if (pyObject2 == null) {
            pyObject2 = pyObject;
        }
        return pyObject2;
    }

    public PyObject getList(int n) {
        int n2 = this.args.length - this.kws.length;
        if (n < n2) {
            PyObject[] pyObjectArray = new PyObject[n2 - n];
            System.arraycopy(this.args, n, pyObjectArray, 0, n2 - n);
            return new PyTuple(pyObjectArray);
        }
        return Py.EmptyTuple;
    }

    private void check() {
        int n = this.args.length - this.kws.length;
        block0: for (int i = 0; i < this.kws.length; ++i) {
            for (int j = 0; j < this.params.length; ++j) {
                if (!this.kws[i].equals(this.params[j])) continue;
                if (j >= n) continue block0;
                throw Py.TypeError("keyword parameter '" + this.params[j] + "' was given by position and by name");
            }
            throw Py.TypeError("'" + this.kws[i] + "' is an invalid keyword " + "argument for this function");
        }
    }

    private PyObject getRequiredArg(int n) {
        PyObject pyObject = this.getOptionalArg(n);
        if (pyObject == null) {
            throw Py.TypeError(this.funcname + ": The " + ArgParser.ordinal(n) + " argument is required");
        }
        return pyObject;
    }

    private PyObject getOptionalArg(int n) {
        int n2 = this.args.length - this.kws.length;
        if (n < n2) {
            return this.args[n];
        }
        for (int i = 0; i < this.kws.length; ++i) {
            if (!this.kws[i].equals(this.params[n])) continue;
            return this.args[n2 + i];
        }
        return null;
    }

    private Object getArg(int n, Class clazz, String string) {
        return this.getArg(n, clazz, string, required);
    }

    private Object getArg(int n, Class clazz, String string, Object object) {
        PyObject pyObject = null;
        if (object == required) {
            pyObject = this.getRequiredArg(n);
        } else {
            pyObject = this.getOptionalArg(n);
            if (pyObject == null) {
                return object;
            }
        }
        Object object2 = pyObject.__tojava__(clazz);
        if (object2 == Py.NoConversion) {
            throw Py.TypeError("argument " + (n + 1) + ": expected " + string + ", " + Py.safeRepr(pyObject) + " found");
        }
        return object2;
    }

    private static String ordinal(int n) {
        switch (n + 1) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return Integer.toString(n + 1) + "th";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

