/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.ConstantPool;
import org.python.compiler.Future;
import org.python.compiler.Label;
import org.python.compiler.Module;
import org.python.compiler.ScopeInfo;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;
import org.python.parser.ast.Assert;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.AugAssign;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.BoolOp;
import org.python.parser.ast.Break;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Compare;
import org.python.parser.ast.Continue;
import org.python.parser.ast.Delete;
import org.python.parser.ast.Dict;
import org.python.parser.ast.Ellipsis;
import org.python.parser.ast.Exec;
import org.python.parser.ast.Expr;
import org.python.parser.ast.Expression;
import org.python.parser.ast.ExtSlice;
import org.python.parser.ast.For;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Index;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Lambda;
import org.python.parser.ast.List;
import org.python.parser.ast.ListComp;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Pass;
import org.python.parser.ast.Print;
import org.python.parser.ast.Raise;
import org.python.parser.ast.Repr;
import org.python.parser.ast.Return;
import org.python.parser.ast.Slice;
import org.python.parser.ast.Str;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.Suite;
import org.python.parser.ast.TryExcept;
import org.python.parser.ast.TryFinally;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.UnaryOp;
import org.python.parser.ast.While;
import org.python.parser.ast.Yield;
import org.python.parser.ast.excepthandlerType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.keywordType;
import org.python.parser.ast.listcompType;
import org.python.parser.ast.modType;
import org.python.parser.ast.stmtType;

public class CodeCompiler
extends Visitor
implements ClassConstants {
    public static final Object Exit = new Integer(1);
    public static final Object NoExit = null;
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int DEL = 2;
    public static final int AUGGET = 3;
    public static final int AUGSET = 4;
    public Module module;
    public Code code;
    public ConstantPool pool;
    public CodeCompiler mrefs;
    public CompilerFlags cflags;
    int temporary;
    int augmode;
    int augtmp1;
    int augtmp2;
    int augtmp3;
    int augtmp4;
    public boolean fast_locals;
    public boolean print_results;
    public Hashtable tbl;
    public ScopeInfo my_scope;
    boolean optimizeGlobals = true;
    public Vector names;
    public String className;
    public Stack continueLabels;
    public Stack breakLabels;
    public Stack finallyLabels;
    public Stack inFinallyLabels;
    public Vector yields = new Vector();
    public int bcfLevel = 0;
    public int PyNone;
    int f_lasti;
    public int setline;
    boolean inSet = false;
    public int EmptyObjects;
    int getclosure;
    int f_globals;
    int PyFunction_init;
    int PyFunction_closure_init;
    public int printResult;
    public int print1;
    public int print2;
    public int print3;
    public int print4;
    public int print5;
    public int print6;
    int yield_count = 0;
    int f_savedlocals;
    public int makeException0;
    public int makeException1;
    public int makeException2;
    public int makeException3;
    public int importOne;
    public int importOneAs;
    public int importAll;
    public int importFrom;
    public int exec;
    public int assert1;
    public int assert2;
    public int nonzero;
    public int iter = 0;
    public int iternext = 0;
    public int match_exception;
    public int add_traceback;
    public int set_exception;
    int[] compare_ops = new int[11];
    static String[] bin_methods = new String[]{null, "_add", "_sub", "_mul", "_div", "_mod", "_pow", "_lshift", "_rshift", "_or", "_xor", "_and", "_floordiv"};
    int[] bin_ops = new int[13];
    static String[] unary_methods = new String[]{null, "__invert__", "__not__", "__pos__", "__neg__"};
    int[] unary_ops = new int[unary_methods.length];
    static String[] aug_methods = new String[]{null, "__iadd__", "__isub__", "__imul__", "__idiv__", "__imod__", "__ipow__", "__ilshift__", "__irshift__", "__ior__", "__ixor__", "__iand__", "__ifloordiv__"};
    int[] augbin_ops = new int[aug_methods.length];
    public int invokea0;
    public int invokea1;
    public int invokea2;
    public int invoke2;
    public int callextra;
    public int call1;
    public int call2;
    public int calla0;
    public int calla1;
    public int calla2;
    public int calla3;
    public int calla4;
    public int getslice;
    public int setslice;
    public int delslice;
    public int getitem;
    public int delitem;
    public int setitem;
    public int getattr;
    public int delattr;
    public int setattr;
    public int getitem2;
    public int unpackSequence;
    public int PyTuple_init;
    public int PyList_init;
    public int PyDictionary_init;
    int list_comprehension_count = 0;
    public int PyList_init2;
    public int PyFunction_init1;
    public int PyFunction_closure_init1;
    public int Ellipsis;
    public int PySlice_init;
    public int makeClass;
    public int makeClass_closure;
    int getglobal;
    int getlocal1;
    int getlocal2;
    int setglobal;
    int setlocal1;
    int setlocal2;
    int delglobal;
    int dellocal1;
    int dellocal2;
    int getderef;
    int setderef;

    public CodeCompiler(Module module, boolean bl) {
        this.module = module;
        this.mrefs = this;
        this.pool = module.classfile.pool;
        this.continueLabels = new Stack();
        this.breakLabels = new Stack();
        this.finallyLabels = new Stack();
        this.inFinallyLabels = new Stack();
        this.print_results = bl;
    }

    public void getNone() throws IOException {
        if (this.mrefs.PyNone == 0) {
            this.mrefs.PyNone = this.pool.Fieldref("org/python/core/Py", "None", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.PyNone);
    }

    public void loadFrame() throws Exception {
        this.code.aload(1);
    }

    public void setLastI(int n) throws Exception {
        if (this.mrefs.f_lasti == 0) {
            this.mrefs.f_lasti = this.code.pool.Fieldref("org/python/core/PyFrame", "f_lasti", "I");
        }
        this.loadFrame();
        this.code.iconst(n);
        this.code.putfield(this.mrefs.f_lasti);
    }

    public int storeTop() throws Exception {
        int n = this.code.getLocal("org/python/core/PyObject");
        this.code.astore(n);
        return n;
    }

    public void setline(int n) throws Exception {
        if (this.module.linenumbers) {
            this.code.setline(n);
            this.loadFrame();
            this.code.iconst(n);
            if (this.mrefs.setline == 0) {
                this.mrefs.setline = this.pool.Methodref("org/python/core/PyFrame", "setline", "(I)V");
            }
            this.code.invokevirtual(this.mrefs.setline);
        }
    }

    public void setline(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode.beginLine);
    }

    public void set(SimpleNode simpleNode) throws Exception {
        int n = this.storeTop();
        this.set(simpleNode, n);
        this.code.aconst_null();
        this.code.astore(n);
        this.code.freeLocal(n);
    }

    public void set(SimpleNode simpleNode, int n) throws Exception {
        if (this.inSet) {
            System.out.println("recurse set: " + n + ", " + this.temporary);
        }
        this.temporary = n;
        this.visit(simpleNode);
    }

    private void saveAugTmps(SimpleNode simpleNode, int n) throws Exception {
        if (n >= 4) {
            this.augtmp4 = this.code.getLocal("org/python/core/PyObject");
            this.code.astore(this.augtmp4);
        }
        if (n >= 3) {
            this.augtmp3 = this.code.getLocal("org/python/core/PyObject");
            this.code.astore(this.augtmp3);
        }
        if (n >= 2) {
            this.augtmp2 = this.code.getLocal("org/python/core/PyObject");
            this.code.astore(this.augtmp2);
        }
        this.augtmp1 = this.code.getLocal("org/python/core/PyObject");
        this.code.astore(this.augtmp1);
        this.code.aload(this.augtmp1);
        if (n >= 2) {
            this.code.aload(this.augtmp2);
        }
        if (n >= 3) {
            this.code.aload(this.augtmp3);
        }
        if (n >= 4) {
            this.code.aload(this.augtmp4);
        }
    }

    private void restoreAugTmps(SimpleNode simpleNode, int n) throws Exception {
        this.code.aload(this.augtmp1);
        this.code.freeLocal(this.augtmp1);
        if (n == 1) {
            return;
        }
        this.code.aload(this.augtmp2);
        this.code.freeLocal(this.augtmp2);
        if (n == 2) {
            return;
        }
        this.code.aload(this.augtmp3);
        this.code.freeLocal(this.augtmp3);
        if (n == 3) {
            return;
        }
        this.code.aload(this.augtmp4);
        this.code.freeLocal(this.augtmp4);
    }

    public void parse(modType modType2, Code code, boolean bl, String string, boolean bl2, ScopeInfo scopeInfo, CompilerFlags compilerFlags) throws Exception {
        this.fast_locals = bl;
        this.className = string;
        this.code = code;
        this.cflags = compilerFlags;
        this.my_scope = scopeInfo;
        this.names = scopeInfo.names;
        this.tbl = scopeInfo.tbl;
        this.optimizeGlobals = bl && !scopeInfo.exec && !scopeInfo.from_import_star;
        Object object = this.visit(modType2);
        if (bl2) {
            this.loadFrame();
            code.invokevirtual("org/python/core/PyFrame", "getf_locals", "()Lorg/python/core/PyObject;");
            code.areturn();
        } else if (object == null) {
            this.setLastI(-1);
            this.getNone();
            code.areturn();
        }
    }

    public Object visitInteractive(Interactive interactive) throws Exception {
        this.traverse(interactive);
        return null;
    }

    public Object visitModule(org.python.parser.ast.Module module) throws Exception {
        if (this.mrefs.setglobal == 0) {
            this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        }
        if (module.body.length > 0 && module.body[0] instanceof Expr && ((Expr)module.body[0]).value instanceof Str) {
            this.loadFrame();
            this.code.ldc("__doc__");
            this.visit(((Expr)module.body[0]).value);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        if (this.module.setFile) {
            this.loadFrame();
            this.code.ldc("__file__");
            this.module.filename.get(this.code);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        this.traverse(module);
        return null;
    }

    public Object visitExpression(Expression expression) throws Exception {
        if (this.my_scope.generator && expression.body != null) {
            this.module.error("'return' with argument inside generator", true, expression);
        }
        return this.visitReturn(new Return(expression.body, expression), true);
    }

    public void makeArray(SimpleNode[] simpleNodeArray) throws Exception {
        int n = simpleNodeArray == null ? 0 : simpleNodeArray.length;
        if (n == 0) {
            if (this.mrefs.EmptyObjects == 0) {
                this.mrefs.EmptyObjects = this.code.pool.Fieldref("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
            }
            this.code.getstatic(this.mrefs.EmptyObjects);
        } else {
            int n2 = this.code.getLocal("[org/python/core/PyObject");
            this.code.iconst(n);
            this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
            this.code.astore(n2);
            for (int i = 0; i < n; ++i) {
                this.code.aload(n2);
                this.code.iconst(i);
                this.visit(simpleNodeArray[i]);
                this.code.aastore();
            }
            this.code.aload(n2);
            this.code.freeLocal(n2);
        }
    }

    public void getDocString(stmtType[] stmtTypeArray) throws Exception {
        if (stmtTypeArray.length > 0 && stmtTypeArray[0] instanceof Expr && ((Expr)stmtTypeArray[0]).value instanceof Str) {
            this.visit(((Expr)stmtTypeArray[0]).value);
        } else {
            this.code.aconst_null();
        }
    }

    public boolean makeClosure(Vector vector) throws Exception {
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        if (n == 0) {
            return false;
        }
        if (this.mrefs.getclosure == 0) {
            this.mrefs.getclosure = this.code.pool.Methodref("org/python/core/PyFrame", "getclosure", "(I)Lorg/python/core/PyObject;");
        }
        int n2 = this.code.getLocal("[org/python/core/PyObject");
        this.code.iconst(n);
        this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
        this.code.astore(n2);
        for (int i = 0; i < n; ++i) {
            this.code.aload(n2);
            this.code.iconst(i);
            this.code.aload(1);
            this.code.iconst(((SymInfo)this.tbl.get(vector.elementAt((int)i))).env_index);
            this.code.invokevirtual(this.getclosure);
            this.code.aastore();
        }
        this.code.aload(n2);
        this.code.freeLocal(n2);
        return true;
    }

    public Object visitFunctionDef(FunctionDef functionDef) throws Exception {
        String string = this.getName(functionDef.name);
        this.setline(functionDef);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        ScopeInfo scopeInfo = this.module.getScopeInfo(functionDef);
        this.makeArray(scopeInfo.ac.getDefaults());
        scopeInfo.setup_closure(this.my_scope);
        scopeInfo.dump();
        this.module.PyCode(new Suite(functionDef.body, functionDef), string, true, this.className, false, false, functionDef.beginLine, scopeInfo, this.cflags).get(this.code);
        Vector vector = scopeInfo.freevars;
        this.getDocString(functionDef.body);
        if (!this.makeClosure(vector)) {
            if (this.mrefs.PyFunction_init == 0) {
                this.mrefs.PyFunction_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init);
        } else {
            if (this.mrefs.PyFunction_closure_init == 0) {
                this.mrefs.PyFunction_closure_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init);
        }
        this.set(new Name(functionDef.name, 2, functionDef));
        return null;
    }

    public Object visitExpr(Expr expr) throws Exception {
        this.setline(expr);
        this.visit(expr.value);
        if (this.print_results) {
            if (this.mrefs.printResult == 0) {
                this.mrefs.printResult = this.code.pool.Methodref("org/python/core/Py", "printResult", "(Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.printResult);
        } else {
            this.code.pop();
        }
        return null;
    }

    public Object visitAssign(Assign assign) throws Exception {
        this.setline(assign);
        this.visit(assign.value);
        if (assign.targets.length == 1) {
            this.set(assign.targets[0]);
            return null;
        }
        int n = this.storeTop();
        for (int i = assign.targets.length - 1; i >= 0; --i) {
            this.set(assign.targets[i], n);
        }
        this.code.freeLocal(n);
        return null;
    }

    public Object visitPrint(Print print) throws Exception {
        int n;
        int n2;
        int n3;
        this.setline(print);
        int n4 = -1;
        if (print.dest != null) {
            this.visit(print.dest);
            n4 = this.storeTop();
            if (this.mrefs.print4 == 0) {
                this.mrefs.print4 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            n3 = this.mrefs.print4;
            if (this.mrefs.print5 == 0) {
                this.mrefs.print5 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            n2 = this.mrefs.print5;
            if (this.mrefs.print6 == 0) {
                this.mrefs.print6 = this.pool.Methodref("org/python/core/Py", "printlnv", "(Lorg/python/core/PyObject;)V");
            }
            n = this.mrefs.print6;
        } else {
            if (this.mrefs.print1 == 0) {
                this.mrefs.print1 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;)V");
            }
            n3 = this.mrefs.print1;
            if (this.mrefs.print2 == 0) {
                this.mrefs.print2 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;)V");
            }
            n2 = this.mrefs.print2;
            if (this.mrefs.print3 == 0) {
                this.mrefs.print3 = this.pool.Methodref("org/python/core/Py", "println", "()V");
            }
            n = this.mrefs.print3;
        }
        if (print.values == null || print.values.length == 0) {
            if (print.dest != null) {
                this.code.aload(n4);
            }
            this.code.invokestatic(n);
        } else {
            for (int i = 0; i < print.values.length; ++i) {
                if (print.dest != null) {
                    this.code.aload(n4);
                }
                this.visit(print.values[i]);
                if (print.nl && i == print.values.length - 1) {
                    this.code.invokestatic(n2);
                    continue;
                }
                this.code.invokestatic(n3);
            }
        }
        if (print.dest != null) {
            this.code.freeLocal(n4);
        }
        return null;
    }

    public Object visitDelete(Delete delete) throws Exception {
        this.setline(delete);
        this.traverse(delete);
        return null;
    }

    public Object visitPass(Pass pass) throws Exception {
        this.setline(pass);
        return null;
    }

    public Object visitBreak(Break break_) throws Exception {
        if (this.breakLabels.empty()) {
            throw new ParseException("'break' outside loop", break_);
        }
        for (int i = this.finallyLabels.size() - 1; i >= this.bcfLevel; --i) {
            this.doFinallyPart((InFinally)this.finallyLabels.elementAt(i));
        }
        this.code.goto_((Label)this.breakLabels.peek());
        return null;
    }

    public Object visitContinue(Continue continue_) throws Exception {
        if (this.continueLabels.empty()) {
            throw new ParseException("'continue' not properly in loop", continue_);
        }
        for (int i = this.finallyLabels.size() - 1; i >= this.bcfLevel; --i) {
            this.doFinallyPart((InFinally)this.finallyLabels.elementAt(i));
        }
        this.code.goto_((Label)this.continueLabels.peek());
        return Exit;
    }

    public Object visitYield(Yield yield) throws Exception {
        this.setline(yield);
        if (!this.fast_locals) {
            throw new ParseException("'yield' outside function", yield);
        }
        if (!this.finallyLabels.empty()) {
            throw new ParseException("'yield' not allowed in a 'try' block with a 'finally' clause", yield);
        }
        InFinally inFinally = null;
        if (this.inFinallyLabels.size() > 0) {
            inFinally = (InFinally)this.inFinallyLabels.peek();
        }
        if (inFinally == null) {
            this.saveLocals();
            this.visit(yield.value);
            this.setLastI(++this.yield_count);
            this.code.areturn();
            Label label = this.code.getLabel();
            this.yields.addElement(label);
            label.setPosition();
            this.restoreLocals();
        } else {
            this.saveLocals();
            this.visit(yield.value);
            this.code.areturn();
            this.code.ret(inFinally.retLocal);
            inFinally.labels[inFinally.cnt++].setPosition();
            this.code.stack = 1;
            this.code.astore(inFinally.retLocal);
            this.restoreLocals();
        }
        return null;
    }

    private void restoreLocals() throws Exception {
        Vector vector = this.code.getActiveLocals();
        this.loadFrame();
        if (this.mrefs.f_savedlocals == 0) {
            this.mrefs.f_savedlocals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_savedlocals", "[Ljava/lang/Object;");
        }
        this.code.getfield(this.mrefs.f_savedlocals);
        int n = this.code.getLocal("[java/lang/Object");
        this.code.astore(n);
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string == null) continue;
            this.code.aload(n);
            this.code.iconst(i);
            this.code.aaload();
            this.code.checkcast(this.code.pool.Class(string));
            this.code.astore(i);
        }
        this.code.freeLocal(n);
    }

    private void saveLocals() throws Exception {
        Vector vector = this.code.getActiveLocals();
        this.code.iconst(vector.size());
        this.code.anewarray(this.code.pool.Class("java/lang/Object"));
        int n = this.code.getLocal("[java/lang/Object");
        this.code.astore(n);
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string == null) continue;
            this.code.aload(n);
            this.code.iconst(i);
            if (i == 2222) {
                this.code.aconst_null();
            } else {
                this.code.aload(i);
            }
            this.code.aastore();
        }
        if (this.mrefs.f_savedlocals == 0) {
            this.mrefs.f_savedlocals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_savedlocals", "[Ljava/lang/Object;");
        }
        this.loadFrame();
        this.code.aload(n);
        this.code.putfield(this.mrefs.f_savedlocals);
        this.code.freeLocal(n);
    }

    public Object visitReturn(Return return_) throws Exception {
        return this.visitReturn(return_, false);
    }

    public Object visitReturn(Return return_, boolean bl) throws Exception {
        this.setline(return_);
        if (!bl && !this.fast_locals) {
            throw new ParseException("'return' outside function", return_);
        }
        int n = 0;
        if (return_.value != null) {
            if (this.my_scope.generator) {
                throw new ParseException("'return' with argument inside generator", return_);
            }
            this.visit(return_.value);
            n = this.code.getReturnLocal();
            this.code.astore(n);
        }
        for (int i = this.finallyLabels.size() - 1; i >= 0; --i) {
            this.doFinallyPart((InFinally)this.finallyLabels.elementAt(i));
        }
        this.setLastI(-1);
        if (return_.value != null) {
            this.code.aload(n);
        } else {
            this.getNone();
        }
        this.code.areturn();
        return Exit;
    }

    public Object visitRaise(Raise raise) throws Exception {
        this.setline(raise);
        this.traverse(raise);
        if (raise.type == null) {
            if (this.mrefs.makeException0 == 0) {
                this.mrefs.makeException0 = this.code.pool.Methodref("org/python/core/Py", "makeException", "()Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException0);
        } else if (raise.inst == null) {
            if (this.mrefs.makeException1 == 0) {
                this.mrefs.makeException1 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException1);
        } else if (raise.tback == null) {
            if (this.mrefs.makeException2 == 0) {
                this.mrefs.makeException2 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException2);
        } else {
            if (this.mrefs.makeException3 == 0) {
                this.mrefs.makeException3 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException3);
        }
        this.code.athrow();
        return Exit;
    }

    public Object visitImport(Import import_) throws Exception {
        this.setline(import_);
        for (int i = 0; i < import_.names.length; ++i) {
            String string;
            String string2 = null;
            if (import_.names[i].asname != null) {
                string = import_.names[i].name;
                string2 = import_.names[i].asname;
                this.code.ldc(string);
                this.loadFrame();
                if (this.mrefs.importOneAs == 0) {
                    this.mrefs.importOneAs = this.code.pool.Methodref("org/python/core/imp", "importOneAs", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOneAs);
            } else {
                string = import_.names[i].name;
                string2 = string;
                if (string2.indexOf(46) > 0) {
                    string2 = string2.substring(0, string2.indexOf(46));
                }
                this.code.ldc(string);
                this.loadFrame();
                if (this.mrefs.importOne == 0) {
                    this.mrefs.importOne = this.code.pool.Methodref("org/python/core/imp", "importOne", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOne);
            }
            this.set(new Name(string2, 2, import_));
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom importFrom) throws Exception {
        Future.checkFromFuture(importFrom);
        this.setline(importFrom);
        this.code.ldc(importFrom.module);
        if (importFrom.names.length > 0) {
            int n;
            String[] stringArray = new String[importFrom.names.length];
            String[] stringArray2 = new String[importFrom.names.length];
            for (n = 0; n < importFrom.names.length; ++n) {
                stringArray[n] = importFrom.names[n].name;
                stringArray2[n] = importFrom.names[n].asname;
                if (stringArray2[n] != null) continue;
                stringArray2[n] = stringArray[n];
            }
            CodeCompiler.makeStrings(this.code, stringArray, stringArray.length);
            this.loadFrame();
            if (this.mrefs.importFrom == 0) {
                this.mrefs.importFrom = this.code.pool.Methodref("org/python/core/imp", "importFrom", "(Ljava/lang/String;[Ljava/lang/String;Lorg/python/core/PyFrame;)[Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.importFrom);
            n = this.storeTop();
            for (int i = 0; i < importFrom.names.length; ++i) {
                this.code.aload(n);
                this.code.iconst(i);
                this.code.aaload();
                this.set(new Name(stringArray2[i], 2, importFrom));
            }
            this.code.freeLocal(n);
        } else {
            this.loadFrame();
            if (this.mrefs.importAll == 0) {
                this.mrefs.importAll = this.code.pool.Methodref("org/python/core/imp", "importAll", "(Ljava/lang/String;Lorg/python/core/PyFrame;)V");
            }
            this.code.invokestatic(this.mrefs.importAll);
        }
        return null;
    }

    public Object visitGlobal(Global global) throws Exception {
        return null;
    }

    public Object visitExec(Exec exec) throws Exception {
        this.setline(exec);
        this.visit(exec.body);
        if (exec.globals != null) {
            this.visit(exec.globals);
        } else {
            this.code.aconst_null();
        }
        if (exec.locals != null) {
            this.visit(exec.locals);
        } else {
            this.code.aconst_null();
        }
        if (this.mrefs.exec == 0) {
            this.mrefs.exec = this.code.pool.Methodref("org/python/core/Py", "exec", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokestatic(this.mrefs.exec);
        return null;
    }

    public Object visitAssert(Assert assert_) throws Exception {
        this.setline(assert_);
        Label label = this.code.getLabel();
        this.loadFrame();
        this.emitGetGlobal("__debug__");
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(label);
        this.visit(assert_.test);
        if (assert_.msg != null) {
            this.visit(assert_.msg);
            if (this.mrefs.assert2 == 0) {
                this.mrefs.assert2 = this.code.pool.Methodref("org/python/core/Py", "assert_", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.assert2);
        } else {
            if (this.mrefs.assert1 == 0) {
                this.mrefs.assert1 = this.code.pool.Methodref("org/python/core/Py", "assert_", "(Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.assert1);
        }
        label.setPosition();
        return null;
    }

    public Object doTest(Label label, If if_, int n) throws Exception {
        Label label2 = this.code.getLabel();
        this.setline(if_.test);
        this.visit(if_.test);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(label2);
        Object object = this.suite(if_.body);
        if (label != null && object == null) {
            this.code.goto_(label);
        }
        label2.setPosition();
        if (if_.orelse != null) {
            return this.suite(if_.orelse) != null ? object : null;
        }
        return null;
    }

    public Object visitIf(If if_) throws Exception {
        Label label = null;
        if (if_.orelse != null) {
            label = this.code.getLabel();
        }
        Object object = this.doTest(label, if_, 0);
        if (label != null) {
            label.setPosition();
        }
        return object;
    }

    public int beginLoop() {
        this.continueLabels.push(this.code.getLabel());
        this.breakLabels.push(this.code.getLabel());
        int n = this.bcfLevel;
        this.bcfLevel = this.finallyLabels.size();
        return n;
    }

    public void finishLoop(int n) {
        this.continueLabels.pop();
        this.breakLabels.pop();
        this.bcfLevel = n;
    }

    public Object visitWhile(While while_) throws Exception {
        int n = this.beginLoop();
        Label label = (Label)this.continueLabels.peek();
        Label label2 = (Label)this.breakLabels.peek();
        Label label3 = this.code.getLabel();
        this.code.goto_(label);
        label3.setPosition();
        this.suite(while_.body);
        label.setPosition();
        this.setline(while_);
        this.visit(while_.test);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifne(label3);
        this.finishLoop(n);
        if (while_.orelse != null) {
            this.suite(while_.orelse);
        }
        label2.setPosition();
        return null;
    }

    public Object visitFor(For for_) throws Exception {
        int n = this.beginLoop();
        Label label = (Label)this.continueLabels.peek();
        Label label2 = (Label)this.breakLabels.peek();
        Label label3 = this.code.getLabel();
        Label label4 = this.code.getLabel();
        int n2 = this.code.getLocal("org/python/core/PyObject");
        int n3 = this.code.getLocal("org/python/core/PyObject");
        this.setline(for_);
        this.visit(for_.iter);
        if (this.mrefs.iter == 0) {
            this.mrefs.iter = this.code.pool.Methodref("org/python/core/PyObject", "__iter__", "()Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.iter);
        this.code.astore(n2);
        this.code.goto_(label4);
        label3.setPosition();
        this.set(for_.target, n3);
        this.suite(for_.body);
        label.setPosition();
        label4.setPosition();
        this.setline(for_);
        this.code.aload(n2);
        if (this.mrefs.iternext == 0) {
            this.mrefs.iternext = this.code.pool.Methodref("org/python/core/PyObject", "__iternext__", "()Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.iternext);
        this.code.astore(n3);
        this.code.aload(n3);
        this.code.ifnonnull(label3);
        this.finishLoop(n);
        if (for_.orelse != null) {
            this.suite(for_.orelse);
        }
        label2.setPosition();
        this.code.freeLocal(n2);
        this.code.freeLocal(n3);
        return null;
    }

    public void exceptionTest(int n, Label label, TryExcept tryExcept, int n2) throws Exception {
        for (int i = 0; i < tryExcept.handlers.length; ++i) {
            excepthandlerType excepthandlerType2 = tryExcept.handlers[i];
            Label label2 = this.code.getLabel();
            if (excepthandlerType2.type != null) {
                this.code.aload(n);
                this.visit(excepthandlerType2.type);
                if (this.mrefs.match_exception == 0) {
                    this.mrefs.match_exception = this.code.pool.Methodref("org/python/core/Py", "matchException", "(Lorg/python/core/PyException;Lorg/python/core/PyObject;)Z");
                }
                this.code.invokestatic(this.mrefs.match_exception);
                this.code.ifeq(label2);
            } else if (i != tryExcept.handlers.length - 1) {
                throw new ParseException("bare except must be last except clause", excepthandlerType2.type);
            }
            if (excepthandlerType2.name != null) {
                this.code.aload(n);
                this.code.getfield(this.code.pool.Fieldref("org/python/core/PyException", "value", "Lorg/python/core/PyObject;"));
                this.set(excepthandlerType2.name);
            }
            this.suite(excepthandlerType2.body);
            this.code.goto_(label);
            label2.setPosition();
        }
        this.code.aload(n);
        this.code.athrow();
    }

    public Object visitTryFinally(TryFinally tryFinally) throws Exception {
        Object object;
        Label label = this.code.getLabel();
        Label label2 = this.code.getLabel();
        Label label3 = this.code.getLabel();
        Label label4 = this.code.getLabel();
        Label label5 = this.code.getLabel();
        int n = 0;
        if (this.my_scope.generator) {
            object = new YieldChecker();
            ((Visitor)object).visit(tryFinally.finalbody);
            n = ((YieldChecker)object).yieldCount;
        }
        if (n > 0) {
            throw new ParseException("'yield' in finally not yet supported", tryFinally);
        }
        object = new InFinally(n + 1);
        this.finallyLabels.push(object);
        int n2 = this.code.getLocal("java/lang/Throwable");
        this.code.aconst_null();
        this.code.astore(n2);
        label.setPosition();
        Object object2 = this.suite(tryFinally.body);
        label2.setPosition();
        if (object2 == null) {
            this.doFinallyPart((InFinally)object);
            this.code.goto_(label4);
        }
        this.finallyLabels.pop();
        label3.setPosition();
        this.code.stack = 1;
        this.code.astore(n2);
        this.code.aload(n2);
        this.loadFrame();
        if (this.mrefs.add_traceback == 0) {
            this.mrefs.add_traceback = this.code.pool.Methodref("org/python/core/Py", "addTraceback", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)V");
        }
        this.code.invokestatic(this.mrefs.add_traceback);
        this.doFinallyPart((InFinally)object);
        this.code.aload(n2);
        this.code.checkcast(this.code.pool.Class("java/lang/Throwable"));
        this.code.athrow();
        ((InFinally)object).labels[0].setPosition();
        this.code.stack = 1;
        ((InFinally)object).retLocal = this.code.getFinallyLocal("ret");
        this.code.astore(((InFinally)object).retLocal);
        this.inFinallyLabels.push(object);
        object2 = this.suite(tryFinally.finalbody);
        this.inFinallyLabels.pop();
        this.code.ret(((InFinally)object).retLocal);
        this.code.freeFinallyLocal(((InFinally)object).retLocal);
        label4.setPosition();
        this.code.freeLocal(n2);
        this.code.addExceptionHandler(label, label2, label3, this.code.pool.Class("java/lang/Throwable"));
        return null;
    }

    private void doFinallyPart(InFinally inFinally) throws Exception {
        if (inFinally.labels.length == 1) {
            this.code.jsr(inFinally.labels[0]);
        } else {
            Label label = this.code.getLabel();
            for (int i = 0; i < inFinally.labels.length; ++i) {
                this.setLastI(++this.yield_count);
                this.code.jsr(inFinally.labels[i]);
                if (i >= inFinally.labels.length - 1) continue;
                this.code.goto_(label);
                Label label2 = this.code.getLabel();
                this.yields.addElement(label2);
                label2.setPosition();
            }
            label.setPosition();
        }
    }

    public Object visitTryExcept(TryExcept tryExcept) throws Exception {
        Label label = this.code.getLabel();
        Label label2 = this.code.getLabel();
        Label label3 = this.code.getLabel();
        Label label4 = this.code.getLabel();
        label.setPosition();
        Object object = this.suite(tryExcept.body);
        label2.setPosition();
        if (object == null) {
            this.code.goto_(label4);
        }
        label3.setPosition();
        this.code.stack = 1;
        this.loadFrame();
        if (this.mrefs.set_exception == 0) {
            this.mrefs.set_exception = this.code.pool.Methodref("org/python/core/Py", "setException", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)Lorg/python/core/PyException;");
        }
        this.code.invokestatic(this.mrefs.set_exception);
        int n = this.code.getFinallyLocal("java/lang/Throwable");
        this.code.astore(n);
        if (tryExcept.orelse == null) {
            this.exceptionTest(n, label4, tryExcept, 1);
            label4.setPosition();
        } else {
            Label label5 = this.code.getLabel();
            this.exceptionTest(n, label5, tryExcept, 1);
            label4.setPosition();
            this.suite(tryExcept.orelse);
            label5.setPosition();
        }
        this.code.freeFinallyLocal(n);
        this.code.addExceptionHandler(label, label2, label3, this.code.pool.Class("java/lang/Throwable"));
        return null;
    }

    public Object visitSuite(Suite suite) throws Exception {
        return this.suite(suite.body);
    }

    public Object suite(stmtType[] stmtTypeArray) throws Exception {
        int n = stmtTypeArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.visit(stmtTypeArray[i]);
            if (object == null) continue;
            return Exit;
        }
        return null;
    }

    public Object visitBoolOp(BoolOp boolOp) throws Exception {
        Label label = this.code.getLabel();
        this.visit(boolOp.values[0]);
        for (int i = 1; i < boolOp.values.length; ++i) {
            this.code.dup();
            if (this.mrefs.nonzero == 0) {
                this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
            }
            this.code.invokevirtual(this.mrefs.nonzero);
            switch (boolOp.op) {
                case 2: {
                    this.code.ifne(label);
                    break;
                }
                case 1: {
                    this.code.ifeq(label);
                }
            }
            this.code.pop();
            this.visit(boolOp.values[i]);
        }
        label.setPosition();
        return null;
    }

    public Object visitCompare(Compare compare) throws Exception {
        int n = this.code.getLocal("org/python/core/PyObject");
        int n2 = this.code.getLocal("org/python/core/PyObject");
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        Label label = this.code.getLabel();
        this.visit(compare.left);
        int n3 = compare.ops.length;
        for (int i = 0; i < n3 - 1; ++i) {
            this.visit(compare.comparators[i]);
            this.code.dup();
            this.code.astore(n);
            this.code.invokevirtual(this.make_cmpop(compare.ops[i]));
            this.code.dup();
            this.code.astore(n2);
            this.code.invokevirtual(this.mrefs.nonzero);
            this.code.ifeq(label);
            this.code.aload(n);
        }
        this.visit(compare.comparators[n3 - 1]);
        this.code.invokevirtual(this.make_cmpop(compare.ops[n3 - 1]));
        if (n3 > 1) {
            this.code.astore(n2);
            label.setPosition();
            this.code.aload(n2);
        }
        this.code.freeLocal(n);
        this.code.freeLocal(n2);
        return null;
    }

    public int make_cmpop(int n) throws Exception {
        if (this.compare_ops[n] == 0) {
            String string = null;
            switch (n) {
                case 1: {
                    string = "_eq";
                    break;
                }
                case 2: {
                    string = "_ne";
                    break;
                }
                case 3: {
                    string = "_lt";
                    break;
                }
                case 4: {
                    string = "_le";
                    break;
                }
                case 5: {
                    string = "_gt";
                    break;
                }
                case 6: {
                    string = "_ge";
                    break;
                }
                case 7: {
                    string = "_is";
                    break;
                }
                case 8: {
                    string = "_isnot";
                    break;
                }
                case 9: {
                    string = "_in";
                    break;
                }
                case 10: {
                    string = "_notin";
                }
            }
            this.compare_ops[n] = this.code.pool.Methodref("org/python/core/PyObject", string, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        }
        return this.compare_ops[n];
    }

    public int make_binop(int n) throws Exception {
        if (this.bin_ops[n] == 0) {
            String string = bin_methods[n];
            if (n == 4 && this.module.getFutures().areDivisionOn()) {
                string = "_truediv";
            }
            this.bin_ops[n] = this.code.pool.Methodref("org/python/core/PyObject", string, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        }
        return this.bin_ops[n];
    }

    public Object visitBinOp(BinOp binOp) throws Exception {
        this.visit(binOp.left);
        this.visit(binOp.right);
        this.code.invokevirtual(this.make_binop(binOp.op));
        return null;
    }

    public int make_unaryop(int n) throws Exception {
        if (this.unary_ops[n] == 0) {
            String string = unary_methods[n];
            this.unary_ops[n] = this.code.pool.Methodref("org/python/core/PyObject", string, "()Lorg/python/core/PyObject;");
        }
        return this.unary_ops[n];
    }

    public Object visitUnaryOp(UnaryOp unaryOp) throws Exception {
        this.visit(unaryOp.operand);
        this.code.invokevirtual(this.make_unaryop(unaryOp.op));
        return null;
    }

    public int make_augbinop(int n) throws Exception {
        if (this.augbin_ops[n] == 0) {
            String string = aug_methods[n];
            if (n == 4 && this.module.getFutures().areDivisionOn()) {
                string = "__itruediv__";
            }
            this.augbin_ops[n] = this.code.pool.Methodref("org/python/core/PyObject", string, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        }
        return this.augbin_ops[n];
    }

    public Object visitAugAssign(AugAssign augAssign) throws Exception {
        this.visit(augAssign.value);
        int n = this.storeTop();
        this.augmode = 1;
        this.visit(augAssign.target);
        this.code.aload(n);
        this.code.invokevirtual(this.make_augbinop(augAssign.op));
        this.code.freeLocal(n);
        this.temporary = this.storeTop();
        this.augmode = 2;
        this.visit(augAssign.target);
        this.code.freeLocal(this.temporary);
        return null;
    }

    public static void makeStrings(Code code, String[] stringArray, int n) throws IOException {
        code.iconst(n);
        code.anewarray(code.pool.Class("java/lang/String"));
        int n2 = code.getLocal("[java/lang/String");
        code.astore(n2);
        for (int i = 0; i < n; ++i) {
            code.aload(n2);
            code.iconst(i);
            code.ldc(stringArray[i]);
            code.aastore();
        }
        code.aload(n2);
        code.freeLocal(n2);
    }

    public Object Invoke(Attribute attribute, SimpleNode[] simpleNodeArray) throws Exception {
        String string = this.getName(attribute.attr);
        this.visit(attribute.value);
        this.code.ldc(string);
        switch (simpleNodeArray.length) {
            case 0: {
                if (this.mrefs.invokea0 == 0) {
                    this.mrefs.invokea0 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invokea0);
                break;
            }
            case 1: {
                if (this.mrefs.invokea1 == 0) {
                    this.mrefs.invokea1 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.visit(simpleNodeArray[0]);
                this.code.invokevirtual(this.mrefs.invokea1);
                break;
            }
            case 2: {
                if (this.mrefs.invokea2 == 0) {
                    this.mrefs.invokea2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.visit(simpleNodeArray[0]);
                this.visit(simpleNodeArray[1]);
                this.code.invokevirtual(this.mrefs.invokea2);
                break;
            }
            default: {
                this.makeArray(simpleNodeArray);
                if (this.mrefs.invoke2 == 0) {
                    this.mrefs.invoke2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invoke2);
            }
        }
        return null;
    }

    public Object visitCall(Call call) throws Exception {
        int n;
        String[] stringArray = new String[call.keywords.length];
        SimpleNode[] simpleNodeArray = new exprType[call.args.length + stringArray.length];
        for (n = 0; n < call.args.length; ++n) {
            simpleNodeArray[n] = call.args[n];
        }
        for (n = 0; n < call.keywords.length; ++n) {
            stringArray[n] = call.keywords[n].arg;
            simpleNodeArray[call.args.length + n] = call.keywords[n].value;
        }
        if (call.keywords == null && call.starargs == null && call.kwargs == null && call.func instanceof Attribute) {
            return this.Invoke((Attribute)call.func, simpleNodeArray);
        }
        this.visit(call.func);
        if (call.starargs != null || call.kwargs != null) {
            this.makeArray(simpleNodeArray);
            CodeCompiler.makeStrings(this.code, stringArray, stringArray.length);
            if (call.starargs == null) {
                this.code.aconst_null();
            } else {
                this.visit(call.starargs);
            }
            if (call.kwargs == null) {
                this.code.aconst_null();
            } else {
                this.visit(call.kwargs);
            }
            if (this.mrefs.callextra == 0) {
                this.mrefs.callextra = this.code.pool.Methodref("org/python/core/PyObject", "_callextra", "([Lorg/python/core/PyObject;[Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.callextra);
        } else if (stringArray.length > 0) {
            this.makeArray(simpleNodeArray);
            CodeCompiler.makeStrings(this.code, stringArray, stringArray.length);
            if (this.mrefs.call1 == 0) {
                this.mrefs.call1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;[Ljava/lang/String;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.call1);
        } else {
            switch (simpleNodeArray.length) {
                case 0: {
                    if (this.mrefs.calla0 == 0) {
                        this.mrefs.calla0 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "()Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.calla0);
                    break;
                }
                case 1: {
                    if (this.mrefs.calla1 == 0) {
                        this.mrefs.calla1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(simpleNodeArray[0]);
                    this.code.invokevirtual(this.mrefs.calla1);
                    break;
                }
                case 2: {
                    if (this.mrefs.calla2 == 0) {
                        this.mrefs.calla2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(simpleNodeArray[0]);
                    this.visit(simpleNodeArray[1]);
                    this.code.invokevirtual(this.mrefs.calla2);
                    break;
                }
                case 3: {
                    if (this.mrefs.calla3 == 0) {
                        this.mrefs.calla3 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(simpleNodeArray[0]);
                    this.visit(simpleNodeArray[1]);
                    this.visit(simpleNodeArray[2]);
                    this.code.invokevirtual(this.mrefs.calla3);
                    break;
                }
                case 4: {
                    if (this.mrefs.calla4 == 0) {
                        this.mrefs.calla4 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(simpleNodeArray[0]);
                    this.visit(simpleNodeArray[1]);
                    this.visit(simpleNodeArray[2]);
                    this.visit(simpleNodeArray[3]);
                    this.code.invokevirtual(this.mrefs.calla4);
                    break;
                }
                default: {
                    this.makeArray(simpleNodeArray);
                    if (this.mrefs.call2 == 0) {
                        this.mrefs.call2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.call2);
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object Slice(Subscript var1_1, Slice var2_2) throws Exception {
        var3_3 = var1_1.ctx;
        if (var3_3 != 5) ** GOTO lbl-1000
        if (this.augmode == 2) {
            this.restoreAugTmps(var1_1, 4);
            var3_3 = 2;
        } else lbl-1000:
        // 2 sources

        {
            this.visit(var1_1.value);
            if (var2_2.lower != null) {
                this.visit(var2_2.lower);
            } else {
                this.code.aconst_null();
            }
            if (var2_2.upper != null) {
                this.visit(var2_2.upper);
            } else {
                this.code.aconst_null();
            }
            if (var2_2.step != null) {
                this.visit(var2_2.step);
            } else {
                this.code.aconst_null();
            }
            if (var1_1.ctx == 5) {
                if (this.augmode == 1) {
                    this.saveAugTmps(var1_1, 4);
                    var3_3 = 1;
                }
            }
        }
        switch (var3_3) {
            case 3: {
                if (this.mrefs.delslice == 0) {
                    this.mrefs.delslice = this.code.pool.Methodref("org/python/core/PyObject", "__delslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delslice);
                return null;
            }
            case 1: {
                if (this.mrefs.getslice == 0) {
                    this.mrefs.getslice = this.code.pool.Methodref("org/python/core/PyObject", "__getslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getslice);
                return null;
            }
            case 2: {
                this.code.aload(this.temporary);
                if (this.mrefs.setslice == 0) {
                    this.mrefs.setslice = this.code.pool.Methodref("org/python/core/PyObject", "__setslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setslice);
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitSubscript(Subscript var1_1) throws Exception {
        if (var1_1.slice instanceof Slice) {
            return this.Slice(var1_1, (Slice)var1_1.slice);
        }
        var2_2 = var1_1.ctx;
        if (var1_1.ctx != 5) ** GOTO lbl-1000
        if (this.augmode == 2) {
            this.restoreAugTmps(var1_1, 2);
            var2_2 = 2;
        } else lbl-1000:
        // 2 sources

        {
            this.visit(var1_1.value);
            this.visit(var1_1.slice);
            if (var1_1.ctx == 5) {
                if (this.augmode == 1) {
                    this.saveAugTmps(var1_1, 2);
                    var2_2 = 1;
                }
            }
        }
        switch (var2_2) {
            case 3: {
                if (this.mrefs.delitem == 0) {
                    this.mrefs.delitem = this.code.pool.Methodref("org/python/core/PyObject", "__delitem__", "(Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delitem);
                return null;
            }
            case 1: {
                if (this.mrefs.getitem == 0) {
                    this.mrefs.getitem = this.code.pool.Methodref("org/python/core/PyObject", "__getitem__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getitem);
                return null;
            }
            case 2: {
                this.code.aload(this.temporary);
                if (this.mrefs.setitem == 0) {
                    this.mrefs.setitem = this.code.pool.Methodref("org/python/core/PyObject", "__setitem__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setitem);
                return null;
            }
        }
        return null;
    }

    public Object visitIndex(Index index) throws Exception {
        this.traverse(index);
        return null;
    }

    public Object visitExtSlice(ExtSlice extSlice) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyTuple"));
        this.code.dup();
        this.makeArray(extSlice.dims);
        if (this.mrefs.PyTuple_init == 0) {
            this.mrefs.PyTuple_init = this.code.pool.Methodref("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyTuple_init);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAttribute(Attribute var1_1) throws Exception {
        var2_2 = var1_1.ctx;
        if (var1_1.ctx != 5) ** GOTO lbl-1000
        if (this.augmode == 2) {
            this.restoreAugTmps(var1_1, 2);
            var2_2 = 2;
        } else lbl-1000:
        // 2 sources

        {
            this.visit(var1_1.value);
            this.code.ldc(this.getName(var1_1.attr));
            if (var1_1.ctx == 5) {
                if (this.augmode == 1) {
                    this.saveAugTmps(var1_1, 2);
                    var2_2 = 1;
                }
            }
        }
        switch (var2_2) {
            case 3: {
                if (this.mrefs.delattr == 0) {
                    this.mrefs.delattr = this.code.pool.Methodref("org/python/core/PyObject", "__delattr__", "(Ljava/lang/String;)V");
                }
                this.code.invokevirtual(this.mrefs.delattr);
                return null;
            }
            case 1: {
                if (this.mrefs.getattr == 0) {
                    this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getattr);
                return null;
            }
            case 2: {
                this.code.aload(this.temporary);
                if (this.mrefs.setattr == 0) {
                    this.mrefs.setattr = this.code.pool.Methodref("org/python/core/PyObject", "__setattr__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setattr);
                return null;
            }
        }
        return null;
    }

    public Object seqSet(exprType[] exprTypeArray) throws Exception {
        if (this.mrefs.unpackSequence == 0) {
            this.mrefs.unpackSequence = this.code.pool.Methodref("org/python/core/Py", "unpackSequence", "(Lorg/python/core/PyObject;I)[Lorg/python/core/PyObject;");
        }
        this.code.aload(this.temporary);
        this.code.iconst(exprTypeArray.length);
        this.code.invokestatic(this.mrefs.unpackSequence);
        int n = this.code.getLocal("[org/python/core/PyObject");
        this.code.astore(n);
        for (int i = 0; i < exprTypeArray.length; ++i) {
            this.code.aload(n);
            this.code.iconst(i);
            this.code.aaload();
            this.set(exprTypeArray[i]);
        }
        this.code.freeLocal(n);
        return null;
    }

    public Object seqDel(exprType[] exprTypeArray) throws Exception {
        for (int i = 0; i < exprTypeArray.length; ++i) {
            this.visit(exprTypeArray[i]);
        }
        return null;
    }

    public Object visitTuple(Tuple tuple) throws Exception {
        if (tuple.ctx == 2) {
            return this.seqSet(tuple.elts);
        }
        if (tuple.ctx == 3) {
            return this.seqDel(tuple.elts);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyTuple"));
        this.code.dup();
        this.makeArray(tuple.elts);
        if (this.mrefs.PyTuple_init == 0) {
            this.mrefs.PyTuple_init = this.code.pool.Methodref("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyTuple_init);
        return null;
    }

    public Object visitList(List list) throws Exception {
        if (list.ctx == 2) {
            return this.seqSet(list.elts);
        }
        if (list.ctx == 3) {
            return this.seqDel(list.elts);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        this.makeArray(list.elts);
        if (this.mrefs.PyList_init == 0) {
            this.mrefs.PyList_init = this.code.pool.Methodref("org/python/core/PyList", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyList_init);
        return null;
    }

    public Object visitListComp(ListComp listComp) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        if (this.mrefs.PyList_init2 == 0) {
            this.mrefs.PyList_init2 = this.code.pool.Methodref("org/python/core/PyList", "<init>", "()V");
        }
        this.code.invokespecial(this.mrefs.PyList_init2);
        this.code.dup();
        this.code.ldc("append");
        if (this.mrefs.getattr == 0) {
            this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getattr);
        String string = "_[" + ++this.list_comprehension_count + "]";
        this.set(new Name(string, 2, listComp));
        stmtType stmtType2 = new Expr(new Call(new Name(string, 1, listComp), new exprType[]{listComp.elt}, new keywordType[0], null, null, listComp), listComp);
        for (int i = listComp.generators.length - 1; i >= 0; --i) {
            listcompType listcompType2 = listComp.generators[i];
            for (int j = listcompType2.ifs.length - 1; j >= 0; --j) {
                stmtType2 = new If(listcompType2.ifs[j], new stmtType[]{stmtType2}, null, listcompType2.ifs[j]);
            }
            stmtType2 = new For(listcompType2.target, listcompType2.iter, new stmtType[]{stmtType2}, null, listcompType2);
        }
        this.visit(stmtType2);
        this.visit(new Delete(new exprType[]{new Name(string, 3)}));
        return null;
    }

    public Object visitDict(Dict dict) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyDictionary"));
        this.code.dup();
        SimpleNode[] simpleNodeArray = new SimpleNode[dict.keys.length * 2];
        for (int i = 0; i < dict.keys.length; ++i) {
            simpleNodeArray[i * 2] = dict.keys[i];
            simpleNodeArray[i * 2 + 1] = dict.values[i];
        }
        this.makeArray(simpleNodeArray);
        if (this.mrefs.PyDictionary_init == 0) {
            this.mrefs.PyDictionary_init = this.code.pool.Methodref("org/python/core/PyDictionary", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyDictionary_init);
        return null;
    }

    public Object visitRepr(Repr repr) throws Exception {
        this.visit(repr.value);
        this.code.invokevirtual("org/python/core/PyObject", "__repr__", "()Lorg/python/core/PyString;");
        return null;
    }

    public Object visitLambda(Lambda lambda) throws Exception {
        String string = "<lambda>";
        Suite suite = new Suite(new stmtType[]{new Return(lambda.body, lambda)}, lambda);
        this.setline(lambda);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        ScopeInfo scopeInfo = this.module.getScopeInfo(lambda);
        this.makeArray(scopeInfo.ac.getDefaults());
        scopeInfo.setup_closure(this.my_scope);
        scopeInfo.dump();
        this.module.PyCode(suite, string, true, this.className, false, false, lambda.beginLine, scopeInfo).get(this.code);
        Vector vector = scopeInfo.freevars;
        if (!this.makeClosure(vector)) {
            if (this.mrefs.PyFunction_init1 == 0) {
                this.mrefs.PyFunction_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init1);
        } else {
            if (this.mrefs.PyFunction_closure_init1 == 0) {
                this.mrefs.PyFunction_closure_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init1);
        }
        return null;
    }

    public Object visitEllipsis(Ellipsis ellipsis) throws Exception {
        if (this.mrefs.Ellipsis == 0) {
            this.mrefs.Ellipsis = this.code.pool.Fieldref("org/python/core/Py", "Ellipsis", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.Ellipsis);
        return null;
    }

    public Object visitSlice(Slice slice) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PySlice"));
        this.code.dup();
        if (slice.lower == null) {
            this.getNone();
        } else {
            this.visit(slice.lower);
        }
        if (slice.upper == null) {
            this.getNone();
        } else {
            this.visit(slice.upper);
        }
        if (slice.step == null) {
            this.getNone();
        } else {
            this.visit(slice.step);
        }
        if (this.mrefs.PySlice_init == 0) {
            this.mrefs.PySlice_init = this.code.pool.Methodref("org/python/core/PySlice", "<init>", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PySlice_init);
        return null;
    }

    public Object visitClassDef(ClassDef classDef) throws Exception {
        this.setline(classDef);
        String string = this.getName(classDef.name);
        this.code.ldc(string);
        this.makeArray(classDef.bases);
        ScopeInfo scopeInfo = this.module.getScopeInfo(classDef);
        scopeInfo.setup_closure(this.my_scope);
        scopeInfo.dump();
        this.module.PyCode(new Suite(classDef.body, classDef), string, false, string, true, false, classDef.beginLine, scopeInfo).get(this.code);
        Vector vector = scopeInfo.freevars;
        this.getDocString(classDef.body);
        if (!this.makeClosure(vector)) {
            if (this.mrefs.makeClass == 0) {
                this.mrefs.makeClass = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass);
        } else {
            if (this.mrefs.makeClass_closure == 0) {
                this.mrefs.makeClass_closure = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass_closure);
        }
        this.set(new Name(classDef.name, 2, classDef));
        return null;
    }

    public Object visitNum(Num num) throws Exception {
        if (num.n instanceof PyInteger) {
            this.module.PyInteger(((PyInteger)num.n).getValue()).get(this.code);
        } else if (num.n instanceof PyLong) {
            this.module.PyLong(((PyObject)num.n).__str__().toString()).get(this.code);
        } else if (num.n instanceof PyFloat) {
            this.module.PyFloat(((PyFloat)num.n).getValue()).get(this.code);
        } else if (num.n instanceof PyComplex) {
            this.module.PyComplex(((PyComplex)num.n).imag).get(this.code);
        }
        return null;
    }

    private String getName(String string) {
        if (this.className != null && string.startsWith("__") && !string.endsWith("__")) {
            int n = 0;
            while (this.className.charAt(n) == '_') {
                ++n;
            }
            return "_" + this.className.substring(n) + string;
        }
        return string;
    }

    void emitGetGlobal(String string) throws Exception {
        this.code.ldc(string);
        if (this.mrefs.getglobal == 0) {
            this.mrefs.getglobal = this.code.pool.Methodref("org/python/core/PyFrame", "getglobal", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getglobal);
    }

    public Object visitName(Name name) throws Exception {
        String string = this.fast_locals ? name.id : this.getName(name.id);
        SymInfo symInfo = (SymInfo)this.tbl.get(string);
        int n = name.ctx;
        if (n == 5) {
            n = this.augmode;
        }
        switch (n) {
            case 1: {
                this.loadFrame();
                if (symInfo != null) {
                    int n2 = symInfo.flags;
                    if ((n2 & 0x42) != 0 || this.optimizeGlobals && (n2 & 0x31) == 0) {
                        this.emitGetGlobal(string);
                        return null;
                    }
                    if (this.fast_locals) {
                        if ((n2 & 0x10) != 0) {
                            this.code.iconst(symInfo.env_index);
                            if (this.mrefs.getderef == 0) {
                                this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getderef);
                            return null;
                        }
                        if ((n2 & 1) != 0) {
                            this.code.iconst(symInfo.locals_index);
                            if (this.mrefs.getlocal2 == 0) {
                                this.mrefs.getlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "getlocal", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getlocal2);
                            return null;
                        }
                    }
                    if ((n2 & 0x20) != 0 && (n2 & 1) == 0) {
                        this.code.iconst(symInfo.env_index);
                        if (this.mrefs.getderef == 0) {
                            this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                        }
                        this.code.invokevirtual(this.mrefs.getderef);
                        return null;
                    }
                }
                this.code.ldc(string);
                if (this.mrefs.getlocal1 == 0) {
                    this.mrefs.getlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "getname", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getlocal1);
                return null;
            }
            case 2: {
                this.loadFrame();
                if (symInfo != null && (symInfo.flags & 0x42) != 0) {
                    this.code.ldc(string);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setglobal == 0) {
                        this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(string);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setlocal1 == 0) {
                        this.mrefs.setlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setlocal1);
                } else {
                    if (symInfo == null) {
                        System.err.println("internal compiler error: " + name);
                    }
                    if ((symInfo.flags & 0x10) != 0) {
                        this.code.iconst(symInfo.env_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setderef == 0) {
                            this.mrefs.setderef = this.code.pool.Methodref("org/python/core/PyFrame", "setderef", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setderef);
                    } else {
                        this.code.iconst(symInfo.locals_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setlocal2 == 0) {
                            this.mrefs.setlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setlocal2);
                    }
                }
                return null;
            }
            case 3: {
                this.loadFrame();
                if (symInfo != null && (symInfo.flags & 0x42) != 0) {
                    this.code.ldc(string);
                    if (this.mrefs.delglobal == 0) {
                        this.mrefs.delglobal = this.code.pool.Methodref("org/python/core/PyFrame", "delglobal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.delglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(string);
                    if (this.mrefs.dellocal1 == 0) {
                        this.mrefs.dellocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal1);
                } else {
                    if (symInfo == null) {
                        System.err.println("internal compiler error: " + name);
                    }
                    if ((symInfo.flags & 0x10) != 0) {
                        this.module.error("can not delete variable '" + string + "' referenced in nested scope", true, name);
                    }
                    this.code.iconst(symInfo.locals_index);
                    if (this.mrefs.dellocal2 == 0) {
                        this.mrefs.dellocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(I)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal2);
                }
                return null;
            }
        }
        return null;
    }

    public Object visitStr(Str str) throws Exception {
        String string = str.s;
        if (string.length() > Short.MAX_VALUE) {
            throw new ParseException("string constant too large (more than 32767 characters)", str);
        }
        this.module.PyString(string).get(this.code);
        return null;
    }

    protected Object unhandled_node(SimpleNode simpleNode) throws Exception {
        throw new Exception("Unhandled node " + simpleNode);
    }

    class InFinally {
        public int retLocal;
        public Label[] labels;
        public int cnt = 1;

        public InFinally(int n) {
            this.labels = new Label[n];
            for (int i = 0; i < n; ++i) {
                this.labels[i] = CodeCompiler.this.code.getLabel();
            }
        }
    }

    class YieldChecker
    extends Visitor {
        public int yieldCount = 0;

        YieldChecker() {
        }

        public Object visitYield(Yield yield) throws Exception {
            ++this.yieldCount;
            return super.visitYield(yield);
        }
    }
}

