/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;
import org.python.compiler.Attribute;
import org.python.compiler.ClassFile;
import org.python.compiler.ConstantPool;
import org.python.compiler.ExceptionLabel;
import org.python.compiler.Label;
import org.python.compiler.LineNumberTable;

public class Code
extends Attribute {
    ConstantPool pool;
    public int stack;
    int max_stack;
    public DataOutputStream code;
    ByteArrayOutputStream stream;
    String sig;
    String[] locals;
    int nlocals;
    int argcount;
    int att_name;
    Vector labels;
    Vector exceptions;
    LineNumberTable linenumbers;
    int returnLocal;
    BitSet finallyLocals = new BitSet();

    public Label getLabel() {
        Label label = new Label(this);
        this.addLabel(label);
        return label;
    }

    public void addLabel(Label label) {
        this.labels.addElement(label);
    }

    public int size() {
        return this.stream.size();
    }

    public Code(String string, ConstantPool constantPool, boolean bl) {
        this.sig = string;
        this.max_stack = 2;
        this.stack = 0;
        this.pool = constantPool;
        this.stream = new ByteArrayOutputStream();
        this.code = new DataOutputStream(this.stream);
        this.nlocals = -ConstantPool.sigSize(string, false);
        if (!bl) {
            ++this.nlocals;
        }
        this.argcount = this.nlocals;
        this.locals = new String[this.nlocals + 128];
        this.labels = new Vector();
        this.exceptions = new Vector();
        try {
            this.att_name = constantPool.UTF8("Code");
        }
        catch (IOException iOException) {
            this.att_name = 0;
        }
    }

    public int getLocal(String string) {
        for (int i = this.argcount; i < this.nlocals; ++i) {
            if (this.locals[i] != null) continue;
            this.locals[i] = string;
            return i;
        }
        if (this.nlocals >= this.locals.length) {
            String[] stringArray = new String[this.locals.length * 2];
            System.arraycopy(this.locals, 0, stringArray, 0, this.locals.length);
            this.locals = stringArray;
        }
        this.locals[this.nlocals] = string;
        ++this.nlocals;
        return this.nlocals - 1;
    }

    public void freeLocal(int n) {
        if (this.locals[n] == null) {
            System.out.println("Double free:" + n);
        }
        this.locals[n] = null;
    }

    public int getFinallyLocal(String string) {
        int n = this.getLocal(string);
        this.finallyLocals.set(n);
        return n;
    }

    public void freeFinallyLocal(int n) {
        this.finallyLocals.clear(n);
        this.freeLocal(n);
    }

    public int getReturnLocal() {
        if (this.returnLocal == 0) {
            this.returnLocal = this.getLocal("return");
        }
        return this.returnLocal;
    }

    public Vector getActiveLocals() {
        Vector<String> vector = new Vector<String>();
        vector.setSize(this.nlocals);
        for (int i = this.argcount; i < this.nlocals; ++i) {
            if (i == this.returnLocal || this.finallyLocals.get(i)) continue;
            vector.setElementAt(this.locals[i], i);
        }
        return vector;
    }

    public void addExceptionHandler(Label label, Label label2, Label label3, int n) {
        this.exceptions.addElement(new ExceptionLabel(label, label2, label3, n));
    }

    public void fixLabels(byte[] byArray) throws IOException {
        for (int i = 0; i < this.labels.size(); ++i) {
            ((Label)this.labels.elementAt(i)).fix(byArray);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = this.stream.toByteArray();
        this.fixLabels(byArray);
        int n = this.exceptions.size();
        int n2 = byArray.length + 12 + 8 * n;
        if (this.linenumbers != null) {
            n2 += this.linenumbers.length();
        }
        dataOutputStream.writeShort(this.att_name);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.nlocals);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            ExceptionLabel exceptionLabel = (ExceptionLabel)this.exceptions.elementAt(i);
            dataOutputStream.writeShort(exceptionLabel.start.getPosition());
            dataOutputStream.writeShort(exceptionLabel.end.getPosition());
            dataOutputStream.writeShort(exceptionLabel.handler.getPosition());
            dataOutputStream.writeShort(exceptionLabel.exc);
        }
        if (this.linenumbers != null) {
            ClassFile.writeAttributes(dataOutputStream, new Attribute[]{this.linenumbers});
        } else {
            ClassFile.writeAttributes(dataOutputStream, new Attribute[0]);
        }
    }

    public void push(int n) {
        this.stack += n;
        if (this.stack > this.max_stack) {
            this.max_stack = this.stack;
        }
        if (this.stack < 0) {
            throw new InternalError("stack < 0: " + this.stack);
        }
    }

    public void branch(int n, Label label) throws IOException {
        int n2 = this.size();
        this.code.writeByte(n);
        label.setBranch(n2, 2);
        label.setStack(this.stack);
    }

    public void print(String string) throws IOException {
        this.getstatic("java/lang/System", "out", "Ljava/io/PrintStream;");
        this.ldc(string);
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public void aaload() throws IOException {
        this.code.writeByte(50);
        this.push(-1);
    }

    public void aastore() throws IOException {
        this.code.writeByte(83);
        this.push(-3);
    }

    public void aconst_null() throws IOException {
        this.code.writeByte(1);
        this.push(1);
    }

    public void aload(int n) throws IOException {
        if (n >= 0 && n < 4) {
            this.code.writeByte(42 + n);
        } else {
            this.code.writeByte(25);
            this.code.writeByte(n);
        }
        this.push(1);
    }

    public void anewarray(int n) throws IOException {
        this.code.writeByte(189);
        this.code.writeShort(n);
    }

    public void areturn() throws IOException {
        this.code.writeByte(176);
        this.push(-1);
    }

    public void arraylength() throws IOException {
        this.code.writeByte(190);
    }

    public void astore(int n) throws IOException {
        if (n >= 0 && n < 4) {
            this.code.writeByte(75 + n);
        } else {
            this.code.writeByte(58);
            this.code.writeByte(n);
        }
        this.push(-1);
    }

    public void athrow() throws IOException {
        this.code.writeByte(191);
        this.push(-1);
    }

    public void checkcast(int n) throws IOException {
        this.code.writeByte(192);
        this.code.writeShort(n);
    }

    public void dload(int n) throws IOException {
        if (n >= 0 && n < 4) {
            this.code.writeByte(38 + n);
        } else {
            this.code.writeByte(24);
            this.code.writeByte(n);
        }
        this.push(2);
    }

    public void dreturn() throws IOException {
        this.code.writeByte(175);
        this.push(-2);
    }

    public void dup() throws IOException {
        this.code.writeByte(89);
        this.push(1);
    }

    public void dup_x1() throws IOException {
        this.code.writeByte(90);
        this.push(1);
    }

    public void fload(int n) throws IOException {
        if (n >= 0 && n < 4) {
            this.code.writeByte(34 + n);
        } else {
            this.code.writeByte(23);
            this.code.writeByte(n);
        }
        this.push(1);
    }

    public void freturn() throws IOException {
        this.code.writeByte(174);
        this.push(-1);
    }

    public void getfield(int n) throws IOException {
        this.code.writeByte(180);
        this.code.writeShort(n);
        this.push(this.pool.sizes[n] - 1);
    }

    public void getfield(String string, String string2, String string3) throws IOException {
        this.getfield(this.pool.Fieldref(string, string2, string3));
    }

    public void getstatic(int n) throws IOException {
        this.code.writeByte(178);
        this.code.writeShort(n);
        this.push(this.pool.sizes[n]);
    }

    public void getstatic(String string, String string2, String string3) throws IOException {
        this.getstatic(this.pool.Fieldref(string, string2, string3));
    }

    public void goto_(Label label) throws IOException {
        this.branch(167, label);
    }

    public void iconst(int n) throws IOException {
        if (n >= -1 && n <= 5) {
            this.code.writeByte(3 + n);
        } else if (n > -127 && n < 128) {
            this.code.writeByte(16);
            if (n < 0) {
                n = 256 + n;
            }
            this.code.writeByte(n);
        } else if (n > -32767 && n < 32768) {
            this.code.writeByte(17);
            if (n < 0) {
                n += 65536;
            }
            this.code.writeShort(n);
        } else {
            this.ldc(this.pool.Integer(n));
        }
        this.push(1);
    }

    public void if_icmpne(Label label) throws IOException {
        this.push(-2);
        this.branch(160, label);
    }

    public void ifeq(Label label) throws IOException {
        this.push(-1);
        this.branch(153, label);
    }

    public void ifne(Label label) throws IOException {
        this.push(-1);
        this.branch(154, label);
    }

    public void ifnonnull(Label label) throws IOException {
        this.push(-1);
        this.branch(199, label);
    }

    public void ifnull(Label label) throws IOException {
        this.push(-1);
        this.branch(198, label);
    }

    public void iinc(int n, int n2) throws IOException {
        this.code.writeByte(132);
        this.code.writeByte(n);
        this.code.writeByte(n2);
    }

    public void iinc(int n) throws IOException {
        this.iinc(n, 1);
    }

    public void iload(int n) throws IOException {
        if (n >= 0 && n < 4) {
            this.code.writeByte(26 + n);
        } else {
            this.code.writeByte(21);
            this.code.writeByte(n);
        }
        this.push(1);
    }

    public void invokespecial(int n) throws IOException {
        this.code.writeByte(183);
        this.code.writeShort(n);
        this.push(this.pool.sizes[n] - 1);
    }

    public void invokestatic(int n) throws IOException {
        this.code.writeByte(184);
        this.code.writeShort(n);
        this.push(this.pool.sizes[n]);
    }

    public void invokevirtual(int n) throws IOException {
        this.code.writeByte(182);
        this.code.writeShort(n);
        this.push(this.pool.sizes[n] - 1);
    }

    public void invokevirtual(String string, String string2, String string3) throws IOException {
        this.invokevirtual(this.pool.Methodref(string, string2, string3));
    }

    public void ireturn() throws IOException {
        this.code.writeByte(172);
        this.push(-1);
    }

    public void istore(int n) throws IOException {
        if (n >= 0 && n < 4) {
            this.code.writeByte(59 + n);
        } else {
            this.code.writeByte(54);
            this.code.writeByte(n);
        }
        this.push(-1);
    }

    public void jsr(Label label) throws IOException {
        int n = this.size();
        this.code.writeByte(168);
        label.setBranch(n, 2);
        label.setStack(this.stack + 1);
    }

    public void ldc(int n) throws IOException {
        int n2 = this.pool.sizes[n];
        if (n2 == 1) {
            if (n < 256) {
                this.code.writeByte(18);
                this.code.writeByte(n);
            } else {
                this.code.writeByte(19);
                this.code.writeShort(n);
            }
        } else {
            this.code.writeByte(20);
            this.code.writeShort(n);
        }
        this.push(this.pool.sizes[n]);
    }

    public void ldc(String string) throws IOException {
        this.ldc(this.pool.String(string));
    }

    public void lload(int n) throws IOException {
        if (n >= 0 && n < 4) {
            this.code.writeByte(30 + n);
        } else {
            this.code.writeByte(22);
            this.code.writeByte(n);
        }
        this.push(2);
    }

    public void lreturn() throws IOException {
        this.code.writeByte(173);
        this.push(-2);
    }

    public void new_(int n) throws IOException {
        this.code.writeByte(187);
        this.code.writeShort(n);
        this.push(1);
    }

    public void pop() throws IOException {
        this.code.writeByte(87);
        this.push(-1);
    }

    public void putfield(int n) throws IOException {
        this.code.writeByte(181);
        this.code.writeShort(n);
        this.push(-this.pool.sizes[n] - 1);
    }

    public void putfield(String string, String string2, String string3) throws IOException {
        this.putfield(this.pool.Fieldref(string, string2, string3));
    }

    public void putstatic(int n) throws IOException {
        this.code.writeByte(179);
        this.code.writeShort(n);
        this.push(-this.pool.sizes[n]);
    }

    public void putstatic(String string, String string2, String string3) throws IOException {
        this.putstatic(this.pool.Fieldref(string, string2, string3));
    }

    public void return_() throws IOException {
        this.code.writeByte(177);
    }

    public void ret(int n) throws IOException {
        this.code.writeByte(169);
        this.code.writeByte(n);
    }

    public void swap() throws IOException {
        this.code.writeByte(95);
    }

    public void tableswitch(Label label, int n, Label[] labelArray) throws IOException {
        int n2;
        int n3 = this.size();
        this.push(-1);
        this.code.writeByte(170);
        for (n2 = 0; n2 < 3 - n3 % 4; ++n2) {
            this.code.writeByte(0);
        }
        label.setBranch(n3, 4);
        this.code.writeInt(n);
        this.code.writeInt(labelArray.length - 1);
        for (n2 = 0; n2 < labelArray.length; ++n2) {
            labelArray[n2].setBranch(n3, 4);
        }
    }

    public void setline(int n) throws IOException {
        if (this.linenumbers == null) {
            this.linenumbers = new LineNumberTable(this.pool);
        }
        this.linenumbers.addLine(this.size(), n);
    }
}

