/*
 * Decompiled with CFR 0.152.
 */
package dacapo.jython;

import dacapo.Benchmark;
import dacapo.parser.Config;
import java.io.File;
import org.python.core.Py;
import org.python.util.jython;

public class JythonHarness
extends Benchmark {
    public JythonHarness(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    protected void prepare() throws Exception {
        super.prepare();
        System.setProperty("python.home", this.fileInScratch("jython"));
        System.setProperty("python.cachedir", this.fileInScratch("cachedir"));
        jython.main(new String[]{this.fileInScratch("jython/noop.py")});
    }

    public void iterate(String size) throws Exception {
        String[] args = this.config.getArgs(size);
        args[0] = new String(this.fileInScratch(args[0]));
        String[] pyargs = new String[args.length - 1];
        for (int i = 0; i < pyargs.length; ++i) {
            pyargs[i] = args[i + 1];
        }
        Py.setArgv(args[0], pyargs);
        jython.main(args);
    }

    public void cleanup() {
        super.cleanup();
        JythonHarness.deleteTree(new File(this.scratch, "cachedir"));
    }
}

