/*
 * Decompiled with CFR 0.152.
 */
package dacapo;

import dacapo.Callback;
import dacapo.DacapoException;
import dacapo.Digest;
import dacapo.FileDigest;
import dacapo.TeePrintStream;
import dacapo.parser.Config;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class Benchmark {
    private static final int BUFFER_SIZE = 2048;
    private static boolean verbose = false;
    private static boolean validateOutput = true;
    private static boolean validate = true;
    private static boolean preserve = false;
    private static PrintWriter valRepFile = null;
    private static boolean validationReport = false;
    private static final PrintStream savedOut = System.out;
    private static final PrintStream savedErr = System.err;
    protected final File scratch;
    protected final Config config;
    private static TeePrintStream err = null;
    private static TeePrintStream out = null;
    private int iteration = 0;
    static /* synthetic */ Class class$dacapo$Benchmark;

    public final boolean run(Callback callback, String size, boolean timing) throws Exception {
        ++this.iteration;
        this.preIteration(size);
        if (timing) {
            callback.start(this.config.name);
        } else {
            callback.startWarmup(this.config.name);
        }
        this.startIteration();
        this.iterate(size);
        this.stopIteration();
        if (timing) {
            callback.stop();
        } else {
            callback.stopWarmup();
        }
        boolean valid = this.validate(size);
        if (timing) {
            callback.complete(this.config.name, valid);
        } else {
            callback.completeWarmup(this.config.name, valid);
        }
        this.postIteration(size);
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Benchmark(Config config, File scratch) throws Exception {
        this.scratch = scratch;
        this.config = config;
        if (validate) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                if (out == null) {
                    out = new TeePrintStream((OutputStream)System.out, new File(scratch, "stdout.log"));
                }
            }
            printStream = System.err;
            synchronized (printStream) {
                if (err == null) {
                    err = new TeePrintStream((OutputStream)System.err, new File(scratch, "stderr.log"));
                }
            }
        }
        this.prepare();
    }

    protected void prepare() throws Exception {
        Benchmark.unpackZipFileResource("data/" + this.config.name + ".zip", this.scratch);
    }

    public void preIteration(String size) throws Exception {
        if (verbose) {
            String[] args = this.config.getArgs(size);
            System.out.print("Benchmark parameters: ");
            for (int i = 0; i < args.length; ++i) {
                System.out.print(args[i] + " ");
            }
            System.out.println();
        }
        if (preserve && this.iteration > 1) {
            this.postIterationCleanup(size);
        }
    }

    public final void startIteration() {
        if (validateOutput) {
            System.setOut(out);
            System.setErr(err);
            if (this.iteration > 1) {
                out.version();
                err.version();
            }
            out.openLog();
            err.openLog();
        }
    }

    public abstract void iterate(String var1) throws Exception;

    public final void stopIteration() {
        if (validateOutput) {
            out.closeLog();
            err.closeLog();
            System.setOut(savedOut);
            System.setErr(savedErr);
        }
    }

    public boolean validate(String size) {
        if (!validate) {
            return true;
        }
        if (validationReport) {
            valRepFile.println("Validating " + this.config.name + " " + size);
        }
        boolean valid = true;
        Iterator v = this.config.getOutputs(size).iterator();
        while (v.hasNext()) {
            String file = (String)v.next();
            if (this.config.hasDigest(size, file)) {
                String digest;
                String refDigest = this.config.getDigest(size, file);
                try {
                    digest = Digest.toString(FileDigest.get(this.fileInScratch(file), this.config.isTextFile(size, file), this.config.filterScratch(size, file), this.scratch));
                }
                catch (FileNotFoundException e) {
                    digest = "<File not found>";
                }
                catch (IOException e) {
                    digest = "<IO exception>";
                    e.printStackTrace();
                }
                if (validationReport) {
                    valRepFile.println("  \"" + file + "\" digest 0x" + digest + ",");
                }
                if (validateOutput || !file.equals("$stdout") && !file.equals("$stderr")) {
                    if (!digest.equals(refDigest)) {
                        valid = false;
                        System.err.println("Digest validation failed for " + file + ", expecting 0x" + refDigest + " found 0x" + digest);
                    } else if (verbose) {
                        System.out.println("Digest validation succeeded for " + file);
                    }
                }
            }
            if (this.config.hasLines(size, file)) {
                int lines;
                int refLines = this.config.getLines(size, file);
                try {
                    lines = Benchmark.lineCount(new File(this.scratch, file));
                }
                catch (FileNotFoundException e) {
                    System.err.println("File not found, " + file);
                    lines = -1;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    lines = -1;
                }
                if (validationReport) {
                    valRepFile.println("  \"" + file + "\" lines " + lines + ",");
                }
                if (lines != refLines) {
                    valid = false;
                    System.err.println("Line count validation failed for " + file + ", expecting " + refLines + " found " + lines);
                } else if (verbose) {
                    System.out.println("Line count validation succeeded for " + file);
                }
            }
            if (this.config.hasBytes(size, file)) {
                long bytes;
                long refBytes = this.config.getBytes(size, file);
                try {
                    bytes = Benchmark.byteCount(new File(this.scratch, file));
                }
                catch (FileNotFoundException e) {
                    System.err.println("File not found, " + file);
                    bytes = -1L;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bytes = -1L;
                }
                if (validationReport) {
                    valRepFile.println("  \"" + file + "\" bytes " + bytes + ",");
                }
                if (bytes != refBytes) {
                    valid = false;
                    System.err.println("Byte count validation failed for " + file + ", expecting " + refBytes + " found " + bytes);
                } else if (verbose) {
                    System.out.println("Byte count validation succeeded for " + file);
                }
            }
            if (!this.config.checkExists(size, file)) continue;
            if (!new File(this.scratch, file).exists()) {
                System.err.println("Expected file " + file + " does not exist");
                valid = false;
                continue;
            }
            if (!verbose) continue;
            System.out.println("Existence validation succeeded for " + file);
        }
        if (validationReport) {
            valRepFile.flush();
        }
        return valid;
    }

    public void postIteration(String size) throws Exception {
        if (!preserve) {
            this.postIterationCleanup(size);
        }
    }

    protected void postIterationCleanup(String size) {
        Iterator v = this.config.getOutputs(size).iterator();
        while (v.hasNext()) {
            String file = (String)v.next();
            if (file.equals("$stdout") || file.equals("$stderr") || this.config.isKept(size, file)) continue;
            Benchmark.deleteFile(new File(this.scratch, file));
        }
    }

    public void cleanup() {
        if (!preserve) {
            Benchmark.deleteTree(new File(this.scratch, this.config.name));
        }
    }

    public static void copyFileTo(File inputFile, File outputDir) throws IOException {
        Benchmark.copyFile(inputFile, new File(outputDir, inputFile.getName()));
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        byte[] buffer;
        int read;
        FileInputStream input = new FileInputStream(inputFile);
        FileOutputStream output = new FileOutputStream(outputFile);
        while ((read = input.read(buffer = new byte[2048])) != -1) {
            output.write(buffer, 0, read);
        }
        input.close();
        output.flush();
        output.close();
    }

    public static URL getURL(String fn) {
        ClassLoader cl = (class$dacapo$Benchmark == null ? (class$dacapo$Benchmark = Benchmark.class$("dacapo.Benchmark")) : class$dacapo$Benchmark).getClassLoader();
        URL resource = cl.getResource(fn);
        if (verbose) {
            System.out.println("Util.getURL: returns " + resource);
        }
        return resource;
    }

    public String fileInScratch(String name) {
        return new File(this.scratch, name).getPath();
    }

    public static void unpackZipFile(String name, File destination) throws IOException, FileNotFoundException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(name));
        Benchmark.unpackZipStream(inputStream, destination);
    }

    public static void unpackZipFileResource(String name, File destination) throws IOException, FileNotFoundException, DacapoException {
        URL resource = Benchmark.getURL(name);
        if (resource == null) {
            throw new DacapoException("No such zip file: \"" + name + "\"");
        }
        BufferedInputStream inputStream = new BufferedInputStream(resource.openStream());
        Benchmark.unpackZipStream(inputStream, destination);
    }

    private static void unpackZipStream(BufferedInputStream inputStream, File destination) throws IOException {
        ZipEntry entry;
        ZipInputStream input = new ZipInputStream(inputStream);
        while ((entry = input.getNextEntry()) != null) {
            int count;
            if (verbose) {
                System.out.println("Unpacking " + entry.getName());
            }
            File file = new File(destination, entry.getName());
            if (entry.isDirectory()) {
                if (file.exists()) continue;
                file.mkdir();
                continue;
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            byte[] data = new byte[2048];
            while ((count = input.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        input.close();
    }

    public static void deleteTree(File tree) {
        if (verbose) {
            System.out.println("Deleting " + tree.getName());
        }
        if (!tree.isDirectory()) {
            tree.delete();
        } else {
            File[] files = tree.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Benchmark.deleteTree(files[i]);
            }
            tree.delete();
        }
    }

    public static void deleteFile(File file) {
        if (verbose) {
            System.out.println("Deleting " + file.getName());
        }
        if (file.exists() && !file.isDirectory()) {
            file.delete();
        }
    }

    public static void deleteFiles(File dir, final String pattern) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(pattern);
            }
        };
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            Benchmark.deleteFile(files[i]);
        }
    }

    public static int lineCount(String file) throws IOException {
        return Benchmark.lineCount(new File(file));
    }

    public static int lineCount(File file) throws IOException {
        int lines = 0;
        BufferedReader in = new BufferedReader(new FileReader(file));
        while (in.readLine() != null) {
            ++lines;
        }
        in.close();
        return lines;
    }

    protected void sortArray(Comparable[] list) {
        ArrayList<Comparable> l = new ArrayList<Comparable>(list.length);
        for (int i = 0; i < list.length; ++i) {
            l.add(list[i]);
        }
        Collections.sort(l);
        int j = 0;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            list[j++] = (Comparable)i.next();
        }
    }

    public static long byteCount(String file) throws IOException {
        return Benchmark.byteCount(new File(file));
    }

    public static long byteCount(File file) throws IOException {
        return file.length();
    }

    public static void setVerbose(boolean verbose) {
        Benchmark.verbose = verbose;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void enableValidationReport(String filename) {
        try {
            validationReport = true;
            valRepFile = new PrintWriter(new BufferedWriter(new FileWriter(filename, true)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setValidateOutput(boolean digestOutput) {
        validateOutput = digestOutput;
    }

    public static boolean isDigestOutput() {
        return validateOutput;
    }

    public static void setPreserve(boolean preserve) {
        Benchmark.preserve = preserve;
    }

    public static boolean isPreserve() {
        return preserve;
    }

    protected int getIteration() {
        return this.iteration;
    }

    public static void setValidate(boolean flag) {
        validate = flag;
        Benchmark.setValidateOutput(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

