/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.DynamicFetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.StaticFetch;
import com.ziclix.python.sql.WarningEvent;
import com.ziclix.python.sql.WarningListener;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.__builtin__;

public abstract class Fetch {
    protected int rowcount = -1;
    protected int rownumber = -1;
    private DataHandler datahandler;
    protected PyObject description = Py.None;
    private List listeners;
    static /* synthetic */ Class class$java$sql$ResultSet;

    protected Fetch(DataHandler dataHandler) {
        this.datahandler = dataHandler;
        this.listeners = new ArrayList(3);
    }

    public static Fetch newFetch(DataHandler dataHandler, boolean bl) {
        if (bl) {
            return new DynamicFetch(dataHandler);
        }
        return new StaticFetch(dataHandler);
    }

    public int getRowCount() {
        return this.rowcount;
    }

    public PyObject getDescription() {
        return this.description;
    }

    public abstract void add(ResultSet var1);

    public abstract void add(ResultSet var1, Set var2);

    public abstract void add(CallableStatement var1, Procedure var2, PyObject var3);

    public PyObject fetchone() {
        PyObject pyObject = this.fetchmany(1);
        if (pyObject.__len__() == 1) {
            return pyObject.__getitem__(0);
        }
        return Py.None;
    }

    public abstract PyObject fetchall();

    public abstract PyObject fetchmany(int var1);

    public abstract PyObject nextset();

    public abstract void scroll(int var1, String var2);

    public void close() throws SQLException {
        this.listeners.clear();
    }

    protected PyObject createDescription(ResultSetMetaData resultSetMetaData) throws SQLException {
        PyList pyList = new PyList();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            PyObject[] pyObjectArray = new PyObject[7];
            pyObjectArray[0] = Py.newString(resultSetMetaData.getColumnName(i));
            pyObjectArray[1] = Py.newInteger(resultSetMetaData.getColumnType(i));
            pyObjectArray[2] = Py.newInteger(resultSetMetaData.getColumnDisplaySize(i));
            pyObjectArray[3] = Py.None;
            switch (resultSetMetaData.getColumnType(i)) {
                case -7: 
                case -5: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    pyObjectArray[4] = Py.newInteger(resultSetMetaData.getPrecision(i));
                    pyObjectArray[5] = Py.newInteger(resultSetMetaData.getScale(i));
                    break;
                }
                default: {
                    pyObjectArray[4] = Py.None;
                    pyObjectArray[5] = Py.None;
                }
            }
            pyObjectArray[6] = Py.newInteger(resultSetMetaData.isNullable(i));
            pyList.append(new PyTuple(pyObjectArray));
        }
        return pyList;
    }

    protected PyObject createDescription(Procedure procedure) throws SQLException {
        PyList pyList = new PyList();
        int n = procedure.columns.__len__();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject = procedure.columns.__getitem__(i);
            int n2 = ((PyInteger)pyObject.__getitem__(4).__int__()).getValue();
            switch (n2) {
                case 5: {
                    PyObject[] pyObjectArray = new PyObject[7];
                    pyObjectArray[0] = pyObject.__getitem__(3);
                    pyObjectArray[1] = pyObject.__getitem__(5);
                    pyObjectArray[2] = Py.newInteger(-1);
                    pyObjectArray[3] = pyObject.__getitem__(8);
                    switch (((PyInteger)pyObjectArray[1].__int__()).getValue()) {
                        case -7: 
                        case -5: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: {
                            pyObjectArray[4] = pyObject.__getitem__(7);
                            pyObjectArray[5] = pyObject.__getitem__(9);
                            break;
                        }
                        default: {
                            pyObjectArray[4] = Py.None;
                            pyObjectArray[5] = Py.None;
                        }
                    }
                    int n3 = ((PyInteger)pyObject.__getitem__(11).__int__()).getValue();
                    pyObjectArray[6] = n3 == 1 ? Py.One : Py.Zero;
                    pyList.append(new PyTuple(pyObjectArray));
                }
            }
        }
        return pyList;
    }

    protected PyObject createResults(CallableStatement callableStatement, Procedure procedure, PyObject pyObject) throws SQLException {
        PyList pyList = new PyList();
        int n = 0;
        int n2 = procedure.columns.__len__();
        block5: for (int i = 0; i < n2; ++i) {
            PyObject pyObject2 = Py.None;
            PyObject pyObject3 = procedure.columns.__getitem__(i);
            int n3 = ((PyInteger)pyObject3.__getitem__(4).__int__()).getValue();
            int n4 = ((PyInteger)pyObject3.__getitem__(5).__int__()).getValue();
            switch (n3) {
                case 1: {
                    ++n;
                    continue block5;
                }
                case 2: 
                case 4: {
                    pyObject2 = this.datahandler.getPyObject(callableStatement, i + 1, n4);
                    pyObject.__setitem__(n++, pyObject2);
                    continue block5;
                }
                case 5: {
                    pyObject2 = this.datahandler.getPyObject(callableStatement, i + 1, n4);
                    Object object = pyObject2.__tojava__(class$java$sql$ResultSet == null ? Fetch.class$("java.sql.ResultSet") : class$java$sql$ResultSet);
                    if (object == Py.NoConversion) {
                        pyList.append(pyObject2);
                        continue block5;
                    }
                    this.add((ResultSet)object);
                }
            }
        }
        if (pyList.__len__() == 0) {
            return pyList;
        }
        PyList pyList2 = new PyList();
        pyList2.append(__builtin__.tuple(pyList));
        return pyList2;
    }

    protected PyList createResults(ResultSet resultSet, Set set, PyObject pyObject) throws SQLException {
        PyList pyList = new PyList();
        while (resultSet.next()) {
            PyTuple pyTuple = this.createResult(resultSet, set, pyObject);
            pyList.append(pyTuple);
        }
        return pyList;
    }

    protected PyTuple createResult(ResultSet resultSet, Set set, PyObject pyObject) throws SQLException {
        int n = pyObject.__len__();
        PyObject[] pyObjectArray = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            if (set != null && set.contains(new Integer(i + 1))) {
                pyObjectArray[i] = Py.None;
                continue;
            }
            int n2 = ((PyInteger)pyObject.__getitem__(i).__getitem__(1)).getValue();
            pyObjectArray[i] = this.datahandler.getPyObject(resultSet, i + 1, n2);
        }
        SQLWarning sQLWarning = resultSet.getWarnings();
        if (sQLWarning != null) {
            this.fireWarning(sQLWarning);
        }
        PyTuple pyTuple = new PyTuple(pyObjectArray);
        return pyTuple;
    }

    protected void fireWarning(SQLWarning sQLWarning) {
        WarningEvent warningEvent = new WarningEvent(this, sQLWarning);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            try {
                ((WarningListener)this.listeners.get(i)).warning(warningEvent);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void addWarningListener(WarningListener warningListener) {
        this.listeners.add(warningListener);
    }

    public boolean removeWarningListener(WarningListener warningListener) {
        return this.listeners.remove(warningListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

