/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.res;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xalan.res.XSLTErrorResources;
import org.apache.xpath.res.XPATHErrorResources;

public class XSLMessages {
    private Locale fLocale = Locale.getDefault();
    private static ResourceBundle XSLTBundle = null;
    private static ResourceBundle XPATHBundle = null;
    private static final String XSLT_ERROR_RESOURCES = "org.apache.xalan.res.XSLTErrorResources";
    private static final String XPATH_ERROR_RESOURCES = "org.apache.xpath.res.XPATHErrorResources";
    private static String BAD_CODE = "BAD_CODE";
    private static String FORMAT_FAILED = "FORMAT_FAILED";

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public static final String createXPATHWarning(int errorCode, Object[] args) {
        ResourceBundle fResourceBundle;
        if (XPATHBundle == null) {
            XPATHBundle = XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XPATHBundle) != null) {
            String msgKey = XPATHErrorResources.getWarningKey(errorCode);
            return XSLMessages.createXPATHMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMessage(int errorCode, Object[] args) {
        ResourceBundle fResourceBundle;
        if (XPATHBundle == null) {
            XPATHBundle = XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XPATHBundle) != null) {
            String msgKey = XPATHErrorResources.getMessageKey(errorCode);
            return XSLMessages.createXPATHMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMessage(String msgKey, Object[] args) {
        ResourceBundle fResourceBundle;
        if (XPATHBundle == null) {
            XPATHBundle = XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XPATHBundle) != null) {
            return XSLMessages.createXPATHMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMsg(ResourceBundle fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString("BAD_CODE");
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                for (int i = 0; i < n; ++i) {
                    if (null != args[i]) continue;
                    args[i] = "";
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = fResourceBundle.getString("FORMAT_FAILED");
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final String createWarning(int errorCode, Object[] args) {
        ResourceBundle fResourceBundle;
        if (XSLTBundle == null) {
            XSLTBundle = XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XSLTBundle) != null) {
            String msgKey = XSLTErrorResources.getWarningKey(errorCode);
            return XSLMessages.createMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMessage(String msgKey, Object[] args) {
        ResourceBundle fResourceBundle;
        if (XSLTBundle == null) {
            XSLTBundle = XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XSLTBundle) != null) {
            return XSLMessages.createMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMessage(int errorCode, Object[] args) {
        ResourceBundle fResourceBundle;
        if (XSLTBundle == null) {
            XSLTBundle = XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XSLTBundle) != null) {
            String msgKey = XSLTErrorResources.getMessageKey(errorCode);
            return XSLMessages.createMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMsg(ResourceBundle fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString(BAD_CODE);
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                for (int i = 0; i < n; ++i) {
                    if (null != args[i]) continue;
                    args[i] = "";
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = fResourceBundle.getString(FORMAT_FAILED);
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public String createMessage(String bundleName, int errorCode, Object[] args) throws Exception {
        boolean throwex = false;
        String fmsg = null;
        ResourceBundle aResourceBundle = null;
        aResourceBundle = XSLMessages.loadResourceBundle(bundleName);
        String msgKey = XSLTErrorResources.getMessageKey(errorCode);
        String msg = null;
        if (msgKey != null) {
            msg = aResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = aResourceBundle.getString(BAD_CODE);
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                for (int i = 0; i < n; ++i) {
                    if (null != args[i]) continue;
                    args[i] = "";
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = aResourceBundle.getString(FORMAT_FAILED);
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final ResourceBundle loadResourceBundle(String className) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        try {
            return ResourceBundle.getBundle(className, locale);
        }
        catch (MissingResourceException e) {
            try {
                return ResourceBundle.getBundle(XSLT_ERROR_RESOURCES, new Locale("en", "US"));
            }
            catch (MissingResourceException e2) {
                throw new MissingResourceException("Could not load any resource bundles." + className, className, "");
            }
        }
    }

    private static final String getResourceSuffix(Locale locale) {
        String suffix = "_" + locale.getLanguage();
        String country = locale.getCountry();
        if (country.equals("TW")) {
            suffix = suffix + "_" + country;
        }
        return suffix;
    }
}

