/*
 * Decompiled with CFR 0.152.
 */
package dacapo.xalan;

import dacapo.Benchmark;
import dacapo.DacapoException;
import dacapo.parser.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.Version;

public class XalanHarness
extends Benchmark {
    final String XALAN_VERSION = "Xalan Java 2.4.1";
    final int WORKERS = 8;
    Templates _template = null;
    WorkQueue _workQueue = null;
    XalanWorker[] _workers = null;

    public XalanHarness(Config config, File scratch) throws Exception {
        super(config, scratch);
        Properties props = System.getProperties();
        if (!Version.getVersion().equals("Xalan Java 2.4.1")) {
            System.err.println("***  Incorrect version of Xalan in use!");
            System.err.println("***     Should be 'Xalan Java 2.4.1',");
            System.err.println("***     actually is '" + Version.getVersion() + "').");
            System.err.println("***  To fix this, extract the included xalan.jar:");
            System.err.println("***     unzip " + props.get("java.class.path") + " xalan.jar");
            System.err.println("***  and override your jvm's boot classpath:");
            System.err.println("***     java -Xbootclasspath/p:xalan.jar [...] ");
            throw new DacapoException("Please fix your bootclasspath and try again.");
        }
        String key = "javax.xml.transform.TransformerFactory";
        String value = "org.apache.xalan.processor.TransformerFactoryImpl";
        props.put(key, value);
        System.setProperties(props);
        StreamSource stylesheet = new StreamSource(new File(scratch, "xalan/xmlspec.xsl"));
        TransformerFactory factory = TransformerFactory.newInstance();
        this._template = factory.newTemplates(stylesheet);
        this._workQueue = new WorkQueue();
    }

    public void preIteration(String size) throws Exception {
        super.preIteration(size);
        if (this._workers == null) {
            this._workers = new XalanWorker[8];
        }
        for (int i = 0; i < 8; ++i) {
            this._workers[i] = new XalanWorker(this._workQueue, i);
            this._workers[i].start();
        }
    }

    public void iterate(String size) throws Exception {
        int i;
        String[] harnessArgs = this.config.getArgs(size);
        int nRuns = Integer.parseInt(harnessArgs[0]);
        for (int iRun = 0; iRun < nRuns; ++iRun) {
            this._workQueue.push("xalan/acks.xml");
            this._workQueue.push("xalan/binding.xml");
            this._workQueue.push("xalan/changes.xml");
            this._workQueue.push("xalan/concepts.xml");
            this._workQueue.push("xalan/controls.xml");
            this._workQueue.push("xalan/datatypes.xml");
            this._workQueue.push("xalan/expr.xml");
            this._workQueue.push("xalan/intro.xml");
            this._workQueue.push("xalan/model.xml");
            this._workQueue.push("xalan/prod-notes.xml");
            this._workQueue.push("xalan/references.xml");
            this._workQueue.push("xalan/rpm.xml");
            this._workQueue.push("xalan/schema.xml");
            this._workQueue.push("xalan/structure.xml");
            this._workQueue.push("xalan/template.xml");
            this._workQueue.push("xalan/terms.xml");
            this._workQueue.push("xalan/ui.xml");
        }
        for (i = 0; i < 8; ++i) {
            this._workQueue.push("");
        }
        for (i = 0; i < 8; ++i) {
            this._workers[i].join();
        }
        System.out.println("Normal completion.");
    }

    class XalanWorker
    extends Thread
    implements ErrorListener {
        WorkQueue _queue;
        int _id;

        public XalanWorker(WorkQueue queue, int id) {
            this._queue = queue;
            this._id = id;
        }

        public void run() {
            try {
                String fileName;
                FileOutputStream outputStream = new FileOutputStream(new File(XalanHarness.this.scratch, "xalan.out." + this._id));
                StreamResult outFile = new StreamResult(outputStream);
                while (!(fileName = this._queue.pop()).equals("")) {
                    Transformer transformer = XalanHarness.this._template.newTransformer();
                    transformer.setErrorListener(this);
                    FileInputStream inputStream = new FileInputStream(new File(XalanHarness.this.scratch, fileName));
                    StreamSource inFile = new StreamSource(inputStream);
                    transformer.transform(inFile, outFile);
                    inputStream.close();
                }
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }

        public void warning(TransformerException exception) throws TransformerException {
        }
    }

    class WorkQueue {
        LinkedList _queue = new LinkedList();

        WorkQueue() {
        }

        public synchronized void push(String filename) {
            this._queue.add(filename);
            this.notify();
        }

        public synchronized String pop() {
            while (this._queue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (String)this._queue.removeFirst();
        }
    }
}

