/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.model;

import java.io.StringReader;
import java.util.List;
import java.util.Vector;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.util.viewer.model.ViewerModelEvent;
import net.sourceforge.pmd.util.viewer.model.ViewerModelListener;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;

public class ViewerModel {
    private Vector listeners = new Vector(5);
    private SimpleNode rootNode;
    private List evaluationResults;

    public SimpleNode getRootNode() {
        return this.rootNode;
    }

    public void commitSource(String source, TargetJDKVersion jdk) {
        ASTCompilationUnit compilationUnit = jdk.createParser(new StringReader(source)).CompilationUnit();
        this.rootNode = compilationUnit;
        this.fireViewerModelEvent(new ViewerModelEvent(this, 1));
    }

    public boolean hasCompiledTree() {
        return this.rootNode != null;
    }

    public void evaluateXPathExpression(String xPath, Object evaluator) throws ParseException, JaxenException {
        BaseXPath xpath = new BaseXPath(xPath, (Navigator)new DocumentNavigator());
        this.evaluationResults = xpath.selectNodes((Object)this.rootNode);
        this.fireViewerModelEvent(new ViewerModelEvent(evaluator, 4));
    }

    public List getLastEvaluationResults() {
        return this.evaluationResults;
    }

    public void selectNode(SimpleNode node, Object selector) {
        this.fireViewerModelEvent(new ViewerModelEvent(selector, 2, node));
    }

    public void appendToXPathExpression(String pathFragment, Object appender) {
        this.fireViewerModelEvent(new ViewerModelEvent(appender, 3, pathFragment));
    }

    public void addViewerModelListener(ViewerModelListener l) {
        this.listeners.add(l);
    }

    public void removeViewerModelListener(ViewerModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireViewerModelEvent(ViewerModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ViewerModelListener)this.listeners.elementAt(i)).viewerModelChanged(e);
        }
    }
}

