/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.sourcetypehandlers;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.sourcetypehandlers.Java13Handler;
import net.sourceforge.pmd.sourcetypehandlers.Java14Handler;
import net.sourceforge.pmd.sourcetypehandlers.Java15Handler;
import net.sourceforge.pmd.sourcetypehandlers.JspTypeHandler;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandler;

public class SourceTypeHandlerBroker {
    private Map mapSourceTypeOnSourceTypeHandler = new HashMap();

    public SourceTypeHandlerBroker() {
        this.initialize();
    }

    private void initialize() {
        this.mapSourceTypeOnSourceTypeHandler.put(SourceType.JAVA_13, new Java13Handler());
        this.mapSourceTypeOnSourceTypeHandler.put(SourceType.JAVA_14, new Java14Handler());
        this.mapSourceTypeOnSourceTypeHandler.put(SourceType.JAVA_15, new Java15Handler());
        this.mapSourceTypeOnSourceTypeHandler.put(SourceType.JSP, new JspTypeHandler());
    }

    public SourceTypeHandler getVisitorsFactoryForSourceType(SourceType sourceType) {
        SourceTypeHandler handler = (SourceTypeHandler)this.mapSourceTypeOnSourceTypeHandler.get(sourceType);
        if (handler == null) {
            throw new IllegalArgumentException("No VisitorsFactory is registered for SourceType [" + sourceType + "].");
        }
        return handler;
    }
}

