/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class ImmutableField
extends AbstractRule {
    private static final int MUTABLE = 0;
    private static final int IMMUTABLE = 1;
    private static final int CHECKDECL = 2;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableInitializer;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTTryStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTForStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTWhileStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTDoStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration;

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map vars = node.getScope().getVariableDeclarations();
        List constructors = this.findAllConstructors(node);
        Iterator i = vars.keySet().iterator();
        while (i.hasNext()) {
            int result;
            VariableNameDeclaration field = (VariableNameDeclaration)i.next();
            if (field.getAccessNodeParent().isStatic() || !field.getAccessNodeParent().isPrivate() || field.getAccessNodeParent().isFinal() || (result = this.initializedInConstructor((List)vars.get(field), new HashSet(constructors))) == 0 || result != 1 && (result != 2 || !this.initializedWhenDeclared(field))) continue;
            this.addViolation(data, field.getNode(), field.getImage());
        }
        return super.visit(node, data);
    }

    private boolean initializedWhenDeclared(VariableNameDeclaration field) {
        return !field.getAccessNodeParent().findChildrenOfType(class$net$sourceforge$pmd$ast$ASTVariableInitializer == null ? (class$net$sourceforge$pmd$ast$ASTVariableInitializer = ImmutableField.class$("net.sourceforge.pmd.ast.ASTVariableInitializer")) : class$net$sourceforge$pmd$ast$ASTVariableInitializer).isEmpty();
    }

    private int initializedInConstructor(List usages, Set allConstructors) {
        int result = 0;
        int methodInitCount = 0;
        HashSet<SimpleNode> consSet = new HashSet<SimpleNode>();
        Iterator j = usages.iterator();
        while (j.hasNext()) {
            NameOccurrence occ = (NameOccurrence)j.next();
            if (!occ.isOnLeftHandSide() && !occ.isSelfAssignment()) continue;
            SimpleNode node = occ.getLocation();
            SimpleNode constructor = (SimpleNode)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTConstructorDeclaration == null ? ImmutableField.class$("net.sourceforge.pmd.ast.ASTConstructorDeclaration") : class$net$sourceforge$pmd$ast$ASTConstructorDeclaration);
            if (constructor != null) {
                if (this.inLoopOrTry(node)) continue;
                if (this.inAnonymousInnerClass(node)) {
                    ++methodInitCount;
                    continue;
                }
                consSet.add(constructor);
                continue;
            }
            if (node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? ImmutableField.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration") : class$net$sourceforge$pmd$ast$ASTMethodDeclaration) == null) continue;
            ++methodInitCount;
        }
        if (usages.isEmpty() || methodInitCount == 0 && consSet.isEmpty()) {
            result = 2;
        } else {
            allConstructors.removeAll(consSet);
            if (allConstructors.isEmpty() && methodInitCount == 0) {
                result = 1;
            }
        }
        return result;
    }

    private boolean inLoopOrTry(SimpleNode node) {
        return (SimpleNode)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTTryStatement == null ? (class$net$sourceforge$pmd$ast$ASTTryStatement = ImmutableField.class$("net.sourceforge.pmd.ast.ASTTryStatement")) : class$net$sourceforge$pmd$ast$ASTTryStatement) != null || (SimpleNode)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTForStatement == null ? (class$net$sourceforge$pmd$ast$ASTForStatement = ImmutableField.class$("net.sourceforge.pmd.ast.ASTForStatement")) : class$net$sourceforge$pmd$ast$ASTForStatement) != null || (SimpleNode)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTWhileStatement == null ? (class$net$sourceforge$pmd$ast$ASTWhileStatement = ImmutableField.class$("net.sourceforge.pmd.ast.ASTWhileStatement")) : class$net$sourceforge$pmd$ast$ASTWhileStatement) != null || (SimpleNode)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTDoStatement == null ? (class$net$sourceforge$pmd$ast$ASTDoStatement = ImmutableField.class$("net.sourceforge.pmd.ast.ASTDoStatement")) : class$net$sourceforge$pmd$ast$ASTDoStatement) != null;
    }

    private boolean inAnonymousInnerClass(SimpleNode node) {
        ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration = ImmutableField.class$("net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration")) : class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration);
        return parent != null && parent.isAnonymousInnerClass();
    }

    private List findAllConstructors(ASTClassOrInterfaceDeclaration node) {
        ArrayList cons = new ArrayList();
        node.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTConstructorDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTConstructorDeclaration = ImmutableField.class$("net.sourceforge.pmd.ast.ASTConstructorDeclaration")) : class$net$sourceforge$pmd$ast$ASTConstructorDeclaration, cons, false);
        return cons;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

