/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.StringUtil;

public class XMLRenderer
extends AbstractRenderer
implements Renderer {
    public String render(Report report) {
        StringBuffer buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + PMD.EOL + this.createVersionAttr() + this.createTimestampAttr() + this.createTimeElapsedAttr(report) + ">" + PMD.EOL);
        String filename = null;
        Iterator i = report.iterator();
        while (i.hasNext()) {
            IRuleViolation rv = (IRuleViolation)i.next();
            if (!rv.getFilename().equals(filename)) {
                if (filename != null) {
                    buf.append("</file>" + PMD.EOL);
                }
                filename = rv.getFilename();
                buf.append("<file name=\"");
                StringUtil.appendXmlEscaped(buf, filename);
                buf.append("\">").append(PMD.EOL);
            }
            buf.append("<violation line=\"").append(rv.getBeginLine()).append("\"");
            buf.append(" rule=\"");
            StringUtil.appendXmlEscaped(buf, rv.getRule().getName());
            buf.append("\"");
            buf.append(" ruleset=\"");
            StringUtil.appendXmlEscaped(buf, rv.getRule().getRuleSetName());
            buf.append("\"");
            this.maybeAdd("package", rv.getPackageName(), buf);
            this.maybeAdd("class", rv.getClassName(), buf);
            this.maybeAdd("method", rv.getMethodName(), buf);
            this.maybeAdd("externalInfoUrl", rv.getRule().getExternalInfoUrl(), buf);
            buf.append(" priority=\"");
            buf.append(rv.getRule().getPriority());
            buf.append("\">");
            buf.append(PMD.EOL);
            StringUtil.appendXmlEscaped(buf, rv.getDescription());
            buf.append(PMD.EOL);
            buf.append("</violation>");
            buf.append(PMD.EOL);
        }
        if (filename != null) {
            buf.append("</file>" + PMD.EOL);
        }
        i = report.errors();
        while (i.hasNext()) {
            Report.ProcessingError pe = (Report.ProcessingError)i.next();
            buf.append("<error ").append("filename=\"");
            StringUtil.appendXmlEscaped(buf, pe.getFile());
            buf.append("\" msg=\"");
            StringUtil.appendXmlEscaped(buf, pe.getMsg());
            buf.append("\"/>").append(PMD.EOL);
        }
        if (this.showSuppressedViolations) {
            i = report.getSuppressedRuleViolations().iterator();
            while (i.hasNext()) {
                Report.SuppressedViolation suppressed = (Report.SuppressedViolation)i.next();
                buf.append("<suppressedviolation ").append("filename=\"");
                StringUtil.appendXmlEscaped(buf, suppressed.getRuleViolation().getFilename());
                buf.append("\" suppressiontype=\"");
                StringUtil.appendXmlEscaped(buf, suppressed.suppressedByNOPMD() ? "nopmd" : "annotation");
                buf.append("\" msg=\"");
                StringUtil.appendXmlEscaped(buf, suppressed.getRuleViolation().getDescription());
                buf.append("\"/>").append(PMD.EOL);
            }
        }
        buf.append("</pmd>");
        return buf.toString();
    }

    private void maybeAdd(String attr, String value, StringBuffer buf) {
        if (value != null && value.length() > 0) {
            buf.append(" " + attr + "=\"");
            StringUtil.appendXmlEscaped(buf, value);
            buf.append("\"");
        }
    }

    private String createVersionAttr() {
        return "<pmd version=\"3.7\"";
    }

    private String createTimestampAttr() {
        return " timestamp=\"" + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(new Date()) + "\"";
    }

    private String createTimeElapsedAttr(Report rpt) {
        Report.ReadableDuration d = new Report.ReadableDuration(rpt.getElapsedTimeInMillis());
        return " elapsedTime=\"" + d.getTime() + "\"";
    }
}

