/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.StringUtil;

public class HTMLRenderer
extends AbstractRenderer
implements Renderer {
    private String linkPrefix;

    public HTMLRenderer(String linkPrefix) {
        this.linkPrefix = linkPrefix;
    }

    public HTMLRenderer() {
        this(null);
    }

    public String render(Report report) {
        StringBuffer buf = new StringBuffer("<html><head><title>PMD</title></head><body>" + PMD.EOL);
        buf.append(this.renderBody(report));
        buf.append("</body></html>");
        return buf.toString();
    }

    public String renderBody(Report report) {
        StringBuffer buf = this.glomIRuleViolations(report);
        this.glomProcessingErrors(report, buf);
        if (this.showSuppressedViolations) {
            this.glomSuppressions(report, buf);
        }
        return buf.toString();
    }

    private StringBuffer glomIRuleViolations(Report report) {
        boolean colorize = true;
        int violationCount = 1;
        StringBuffer buf = new StringBuffer();
        buf.append("<center><h3>PMD report</h3></center>");
        buf.append("<center><h3>Problems found</h3></center>");
        buf.append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>" + PMD.EOL);
        Iterator i = report.iterator();
        while (i.hasNext()) {
            IRuleViolation rv = (IRuleViolation)i.next();
            buf.append("<tr");
            if (colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            colorize = !colorize;
            buf.append("> " + PMD.EOL);
            buf.append("<td align=\"center\">" + violationCount + "</td>" + PMD.EOL);
            buf.append("<td width=\"*%\">" + this.maybeWrap(rv.getFilename(), Integer.toString(rv.getBeginLine())) + "</td>" + PMD.EOL);
            buf.append("<td align=\"center\" width=\"5%\">" + Integer.toString(rv.getBeginLine()) + "</td>" + PMD.EOL);
            String d = rv.getDescription();
            d = StringUtil.replaceString(d, '&', "&amp;");
            d = StringUtil.replaceString(d, '<', "&lt;");
            d = StringUtil.replaceString(d, '>', "&gt;");
            if (rv.getRule().getExternalInfoUrl() != null && rv.getRule().getExternalInfoUrl().length() != 0) {
                d = "<a href=\"" + rv.getRule().getExternalInfoUrl() + "\">" + d + "</a>";
            }
            buf.append("<td width=\"*\">" + d + "</td>" + PMD.EOL);
            buf.append("</tr>" + PMD.EOL);
            ++violationCount;
        }
        if (violationCount > 0) {
            buf.append("</table>");
        }
        return buf;
    }

    private void glomProcessingErrors(Report report, StringBuffer buf) {
        boolean colorize = true;
        if (report.errors().hasNext()) {
            buf.append("<hr/>");
            buf.append("<center><h3>Processing errors</h3></center>");
            buf.append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>File</th><th>Problem</th></tr>" + PMD.EOL);
        }
        int violationCount = 0;
        Iterator i = report.errors();
        while (i.hasNext()) {
            Report.ProcessingError pe = (Report.ProcessingError)i.next();
            buf.append("<tr");
            if (colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            colorize = !colorize;
            buf.append("> " + PMD.EOL);
            buf.append("<td>" + pe.getFile() + "</td>" + PMD.EOL);
            buf.append("<td>" + pe.getMsg() + "</td>" + PMD.EOL);
            buf.append("</tr>" + PMD.EOL);
            ++violationCount;
        }
        if (violationCount > 0) {
            buf.append("</table>");
        }
    }

    private void glomSuppressions(Report report, StringBuffer buf) {
        boolean colorize = true;
        if (!report.getSuppressedRuleViolations().isEmpty()) {
            buf.append("<hr/>");
            buf.append("<center><h3>Suppressed warnings</h3></center>");
            buf.append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>File</th><th>Line</th><th>Rule</th><th>NOPMD or Annotation</th></tr>" + PMD.EOL);
        }
        Iterator i = report.getSuppressedRuleViolations().iterator();
        while (i.hasNext()) {
            Report.SuppressedViolation sv = (Report.SuppressedViolation)i.next();
            buf.append("<tr");
            if (colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            colorize = !colorize;
            buf.append("> " + PMD.EOL);
            buf.append("<td align=\"left\">" + sv.getRuleViolation().getFilename() + "</td>" + PMD.EOL);
            buf.append("<td align=\"center\">" + sv.getRuleViolation().getBeginLine() + "</td>" + PMD.EOL);
            buf.append("<td align=\"center\">" + sv.getRuleViolation().getRule().getName() + "</td>" + PMD.EOL);
            buf.append("<td align=\"center\">" + (sv.suppressedByNOPMD() ? "NOPMD" : "Annotation") + "</td>" + PMD.EOL);
            buf.append("</tr>" + PMD.EOL);
        }
        if (!report.getSuppressedRuleViolations().isEmpty()) {
            buf.append("</table>");
        }
    }

    private String maybeWrap(String filename, String line) {
        if (this.linkPrefix == null) {
            return filename;
        }
        String newFileName = filename.substring(0, filename.lastIndexOf("."));
        return "<a href=\"" + this.linkPrefix + newFileName + ".html#" + line + "\">" + newFileName + "</a>";
    }
}

