/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.TokenEntry;

public class Match
implements Comparable {
    private int tokenCount;
    private int lineCount;
    private Set markSet = new TreeSet();
    private TokenEntry[] marks = new TokenEntry[2];
    private String code;
    private MatchCode mc;

    public Match(int tokenCount, TokenEntry first, TokenEntry second) {
        this.markSet.add(first);
        this.markSet.add(second);
        this.marks[0] = first;
        this.marks[1] = second;
        this.tokenCount = tokenCount;
    }

    public int getMarkCount() {
        return this.markSet.size();
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getSourceCodeSlice() {
        return this.code;
    }

    public void setSourceCodeSlice(String code) {
        this.code = code;
    }

    public Iterator iterator() {
        return this.markSet.iterator();
    }

    public int compareTo(Object o) {
        Match other = (Match)o;
        int diff = other.getTokenCount() - this.getTokenCount();
        if (diff != 0) {
            return diff;
        }
        return other.getFirstMark().getIndex() - this.getFirstMark().getIndex();
    }

    public TokenEntry getFirstMark() {
        return this.marks[0];
    }

    public TokenEntry getSecondMark() {
        return this.marks[1];
    }

    public String toString() {
        return "Match: " + PMD.EOL + "tokenCount = " + this.tokenCount + PMD.EOL + "marks = " + this.markSet.size();
    }

    public Set getMarkSet() {
        return this.markSet;
    }

    public MatchCode getMatchCode() {
        if (this.mc == null) {
            this.mc = new MatchCode(this.marks[0], this.marks[1]);
        }
        return this.mc;
    }

    public int getEndIndex() {
        return this.marks[1].getIndex() + this.getTokenCount() - 1;
    }

    public void setMarkSet(Set markSet) {
        this.markSet = markSet;
    }

    public static class MatchCode {
        private int first;
        private int second;

        public MatchCode() {
        }

        public MatchCode(TokenEntry m1, TokenEntry m2) {
            this.first = m1.getIndex();
            this.second = m2.getIndex();
        }

        public int hashCode() {
            return this.first + 37 * this.second;
        }

        public boolean equals(Object other) {
            MatchCode mc = (MatchCode)other;
            return mc.first == this.first && mc.second == this.second;
        }

        public void setFirst(int first) {
            this.first = first;
        }

        public void setSecond(int second) {
            this.second = second;
        }
    }
}

