/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Properties;
import net.sourceforge.pmd.cpd.AnyLanguage;
import net.sourceforge.pmd.cpd.CPPLanguage;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.PHPLanguage;
import net.sourceforge.pmd.cpd.RubyLanguage;

public class LanguageFactory {
    public static final String JAVA_KEY = "java";
    public static final String CPP_KEY = "cpp";
    public static final String C_KEY = "c";
    public static final String PHP_KEY = "php";
    public static final String RUBY_KEY = "ruby";
    public static final String EXTENSION = "extension";
    public static final String BY_EXTENSION = "by_extension";

    public Language createLanguage(String language) {
        return this.createLanguage(language, new Properties());
    }

    public Language createLanguage(String language, Properties properties) {
        if (language.equals(CPP_KEY) || language.equals(C_KEY)) {
            return new CPPLanguage();
        }
        if (language.equals(JAVA_KEY)) {
            return new JavaLanguage(properties);
        }
        if (language.equals(BY_EXTENSION)) {
            return new AnyLanguage(properties.getProperty(EXTENSION));
        }
        if (language.equals(PHP_KEY)) {
            return new PHPLanguage();
        }
        if (language.equals(RUBY_KEY)) {
            return new RubyLanguage();
        }
        return new AnyLanguage(language);
    }
}

