/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FilenameFilter;
import net.sourceforge.pmd.cpd.AnyTokenizer;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Tokenizer;

public class AnyLanguage
implements Language {
    private AnyTokenizer tokenizer;
    private String extension;

    public AnyLanguage(String extension) {
        this.extension = extension;
        this.tokenizer = new AnyTokenizer();
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public FilenameFilter getFileFilter() {
        return new AnyFileOrDirectoryFilter(this.extension);
    }

    public static class AnyFileOrDirectoryFilter
    implements FilenameFilter {
        String extension;

        public AnyFileOrDirectoryFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File dir, String filename) {
            return filename.endsWith(this.extension) || new File(dir.getAbsolutePath() + System.getProperty("file.separator") + filename).isDirectory();
        }
    }
}

