/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.ast.CanSuppressWarnings;
import net.sourceforge.pmd.ast.SimpleNode;

public class RuleViolation
implements IRuleViolation {
    private Rule rule;
    private String description;
    private String filename;
    private String className;
    private String methodName;
    private String packageName;
    private int beginLine;
    private int endLine;
    private int beginColumn;
    private int endColumn;
    private boolean isSuppressed;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTTypeDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFormalParameter;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;

    public RuleViolation(Rule rule, RuleContext ctx, SimpleNode node) {
        this(rule, ctx, node, rule.getMessage());
    }

    public RuleViolation(Rule rule, RuleContext ctx, SimpleNode node, String specificMsg) {
        this.rule = rule;
        this.filename = ctx.getSourceCodeFilename();
        this.description = specificMsg;
        this.className = node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = RuleViolation.class$("net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration")) : class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration) == null ? "" : (node.getScope().getEnclosingClassScope().getClassName() == null ? "" : node.getScope().getEnclosingClassScope().getClassName());
        this.methodName = node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTMethodDeclaration = RuleViolation.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration")) : class$net$sourceforge$pmd$ast$ASTMethodDeclaration) == null ? "" : node.getScope().getEnclosingMethodScope().getName();
        this.packageName = node.getScope().getEnclosingSourceFileScope().getPackageName() == null ? "" : node.getScope().getEnclosingSourceFileScope().getPackageName();
        this.beginLine = node.getBeginLine();
        this.endLine = node.getEndLine();
        this.beginColumn = node.getBeginColumn();
        this.endColumn = node.getEndColumn();
        List parentTypes = node.getParentsOfType(class$net$sourceforge$pmd$ast$ASTTypeDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTTypeDeclaration = RuleViolation.class$("net.sourceforge.pmd.ast.ASTTypeDeclaration")) : class$net$sourceforge$pmd$ast$ASTTypeDeclaration);
        if (node instanceof ASTTypeDeclaration) {
            parentTypes.add(node);
        }
        parentTypes.addAll(node.getParentsOfType(class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration = RuleViolation.class$("net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration")) : class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration));
        if (node instanceof ASTClassOrInterfaceBodyDeclaration) {
            parentTypes.add(node);
        }
        parentTypes.addAll(node.getParentsOfType(class$net$sourceforge$pmd$ast$ASTFormalParameter == null ? (class$net$sourceforge$pmd$ast$ASTFormalParameter = RuleViolation.class$("net.sourceforge.pmd.ast.ASTFormalParameter")) : class$net$sourceforge$pmd$ast$ASTFormalParameter));
        if (node instanceof ASTFormalParameter) {
            parentTypes.add(node);
        }
        parentTypes.addAll(node.getParentsOfType(class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = RuleViolation.class$("net.sourceforge.pmd.ast.ASTLocalVariableDeclaration")) : class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration));
        if (node instanceof ASTLocalVariableDeclaration) {
            parentTypes.add(node);
        }
        Iterator i = parentTypes.iterator();
        while (i.hasNext()) {
            CanSuppressWarnings t = (CanSuppressWarnings)i.next();
            if (!t.hasSuppressWarningsAnnotationFor(this.getRule())) continue;
            this.isSuppressed = true;
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getVariableName() {
        return "";
    }

    public String toString() {
        return this.getFilename() + ":" + this.getRule() + ":" + this.getDescription() + ":" + this.beginLine;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RuleViolationComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            IRuleViolation r1 = (IRuleViolation)o1;
            IRuleViolation r2 = (IRuleViolation)o2;
            if (!r1.getFilename().equals(r2.getFilename())) {
                return r1.getFilename().compareTo(r2.getFilename());
            }
            if (r1.getBeginLine() != r2.getBeginLine()) {
                return r1.getBeginLine() - r2.getBeginLine();
            }
            if (r1.getDescription() != null && r2.getDescription() != null && !r1.getDescription().equals(r2.getDescription())) {
                return r1.getDescription().compareTo(r2.getDescription());
            }
            if (r1.getBeginLine() == r2.getBeginLine()) {
                return 1;
            }
            return r1.getBeginLine() - r2.getBeginLine();
        }
    }
}

