/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public abstract class CommonAbstractRule
implements Rule {
    protected String name = this.getClass().getName();
    protected Properties properties = new Properties();
    protected String message;
    protected String description;
    protected String example;
    protected String ruleSetName;
    protected boolean include;
    protected boolean usesDFA;
    protected int priority = 5;
    protected String externalInfoUrl;

    public String getRuleSetName() {
        return this.ruleSetName;
    }

    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.properties.getProperty(name));
    }

    public int getIntProperty(String name) {
        return Integer.parseInt(this.properties.getProperty(name));
    }

    public boolean getBooleanProperty(String name) {
        return Boolean.valueOf(this.properties.getProperty(name));
    }

    public String getStringProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    public void setExternalInfoUrl(String url) {
        this.externalInfoUrl = url;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Rule rule = null;
        boolean equality = this.getClass().getName().equals(o.getClass().getName());
        if (equality) {
            rule = (Rule)o;
            equality = this.getName().equals(rule.getName()) && this.getPriority() == rule.getPriority() && this.getProperties().equals(rule.getProperties());
        }
        return equality;
    }

    public int hashCode() {
        String s = this.getClass().getName() + this.getName() + String.valueOf(this.getPriority()) + this.getProperties().toString();
        return s.hashCode();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean include() {
        return this.include;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPriorityName() {
        return Rule.PRIORITIES[this.getPriority() - 1];
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setUsesDFA() {
        this.usesDFA = true;
    }

    public boolean usesDFA() {
        return this.usesDFA;
    }

    protected final void addViolation(Object data, SimpleNode node) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node));
    }

    protected final void addViolationWithMessage(Object data, SimpleNode node, String msg) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, msg));
    }

    protected final void addViolation(Object data, SimpleNode node, String embed) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, MessageFormat.format(this.getMessage(), embed)));
    }

    protected final void addViolation(Object data, Node node, Object[] args) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, (SimpleNode)node, MessageFormat.format(this.getMessage(), args)));
    }
}

