/*
 * Decompiled with CFR 0.152.
 */
package dacapo.pmd;

import dacapo.Benchmark;
import dacapo.parser.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.PMD;

public class PmdHarness
extends Benchmark {
    public PmdHarness(Config config, File scratch) throws Exception {
        super(config, scratch);
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
    }

    public void iterate(String size) throws Exception {
        String[] args = this.config.getArgs(size);
        if (args[0].charAt(0) == '@') {
            args[0] = this.collectFilesFromFile(this.fileInScratch(args[0].substring(1)));
        }
        for (int i = 2; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') continue;
            args[i] = this.fileInScratch(args[i]);
        }
        PMD.main(args);
    }

    private String collectFilesFromFile(String inputFileName) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(inputFileName)));
            ArrayList<File> files = new ArrayList<File>();
            String l = reader.readLine();
            while (l != null) {
                files.add(new File(this.scratch, l));
                l = reader.readLine();
            }
            return PmdHarness.commaSeparate(files);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File " + inputFileName + " error: " + e);
        }
        catch (IOException e) {
            throw new RuntimeException("File " + inputFileName + " error: " + e);
        }
    }

    private static String commaSeparate(List list) {
        String result = "";
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String s = ((File)i.next()).getPath();
            result = result + s;
            if (!i.hasNext()) continue;
            result = result + ",";
        }
        return result;
    }
}

