/*
 * Decompiled with CFR 0.152.
 */
package dacapo.parser;

import dacapo.parser.Config;
import dacapo.parser.ConfigFileConstants;
import dacapo.parser.ConfigFileTokenManager;
import dacapo.parser.ParseException;
import dacapo.parser.SimpleCharStream;
import dacapo.parser.Token;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

class ConfigFile
implements ConfigFileConstants {
    public ConfigFileTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[17];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) {
        try {
            ConfigFile parser = new ConfigFile(new FileInputStream(args[0]));
            parser.configFile();
        }
        catch (ParseException p) {
            System.err.println("Parse exception");
            p.printStackTrace();
            return;
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + args[0] + " not found.");
            return;
        }
        System.out.println("Success!");
    }

    private static String unQuote(Token token) {
        return token.image.substring(1, token.image.length() - 1);
    }

    private static String unHex(Token token) {
        return token.image.substring(2).toLowerCase();
    }

    public final Config configFile() throws ParseException {
        Config config = this.config();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    this.sizeSpec(config);
                    break;
                }
                case 20: {
                    this.description(config);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: 
                case 32: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        return config;
    }

    public final Config config() throws ParseException {
        this.jj_consume_token(15);
        Token name = this.jj_consume_token(40);
        Config config = new Config(name.image);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                Token className = this.jj_consume_token(40);
                config.setClass(className.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        Token methodName = this.jj_consume_token(40);
                        config.setMethod(methodName.image);
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(47);
        return config;
    }

    public final void sizeSpec(Config config) throws ParseException {
        this.jj_consume_token(32);
        Token size = this.jj_consume_token(40);
        block3: while (true) {
            this.sizeClause(config, size.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 29: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(47);
    }

    public final void sizeClause(Config config, String size) throws ParseException {
        Vector<String> args = new Vector<String>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: {
                        String arg = this.string();
                        args.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 44: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[5] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.jj_consume_token(44);
                            arg = this.string();
                            args.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                config.addSize(size, args);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                this.outputFile(config, size);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 44: {
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(44);
                    this.outputFile(config, size);
                }
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void outputFile(Config config, String size) throws ParseException {
        void var3_3;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                String file = this.string();
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                String file = "stdout.log";
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                String file = "stderr.log";
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        config.addOutputFile(size, (String)var3_3);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 21: 
                case 22: 
                case 24: 
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block8;
                }
            }
            this.outputClause(config, size, (String)var3_3);
        }
    }

    public final void outputClause(Config config, String size, String file) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 45: {
                        this.jj_consume_token(45);
                        this.digestOption(config, size, file);
                        block13: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 44: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[11] = this.jj_gen;
                                    break block13;
                                }
                            }
                            this.jj_consume_token(44);
                            this.digestOption(config, size, file);
                        }
                        this.jj_consume_token(46);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                String digest = this.hex();
                config.setDigest(size, file, digest);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                config.setExists(size, file);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                config.setKeep(size, file);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                int n = this.integer();
                config.setLines(size, file, n);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                long l = this.longInt();
                config.setBytes(size, file, l);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void digestOption(Config config, String size, String file) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                config.setTextFile(size, file, true);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                config.setTextFile(size, file, false);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                config.setFilterScratch(size, file, true);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                config.setFilterScratch(size, file, false);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void description(Config config) throws ParseException {
        this.jj_consume_token(20);
        this.descElement(config);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 44: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(44);
            this.descElement(config);
        }
        this.jj_consume_token(47);
    }

    public final void descElement(Config config) throws ParseException {
        String id = this.descId();
        String desc = this.string();
        config.addDesc(id, desc);
    }

    public final String descId() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String string() throws ParseException {
        Token s = this.jj_consume_token(42);
        return ConfigFile.unQuote(s);
    }

    public final int integer() throws ParseException {
        Token n = this.jj_consume_token(43);
        return Integer.parseInt(n.image);
    }

    public final long longInt() throws ParseException {
        Token n = this.jj_consume_token(43);
        return Long.parseLong(n.image);
    }

    public final String hex() throws ParseException {
        Token h = this.jj_consume_token(41);
        return ConfigFile.unHex(h);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x100000, 0x100000, 0x10000000, 262144, 0x20002000, 0, 0, 0, 0x20002000, 0, 90308608, 0, 0, 90308608, 1082195968, 0, -1979170816};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{1, 1, 0, 0, 0, 4096, 1024, 4096, 0, 1030, 0, 4096, 8192, 0, 8, 4096, 240};
    }

    public ConfigFile(InputStream stream) {
        this(stream, null);
    }

    public ConfigFile(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ConfigFileTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigFile(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConfigFileTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigFile(ConfigFileTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ConfigFileTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[48];
        for (i = 0; i < 48; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 17; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 48; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, ConfigFileConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ConfigFile.jj_la1_0();
        ConfigFile.jj_la1_1();
    }
}

