/*
 * Decompiled with CFR 0.152.
 */
package dacapo.parser;

import dacapo.parser.ConfigFile;
import dacapo.parser.ParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class Config {
    public final String name;
    public String className = null;
    public String methodName = null;
    HashMap sizes = new HashMap(3);
    HashMap desc = new HashMap(6);

    Config(String name) {
        this.name = name;
    }

    void setClass(String klass) {
        this.className = klass;
    }

    void setMethod(String method) {
        this.methodName = method;
    }

    void addSize(String name, Vector args) {
        this.sizes.put(name, new Size(name, args));
    }

    private Size getSize(String size) {
        Size s = (Size)this.sizes.get(size);
        if (s == null) {
            System.err.println("No such size: \"" + size + "\" in this configuration");
        }
        return s;
    }

    void addDesc(String element, String description) {
        this.desc.put(element, description);
    }

    void addOutputFile(String size, String file) {
        this.getSize(size).addOutputFile(file);
        if (file.equals("stdout.log") || file.equals("stderr.log")) {
            this.setTextFile(size, file, true);
            this.setFilterScratch(size, file, true);
        }
    }

    void setDigest(String size, String file, String digest) {
        this.getSize((String)size).getOutputFile((String)file).digest = digest;
    }

    void setLines(String size, String file, int lines) {
        this.getSize((String)size).getOutputFile((String)file).lines = lines;
    }

    void setBytes(String size, String file, long bytes) {
        this.getSize((String)size).getOutputFile((String)file).bytes = bytes;
    }

    void setKeep(String size, String file) {
        this.getSize((String)size).getOutputFile((String)file).keep = true;
    }

    void setExists(String size, String file) {
        this.getSize((String)size).getOutputFile((String)file).existence = true;
    }

    public void setTextFile(String size, String file, boolean isText) {
        Size s = this.getSize(size);
        s.getOutputFile((String)file).text = isText;
    }

    public void setFilterScratch(String size, String file, boolean doFilter) {
        Size s = this.getSize(size);
        s.getOutputFile((String)file).filter = doFilter;
    }

    public static Config parse(String file) {
        return Config.parse(new File(file));
    }

    public static Config parse(File file) {
        try {
            return Config.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Config parse(URL url) {
        try {
            return Config.parse(url.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Config parse(InputStream stream) {
        try {
            ConfigFile parser = new ConfigFile(stream);
            return parser.configFile();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getArgs(String config) {
        Size s = this.getSize(config);
        return (String[])s.args.clone();
    }

    public Collection getSizes() {
        return this.sizes.keySet();
    }

    public Set getOutputs(String size) {
        return this.getSize((String)size).outputFiles.keySet();
    }

    public String getDigest(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).digest;
    }

    public boolean hasDigest(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile(file).hasDigest();
    }

    public boolean isTextFile(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).text;
    }

    public boolean filterScratch(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).filter;
    }

    public long getBytes(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).bytes;
    }

    public boolean hasBytes(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile(file).hasBytes();
    }

    public int getLines(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).lines;
    }

    public boolean hasLines(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile(file).hasLines();
    }

    public boolean isKept(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).keep;
    }

    public boolean checkExists(String size, String file) {
        Size s = this.getSize(size);
        return s.getOutputFile((String)file).existence;
    }

    private String pad(String in, int length) {
        while (in.length() < length) {
            in = in + " ";
        }
        return in;
    }

    public void describe(PrintStream str) {
        this.describe(str, false);
    }

    private void describe(PrintStream str, boolean decorated, String desc, String trail) {
        if (decorated) {
            str.print("  ");
        }
        str.println(this.pad(desc, 10) + this.desc.get(desc) + (decorated ? trail : ""));
    }

    public void describe(PrintStream str, boolean decorated) {
        if (decorated) {
            str.println("description");
        }
        this.describe(str, decorated, "short", ",");
        this.describe(str, decorated, "long", ",");
        this.describe(str, decorated, "author", ",");
        this.describe(str, decorated, "license", ",");
        this.describe(str, decorated, "copyright", ",");
        this.describe(str, decorated, "url", ",");
        this.describe(str, decorated, "version", ";");
    }

    public String getDesc(String item) {
        return (String)this.desc.get(item);
    }

    public void print(PrintStream str) {
        str.print("benchmark " + this.name);
        if (this.className != null) {
            str.print(" class " + this.className);
        }
        if (this.methodName != null) {
            str.print(" method " + this.methodName);
        }
        str.println(";");
        Iterator i = this.getSizes().iterator();
        while (i.hasNext()) {
            String size = (String)i.next();
            String[] args = this.getArgs(size);
            str.print("size " + size + " args \"");
            for (int j = 0; j < args.length; ++j) {
                if (j != 0) {
                    str.print(" ");
                }
                str.print(args[j]);
            }
            str.println("\";");
            str.print("  outputs");
            Iterator v = this.getOutputs(size).iterator();
            while (v.hasNext()) {
                str.println();
                String file = (String)v.next();
                OutputFile f = this.getSize(size).getOutputFile(file);
                str.print("    \"" + file + "\"");
                if (f.hasDigest()) {
                    str.print(" digest 0x" + f.digest);
                }
                if (f.keep) {
                    str.print(" keep");
                }
                if (!v.hasNext()) continue;
                str.print(",");
            }
            str.println(";");
        }
        this.describe(str, true);
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            Config.parse(args[i]).print(System.out);
        }
    }

    class Size {
        final String name;
        final String[] args;
        HashMap outputFiles = new LinkedHashMap(20);

        public Size(String name, Vector args) {
            this.args = args.toArray(new String[0]);
            this.name = name;
        }

        void addOutputFile(String file) {
            this.outputFiles.put(file, new OutputFile(file));
        }

        OutputFile getOutputFile(String file) {
            return (OutputFile)this.outputFiles.get(file);
        }
    }

    class OutputFile {
        String name;
        String digest = null;
        boolean keep = false;
        boolean existence = false;
        int lines = -1;
        long bytes = -1L;
        boolean text = false;
        boolean filter = false;

        OutputFile(String name) {
            this.name = name;
        }

        boolean hasDigest() {
            return this.digest != null;
        }

        boolean hasLines() {
            return this.lines != -1;
        }

        boolean hasBytes() {
            return this.bytes != -1L;
        }
    }
}

